/*
    TCFbENeighbor.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbENeighbor.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbENeighbor::TCFbENeighbor(AnsiString Label, double Similarity, double Value, double SourceValue)
{
    this->FLabel = Label;
    this->FSimilarity = Similarity;
    this->FValue = Value;
    this->FSourceValue = SourceValue;
}

//---------------------------------------------------------------------------
__fastcall TCFbENeighbor::~TCFbENeighbor()
{
}

//---------------------------------------------------------------------------
// NeighborList Ɋi[ꂽ Neighbors ̒l̕ϒlԂ
double __fastcall TCFbENeighbor::GetAverageValueOfNeighborList(TObjectList* NeighborList)
{
    TDoubleDynArray Array;
    for (int i = 0; i < NeighborList->Count; i++) {
        Array.Length++;
        Array[i] = ((TCFbENeighbor*)NeighborList->Items[i])->Value;
    }

    double    ReturnValue = TCFbEToolkit::GetToolkit()->GetAverageOfDynArray(Array);
    Array.Length = 0;
    return ReturnValue;
}

//---------------------------------------------------------------------------
// NeighborList Ɋi[ꂽ Neighbors ̒l̒ԒlԂ
double __fastcall TCFbENeighbor::GetMedianValueOfNeighborList(TObjectList* NeighborList)
{
    TDoubleDynArray Array;
    for (int i = 0; i < NeighborList->Count; i++) {
        Array.Length++;
        Array[i] = ((TCFbENeighbor*)NeighborList->Items[i])->Value;
    }

    TCFbEToolkit::GetToolkit()->SortDoubleDynArray(Array, sdDescending);
    double    ReturnValue = TCFbEToolkit::GetToolkit()->GetMedianOfDynArray(Array);
    Array.Length = 0;
    return ReturnValue;
}

//---------------------------------------------------------------------------

