/*
    TCFbEDataSet.h    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEDataSetH
#define TCFbEDataSetH
//---------------------------------------------------------------------------
// #include "Maprof.h"

#include "math.h"
#include "TCFbEToolkit.h"
#include "TCFbETable.h"
#include "TCFbECell.h"
#include "TCFbENeighbor.h"

class TCFbESimilarityComputationAlgorithm;
#include "TCFbESimilarityComputationAlgorithm.h"

class TCFbEPredictionAlgorithm;
#include "TCFbEPredictionAlgorithm.h"
//---------------------------------------------------------------------------
// Ăl
enum TCFbEValueBase { vbUnknown, vbValue, vbStandardizedValue, vbNormalizedValue, vbOrder, vbDoubleStandardizedValue, vbDoubleNormalizedValue, vbDoubleOrder };

// x[X̃ASYiabUnknown Ȃ abRow ƓlƂ݂Ȃ
enum TCFbEAlgorithmBase { abUnknown, abRow, abColumn };
//---------------------------------------------------------------------------
// Facade IȃNX
class TCFbEDataSet : public TObject
{
public:
    __property double        Values[AnsiString RowLabel][AnsiString ColumnLabel]    = { read=GetValues, write=SetValues };    // f[^vfێ 2 z
    __property double        ValuesByIndex[int RowIndex][int ColumnIndex]        = { read=GetValuesByIndex, write=SetValuesByIndex };
    __property bool            Enabled[AnsiString RowLabel][AnsiString ColumnLabel]= { read=GetEnabled, write=SetEnabled };
    __property bool            EnabledByIndex[int RowIndex][int ColumnIndex]        = { read=GetEnabledByIndex, write=SetEnabledByIndex };
    __property int            NumberOfRows    = { read=GetNumberOfRows };
    __property int            NumberOfColumns    = { read=GetNumberOfColumns };
    __property TStringList*    RowLabelList    = { read=GetRowLabelList };
    __property TStringList*    ColumnLabelList    = { read=GetColumnLabelList };

    __property TCFbETable*    SimilarityComputationTable = { read=GetSimilarityComputationTable };
    __property TCFbETable*    PredictionTable    = { read=GetPredictionTable };

    __property TCFbEValueBase                        ValueBase        = { read=FValueBase };
    __property TCFbEAlgorithmBase                    AlgorithmBase    = { read=FAlgorithmBase };
    __property TCFbESimilarityComputationAlgorithm*    SimilarityComputationAlgorithm    = { read=FSimilarityComputationAlgorithm };
    __property TCFbEPredictionAlgorithm*            PredictionAlgorithm                = { read=FPredictionAlgorithm };
    __property int            NeighborhoodSize    = { read=FNeighborhoodSize };
    __property bool            DefaultValueEnabled    = { read=FDefaultValueEnabled };
    __property double        DefaultValue        = { read=FDefaultValue };
    __property bool            InverseCaszzeFrequencyEnabled    = { read=FInverseCaseFrequencyEnabled };
    __property double        CaseAmplifier        = { read=FCaseAmplifier };

    __property double        Similarities[AnsiString TargetRowLabel][AnsiString ComparedRowLabel] = { read=GetSimilarities };
    __property double        SimilaritiesByIndex[int TargetRowIndex][int ComparedRowIndex] = { read=GetSimilaritiesByIndex };

    __property double        PredictedValues[AnsiString TargetRowLabel][AnsiString TargetColumnLabel] = { read=GetPredictedValues };
    __property double        PredictedValuesByIndex[int TargetRowIndex][int TargetColumnIndex] = { read=GetPredictedValuesByIndex };

    virtual    __fastcall TCFbEDataSet(void);    // RXgN^
    virtual    __fastcall TCFbEDataSet(TStringList* SourceCsvStringList);    // RXgN^
    __fastcall    ~TCFbEDataSet();    // fXgN^

    virtual void    __fastcall PrepareCF(TCFbEValueBase ValueBase, TCFbEAlgorithmBase AlgorithmBase, TCFbESimilarityComputationAlgorithm* SimilarityComputationAlgorithm, TCFbEPredictionAlgorithm* PredictionAlgorithm, int NeighborhoodSize, bool DefaultValueEnabled, double DefaultValue, bool InverseCaseFrequencyEnabled, double CaseAmplifier);    // CF ̏siPredictionTable 
    virtual void    __fastcall TemporaryUnable(int TargetRowIndex, int TargetColumnIndex);    // TargetRowIndex, TargetColumnIndex ̃ZꎞI Enabled = false ɂ
    virtual void    __fastcall RecoverEnabled(void);    // ꎞI Enabled = false ɂĂZɂǂ

    virtual void    __fastcall AddValue(AnsiString RowLabel, AnsiString ColumnLabel, double Value);    // RowLabel, ColumnLabel ̃Z̒l Value Z
    virtual void    __fastcall UpdateValue(AnsiString RowLabel, AnsiString ColumnLabel, double Value);    // RowLabel, ColumnLabel ̃Z̒l Value ɍXV
    virtual void    __fastcall DeleteValue(AnsiString RowLabel, AnsiString ColumnLabel);    // RowLabel, ColumnLabel ̃Z폜iEnabled = false ɂ

    virtual int     __fastcall UpdateRow(TCFbEDataSet* DataSet, int RowIndex);    // DataSet  RowIndex sڂXV
    virtual int        __fastcall AddRow(AnsiString RowLabel);    // sǉD
    virtual void    __fastcall DeleteRow(AnsiString RowLabel);    // s폜D
    virtual void    __fastcall AddRowElements(AnsiString RowLabel, TStringList* ColumnLabelList, TDoubleDynArray& Values);    // s̊evfZDvf ColumnLabelList Ŏw肳ꂽ Values Ɋi[D
    virtual void    __fastcall UpdateRowElements(AnsiString RowLabel, TStringList* ColumnLabelList, TDoubleDynArray& Values);    // s̊evfXVDvf ColumnLabelList Ŏw肳ꂽ Values Ɋi[D
    virtual void    __fastcall DeleteRowElements(AnsiString RowLabel, TStringList* ColumnLabelList);    // s̎wvf Enabled  false ɂDvf ColumnLabelList Ŏw肳Dŝ̍폜͍sȂD
    virtual int        __fastcall AddColumn(AnsiString ColumnLabel);    // ǉD
    virtual void    __fastcall DeleteColumn(AnsiString ColumnLabel);    // 폜D
    virtual void    __fastcall AddColumnElements(AnsiString ColumnLabel, TStringList* RowLabelList, TDoubleDynArray& Values);    // ̊evfZDvf RowLabelList Ŏw肳ꂽ Values Ɋi[D
    virtual void    __fastcall UpdateColumnElements(AnsiString ColumnLabel, TStringList* RowLabelList, TDoubleDynArray& Values);    // ̊evfXVDvf RowLabelList Ŏw肳ꂽ Values Ɋi[D
    virtual void    __fastcall DeleteColumnElements(AnsiString ColumnLabel, TStringList* RowLabelList);    // ̎wvf Enabled  false ɂDvf RowLabelList Ŏw肳D񎩑̂̍폜͍sȂD

    virtual double    __fastcall GetICFCoefficient(int j);    // j ڂ Inverse Case Frequency Coefficient 𓾂
    virtual void     __fastcall GetNearestNeighbors(int TargetRowIndex, int TargetColumnIndex, int NeighborhoodSize, TObjectList* NeighborList);    // TargetRowIndex ɑ΂ NearestNeigobors 𒲂ׂ

    virtual void     __fastcall FillColumns(TCFbEDataSet* BaseDataSet);    // BaseDataSet ɂāCthis ɂȂVȗƂĒǉ
    virtual bool    __fastcall IsConsistentWith(TCFbEDataSet* TargetDataSet);    // TargetDataSet Ǝѐ邩ǂ𒲂ׂ

    virtual double    __fastcall DisNormalize(int ColumnIndex, double NormalizedValue);    // ColumnIndex ڂ Normalize ꂽl NormalizedValue  DisNormalize ĕԂ
    virtual double    __fastcall DisStandardize(int ColumnIndex, double StandardizedValue);    // ColumnIndex ڂ Standardize ꂽl StandardizedValue  DisStandardize ĕԂ
    virtual double    __fastcall DisOrdering(int ColumnIndex, double Order);    // ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ
    virtual double    __fastcall DisDoubleNormalize(int RowIndex, int ColumnIndex, double DoubleNormalizedValue);    // RowIndex sځCColumnIndex ڂ DoubleNormalize ꂽl DoubleNormalizedValue  DisDoubleNormalize ĕԂ
    virtual double    __fastcall DisDoubleStandardize(int RowIndex, int ColumnIndex, double DoubleStandardizedValue);    // RowIndex sځCColumnIndex ڂ DoubleStandardize ꂽl DoubleStandardizedValue  DisDoubleStandardize ĕԂ
    virtual double    __fastcall DisDoubleOrdering(int RowIndex, int ColumnIndex, double DoubleOrder);    // RowIndex sځCColumnIndex ڂ DoubleOrdering ꂽl DoubleOrder  DisDoubleOrdering ĕԂ

protected:
    TCFbEValueBase        FValueBase;
    TCFbEAlgorithmBase    FAlgorithmBase;
    TCFbETable*            FSourceTable;
    TCFbETable*            FSimilarityComputationTable;
    TCFbETable*         FPredictionMediateTable;
    TCFbETable*            FPredictionTable;
    bool                FAppliedTableArePrepared;
    TCFbESimilarityComputationAlgorithm*    FSimilarityComputationAlgorithm;
    TCFbEPredictionAlgorithm*                FPredictionAlgorithm;
    int                    FNeighborhoodSize;
    bool                FDefaultValueEnabled;
    double                FDefaultValue;
    bool                FInverseCaseFrequencyEnabled;
    double                FCaseAmplifier;
    TObjectList*        FSimilarityList;
    int                    TargetRowIndexOfSimilarity;
    TObjectList*        FPredictedValueList;
    int                    TargetRowIndexOfPrediction;
    int                    TemporaryUnableRowIndex;
    int                    TemporaryUnableColumnIndex;

    virtual double    __fastcall GetValues(AnsiString RowLabel, AnsiString ColumnLabel);
    virtual void    __fastcall SetValues(AnsiString RowLabel, AnsiString ColumnLabel, double Value);
    virtual double    __fastcall GetValuesByIndex(int RowIndex, int ColumnIndex);
    virtual void    __fastcall SetValuesByIndex(int RowIndex, int ColumnIndex, double Value);
    virtual bool    __fastcall GetEnabled(AnsiString RowLabel, AnsiString ColumnLabel);
    virtual void    __fastcall SetEnabled(AnsiString RowLabel, AnsiString ColumnLabel, bool Value);
    virtual bool    __fastcall GetEnabledByIndex(int RowIndex, int ColumnIndex);
    virtual void    __fastcall SetEnabledByIndex(int RowIndex, int ColumnIndex, bool Value);
    virtual int        __fastcall GetNumberOfRows(void);
    virtual int     __fastcall GetNumberOfColumns(void);
    virtual TStringList*    __fastcall GetRowLabelList(void);
    virtual TStringList*    __fastcall GetColumnLabelList(void);

    virtual TCFbETable*        __fastcall GetSimilarityComputationTable(void);
    virtual TCFbETable*        __fastcall GetPredictionTable(void);

    virtual double    __fastcall GetSimilarities(AnsiString TargetRowLabel, AnsiString ComparedRowLabel);
    virtual double    __fastcall GetSimilaritiesByIndex(int TargetRowIndex, int ComparedRowIndex);
    virtual double    __fastcall GetPredictedValues(AnsiString TargetRowLabel, AnsiString TargetColumnLabel);
    virtual double    __fastcall GetPredictedValuesByIndex(int TargetRowIndex, int TargetColumnIndex);

    virtual void    __fastcall IsUpdated(void);    // Abvf[gꂽƂ}[NCLbVNA

    virtual void __fastcall CsvToStrings2(char* str, TStrings *List);    // CSV`̕TStringsɕ
    
private:

};
//---------------------------------------------------------------------------
#endif
