/*
    TCFbETestCase9.cpp    December 28, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETestCase9H
#define TCFbETestCase9H
//---------------------------------------------------------------------------
#pragma hdrstop
//---------------------------------------------------------------------------
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>
#include <math.h>

USING_NAMESPACE_CPPUNIT
//---------------------------------------------------------------------------
#include <System.hpp>

#include "TCFbETypes.h"
#include "TCFbEDataSetEx.h"
#include "TCFbECombinedSimilarity.h"
#include "TCFbECosineSimilarity.h"
#include "TCFbEDistanceSimilarityWithAverage.h"
#include "TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier.h"
#include "TCFbERankCorrelation.h"
#include "TCFbECorrelationCoefficientWithAverage.h"
#include "TCFbEDocfbeCommandLineParser.h"
#include "TCFbEDocfbeDataLoader.h"
#include "TCFbEOutputCache.h"
//---------------------------------------------------------------------------
// eXgP[X9
class TCFbETestCase9 : public TestCase
{
    // RXgN^
    TEST_CASE_COMMON(TCFbETestCase9)

public:
    // eXg
    // FILENAME BUG	LOC	N_COMM	HALVOL	SCPMN
    // module_1	10	800	0.3	    3600	4
    // module_2	0	250	0.2	    3200	3.5
    // module_3	8	500	0	    3200
    // module_4	5	700	0.25		    4
    // module_5	9	600		    3200	2.5
    // module_6	15		0.35	3800	4.1
    virtual void setUp() {
        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,  BUG,    LOC,    N_COMM, HALVOL, SCPMN");
        TestStringList->Add("module_1,  10,     800,    0.3,    3600,   4");
        TestStringList->Add("module_2,  0,      250,    0.2,    3200,   3.5");
        TestStringList->Add("module_3,  8,      500,    0,      3200,   ");
        TestStringList->Add("module_4,  5,      700,    0.25,   ,       4");
        TestStringList->Add("module_5,  9,      600,    ,       3200,   2.5");
        TestStringList->Add("module_6,  15,     ,       0.35,   3800,   4.1");
        this->DataSetEx = new TCFbEDataSetEx(TestStringList, "");
        delete TestStringList;
    }

    // eXǧЕt
    virtual void tearDown() {
        delete this->DataSetEx;
    }

    //  Combined Similarity (Cosine Similarity + Distance Similarity with Average)
    //
    //  0.508665025
    //  0.45128808
    //  0.943964912
    //  0.445675326
    //  0.882547563
    virtual void Test_TCFbECombinedSimilarity_TCFbECosineSimilarity_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abRow_VW() {
        this->DataSetEx->PrepareCF(vbNormalizedValue, abRow, new TCFbECombinedSimilarity(new TCFbECosineSimilarity, new TCFbEDistanceSimilarityWithAverage(), 0.4), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbERankCorrelation(), new TCFbECorrelationCoefficientWithAverage(), 0.0);
        this->DataSetEx->TemporallyUnable(0, 0);

        TEST_ASSERT_EQUALS_DOUBLE(0.508665025,  this->DataSetEx->GetSimilarity("module_1", "module_2", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.45128808,   this->DataSetEx->GetSimilarity("module_1", "module_3", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.943964912,  this->DataSetEx->GetSimilarity("module_1", "module_4", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.445675326,  this->DataSetEx->GetSimilarity("module_1", "module_5", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.882547563,  this->DataSetEx->GetSimilarity("module_1", "module_6", 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(9.220149187,    this->DataSetEx->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    virtual void Test_TCFbEOutputCache_TCFbECombinedSimilarity_TCFbECosineSimilarity_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abRow_VW() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=0"
            , "-t=BUG"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=CosineSimilarity"
            , "-cs=DistanceSimilarityWithAverage"
            , "-cr=0.4"
            , "-p=AmplifiedWeightedSumWithVWWeightedMultiplier"
            , "-vs=RankCorrelation"
            , "-vp=CorrelationCoefficientWithAverage"
        };

        TCFbEDocfbeCommandLineParser*   Parser = new TCFbEDocfbeCommandLineParser(12, argv);
        Parser->DoParse();
        TCFbEDocfbeDataLoader*  DataLoader = new TCFbEDocfbeDataLoader(Parser);
        TCFbEOutputCache*       Cash = new TCFbEOutputCache(Parser, DataLoader);

        TEST_ASSERT_EQUALS((int)true,    (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));

        TEST_ASSERT_EQUALS_DOUBLE(9.220149187,    Cash->GetResultValue(0, 0), 1E-6);

        delete Cash;
        delete DataLoader;
        delete Parser;
    }

    // TCFbEPrimitiveTable LogN feature
    virtual void Test_TCFbEPrimitiveTable_LogN() {
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(8,    this->DataSetEx->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5,    this->DataSetEx->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9,    this->DataSetEx->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(15,   this->DataSetEx->GetValue("module_6", "BUG"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(800,  this->DataSetEx->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  this->DataSetEx->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  this->DataSetEx->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700,  this->DataSetEx->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600,  this->DataSetEx->GetValue("module_5", "LOC"), 1E-6);

        this->DataSetEx->Log(10);

        TEST_ASSERT_EQUALS_DOUBLE(0,            this->DataSetEx->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.903089987,  this->DataSetEx->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.698970004,  this->DataSetEx->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.954242509,  this->DataSetEx->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.176091259,  this->DataSetEx->GetValue("module_6", "BUG"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.903089987,  this->DataSetEx->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.397940009,  this->DataSetEx->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.698970004,  this->DataSetEx->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.84509804,  this->DataSetEx->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.77815125,  this->DataSetEx->GetValue("module_5", "LOC"), 1E-6);
    }

    //  Log10 Combined Similarity (Cosine Similarity + Distance Similarity with Average)
    //
    //  0.462868057
    //  0.389597819
    //  0.951643445
    //  0.438059399
    //  0.907647343
    virtual void Test_TCFbECombinedSimilarity_TCFbECosineSimilarity_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abRow_VW_log10() {
        this->DataSetEx->PrepareCF(vbNormalizedValue, abRow, new TCFbECombinedSimilarity(new TCFbECosineSimilarity, new TCFbEDistanceSimilarityWithAverage(), 0.4), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbERankCorrelation(), new TCFbECorrelationCoefficientWithAverage(), 10.0);
        this->DataSetEx->TemporallyUnable(0, 0);

        TEST_ASSERT_EQUALS_DOUBLE(0.462868057,  this->DataSetEx->GetSimilarity("module_1", "module_2", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.389597819,  this->DataSetEx->GetSimilarity("module_1", "module_3", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.951643445,  this->DataSetEx->GetSimilarity("module_1", "module_4", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.438059399,  this->DataSetEx->GetSimilarity("module_1", "module_5", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.907647343,  this->DataSetEx->GetSimilarity("module_1", "module_6", 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(6.854442734,  this->DataSetEx->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    virtual void Test_TCFbEOutputCache_TCFbECombinedSimilarity_TCFbECosineSimilarity_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abRow_VW_log10() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=0"
            , "-t=BUG"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=CosineSimilarity"
            , "-cs=DistanceSimilarityWithAverage"
            , "-cr=0.4"
            , "-p=AmplifiedWeightedSumWithVWWeightedMultiplier"
            , "-vs=RankCorrelation"
            , "-vp=CorrelationCoefficientWithAverage"
            , "-lb=10.0"
        };

        TCFbEDocfbeCommandLineParser*   Parser = new TCFbEDocfbeCommandLineParser(13, argv);
        Parser->DoParse();
        TCFbEDocfbeDataLoader*  DataLoader = new TCFbEDocfbeDataLoader(Parser);
        TCFbEOutputCache*       Cash = new TCFbEOutputCache(Parser, DataLoader);

        TEST_ASSERT_EQUALS((int)true,     (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));

        TEST_ASSERT_EQUALS_DOUBLE(6.854442734,  Cash->GetResultValue(0, 0), 1E-6);

        delete Cash;
        delete DataLoader;
        delete Parser;
    }

    //  LogE Combined Similarity (Cosine Similarity + Distance Similarity with Average)
    //
    //  0.462868057
    //  0.389597819
    //  0.951643445
    //  0.438059399
    //  0.907647343
    virtual void Test_TCFbECombinedSimilarity_TCFbECosineSimilarity_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abRow_VW_logE() {
        this->DataSetEx->PrepareCF(vbNormalizedValue, abRow, new TCFbECombinedSimilarity(new TCFbECosineSimilarity, new TCFbEDistanceSimilarityWithAverage(), 0.4), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbERankCorrelation(), new TCFbECorrelationCoefficientWithAverage(), exp(1));
        this->DataSetEx->TemporallyUnable(0, 0);

        TEST_ASSERT_EQUALS_DOUBLE(0.462868057,  this->DataSetEx->GetSimilarity("module_1", "module_2", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.389597819,  this->DataSetEx->GetSimilarity("module_1", "module_3", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.951643445,  this->DataSetEx->GetSimilarity("module_1", "module_4", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.438059399,  this->DataSetEx->GetSimilarity("module_1", "module_5", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.907647343,  this->DataSetEx->GetSimilarity("module_1", "module_6", 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(6.854442734,  this->DataSetEx->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    virtual void Test_TCFbEOutputCache_TCFbECombinedSimilarity_TCFbECosineSimilarity_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abRow_VW_logE() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=0"
            , "-t=BUG"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=CosineSimilarity"
            , "-cs=DistanceSimilarityWithAverage"
            , "-cr=0.4"
            , "-p=AmplifiedWeightedSumWithVWWeightedMultiplier"
            , "-vs=RankCorrelation"
            , "-vp=CorrelationCoefficientWithAverage"
            , "-lb=e"
        };

        TCFbEDocfbeCommandLineParser*   Parser = new TCFbEDocfbeCommandLineParser(13, argv);
        Parser->DoParse();
        TCFbEDocfbeDataLoader*  DataLoader = new TCFbEDocfbeDataLoader(Parser);
        TCFbEOutputCache*       Cash = new TCFbEOutputCache(Parser, DataLoader);

        TEST_ASSERT_EQUALS((int)true,     (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));

        TEST_ASSERT_EQUALS_DOUBLE(6.854442734,  Cash->GetResultValue(0, 0), 1E-6);

        delete Cash;
        delete DataLoader;
        delete Parser;
    }

    // TCFbEPrimitiveTable auto expanding feature
    virtual void Test_TCFbEPrimitiveTable_AutoExpanding_log10() {
        delete this->DataSetEx;

        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,  BUG,    LOC,    LANG,   SCPMN");
        TestStringList->Add("module_1,  10,     800,    C++,    4");
        TestStringList->Add("module_2,  0,      250,    JAVA,   3.5");
        TestStringList->Add("module_3,  8,      500,    C++,    ");
        TestStringList->Add("module_4,  5,      700,    PASCAL, 4");
        TestStringList->Add("module_5,  9,      600,    ,       2.5");
        TestStringList->Add("module_6,  15,     ,       JAVA,   4.1");
        this->DataSetEx = new TCFbEDataSetEx(TestStringList, "");
        delete TestStringList;

        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(8,    this->DataSetEx->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5,    this->DataSetEx->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9,    this->DataSetEx->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(15,   this->DataSetEx->GetValue("module_6", "BUG"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(800,  this->DataSetEx->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  this->DataSetEx->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  this->DataSetEx->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700,  this->DataSetEx->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600,  this->DataSetEx->GetValue("module_5", "LOC"), 1E-6);

        this->DataSetEx->Log(10);

        TEST_ASSERT_EQUALS_DOUBLE(0,            this->DataSetEx->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.903089987,  this->DataSetEx->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.698970004,  this->DataSetEx->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.954242509,  this->DataSetEx->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.176091259,  this->DataSetEx->GetValue("module_6", "BUG"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.903089987,  this->DataSetEx->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.397940009,  this->DataSetEx->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.698970004,  this->DataSetEx->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.84509804,  this->DataSetEx->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.77815125,  this->DataSetEx->GetValue("module_5", "LOC"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.602059991,  this->DataSetEx->GetValue("module_1", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.544068044,  this->DataSetEx->GetValue("module_2", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.602059991,  this->DataSetEx->GetValue("module_4", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.397940009,  this->DataSetEx->GetValue("module_5", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.612783857,  this->DataSetEx->GetValue("module_6", "SCPMN"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,    this->DataSetEx->GetValue("module_1", "C++@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_2", "C++@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    this->DataSetEx->GetValue("module_3", "C++@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_4", "C++@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_6", "C++@LANG"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_1", "JAVA@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    this->DataSetEx->GetValue("module_2", "JAVA@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_3", "JAVA@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_4", "JAVA@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    this->DataSetEx->GetValue("module_6", "JAVA@LANG"), 1E-6);
    }

    //  With auto expanding feature, log10 Combined Similarity (Cosine Similarity + Distance Similarity with Average) with auto expanding feature
    virtual void Test_AutoExpanding_TCFbECombinedSimilarity_TCFbECosineSimilarity_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abRow_VW_log10() {
        delete this->DataSetEx;

        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,  BUG,    LOC,    LANG,   SCPMN");
        TestStringList->Add("module_1,  10,     800,    C++,    4");
        TestStringList->Add("module_2,  0,      250,    JAVA,   3.5");
        TestStringList->Add("module_3,  8,      500,    C++,    ");
        TestStringList->Add("module_4,  5,      700,    PASCAL, 4");
        TestStringList->Add("module_5,  9,      600,    ,       2.5");
        TestStringList->Add("module_6,  15,     ,       JAVA,   4.1");
        this->DataSetEx = new TCFbEDataSetEx(TestStringList, "");
        delete TestStringList;

        this->DataSetEx->PrepareCF(vbNormalizedValue, abRow, new TCFbECombinedSimilarity(new TCFbECosineSimilarity, new TCFbEDistanceSimilarityWithAverage(), 0.4), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbERankCorrelation(), new TCFbECorrelationCoefficientWithAverage(), 10.0);
        this->DataSetEx->TemporallyUnable(0, 0);

        TEST_ASSERT_EQUALS_DOUBLE(0.460277745,  this->DataSetEx->GetSimilarity("module_1", "module_2", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.84523589,   this->DataSetEx->GetSimilarity("module_1", "module_3", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.773733405,  this->DataSetEx->GetSimilarity("module_1", "module_4", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.557300134,  this->DataSetEx->GetSimilarity("module_1", "module_5", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.678714008,  this->DataSetEx->GetSimilarity("module_1", "module_6", 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(6.07819779,  this->DataSetEx->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    // TCFbEPrimitiveTable qualitative indicator feature
    virtual void Test_TCFbEPrimitiveTable_QualitativeIndicator_log10() {
        delete this->DataSetEx;

        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,  BUG,    LOC,    SCPMN,  &C++@LANG,   &JAVA@LANG");
        TestStringList->Add("module_1,  10,     800,    4,      1.0,        0.0");
        TestStringList->Add("module_2,  0,      250,    3.5,    0.0,        1.0");
        TestStringList->Add("module_3,  8,      500,    ,       1.0,        0.0");
        TestStringList->Add("module_4,  5,      700,    4,      0.0,        0.0");
        TestStringList->Add("module_5,  9,      600,    2.5,    ,           ");
        TestStringList->Add("module_6,  15,     ,       4.1,    0.0,        1.0");
        this->DataSetEx = new TCFbEDataSetEx(TestStringList, "&");
        delete TestStringList;

        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(8,    this->DataSetEx->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5,    this->DataSetEx->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9,    this->DataSetEx->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(15,   this->DataSetEx->GetValue("module_6", "BUG"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(800,  this->DataSetEx->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  this->DataSetEx->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  this->DataSetEx->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700,  this->DataSetEx->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600,  this->DataSetEx->GetValue("module_5", "LOC"), 1E-6);

        this->DataSetEx->Log(10);

        TEST_ASSERT_EQUALS_DOUBLE(0,            this->DataSetEx->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.903089987,  this->DataSetEx->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.698970004,  this->DataSetEx->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.954242509,  this->DataSetEx->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.176091259,  this->DataSetEx->GetValue("module_6", "BUG"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.903089987,  this->DataSetEx->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.397940009,  this->DataSetEx->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.698970004,  this->DataSetEx->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.84509804,  this->DataSetEx->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.77815125,  this->DataSetEx->GetValue("module_5", "LOC"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.602059991,  this->DataSetEx->GetValue("module_1", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.544068044,  this->DataSetEx->GetValue("module_2", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.602059991,  this->DataSetEx->GetValue("module_4", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.397940009,  this->DataSetEx->GetValue("module_5", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.612783857,  this->DataSetEx->GetValue("module_6", "SCPMN"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,    this->DataSetEx->GetValue("module_1", "&C++@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_2", "&C++@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    this->DataSetEx->GetValue("module_3", "&C++@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_4", "&C++@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_6", "&C++@LANG"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_1", "&JAVA@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    this->DataSetEx->GetValue("module_2", "&JAVA@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_3", "&JAVA@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_4", "&JAVA@LANG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,    this->DataSetEx->GetValue("module_6", "&JAVA@LANG"), 1E-6);
    }

    //  With qualitative indicator, log10 Combined Similarity (Cosine Similarity + Distance Similarity with Average) with auto expanding feature
    virtual void Test_QualitativeIndicator_TCFbECombinedSimilarity_TCFbECosineSimilarity_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abRow_VW_log10() {
        delete this->DataSetEx;

        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,  BUG,    LOC,    SCPMN,  $$C++@LANG,   $$JAVA@LANG");
        TestStringList->Add("module_1,  10,     800,    4,      1.0,        0.0");
        TestStringList->Add("module_2,  0,      250,    3.5,    0.0,        1.0");
        TestStringList->Add("module_3,  8,      500,    ,       1.0,        0.0");
        TestStringList->Add("module_4,  5,      700,    4,      0.0,        0.0");
        TestStringList->Add("module_5,  9,      600,    2.5,    ,           ");
        TestStringList->Add("module_6,  15,     ,       4.1,    0.0,        1.0");
        this->DataSetEx = new TCFbEDataSetEx(TestStringList, "$$");
        delete TestStringList;

        this->DataSetEx->PrepareCF(vbNormalizedValue, abRow, new TCFbECombinedSimilarity(new TCFbECosineSimilarity, new TCFbEDistanceSimilarityWithAverage(), 0.4), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbERankCorrelation(), new TCFbECorrelationCoefficientWithAverage(), 10.0);
        this->DataSetEx->TemporallyUnable(0, 0);

        TEST_ASSERT_EQUALS_DOUBLE(0.460277745,  this->DataSetEx->GetSimilarity("module_1", "module_2", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.84523589,   this->DataSetEx->GetSimilarity("module_1", "module_3", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.773733405,  this->DataSetEx->GetSimilarity("module_1", "module_4", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.557300134,  this->DataSetEx->GetSimilarity("module_1", "module_5", 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.678714008,  this->DataSetEx->GetSimilarity("module_1", "module_6", 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(6.07819779,  this->DataSetEx->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

protected:
    TCFbEDataSetEx* DataSetEx;
};

//---------------------------------------------------------------------------
#endif


