/*
    TCFbETestCase7.cpp    December 28, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETestCase7H
#define TCFbETestCase7H
//---------------------------------------------------------------------------
#pragma hdrstop
//---------------------------------------------------------------------------
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>

USING_NAMESPACE_CPPUNIT
//---------------------------------------------------------------------------
#include <System.hpp>

#include "TCFbETableEx.h"
#include "TCFbEDataSetEx.h"
#include "TCFbEAdjustedCosineSimilarityWithAverage.h"
#include "TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier.h"
#include "TCFbECorrelationCoefficientWithAverage.h"
//---------------------------------------------------------------------------
// eXgP[X7
class TCFbETestCase7 : public TestCase
{
    // RXgN^
    TEST_CASE_COMMON(TCFbETestCase7)

public:
    // eXg
    // FILENAME BUG	LOC	N_COMM	HALVOL	SCPMN
    // module_1	10	800	0.3	    3600	4
    // module_2	0	250	0.2	    3200	3.5
    // module_3	8	500	0	    3200
    // module_4	5	700	0.25		    4
    // module_5	9	600		    3200	2.5
    // module_6	15		0.35	3800	4.1
    virtual void setUp() {
        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,  BUG,    LOC,    N_COMM, HALVOL, SCPMN");
        TestStringList->Add("module_1,  10,     800,    0.3,    3600,   4");
        TestStringList->Add("module_2,  0,      250,    0.2,    3200,   3.5");
        TestStringList->Add("module_3,  8,      500,    0,      3200,   ");
        TestStringList->Add("module_4,  5,      700,    0.25,   ,       4");
        TestStringList->Add("module_5,  9,      600,    ,       3200,   2.5");
        TestStringList->Add("module_6,  15,     ,       0.35,   3800,   4.1");
        this->DataSetEx = new TCFbEDataSetEx(TestStringList, "");
        delete TestStringList;
    }

    // eXǧЕt
    virtual void tearDown() {
        delete this->DataSetEx;
    }

    //---------------------------------------------------------------------------
    // VW ̂߂ DataSetEx ̃eXg
    //---------------------------------------------------------------------------
    virtual void Test_TCFbEDataSetEx_Constructor_VW() {
        TEST_ASSERT_EQUALS(5, this->DataSetEx->GetNumberOfColumns());
        TEST_ASSERT_EQUALS(6, this->DataSetEx->GetNumberOfRows());

        TEST_ASSERT_EQUALS("BUG",   this->DataSetEx->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",   this->DataSetEx->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",this->DataSetEx->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",this->DataSetEx->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN", this->DataSetEx->GetColumnLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS("module_1", this->DataSetEx->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2", this->DataSetEx->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3", this->DataSetEx->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4", this->DataSetEx->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5", this->DataSetEx->GetRowLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6", this->DataSetEx->GetRowLabelList()->Strings[5].c_str());

        // module_1	10	800	0.3	    3600	4
        TEST_ASSERT_EQUALS_DOUBLE(10,   this->DataSetEx->GetValue("module_1", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(800,  this->DataSetEx->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  this->DataSetEx->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600, this->DataSetEx->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,    this->DataSetEx->GetValue("module_1", "SCPMN"), 1E-6);

        // module_2	0   250	0.2	    3200	3.5
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  this->DataSetEx->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  this->DataSetEx->GetValue("module_2", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, this->DataSetEx->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5,  this->DataSetEx->GetValue("module_2", "SCPMN"), 1E-6);

        // module_3	8	500	0	    3200
        TEST_ASSERT_EQUALS_DOUBLE(8,    this->DataSetEx->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  this->DataSetEx->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    this->DataSetEx->GetValue("module_3", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200, this->DataSetEx->GetValue("module_3", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)this->DataSetEx->GetEnabled("module_3", "SCPMN"));

        // module_4	5	700	0.25		    4
        TEST_ASSERT_EQUALS_DOUBLE(5, this->DataSetEx->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700, this->DataSetEx->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, this->DataSetEx->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)this->DataSetEx->GetEnabled("module_4", "HALVOL"));
        TEST_ASSERT_EQUALS_DOUBLE(4, this->DataSetEx->GetValue("module_4", "SCPMN"), 1E-6);

        // module_5	9	600		    3200	2.5
        TEST_ASSERT_EQUALS_DOUBLE(9,    this->DataSetEx->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600,  this->DataSetEx->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)this->DataSetEx->GetEnabled("module_5", "N_COMM"));
        TEST_ASSERT_EQUALS_DOUBLE(3200, this->DataSetEx->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5,  this->DataSetEx->GetValue("module_5", "SCPMN"), 1E-6);

        // module_6	15		0.35	3800	4.1
        TEST_ASSERT_EQUALS_DOUBLE(15,   this->DataSetEx->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)this->DataSetEx->GetEnabled("module_6", "LOC"));
        TEST_ASSERT_EQUALS_DOUBLE(0.35, this->DataSetEx->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800, this->DataSetEx->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1,  this->DataSetEx->GetValue("module_6", "SCPMN"), 1E-6);
    }

    //  VWSimilarityComputationTable
    //  FILENAME	BUG	        LOC	        N_COMM	    HALVOL	    SCPMN
    //  module_1		        1	        0.857142857	0.666666667	0.9375
    //  module_2	0	        0	        0.571428571	0	        0.625
    //  module_3	0.533333333	0.454545455	0	        0
    //  module_4	0.333333333	0.818181818	0.714285714		        0.9375
    //  module_5	0.6	        0.636363636		        0	        0
    //  module_6	1		                1	        1	        1
    virtual void Test_TCFbEDataSetEx_VWSimilarityComputationTable_vbNormalizedValue_abColumn_VW() {
        this->DataSetEx->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbECorrelationCoefficientWithAverage(), new TCFbECorrelationCoefficientWithAverage(), 0.0);
        this->DataSetEx->TemporallyUnable(0, 0);

        TCFbECustomTableEx* VWSimilarityComputationTable = (TCFbETableEx*)this->DataSetEx->GetChildCache("NormalizedTable")->GetChildCache("VWSimilarityComputationTable");

        TEST_ASSERT_EQUALS(5, VWSimilarityComputationTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS(6, VWSimilarityComputationTable->GetNumberOfRows());

        TEST_ASSERT_EQUALS("BUG",   VWSimilarityComputationTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",   VWSimilarityComputationTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",VWSimilarityComputationTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",VWSimilarityComputationTable->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN", VWSimilarityComputationTable->GetColumnLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS("module_1", VWSimilarityComputationTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2", VWSimilarityComputationTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3", VWSimilarityComputationTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4", VWSimilarityComputationTable->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5", VWSimilarityComputationTable->GetRowLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6", VWSimilarityComputationTable->GetRowLabelList()->Strings[5].c_str());

        //  module_1		        1	        0.857142857	0.666666667	0.9375
        TEST_ASSERT_EQUALS((int)false, (int)VWSimilarityComputationTable->GetEnabled("module_1", "BUG"));
        TEST_ASSERT_EQUALS_DOUBLE(1,            VWSimilarityComputationTable->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.857142857,  VWSimilarityComputationTable->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.666666667,  VWSimilarityComputationTable->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375,       VWSimilarityComputationTable->GetValue("module_1", "SCPMN"), 1E-6);

        //  module_2	0	        0	        0.571428571	0	        0.625
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWSimilarityComputationTable->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWSimilarityComputationTable->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571,  VWSimilarityComputationTable->GetValue("module_2", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWSimilarityComputationTable->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.625,        VWSimilarityComputationTable->GetValue("module_2", "SCPMN"), 1E-6);

        //  module_3	0.533333333	0.454545455	0	        0
        TEST_ASSERT_EQUALS_DOUBLE(0.533333333,  VWSimilarityComputationTable->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.454545455,  VWSimilarityComputationTable->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWSimilarityComputationTable->GetValue("module_3", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWSimilarityComputationTable->GetValue("module_3", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)VWSimilarityComputationTable->GetEnabled("module_3", "SCPMN"));

        //  module_4	0.333333333	0.818181818	0.714285714		        0.9375
        TEST_ASSERT_EQUALS_DOUBLE(0.333333333,  VWSimilarityComputationTable->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.818181818,  VWSimilarityComputationTable->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714,  VWSimilarityComputationTable->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)VWSimilarityComputationTable->GetEnabled("module_4", "HALVOL"));
        TEST_ASSERT_EQUALS_DOUBLE(0.9375,       VWSimilarityComputationTable->GetValue("module_4", "SCPMN"), 1E-6);

        //  module_5	0.6	        0.636363636		        0	        0
        TEST_ASSERT_EQUALS_DOUBLE(0.6,          VWSimilarityComputationTable->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.636363636,  VWSimilarityComputationTable->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)VWSimilarityComputationTable->GetEnabled("module_5", "N_COMM"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWSimilarityComputationTable->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWSimilarityComputationTable->GetValue("module_5", "SCPMN"), 1E-6);

        //  module_6	1		                1	        1	        1
        TEST_ASSERT_EQUALS_DOUBLE(1, VWSimilarityComputationTable->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)VWSimilarityComputationTable->GetEnabled("module_6", "LOC"));
        TEST_ASSERT_EQUALS_DOUBLE(1, VWSimilarityComputationTable->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, VWSimilarityComputationTable->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, VWSimilarityComputationTable->GetValue("module_6", "SCPMN"), 1E-6);
    }

    //  VWPredictionTable
    //  FILENAME	BUG	        LOC	        N_COMM	    HALVOL	    SCPMN
    //  module_1		        1	        0.857142857	0.666666667	0.9375
    //  module_2	0	        0	        0.571428571	0	        0.625
    //  module_3	0.533333333	0.454545455	0	        0
    //  module_4	0.333333333	0.818181818	0.714285714		        0.9375
    //  module_5	0.6	        0.636363636		        0	        0
    //  module_6	1		                1	        1	        1
    virtual void Test_TCFbEDataSetEx_VWPredictionTable_vbNormalizedValue_abColumn_VW() {
        this->DataSetEx->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbECorrelationCoefficientWithAverage(), new TCFbECorrelationCoefficientWithAverage(), 0.0);
        this->DataSetEx->TemporallyUnable(0, 0);

        TCFbECustomTableEx* VWPredictionTable = (TCFbETableEx*)this->DataSetEx->GetChildCache("NormalizedTable")->GetChildCache("VWPredictionTable");

        TEST_ASSERT_EQUALS(5, VWPredictionTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS(6, VWPredictionTable->GetNumberOfRows());

        TEST_ASSERT_EQUALS("BUG",   VWPredictionTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",   VWPredictionTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",VWPredictionTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",VWPredictionTable->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN", VWPredictionTable->GetColumnLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS("module_1", VWPredictionTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2", VWPredictionTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3", VWPredictionTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4", VWPredictionTable->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5", VWPredictionTable->GetRowLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6", VWPredictionTable->GetRowLabelList()->Strings[5].c_str());

        //  module_1		        1	        0.857142857	0.666666667	0.9375
        TEST_ASSERT_EQUALS((int)false, (int)VWPredictionTable->GetEnabled("module_1", "BUG"));
        TEST_ASSERT_EQUALS_DOUBLE(1,            VWPredictionTable->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.857142857,  VWPredictionTable->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.666666667,  VWPredictionTable->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375,       VWPredictionTable->GetValue("module_1", "SCPMN"), 1E-6);

        //  module_2	0	        0	        0.571428571	0	        0.625
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWPredictionTable->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWPredictionTable->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571,  VWPredictionTable->GetValue("module_2", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWPredictionTable->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.625,        VWPredictionTable->GetValue("module_2", "SCPMN"), 1E-6);

        //  module_3	0.533333333	0.454545455	0	        0
        TEST_ASSERT_EQUALS_DOUBLE(0.533333333,  VWPredictionTable->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.454545455,  VWPredictionTable->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWPredictionTable->GetValue("module_3", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWPredictionTable->GetValue("module_3", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)VWPredictionTable->GetEnabled("module_3", "SCPMN"));

        //  module_4	0.333333333	0.818181818	0.714285714		        0.9375
        TEST_ASSERT_EQUALS_DOUBLE(0.333333333,  VWPredictionTable->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.818181818,  VWPredictionTable->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714,  VWPredictionTable->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)VWPredictionTable->GetEnabled("module_4", "HALVOL"));
        TEST_ASSERT_EQUALS_DOUBLE(0.9375,       VWPredictionTable->GetValue("module_4", "SCPMN"), 1E-6);

        //  module_5	0.6	        0.636363636		        0	        0
        TEST_ASSERT_EQUALS_DOUBLE(0.6,          VWPredictionTable->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.636363636,  VWPredictionTable->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)VWPredictionTable->GetEnabled("module_5", "N_COMM"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWPredictionTable->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            VWPredictionTable->GetValue("module_5", "SCPMN"), 1E-6);

        //  module_6	1		                1	        1	        1
        TEST_ASSERT_EQUALS_DOUBLE(1, VWPredictionTable->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)VWPredictionTable->GetEnabled("module_6", "LOC"));
        TEST_ASSERT_EQUALS_DOUBLE(1, VWPredictionTable->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, VWPredictionTable->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, VWPredictionTable->GetValue("module_6", "SCPMN"), 1E-6);
    }

    //  NormalizedTable
    //  FILENAME	BUG	        LOC	        N_COMM	    HALVOL	    SCPMN
    //  module_1		        1	        0.857142857	0.666666667	0.9375
    //  module_2	0	        0	        0.571428571	0	        0.625
    //  module_3	0.533333333	0.454545455	0	        0
    //  module_4	0.333333333	0.818181818	0.714285714		        0.9375
    //  module_5	0.6	        0.636363636		        0	        0
    //  module_6	1		                1	        1	        1
    virtual void Test_TCFbEDataSetEx_NormalizedTable_vbNormalizedValue_abColumn_VW() {
        this->DataSetEx->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbECorrelationCoefficientWithAverage(), new TCFbECorrelationCoefficientWithAverage(), 0.0);
        this->DataSetEx->TemporallyUnable(0, 0);

        TCFbETableEx* NormalizedTable = (TCFbETableEx*)this->DataSetEx->GetChildCache("NormalizedTable");

        TEST_ASSERT_EQUALS(5, NormalizedTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS(6, NormalizedTable->GetNumberOfRows());

        TEST_ASSERT_EQUALS("BUG",   NormalizedTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",   NormalizedTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",NormalizedTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",NormalizedTable->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN", NormalizedTable->GetColumnLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS("module_1", NormalizedTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2", NormalizedTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3", NormalizedTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4", NormalizedTable->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5", NormalizedTable->GetRowLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6", NormalizedTable->GetRowLabelList()->Strings[5].c_str());

        //  module_1		        1	        0.857142857	0.666666667	0.9375
        TEST_ASSERT_EQUALS((int)false, (int)NormalizedTable->GetEnabled("module_1", "BUG"));
        TEST_ASSERT_EQUALS_DOUBLE(1,            NormalizedTable->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.857142857,  NormalizedTable->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.666666667,  NormalizedTable->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375,       NormalizedTable->GetValue("module_1", "SCPMN"), 1E-6);

        //  module_2	0	        0	        0.571428571	0	        0.625
        TEST_ASSERT_EQUALS_DOUBLE(0,            NormalizedTable->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            NormalizedTable->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571,  NormalizedTable->GetValue("module_2", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            NormalizedTable->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.625,        NormalizedTable->GetValue("module_2", "SCPMN"), 1E-6);

        //  module_3	0.533333333	0.454545455	0	        0
        TEST_ASSERT_EQUALS_DOUBLE(0.533333333,  NormalizedTable->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.454545455,  NormalizedTable->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            NormalizedTable->GetValue("module_3", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            NormalizedTable->GetValue("module_3", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)NormalizedTable->GetEnabled("module_3", "SCPMN"));

        //  module_4	0.333333333	0.818181818	0.714285714		        0.9375
        TEST_ASSERT_EQUALS_DOUBLE(0.333333333,  NormalizedTable->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.818181818,  NormalizedTable->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714,  NormalizedTable->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)NormalizedTable->GetEnabled("module_4", "HALVOL"));
        TEST_ASSERT_EQUALS_DOUBLE(0.9375,       NormalizedTable->GetValue("module_4", "SCPMN"), 1E-6);

        //  module_5	0.6	        0.636363636		        0	        0
        TEST_ASSERT_EQUALS_DOUBLE(0.6,          NormalizedTable->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.636363636,  NormalizedTable->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)NormalizedTable->GetEnabled("module_5", "N_COMM"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            NormalizedTable->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            NormalizedTable->GetValue("module_5", "SCPMN"), 1E-6);

        //  module_6	1		                1	        1	        1
        TEST_ASSERT_EQUALS_DOUBLE(1, NormalizedTable->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)NormalizedTable->GetEnabled("module_6", "LOC"));
        TEST_ASSERT_EQUALS_DOUBLE(1, NormalizedTable->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, NormalizedTable->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, NormalizedTable->GetValue("module_6", "SCPMN"), 1E-6);
    }

    //  SimilarityComputationTable
    //  FILENAME	module_1	module_2	module_3	module_4	module_5	module_6
    //  BUG		                0	        0.532094864	0.082880527	0.599603766	0.993493614
    //  LOC	        1	        0	        0.453489941	0.20343402	0.635943388
    //  N_COMM	    0.857142857	0.560708933	0	        0.177601128		        0.993493614
    //  HALVOL	    0.666666667	0	        0		                0	        0.993493614
    //  SCPMN	    0.9375	    0.613275395	            0.233101481 0	        0.993493614
    virtual void Test_TCFbEDataSetEx_SimilarityComputationTable_vbNormalizedValue_abColumn_VW() {
        this->DataSetEx->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbECorrelationCoefficientWithAverage(), new TCFbECorrelationCoefficientWithAverage(), 0.0);
        this->DataSetEx->TemporallyUnable(0, 0);
        this->DataSetEx->GetSimilarityByIndex(0, 1, 0);

        TCFbECustomTableEx* SimilarityComputationTable = (TCFbETableEx*)this->DataSetEx->GetChildCache("NormalizedTable")->GetChildCache("SimilarityComputationTable");

        TEST_ASSERT_EQUALS(6, SimilarityComputationTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS(5, SimilarityComputationTable->GetNumberOfRows());

        TEST_ASSERT_EQUALS("module_1", SimilarityComputationTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2", SimilarityComputationTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3", SimilarityComputationTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4", SimilarityComputationTable->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5", SimilarityComputationTable->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6", SimilarityComputationTable->GetColumnLabelList()->Strings[5].c_str());

        TEST_ASSERT_EQUALS("BUG",   SimilarityComputationTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",   SimilarityComputationTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",SimilarityComputationTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",SimilarityComputationTable->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN", SimilarityComputationTable->GetRowLabelList()->Strings[4].c_str());

        // Variable Weighting icorrelation coefficientjW   1	0.263787326	0.810078601	0.80980267	0.607730614	0
        TEST_ASSERT_EQUALS_DOUBLE(1,            this->DataSetEx->GetVWSimilarityOfColumn(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.263787326,  this->DataSetEx->GetVWSimilarityOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.810078601,  this->DataSetEx->GetVWSimilarityOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.80980267,   this->DataSetEx->GetVWSimilarityOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.607730614,  this->DataSetEx->GetVWSimilarityOfColumn(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            this->DataSetEx->GetVWSimilarityOfColumn(0, 5), 1E-6);

        //  BUG		0	0.43204192	0.269934223	0.364638369	0
        TEST_ASSERT_EQUALS((int)false, (int)SimilarityComputationTable->GetEnabled("BUG",    "module_1"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("BUG",    "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.43204192,   SimilarityComputationTable->GetValue("BUG",    "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.269934223,  SimilarityComputationTable->GetValue("BUG",    "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.364638369,  SimilarityComputationTable->GetValue("BUG",    "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("BUG",    "module_6"), 1E-6);

        //  LOC	1	0	0.368217546	0.662565821	0.386737664
        TEST_ASSERT_EQUALS_DOUBLE(1,            SimilarityComputationTable->GetValue("LOC",    "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("LOC",    "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.368217546,  SimilarityComputationTable->GetValue("LOC",    "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.662565821,  SimilarityComputationTable->GetValue("LOC",    "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.386737664,  SimilarityComputationTable->GetValue("LOC",    "module_5"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)SimilarityComputationTable->GetEnabled("LOC",    "module_6"));

        //  N_COMM	0.857142857	0.150735615	0	0.578430479		0
        TEST_ASSERT_EQUALS_DOUBLE(0.857142857,  SimilarityComputationTable->GetValue("N_COMM", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.150735615,  SimilarityComputationTable->GetValue("N_COMM", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("N_COMM", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.578430479,  SimilarityComputationTable->GetValue("N_COMM", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)SimilarityComputationTable->GetEnabled("N_COMM",    "module_5"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("N_COMM", "module_6"), 1E-6);

        //  HALVOL	0.666666667	0	0		0	0
        TEST_ASSERT_EQUALS_DOUBLE(0.666666667,  SimilarityComputationTable->GetValue("HALVOL", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("HALVOL", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("HALVOL", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)SimilarityComputationTable->GetEnabled("HALVOL",     "module_4"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("HALVOL", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("HALVOL", "module_6"), 1E-6);

        //  SCPMN	0.9375	0.164867079		0.759190003	0	0
        TEST_ASSERT_EQUALS_DOUBLE(0.9375,       SimilarityComputationTable->GetValue("SCPMN",  "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.164867079,  SimilarityComputationTable->GetValue("SCPMN",  "module_2"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)SimilarityComputationTable->GetEnabled("SCPMN",  "module_3"));
        TEST_ASSERT_EQUALS_DOUBLE(0.759190003,  SimilarityComputationTable->GetValue("SCPMN",  "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("SCPMN",  "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("SCPMN",  "module_6"), 1E-6);
    }

    //  PredictionTable
    //  FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
    //  BUG                     0           0.533333333 0.333333333 0.6         1
    //  LOC         1           0           0.454545455 0.818181818 0.636363636
    //  N_COMM      0.857142857 0.571428571 0           0.714285714             1
    //  HALVOL      0.666666667 0           0                       0           1
    //  SCPMN       0.9375      0.625                   0.9375      0           1
    virtual void Test_TCFbEDataSetEx_PredictionTable_vbNormalizedValue_abColumn_VW() {
        this->DataSetEx->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbECorrelationCoefficientWithAverage(), new TCFbECorrelationCoefficientWithAverage(), 0.0);
        this->DataSetEx->TemporallyUnable(0, 0);

        TCFbECustomTableEx* PredictionTable = (TCFbETableEx*)this->DataSetEx->GetChildCache("NormalizedTable")->GetChildCache("PredictionTable");

        TEST_ASSERT_EQUALS(6, PredictionTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS(5, PredictionTable->GetNumberOfRows());

        TEST_ASSERT_EQUALS("module_1", PredictionTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2", PredictionTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3", PredictionTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4", PredictionTable->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5", PredictionTable->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6", PredictionTable->GetColumnLabelList()->Strings[5].c_str());

        TEST_ASSERT_EQUALS("BUG",   PredictionTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",   PredictionTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",PredictionTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",PredictionTable->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN", PredictionTable->GetRowLabelList()->Strings[4].c_str());

        //  BUG                     0           0.533333333 0.333333333 0.6         1
        TEST_ASSERT_EQUALS((int)false, (int)PredictionTable->GetEnabled("BUG",    "module_1"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            PredictionTable->GetValue("BUG",    "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.533333333,  PredictionTable->GetValue("BUG",    "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.333333333,  PredictionTable->GetValue("BUG",    "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,          PredictionTable->GetValue("BUG",    "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            PredictionTable->GetValue("BUG",    "module_6"), 1E-6);

        //  LOC         1           0           0.454545455 0.818181818 0.636363636
        TEST_ASSERT_EQUALS_DOUBLE(1,            PredictionTable->GetValue("LOC",    "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            PredictionTable->GetValue("LOC",    "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.454545455,  PredictionTable->GetValue("LOC",    "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.818181818,  PredictionTable->GetValue("LOC",    "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.636363636,  PredictionTable->GetValue("LOC",    "module_5"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)PredictionTable->GetEnabled("LOC",    "module_6"));

        //  N_COMM      0.857142857 0.571428571 0           0.714285714             1
        TEST_ASSERT_EQUALS_DOUBLE(0.857142857,  PredictionTable->GetValue("N_COMM", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571,  PredictionTable->GetValue("N_COMM", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            PredictionTable->GetValue("N_COMM", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.714285714,  PredictionTable->GetValue("N_COMM", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)PredictionTable->GetEnabled("N_COMM",    "module_5"));
        TEST_ASSERT_EQUALS_DOUBLE(1,            PredictionTable->GetValue("N_COMM", "module_6"), 1E-6);

        //  HALVOL      0.666666667 0           0                       0           1
        TEST_ASSERT_EQUALS_DOUBLE(0.666666667,  PredictionTable->GetValue("HALVOL", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            PredictionTable->GetValue("HALVOL", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            PredictionTable->GetValue("HALVOL", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)PredictionTable->GetEnabled("HALVOL",     "module_4"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            PredictionTable->GetValue("HALVOL", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            PredictionTable->GetValue("HALVOL", "module_6"), 1E-6);

        //  SCPMN       0.9375      0.625                   0.9375      0           1
        TEST_ASSERT_EQUALS_DOUBLE(0.9375,   PredictionTable->GetValue("SCPMN",  "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.625,    PredictionTable->GetValue("SCPMN",  "module_2"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)PredictionTable->GetEnabled("SCPMN",  "module_3"));
        TEST_ASSERT_EQUALS_DOUBLE(0.9375,   PredictionTable->GetValue("SCPMN",  "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,        PredictionTable->GetValue("SCPMN",  "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,        PredictionTable->GetValue("SCPMN",  "module_6"), 1E-6);
    }

    //  Similarity Computation  Adjusted Cosine Similarity with Average
    //  BUG                     1
    //  LOC                     0.416180206
    //  N_COMM                  -0.659623056
    //  HALVOL                  -0.900073719
    //  SCPMN                   -0.95726818
    virtual void Test_TCFbEDataSetEx_AdjustedConsineSimilarity_vbNormalizedValue_abColumn_VW() {
        this->DataSetEx->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(), 0, false, 0.0, false, 1.0, new TCFbECorrelationCoefficientWithAverage(), new TCFbECorrelationCoefficientWithAverage(), 0.0);
        this->DataSetEx->TemporallyUnable(0, 0);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,          this->DataSetEx->GetSimilarityByIndex(0, 0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.416180206,  this->DataSetEx->GetSimilarityByIndex(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.659623056, this->DataSetEx->GetSimilarityByIndex(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.900073719, this->DataSetEx->GetSimilarityByIndex(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.95726818,  this->DataSetEx->GetSimilarityByIndex(0, 4, 0), 1E-6);
    }

    // Amplified Weighted Sum with VW Weighted Multiplier		-1.21031612
    virtual void Test_TCFbEDataSetEx_TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier_vbNormalizedValue_abColumn_VW() {
        TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier* vwwm = new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier();
        this->DataSetEx->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), vwwm, 0, false, 0.0, false, 1.0, new TCFbECorrelationCoefficientWithAverage(), new TCFbECorrelationCoefficientWithAverage(), 0.0);
        this->DataSetEx->TemporallyUnable(0, 0);
        this->DataSetEx->GetPredictedValueByIndex(0, 0);

        //  Variable Weighting icorrelation coefficientjW  1	0.263787326	0.810078601	0.80980267	0.607730614	0
        TEST_ASSERT_EQUALS_DOUBLE(1,            vwwm->GetVWPredictionOfColumn(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.263787326,  vwwm->GetVWPredictionOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.810078601,  vwwm->GetVWPredictionOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.80980267,   vwwm->GetVWPredictionOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.607730614,  vwwm->GetVWPredictionOfColumn(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            vwwm->GetVWPredictionOfColumn(0, 5), 1E-6);

        //  VW Weighted Multiplier
        //  1
        //  0.832018806
        //  0.466666667
        //  0
        //  0.355555556
        TEST_ASSERT_EQUALS_DOUBLE(1,            vwwm->GetVWWeightedMultiplierOfRow(0, 0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.832018806,  vwwm->GetVWWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.466666667,  vwwm->GetVWWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            vwwm->GetVWWeightedMultiplierOfRow(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.355555556,  vwwm->GetVWWeightedMultiplierOfRow(0, 4, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.21031612, this->DataSetEx->GetPredictedValueByIndex(0, 0), 1E-6);
    }

    // Amplified Weighted Sum with VW Weighted Multiplier		38.61195226
    virtual void Test_TCFbEDataSetEx_Reuse_vbNormalizedValue_abColumn_VW() {
        TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier* vwwm = new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier();
        this->DataSetEx->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), vwwm, 0, false, 0.0, false, 1.0, new TCFbECorrelationCoefficientWithAverage(), new TCFbECorrelationCoefficientWithAverage(), 0.0);
        this->DataSetEx->TemporallyUnable(0, 0);
        this->DataSetEx->GetPredictedValueByIndex(0, 0);
        this->DataSetEx->RecoverEnabled();
        this->DataSetEx->TemporallyUnable(0, 1);

        this->DataSetEx->GetSimilarityByIndex(1, 1, 0);

        TCFbECustomTableEx* SimilarityComputationTable = (TCFbETableEx*)this->DataSetEx->GetChildCache("NormalizedTable")->GetChildCache("SimilarityComputationTable");

        TEST_ASSERT_EQUALS(6, SimilarityComputationTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS(5, SimilarityComputationTable->GetNumberOfRows());

        TEST_ASSERT_EQUALS("module_1", SimilarityComputationTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2", SimilarityComputationTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3", SimilarityComputationTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4", SimilarityComputationTable->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5", SimilarityComputationTable->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6", SimilarityComputationTable->GetColumnLabelList()->Strings[5].c_str());

        TEST_ASSERT_EQUALS("BUG",   SimilarityComputationTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",   SimilarityComputationTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",SimilarityComputationTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",SimilarityComputationTable->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN", SimilarityComputationTable->GetRowLabelList()->Strings[4].c_str());

        // Variable Weighting icorrelation coefficientjW   1	0.965109472	-0.229552854	0.791161121	-0.349396603	0
        TEST_ASSERT_EQUALS_DOUBLE(1,            this->DataSetEx->GetVWSimilarityOfColumn(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.965109472,  this->DataSetEx->GetVWSimilarityOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.229552854, this->DataSetEx->GetVWSimilarityOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.791161121,  this->DataSetEx->GetVWSimilarityOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.349396603, this->DataSetEx->GetVWSimilarityOfColumn(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            this->DataSetEx->GetVWSimilarityOfColumn(0, 5), 1E-6);

        //  BUG	0.666666667	0	-0.122428189	0.263720374	-0.209637962	0
        TEST_ASSERT_EQUALS_DOUBLE(0.666666667,  SimilarityComputationTable->GetValue("BUG",    "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("BUG",    "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.122428189, SimilarityComputationTable->GetValue("BUG",    "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.263720374,  SimilarityComputationTable->GetValue("BUG",    "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.209637962, SimilarityComputationTable->GetValue("BUG",    "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("BUG",    "module_6"), 1E-6);

        //  LOC		0	-0.127529363	0.791161121	-0.271752914
        TEST_ASSERT_EQUALS((int)false, (int)SimilarityComputationTable->GetEnabled("LOC",    "module_1"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("LOC",    "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.127529363, SimilarityComputationTable->GetValue("LOC",    "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.791161121,  SimilarityComputationTable->GetValue("LOC",    "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.271752914, SimilarityComputationTable->GetValue("LOC",    "module_5"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)SimilarityComputationTable->GetEnabled("LOC",    "module_6"));

        //  N_COMM	0.857142857	0.551491127	0	0.565115086		0
        TEST_ASSERT_EQUALS_DOUBLE(0.857142857,  SimilarityComputationTable->GetValue("N_COMM", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.551491127,  SimilarityComputationTable->GetValue("N_COMM", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("N_COMM", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.565115086,  SimilarityComputationTable->GetValue("N_COMM", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)SimilarityComputationTable->GetEnabled("N_COMM",    "module_5"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("N_COMM", "module_6"), 1E-6);

        //  HALVOL	0.666666667	0	0		0	0
        TEST_ASSERT_EQUALS_DOUBLE(0.666666667,  SimilarityComputationTable->GetValue("HALVOL", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("HALVOL", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("HALVOL", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)SimilarityComputationTable->GetEnabled("HALVOL",     "module_4"));
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("HALVOL", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("HALVOL", "module_6"), 1E-6);

        //  SCPMN	0.9375	0.60319342		0.741713551	0	0
        TEST_ASSERT_EQUALS_DOUBLE(0.9375,       SimilarityComputationTable->GetValue("SCPMN",  "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.60319342,   SimilarityComputationTable->GetValue("SCPMN",  "module_2"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)SimilarityComputationTable->GetEnabled("SCPMN",  "module_3"));
        TEST_ASSERT_EQUALS_DOUBLE(0.741713551,  SimilarityComputationTable->GetValue("SCPMN",  "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("SCPMN",  "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            SimilarityComputationTable->GetValue("SCPMN",  "module_6"), 1E-6);

        // Similarity
        TEST_ASSERT_EQUALS_DOUBLE(0.035895354,  this->DataSetEx->GetSimilarityByIndex(1, 0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            this->DataSetEx->GetSimilarityByIndex(1, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8116864,   this->DataSetEx->GetSimilarityByIndex(1, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.408629083,  this->DataSetEx->GetSimilarityByIndex(1, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.515506895, this->DataSetEx->GetSimilarityByIndex(1, 4, 0), 1E-6);

        //  Variable Weighting icorrelation coefficientjW  1	0.965109472	-0.229552854	0.791161121	-0.349396603	0
        TEST_ASSERT_EQUALS_DOUBLE(1,            vwwm->GetVWPredictionOfColumn(0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.965109472,  vwwm->GetVWPredictionOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.229552854, vwwm->GetVWPredictionOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.791161121,  vwwm->GetVWPredictionOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.349396603, vwwm->GetVWPredictionOfColumn(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            vwwm->GetVWPredictionOfColumn(0, 5), 1E-6);

        //  VW Weighted Multiplier
        //  3
        //  1
        //  1.4
        //  0
        //  1.066666667
        TEST_ASSERT_EQUALS_DOUBLE(3.0,  vwwm->GetVWWeightedMultiplierOfRow(1, 0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            vwwm->GetVWWeightedMultiplierOfRow(1, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4,          vwwm->GetVWWeightedMultiplierOfRow(1, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            vwwm->GetVWWeightedMultiplierOfRow(1, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.066666667,  vwwm->GetVWWeightedMultiplierOfRow(1, 4, 0), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-110.0928794, this->DataSetEx->GetPredictedValueByIndex(0, 1), 1E-6);
    }

    // Amplified Weighted Sum with VW Weighted Multiplier		38.61195226
    virtual void Test_TCFbEDataSetEx_Reuse2_vbNormalizedValue_abColumn_VW() {
        TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier* vwwm = new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier();
        this->DataSetEx->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), vwwm, 0, false, 0.0, false, 1.0, new TCFbECorrelationCoefficientWithAverage(), new TCFbECorrelationCoefficientWithAverage(), 0.0);
        this->DataSetEx->TemporallyUnable(0, 0);
        this->DataSetEx->GetPredictedValueByIndex(0, 0);
        this->DataSetEx->TemporallyUnable(1, 0);
        TEST_ASSERT_EQUALS_DOUBLE(2.691040246, this->DataSetEx->GetPredictedValueByIndex(1, 0), 1E-6);
    }

protected:
    TCFbEDataSetEx* DataSetEx;
};

//---------------------------------------------------------------------------
#endif

