/*
    TCFbETestCase6.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETestCase6H
#define TCFbETestCase6H
//---------------------------------------------------------------------------
#pragma hdrstop
//---------------------------------------------------------------------------
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>

USING_NAMESPACE_CPPUNIT
//---------------------------------------------------------------------------
#include <System.hpp>

//#include "TCFbEDataAccessor.h"
#include "TCFbETableEx.h"
//---------------------------------------------------------------------------
// eXgP[X6
class TCFbETestCase6 : public TestCase
{
    // RXgN^
    TEST_CASE_COMMON(TCFbETestCase6)

public:
    // eXg
    //          column_0    column_1    column_2    column_3    column_4    column_5
    // row_0    0.1         0.6         1.1         1.6         2.1         2.6
    // row_1    0.2         0.7         1.2         1.7         2.2         2.7
    // row_2    0.3         0.8         1.3         1.8         2.3         2.8
    // row_3    0.4         0.9         1.4         1.9         2.4         2.9
    // row_4    0.5         1           1.5         2           2.5         3

    virtual void setUp() {
        TStringList* TestStringList = new TStringList();
        TestStringList->Add("       ,column_0   ,column_1   ,column_2   ,column_3   ,column_4   ,column_5");
        TestStringList->Add("row_0  ,0.1        ,0.6        ,1.1        ,1.6        ,2.1        ,2.6");
        TestStringList->Add("row_1  ,0.2        ,0.7        ,1.2        ,1.7        ,2.2        ,2.7");
        TestStringList->Add("row_2  ,0.3        ,0.8        ,1.3        ,1.8        ,2.3        ,2.8");
        TestStringList->Add("row_3  ,0.4        ,0.9        ,1.4        ,1.9        ,2.4        ,2.9");
        TestStringList->Add("row_4  ,0.5        ,1.0        ,1.5        ,2.0        ,2.5        ,3.0");

        this->TableEx = new TCFbETableEx(TestStringList, "");
        delete TestStringList;
    }

    // eXǧЕt
    virtual void tearDown() {
        delete this->TableEx;
    }

    //---------------------------------------------------------------------------
    // ȉCDataSet ̃eXg
    //---------------------------------------------------------------------------
    virtual void Test_TCFbETableEx_Constructor() {
        TEST_ASSERT_EQUALS(6, this->TableEx->GetNumberOfColumns());
        TEST_ASSERT_EQUALS(5, this->TableEx->GetNumberOfRows());

        TEST_ASSERT_EQUALS("column_0", this->TableEx->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("column_1", this->TableEx->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("column_2", this->TableEx->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("column_3", this->TableEx->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("column_4", this->TableEx->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("column_5", this->TableEx->GetColumnLabelList()->Strings[5].c_str());

        TEST_ASSERT_EQUALS("row_0", this->TableEx->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("row_1", this->TableEx->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("row_2", this->TableEx->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("row_3", this->TableEx->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("row_4", this->TableEx->GetRowLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS_DOUBLE(0.1, this->TableEx->GetValue("row_0", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6, this->TableEx->GetValue("row_0", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1, this->TableEx->GetValue("row_0", "column_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, this->TableEx->GetValue("row_0", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetValue("row_0", "column_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6, this->TableEx->GetValue("row_0", "column_5"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2, this->TableEx->GetValue("row_1", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7, this->TableEx->GetValue("row_1", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2, this->TableEx->GetValue("row_1", "column_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7, this->TableEx->GetValue("row_1", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.2, this->TableEx->GetValue("row_1", "column_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.7, this->TableEx->GetValue("row_1", "column_5"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetValue("row_2", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8, this->TableEx->GetValue("row_2", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3, this->TableEx->GetValue("row_2", "column_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetValue("row_2", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.3, this->TableEx->GetValue("row_2", "column_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, this->TableEx->GetValue("row_2", "column_5"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.4, this->TableEx->GetValue("row_3", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9, this->TableEx->GetValue("row_3", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4, this->TableEx->GetValue("row_3", "column_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.9, this->TableEx->GetValue("row_3", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.4, this->TableEx->GetValue("row_3", "column_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, this->TableEx->GetValue("row_3", "column_5"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->TableEx->GetValue("row_4", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->TableEx->GetValue("row_4", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5, this->TableEx->GetValue("row_4", "column_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, this->TableEx->GetValue("row_4", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5, this->TableEx->GetValue("row_4", "column_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, this->TableEx->GetValue("row_4", "column_5"), 1E-6);
    }

    virtual void Test_TCFbETableEx_GetStatistics() {
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Max.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Min.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Average.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Median.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Stdev.row", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Max.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Min.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Average.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Median.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Stdev.column", true);

        //  Max of Row	2.6	2.7	2.8	2.9	3
        TEST_ASSERT_EQUALS_DOUBLE(2.6, this->TableEx->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.7, this->TableEx->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, this->TableEx->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, this->TableEx->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, this->TableEx->GetMaxOfRow(4), 1E-6);

        //  Min of Row	0.1	0.2	0.3	0.4	0.5
        TEST_ASSERT_EQUALS_DOUBLE(0.1, this->TableEx->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2, this->TableEx->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4, this->TableEx->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->TableEx->GetMinOfRow(4), 1E-6);

        //  Average of Row	1.35	1.45	1.55	1.65	1.75
        TEST_ASSERT_EQUALS_DOUBLE(1.35, this->TableEx->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.45, this->TableEx->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.55, this->TableEx->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, this->TableEx->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.75, this->TableEx->GetAverageOfRow(4), 1E-6);

        //  Median of Row	1.35	1.45	1.55	1.65	1.75
        TEST_ASSERT_EQUALS_DOUBLE(1.35, this->TableEx->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.45, this->TableEx->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.55, this->TableEx->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, this->TableEx->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.75, this->TableEx->GetMedianOfRow(4), 1E-6);

        //  Standard Deviation of Row	0.853912564	0.853912564	0.853912564	0.853912564	0.853912564
        TEST_ASSERT_EQUALS_DOUBLE(0.853912564, this->TableEx->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.853912564, this->TableEx->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.853912564, this->TableEx->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.853912564, this->TableEx->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.853912564, this->TableEx->GetStdevOfRow(4), 1E-6);

        //  Max of Column	    0.5	1.0	1.5	2.0	2.5	3.0
        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->TableEx->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->TableEx->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5, this->TableEx->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, this->TableEx->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5, this->TableEx->GetMaxOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, this->TableEx->GetMaxOfColumn(5), 1E-6);

        //  Min of Column	    0.1	0.6	1.1	1.6	2.1	2.6
        TEST_ASSERT_EQUALS_DOUBLE(0.1, this->TableEx->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6, this->TableEx->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1, this->TableEx->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, this->TableEx->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetMinOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6, this->TableEx->GetMinOfColumn(5), 1E-6);

        //  Average of Column	0.3	0.8	1.3	1.8	2.3	2.8
        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8, this->TableEx->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3, this->TableEx->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.3, this->TableEx->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, this->TableEx->GetAverageOfColumn(5), 1E-6);

        //  Median of Column	0.3	0.8	1.3	1.8	2.3	2.8
        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8, this->TableEx->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3, this->TableEx->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.3, this->TableEx->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, this->TableEx->GetMedianOfColumn(5), 1E-6);

        //  Standard Deviation of Column	0.141421356	0.141421356	0.141421356	0.141421356	0.141421356	0.141421356
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, this->TableEx->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, this->TableEx->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, this->TableEx->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, this->TableEx->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, this->TableEx->GetStdevOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, this->TableEx->GetStdevOfColumn(5), 1E-6);
    }

    virtual void Test_TCFbETableEx_ValuesUpdate() {
        this->TableEx->UnableElement("row_0", "column_0");
        this->TableEx->UnableElement("row_1", "column_1");
        this->TableEx->UnableElement("row_2", "column_2");
        this->TableEx->UnableElement("row_4", "column_4");

        this->TableEx->SetValue("row_1", "column_0", 3.1);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_1", "column_4", 3.4);
        this->TableEx->SetValue("row_1", "column_5", 3.5);

        this->TableEx->SetValue("row_0", "column_2", 3.6);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_4", "column_2", 3.8);

        TEST_ASSERT_EQUALS(6, this->TableEx->GetNumberOfColumns());
        TEST_ASSERT_EQUALS(5, this->TableEx->GetNumberOfRows());

        TEST_ASSERT_EQUALS("column_0", this->TableEx->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("column_1", this->TableEx->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("column_2", this->TableEx->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("column_3", this->TableEx->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("column_4", this->TableEx->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("column_5", this->TableEx->GetColumnLabelList()->Strings[5].c_str());

        TEST_ASSERT_EQUALS("row_0", this->TableEx->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("row_1", this->TableEx->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("row_2", this->TableEx->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("row_3", this->TableEx->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("row_4", this->TableEx->GetRowLabelList()->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)false, (int)this->TableEx->GetEnabled("row_0", "column_0"));
        TEST_ASSERT_EQUALS_DOUBLE(0.6, this->TableEx->GetValue("row_0", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.6, this->TableEx->GetValue("row_0", "column_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, this->TableEx->GetValue("row_0", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetValue("row_0", "column_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6, this->TableEx->GetValue("row_0", "column_5"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.1, this->TableEx->GetValue("row_1", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)this->TableEx->GetEnabled("row_1", "column_1"));
        TEST_ASSERT_EQUALS_DOUBLE(3.2, this->TableEx->GetValue("row_1", "column_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7, this->TableEx->GetValue("row_1", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, this->TableEx->GetValue("row_1", "column_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, this->TableEx->GetValue("row_1", "column_5"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetValue("row_2", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8, this->TableEx->GetValue("row_2", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)this->TableEx->GetEnabled("row_2", "column_2"));
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetValue("row_2", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.3, this->TableEx->GetValue("row_2", "column_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, this->TableEx->GetValue("row_2", "column_5"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.4, this->TableEx->GetValue("row_3", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9, this->TableEx->GetValue("row_3", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4, this->TableEx->GetValue("row_3", "column_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.9, this->TableEx->GetValue("row_3", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.4, this->TableEx->GetValue("row_3", "column_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, this->TableEx->GetValue("row_3", "column_5"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->TableEx->GetValue("row_4", "column_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, this->TableEx->GetValue("row_4", "column_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, this->TableEx->GetValue("row_4", "column_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, this->TableEx->GetValue("row_4", "column_3"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)this->TableEx->GetEnabled("row_4", "column_4"));
        TEST_ASSERT_EQUALS_DOUBLE(3.0, this->TableEx->GetValue("row_4", "column_5"), 1E-6);
    }

    virtual void Test_TCFbETableEx_GetUpdatedStatistics() {
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Max.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Min.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Average.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Median.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Stdev.row", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Max.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Min.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Average.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Median.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Stdev.column", true);

        this->TableEx->UnableElement("row_0", "column_0");
        this->TableEx->UnableElement("row_1", "column_1");
        this->TableEx->UnableElement("row_2", "column_2");
        this->TableEx->UnableElement("row_4", "column_4");

        this->TableEx->SetValue("row_1", "column_0", 3.1);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_1", "column_4", 3.4);
        this->TableEx->SetValue("row_1", "column_5", 3.5);

        this->TableEx->SetValue("row_0", "column_2", 3.6);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_4", "column_2", 3.8);

        //  Max of Row	3.6	3.5	2.8	2.9	3.8
        TEST_ASSERT_EQUALS_DOUBLE(3.6, this->TableEx->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, this->TableEx->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, this->TableEx->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, this->TableEx->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, this->TableEx->GetMaxOfRow(4), 1E-6);

        //  Min of Row	0.6	1.7	0.3	0.4	0.5
        TEST_ASSERT_EQUALS_DOUBLE(0.6, this->TableEx->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7, this->TableEx->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4, this->TableEx->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->TableEx->GetMinOfRow(4), 1E-6);

        //  Average of Row	2.1	2.98	1.6	1.65	2.06
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.98, this->TableEx->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, this->TableEx->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, this->TableEx->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.06, this->TableEx->GetAverageOfRow(4), 1E-6);

        //  Median of Row	2.1	3.2	1.8	1.65	2
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2, this->TableEx->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, this->TableEx->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2, this->TableEx->GetMedianOfRow(4), 1E-6);

        //  Standard Deviation of Row	1	0.655438784	0.92736185	0.853912564	1.222456543
        TEST_ASSERT_EQUALS_DOUBLE(1, this->TableEx->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.655438784, this->TableEx->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.92736185, this->TableEx->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.853912564, this->TableEx->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.222456543, this->TableEx->GetStdevOfRow(4), 1E-6);

        //  Max of Column	3.1	1	3.8	2	3.4	3.5
        TEST_ASSERT_EQUALS_DOUBLE(3.1, this->TableEx->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, this->TableEx->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, this->TableEx->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2, this->TableEx->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, this->TableEx->GetMaxOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, this->TableEx->GetMaxOfColumn(5), 1E-6);

        //  Min of Column	0.3	0.6	1.4	1.6	2.1	2.6
        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6, this->TableEx->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4, this->TableEx->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, this->TableEx->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetMinOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6, this->TableEx->GetMinOfColumn(5), 1E-6);

        //  Average of Column	1.075	0.825	3	1.8	2.55	2.96
        TEST_ASSERT_EQUALS_DOUBLE(1.075, this->TableEx->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.825, this->TableEx->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3, this->TableEx->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.55, this->TableEx->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.96, this->TableEx->GetAverageOfColumn(5), 1E-6);

        //  Median of Column	0.45	0.85	3.4	1.8	2.35	2.9
        TEST_ASSERT_EQUALS_DOUBLE(0.45, this->TableEx->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.85, this->TableEx->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, this->TableEx->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.35, this->TableEx->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, this->TableEx->GetMedianOfColumn(5), 1E-6);

        //  Standard Deviation of Column	1.171270678	0.147901995	0.948683298	0.141421356	0.502493781	0.300665928
        TEST_ASSERT_EQUALS_DOUBLE(1.171270678, this->TableEx->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.147901995, this->TableEx->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.948683298, this->TableEx->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, this->TableEx->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.502493781, this->TableEx->GetStdevOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.300665928, this->TableEx->GetStdevOfColumn(5), 1E-6);
    }

    virtual void Test_TCFbETableEx_RotatedAssign_Values() {
        this->TableEx->UnableElement("row_0", "column_0");
        this->TableEx->UnableElement("row_1", "column_1");
        this->TableEx->UnableElement("row_2", "column_2");
        this->TableEx->UnableElement("row_4", "column_4");

        this->TableEx->SetValue("row_1", "column_0", 3.1);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_1", "column_4", 3.4);
        this->TableEx->SetValue("row_1", "column_5", 3.5);

        this->TableEx->SetValue("row_0", "column_2", 3.6);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_4", "column_2", 3.8);

        TCFbETableEx* RotatedTable = new TCFbETableEx();
        RotatedTable->RotatedAssign(this->TableEx);

        TEST_ASSERT_EQUALS(5, RotatedTable->GetNumberOfColumns());
        TEST_ASSERT_EQUALS(6, RotatedTable->GetNumberOfRows());

        TEST_ASSERT_EQUALS("column_0", RotatedTable->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("column_1", RotatedTable->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("column_2", RotatedTable->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("column_3", RotatedTable->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("column_4", RotatedTable->GetRowLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("column_5", RotatedTable->GetRowLabelList()->Strings[5].c_str());

        TEST_ASSERT_EQUALS("row_0", RotatedTable->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("row_1", RotatedTable->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("row_2", RotatedTable->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("row_3", RotatedTable->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("row_4", RotatedTable->GetColumnLabelList()->Strings[4].c_str());

        //  column_0		3.1	0.3	0.4	0.5
        TEST_ASSERT_EQUALS((int)false, (int)RotatedTable->GetEnabled("column_0", "row_0"));
        TEST_ASSERT_EQUALS_DOUBLE(3.1, RotatedTable->GetValue("column_0", "row_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3, RotatedTable->GetValue("column_0", "row_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4, RotatedTable->GetValue("column_0", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, RotatedTable->GetValue("column_0", "row_4"), 1E-6);

        //  column_1	0.6		0.8	0.9	1
        TEST_ASSERT_EQUALS_DOUBLE(0.6, RotatedTable->GetValue("column_1", "row_0"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)RotatedTable->GetEnabled("column_1", "row_1"));
        TEST_ASSERT_EQUALS_DOUBLE(0.8, RotatedTable->GetValue("column_1", "row_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9, RotatedTable->GetValue("column_1", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, RotatedTable->GetValue("column_1", "row_4"), 1E-6);

        //  column_2	3.6	3.2		1.4	3.8
        TEST_ASSERT_EQUALS_DOUBLE(3.6, RotatedTable->GetValue("column_2", "row_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2, RotatedTable->GetValue("column_2", "row_1"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)RotatedTable->GetEnabled("column_2", "row_2"));
        TEST_ASSERT_EQUALS_DOUBLE(1.4, RotatedTable->GetValue("column_2", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, RotatedTable->GetValue("column_2", "row_4"), 1E-6);

        //  column_3	1.6	1.7	1.8	1.9	2
        TEST_ASSERT_EQUALS_DOUBLE(1.6, RotatedTable->GetValue("column_3", "row_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7, RotatedTable->GetValue("column_3", "row_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, RotatedTable->GetValue("column_3", "row_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.9, RotatedTable->GetValue("column_3", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, RotatedTable->GetValue("column_3", "row_4"), 1E-6);

        //  column_4	2.1	3.4	2.3	2.4
        TEST_ASSERT_EQUALS_DOUBLE(2.1, RotatedTable->GetValue("column_4", "row_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, RotatedTable->GetValue("column_4", "row_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.3, RotatedTable->GetValue("column_4", "row_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.4, RotatedTable->GetValue("column_4", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)RotatedTable->GetEnabled("column_4", "row_4"));

        //  column_5	2.6	3.5	2.8	2.9	3
        TEST_ASSERT_EQUALS_DOUBLE(2.6, RotatedTable->GetValue("column_5", "row_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, RotatedTable->GetValue("column_5", "row_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, RotatedTable->GetValue("column_5", "row_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, RotatedTable->GetValue("column_5", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, RotatedTable->GetValue("column_5", "row_4"), 1E-6);

        delete RotatedTable;
    }

    virtual void Test_TCFbETableEx_GetRotatedAssign_Statistics() {
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Max.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Min.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Average.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Median.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Stdev.row", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Max.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Min.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Average.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Median.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Stdev.column", true);

        this->TableEx->UnableElement("row_0", "column_0");
        this->TableEx->UnableElement("row_1", "column_1");
        this->TableEx->UnableElement("row_2", "column_2");
        this->TableEx->UnableElement("row_4", "column_4");

        this->TableEx->SetValue("row_1", "column_0", 3.1);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_1", "column_4", 3.4);
        this->TableEx->SetValue("row_1", "column_5", 3.5);

        this->TableEx->SetValue("row_0", "column_2", 3.6);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_4", "column_2", 3.8);

        //  Max of Row	3.6	3.5	2.8	2.9	3.8
        TEST_ASSERT_EQUALS_DOUBLE(3.6, this->TableEx->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, this->TableEx->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, this->TableEx->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, this->TableEx->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, this->TableEx->GetMaxOfRow(4), 1E-6);

        //  Min of Row	0.6	1.7	0.3	0.4	0.5
        TEST_ASSERT_EQUALS_DOUBLE(0.6, this->TableEx->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7, this->TableEx->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4, this->TableEx->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->TableEx->GetMinOfRow(4), 1E-6);

        //  Average of Row	2.1	2.98	1.6	1.65	2.06
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.98, this->TableEx->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, this->TableEx->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, this->TableEx->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.06, this->TableEx->GetAverageOfRow(4), 1E-6);

        //  Median of Row	2.1	3.2	1.8	1.65	2
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2, this->TableEx->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, this->TableEx->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2, this->TableEx->GetMedianOfRow(4), 1E-6);

        //  Standard Deviation of Row	1	0.655438784	0.92736185	0.853912564	1.222456543
        TEST_ASSERT_EQUALS_DOUBLE(1, this->TableEx->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.655438784, this->TableEx->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.92736185, this->TableEx->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.853912564, this->TableEx->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.222456543, this->TableEx->GetStdevOfRow(4), 1E-6);

        //  Max of Column	3.1	1	3.8	2	3.4	3.5
        TEST_ASSERT_EQUALS_DOUBLE(3.1, this->TableEx->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, this->TableEx->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, this->TableEx->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2, this->TableEx->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, this->TableEx->GetMaxOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, this->TableEx->GetMaxOfColumn(5), 1E-6);

        //  Min of Column	0.3	0.6	1.4	1.6	2.1	2.6
        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6, this->TableEx->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4, this->TableEx->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, this->TableEx->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetMinOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6, this->TableEx->GetMinOfColumn(5), 1E-6);

        //  Average of Column	1.075	0.825	3	1.8	2.55	2.96
        TEST_ASSERT_EQUALS_DOUBLE(1.075, this->TableEx->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.825, this->TableEx->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3, this->TableEx->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.55, this->TableEx->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.96, this->TableEx->GetAverageOfColumn(5), 1E-6);

        //  Median of Column	0.45	0.85	3.4	1.8	2.35	2.9
        TEST_ASSERT_EQUALS_DOUBLE(0.45, this->TableEx->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.85, this->TableEx->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, this->TableEx->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.35, this->TableEx->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, this->TableEx->GetMedianOfColumn(5), 1E-6);

        //  Standard Deviation of Column	1.171270678	0.147901995	0.948683298	0.141421356	0.502493781	0.300665928
        TEST_ASSERT_EQUALS_DOUBLE(1.171270678, this->TableEx->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.147901995, this->TableEx->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.948683298, this->TableEx->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, this->TableEx->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.502493781, this->TableEx->GetStdevOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.300665928, this->TableEx->GetStdevOfColumn(5), 1E-6);

        TCFbETableEx* RotatedTable = new TCFbETableEx();
        RotatedTable->RotatedAssign(this->TableEx);

        //  Max of Row	3.1	1	3.8	2	3.4	3.5
        TEST_ASSERT_EQUALS_DOUBLE(3.1, RotatedTable->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, RotatedTable->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, RotatedTable->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2, RotatedTable->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, RotatedTable->GetMaxOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, RotatedTable->GetMaxOfRow(5), 1E-6);

        //  Min of Row	0.3	0.6	1.4	1.6	2.1	2.6
        TEST_ASSERT_EQUALS_DOUBLE(0.3, RotatedTable->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6, RotatedTable->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4, RotatedTable->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, RotatedTable->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1, RotatedTable->GetMinOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6, RotatedTable->GetMinOfRow(5), 1E-6);

        //  Average of Row	1.075	0.825	3	1.8	2.55	2.96
        TEST_ASSERT_EQUALS_DOUBLE(1.075, RotatedTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.825, RotatedTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3, RotatedTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, RotatedTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.55, RotatedTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.96, RotatedTable->GetAverageOfRow(5), 1E-6);

        //  Median of Row	0.45	0.85	3.4	1.8	2.35	2.9
        TEST_ASSERT_EQUALS_DOUBLE(0.45, RotatedTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.85, RotatedTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, RotatedTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, RotatedTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.35, RotatedTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, RotatedTable->GetMedianOfRow(5), 1E-6);

        //  Standard Deviation of Row	1.171270678	0.147901995	0.948683298	0.141421356	0.502493781	0.300665928
        TEST_ASSERT_EQUALS_DOUBLE(1.171270678, RotatedTable->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.147901995, RotatedTable->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.948683298, RotatedTable->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, RotatedTable->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.502493781, RotatedTable->GetStdevOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.300665928, RotatedTable->GetStdevOfRow(5), 1E-6);

        //  Max of Column	3.6	3.5	2.8	2.9	3.8
        TEST_ASSERT_EQUALS_DOUBLE(3.6, RotatedTable->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, RotatedTable->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, RotatedTable->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, RotatedTable->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, RotatedTable->GetMaxOfColumn(4), 1E-6);

        //  Min of Column	0.6	1.7	0.3	0.4	0.5
        TEST_ASSERT_EQUALS_DOUBLE(0.6, RotatedTable->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7, RotatedTable->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3, RotatedTable->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4, RotatedTable->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, RotatedTable->GetMinOfColumn(4), 1E-6);

        //  Average of Column	2.1	2.98	1.6	1.65	2.06
        TEST_ASSERT_EQUALS_DOUBLE(2.1, RotatedTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.98, RotatedTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, RotatedTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, RotatedTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.06, RotatedTable->GetAverageOfColumn(4), 1E-6);

        //  Median of Column	2.1	3.2	1.8	1.65	2
        TEST_ASSERT_EQUALS_DOUBLE(2.1, RotatedTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2, RotatedTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, RotatedTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, RotatedTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2, RotatedTable->GetMedianOfColumn(4), 1E-6);

        //  Standard Deviation of Column	1	0.655438784	0.92736185	0.853912564	1.222456543
        TEST_ASSERT_EQUALS_DOUBLE(1, RotatedTable->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.655438784, RotatedTable->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.92736185, RotatedTable->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.853912564, RotatedTable->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.222456543, RotatedTable->GetStdevOfColumn(4), 1E-6);

        delete RotatedTable;
    }

    virtual void Test_TCFbETableEx_GetRotatedAssign_UpdatedValues() {
        this->TableEx->UnableElement("row_0", "column_0");
        this->TableEx->UnableElement("row_1", "column_1");
        this->TableEx->UnableElement("row_2", "column_2");
        this->TableEx->UnableElement("row_4", "column_4");

        this->TableEx->SetValue("row_1", "column_0", 3.1);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_1", "column_4", 3.4);
        this->TableEx->SetValue("row_1", "column_5", 3.5);

        this->TableEx->SetValue("row_0", "column_2", 3.6);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_4", "column_2", 3.8);

        TCFbETableEx* RotatedTable = new TCFbETableEx();
        RotatedTable->RotatedAssign(this->TableEx);

        RotatedTable->UnableElement("column_1", "row_4");
        RotatedTable->UnableElement("column_2", "row_3");
        RotatedTable->UnableElement("column_3", "row_2");
        RotatedTable->UnableElement("column_4", "row_1");
        RotatedTable->UnableElement("column_5", "row_0");

        RotatedTable->SetValue("column_0", "row_0", 1.0);
        RotatedTable->SetValue("column_1", "row_1", 2.0);
        RotatedTable->SetValue("column_2", "row_2", 3.0);
        RotatedTable->SetValue("column_3", "row_3", 4.0);
        RotatedTable->SetValue("column_4", "row_4", 5.0);

        RotatedTable->SetValue("column_2", "row_0", 6.0);
        RotatedTable->SetValue("column_2", "row_1", 7.0);
        RotatedTable->SetValue("column_2", "row_2", 8.0);
        RotatedTable->SetValue("column_2", "row_4", 9.0);

        //  column_0	1	3.1	0.3	0.4	0.5
        TEST_ASSERT_EQUALS_DOUBLE(1.0, RotatedTable->GetValue("column_0", "row_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.1, RotatedTable->GetValue("column_0", "row_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3, RotatedTable->GetValue("column_0", "row_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4, RotatedTable->GetValue("column_0", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, RotatedTable->GetValue("column_0", "row_4"), 1E-6);

        //  column_1	0.6	2	0.8	0.9
        TEST_ASSERT_EQUALS_DOUBLE(0.6, RotatedTable->GetValue("column_1", "row_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, RotatedTable->GetValue("column_1", "row_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8, RotatedTable->GetValue("column_1", "row_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9, RotatedTable->GetValue("column_1", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)RotatedTable->GetEnabled("column_1", "row_4"));

        //  column_2	6	7	8		9
        TEST_ASSERT_EQUALS_DOUBLE(6.0, RotatedTable->GetValue("column_2", "row_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0, RotatedTable->GetValue("column_2", "row_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(8.0, RotatedTable->GetValue("column_2", "row_2"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)RotatedTable->GetEnabled("column_2", "row_3"));
        TEST_ASSERT_EQUALS_DOUBLE(9.0, RotatedTable->GetValue("column_2", "row_4"), 1E-6);

        //  column_3	1.6	1.7		4	2
        TEST_ASSERT_EQUALS_DOUBLE(1.6, RotatedTable->GetValue("column_3", "row_0"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7, RotatedTable->GetValue("column_3", "row_1"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)RotatedTable->GetEnabled("column_3", "row_2"));
        TEST_ASSERT_EQUALS_DOUBLE(4.0, RotatedTable->GetValue("column_3", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, RotatedTable->GetValue("column_3", "row_4"), 1E-6);

        //  column_4	2.1		2.3	2.4	5
        TEST_ASSERT_EQUALS_DOUBLE(2.1, RotatedTable->GetValue("column_4", "row_0"), 1E-6);
        TEST_ASSERT_EQUALS((int)false, (int)RotatedTable->GetEnabled("column_4", "row_1"));
        TEST_ASSERT_EQUALS_DOUBLE(2.3, RotatedTable->GetValue("column_4", "row_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.4, RotatedTable->GetValue("column_4", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, RotatedTable->GetValue("column_4", "row_4"), 1E-6);

        //  column_5		3.5	2.8	2.9	3
        TEST_ASSERT_EQUALS((int)false, (int)RotatedTable->GetEnabled("column_5", "row_0"));
        TEST_ASSERT_EQUALS_DOUBLE(3.5, RotatedTable->GetValue("column_5", "row_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, RotatedTable->GetValue("column_5", "row_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, RotatedTable->GetValue("column_5", "row_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, RotatedTable->GetValue("column_5", "row_4"), 1E-6);

        delete RotatedTable;
    }

    virtual void Test_TCFbETableEx_GetRotatedAssign_UpdatedStatistics() {
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Max.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Min.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Average.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Median.row", true);
        this->TableEx->AddChildCache(new TCFbERowCachedTable(this->TableEx), "Stdev.row", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Max.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Min.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Average.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Median.column", true);
        this->TableEx->AddChildCache(new TCFbEColumnCachedTable(this->TableEx), "Stdev.column", true);

        this->TableEx->UnableElement("row_0", "column_0");
        this->TableEx->UnableElement("row_1", "column_1");
        this->TableEx->UnableElement("row_2", "column_2");
        this->TableEx->UnableElement("row_4", "column_4");

        this->TableEx->SetValue("row_1", "column_0", 3.1);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_1", "column_4", 3.4);
        this->TableEx->SetValue("row_1", "column_5", 3.5);

        this->TableEx->SetValue("row_0", "column_2", 3.6);
        this->TableEx->SetValue("row_1", "column_2", 3.2);
        this->TableEx->SetValue("row_4", "column_2", 3.8);

        //  Max of Row	3.6	3.5	2.8	2.9	3.8
        TEST_ASSERT_EQUALS_DOUBLE(3.6, this->TableEx->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, this->TableEx->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, this->TableEx->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, this->TableEx->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, this->TableEx->GetMaxOfRow(4), 1E-6);

        //  Min of Row	0.6	1.7	0.3	0.4	0.5
        TEST_ASSERT_EQUALS_DOUBLE(0.6, this->TableEx->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7, this->TableEx->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4, this->TableEx->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, this->TableEx->GetMinOfRow(4), 1E-6);

        //  Average of Row	2.1	2.98	1.6	1.65	2.06
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.98, this->TableEx->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, this->TableEx->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, this->TableEx->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.06, this->TableEx->GetAverageOfRow(4), 1E-6);

        //  Median of Row	2.1	3.2	1.8	1.65	2
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2, this->TableEx->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, this->TableEx->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2, this->TableEx->GetMedianOfRow(4), 1E-6);

        //  Standard Deviation of Row	1	0.655438784	0.92736185	0.853912564	1.222456543
        TEST_ASSERT_EQUALS_DOUBLE(1, this->TableEx->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.655438784, this->TableEx->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.92736185, this->TableEx->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.853912564, this->TableEx->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.222456543, this->TableEx->GetStdevOfRow(4), 1E-6);

        //  Max of Column	3.1	1	3.8	2	3.4	3.5
        TEST_ASSERT_EQUALS_DOUBLE(3.1, this->TableEx->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, this->TableEx->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, this->TableEx->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2, this->TableEx->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, this->TableEx->GetMaxOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, this->TableEx->GetMaxOfColumn(5), 1E-6);

        //  Min of Column	0.3	0.6	1.4	1.6	2.1	2.6
        TEST_ASSERT_EQUALS_DOUBLE(0.3, this->TableEx->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6, this->TableEx->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4, this->TableEx->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, this->TableEx->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1, this->TableEx->GetMinOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6, this->TableEx->GetMinOfColumn(5), 1E-6);

        //  Average of Column	1.075	0.825	3	1.8	2.55	2.96
        TEST_ASSERT_EQUALS_DOUBLE(1.075, this->TableEx->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.825, this->TableEx->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3, this->TableEx->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.55, this->TableEx->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.96, this->TableEx->GetAverageOfColumn(5), 1E-6);

        //  Median of Column	0.45	0.85	3.4	1.8	2.35	2.9
        TEST_ASSERT_EQUALS_DOUBLE(0.45, this->TableEx->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.85, this->TableEx->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, this->TableEx->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, this->TableEx->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.35, this->TableEx->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, this->TableEx->GetMedianOfColumn(5), 1E-6);

        //  Standard Deviation of Column	1.171270678	0.147901995	0.948683298	0.141421356	0.502493781	0.300665928
        TEST_ASSERT_EQUALS_DOUBLE(1.171270678, this->TableEx->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.147901995, this->TableEx->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.948683298, this->TableEx->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, this->TableEx->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.502493781, this->TableEx->GetStdevOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.300665928, this->TableEx->GetStdevOfColumn(5), 1E-6);

        TCFbETableEx* RotatedTable = new TCFbETableEx();
        RotatedTable->RotatedAssign(this->TableEx);

        //  Max of Row	3.1	1	3.8	2	3.4	3.5
        TEST_ASSERT_EQUALS_DOUBLE(3.1, RotatedTable->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, RotatedTable->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, RotatedTable->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2, RotatedTable->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, RotatedTable->GetMaxOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, RotatedTable->GetMaxOfRow(5), 1E-6);

        //  Min of Row	0.3	0.6	1.4	1.6	2.1	2.6
        TEST_ASSERT_EQUALS_DOUBLE(0.3, RotatedTable->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6, RotatedTable->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4, RotatedTable->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, RotatedTable->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1, RotatedTable->GetMinOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6, RotatedTable->GetMinOfRow(5), 1E-6);

        //  Average of Row	1.075	0.825	3	1.8	2.55	2.96
        TEST_ASSERT_EQUALS_DOUBLE(1.075, RotatedTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.825, RotatedTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3, RotatedTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, RotatedTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.55, RotatedTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.96, RotatedTable->GetAverageOfRow(5), 1E-6);

        //  Median of Row	0.45	0.85	3.4	1.8	2.35	2.9
        TEST_ASSERT_EQUALS_DOUBLE(0.45, RotatedTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.85, RotatedTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4, RotatedTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, RotatedTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.35, RotatedTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, RotatedTable->GetMedianOfRow(5), 1E-6);

        //  Standard Deviation of Row	1.171270678	0.147901995	0.948683298	0.141421356	0.502493781	0.300665928
        TEST_ASSERT_EQUALS_DOUBLE(1.171270678, RotatedTable->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.147901995, RotatedTable->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.948683298, RotatedTable->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.141421356, RotatedTable->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.502493781, RotatedTable->GetStdevOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.300665928, RotatedTable->GetStdevOfRow(5), 1E-6);

        //  Max of Column	3.6	3.5	2.8	2.9	3.8
        TEST_ASSERT_EQUALS_DOUBLE(3.6, RotatedTable->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, RotatedTable->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, RotatedTable->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9, RotatedTable->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.8, RotatedTable->GetMaxOfColumn(4), 1E-6);

        //  Min of Column	0.6	1.7	0.3	0.4	0.5
        TEST_ASSERT_EQUALS_DOUBLE(0.6, RotatedTable->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7, RotatedTable->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3, RotatedTable->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4, RotatedTable->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, RotatedTable->GetMinOfColumn(4), 1E-6);

        //  Average of Column	2.1	2.98	1.6	1.65	2.06
        TEST_ASSERT_EQUALS_DOUBLE(2.1, RotatedTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.98, RotatedTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, RotatedTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, RotatedTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.06, RotatedTable->GetAverageOfColumn(4), 1E-6);

        //  Median of Column	2.1	3.2	1.8	1.65	2
        TEST_ASSERT_EQUALS_DOUBLE(2.1, RotatedTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2, RotatedTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, RotatedTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.65, RotatedTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2, RotatedTable->GetMedianOfColumn(4), 1E-6);

        //  Standard Deviation of Column	1	0.655438784	0.92736185	0.853912564	1.222456543
        TEST_ASSERT_EQUALS_DOUBLE(1, RotatedTable->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.655438784, RotatedTable->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.92736185, RotatedTable->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.853912564, RotatedTable->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.222456543, RotatedTable->GetStdevOfColumn(4), 1E-6);

        RotatedTable->UnableElement("column_1", "row_4");
        RotatedTable->UnableElement("column_2", "row_3");
        RotatedTable->UnableElement("column_3", "row_2");
        RotatedTable->UnableElement("column_4", "row_1");
        RotatedTable->UnableElement("column_5", "row_0");

        RotatedTable->SetValue("column_0", "row_0", 1.0);
        RotatedTable->SetValue("column_1", "row_1", 2.0);
        RotatedTable->SetValue("column_2", "row_2", 3.0);
        RotatedTable->SetValue("column_3", "row_3", 4.0);
        RotatedTable->SetValue("column_4", "row_4", 5.0);

        RotatedTable->SetValue("column_2", "row_0", 6.0);
        RotatedTable->SetValue("column_2", "row_1", 7.0);
        RotatedTable->SetValue("column_2", "row_2", 8.0);
        RotatedTable->SetValue("column_2", "row_4", 9.0);

        //  Max of Row	3.1	2	9	4	5	3.5
        TEST_ASSERT_EQUALS_DOUBLE(3.1, RotatedTable->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, RotatedTable->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9.0, RotatedTable->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, RotatedTable->GetMaxOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, RotatedTable->GetMaxOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, RotatedTable->GetMaxOfRow(5), 1E-6);

        //  Min of Row	0.3	0.6	6	1.6	2.1	2.8
        TEST_ASSERT_EQUALS_DOUBLE(0.3, RotatedTable->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6, RotatedTable->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.0, RotatedTable->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6, RotatedTable->GetMinOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1, RotatedTable->GetMinOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8, RotatedTable->GetMinOfRow(5), 1E-6);

        //  Average of Row	1.06	1.075	7.5	2.325	2.95	3.05
        TEST_ASSERT_EQUALS_DOUBLE(1.06, RotatedTable->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.075, RotatedTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.5, RotatedTable->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.325, RotatedTable->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.95, RotatedTable->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.05, RotatedTable->GetAverageOfRow(5), 1E-6);

        //  Median of Row	0.5	0.85	7.5	1.85	2.35	2.95
        TEST_ASSERT_EQUALS_DOUBLE(0.5, RotatedTable->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.85, RotatedTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.5, RotatedTable->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.85, RotatedTable->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.35, RotatedTable->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.95, RotatedTable->GetMedianOfRow(5), 1E-6);

        //  Standard Deviation of Row	1.048045801	0.544862368	1.118033989	0.978199877	1.188486432	0.26925824
        TEST_ASSERT_EQUALS_DOUBLE(1.048045801, RotatedTable->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.544862368, RotatedTable->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.118033989, RotatedTable->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.978199877, RotatedTable->GetStdevOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.188486432, RotatedTable->GetStdevOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.26925824, RotatedTable->GetStdevOfRow(5), 1E-6);

        //  Max of Column	6	7	8	4	9
        TEST_ASSERT_EQUALS_DOUBLE(6.0, RotatedTable->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0, RotatedTable->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(8.0, RotatedTable->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, RotatedTable->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9.0, RotatedTable->GetMaxOfColumn(4), 1E-6);

        //  Min of Column	0.6	1.7	0.3	0.4	0.5
        TEST_ASSERT_EQUALS_DOUBLE(0.6, RotatedTable->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7, RotatedTable->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3, RotatedTable->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4, RotatedTable->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5, RotatedTable->GetMinOfColumn(4), 1E-6);

        //  Average of Column	2.26	3.46	2.84	2.12	3.9
        TEST_ASSERT_EQUALS_DOUBLE(2.26, RotatedTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.46, RotatedTable->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.84, RotatedTable->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.12, RotatedTable->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.9, RotatedTable->GetAverageOfColumn(4), 1E-6);

        //  Median of Column	1.6	3.1	2.3	2.4	3
        TEST_ASSERT_EQUALS_DOUBLE(1.6, RotatedTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.1, RotatedTable->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.3, RotatedTable->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.4, RotatedTable->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, RotatedTable->GetMedianOfColumn(4), 1E-6);

        //  Standard Deviation of Column	1.938659331	1.891665932	2.739781013	1.316662447	2.939387691
        TEST_ASSERT_EQUALS_DOUBLE(1.938659331, RotatedTable->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.891665932, RotatedTable->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.739781013, RotatedTable->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.316662447, RotatedTable->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.939387691, RotatedTable->GetStdevOfColumn(4), 1E-6);

        delete RotatedTable;
    }

protected:
    TCFbETableEx*   TableEx;
};

//---------------------------------------------------------------------------
#endif

