/*
    TCFbESimfinderCommandLineParser.cpp    January 13, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbESimfinderCommandLineParser.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^iargc  argv ɂăR}hC^
__fastcall TCFbESimfinderCommandLineParser::TCFbESimfinderCommandLineParser(int argc, char* argv[])
    : TCFbECustomCommandLineParser(argc, argv)
{
}

//---------------------------------------------------------------------------
__fastcall TCFbESimfinderCommandLineParser::~TCFbESimfinderCommandLineParser()
{
}

//---------------------------------------------------------------------------
// wvԂ
AnsiString __fastcall TCFbESimfinderCommandLineParser::GetHelpString(void)
{
    return
        //            0         1         2         3         4         5         6         7
        //            01234567890123456789012345678901234567890123456789012345678901234567890123456789
          AnsiString("USAGE:                                                                         \n")
        + AnsiString("  simfinder [OPTIONS] -l=FILENAMES -s=ALGORITHM                                \n")
        + AnsiString("\n")
        + AnsiString("where,                                                                         \n")
        + AnsiString("  -l, --learning=FILENAMES   Learning Data filenames separated by comma.       \n")
        + AnsiString("  -s, --similarity=ALGORITHM Similarity computation algorithm.                 \n")
        + AnsiString("\n")
        + AnsiString("OPTIONS are specified as:                                                      \n")
        + AnsiString("  -h, --help                 Display this help and exit.                       \n")
        + AnsiString("  -n, --normalize=METHOD     Method to normalize values. METHOD is specified as\n")
        + AnsiString("                             value | normalize | standardize | order           \n")
//        + AnsiString("  -lb,--log-base=LOGBASE     Base number of logarithmic conversion. \"e\" can  \n")
        + AnsiString("                             be specified for natural logarithm.               \n")
        + AnsiString("  -i, --itembased            Apply item-based collaborative filtering.         \n")
        + AnsiString("  -cs,--combined-similarity=ALGORITHM   Combined similarity computation        \n")
        + AnsiString("                                        algorithm is specified.                \n")
        + AnsiString("  -cr,--combined-ratio=RATIO Ratio of similarity calculated with combined      \n")
        + AnsiString("                             similarity algorithm in combining similarities.   \n")
        + AnsiString("  -d, --default=VALUE        Default value is put instead of missing values.   \n")
        + AnsiString("  -if,--inverse-frequency    Inverse Case Frequency is applied.                \n")
        + AnsiString("  -vs,--vw-similarity=ALGORITHM   Variable Weighting is applied for similarity \n")
        + AnsiString("                                  computation.                                 \n")
        + AnsiString("  -t, --target=LABEL[,LABEL] Target columns to estimate. Unspecified denotes   \n")
        + AnsiString("                             all unknown columns will be estimated. Or \"*\"   \n")
        + AnsiString("                             indicates all columns will be estimated.          \n")
        + AnsiString("  -qi,--qualitative-indicator=CHAR  Character to specify qualitative variables.\n")
        + AnsiString("  -o, --output=FILENAME      File name for outputting the results.             \n")
        + AnsiString("\n")
        + AnsiString("Similarity computation algorithm and variable weighting algorithm are specified\n")
        + AnsiString("as one of the following terms:                                                 \n")
        + AnsiString("  CosineSimilarity                                                             \n")
        + AnsiString("  AdjustedCosineSimilarityWithAverage                                          \n")
        + AnsiString("  AdjustedCosineSimilarityWithMedian                                           \n")
        + AnsiString("  CorrelationCoefficientWithAverage                                            \n")
        + AnsiString("  CorrelationCoefficientWithMedian                                             \n")
        + AnsiString("  RankCorrelation                                                              \n")
        + AnsiString("  DistanceSimilarityWithAverage                                                \n")
        + AnsiString("  DistanceSimilarityWithMedian                                                 \n")
        + AnsiString("\n")
        + AnsiString("EXAMPLES:                                                                      \n")
        + AnsiString("  simfinder -l=learning.csv -s=CosineSimilarity                                \n")
        + AnsiString("\n")
        + AnsiString("  simfinder --learning=learning.csv --similarity=CosineSimilarity              \n")
        + AnsiString("\n")
        + AnsiString("  simfinder -n=normalize -i -t=BUG,EFFORT  -o=output.txt -l=learning.csv -s=Cos\n")
        + AnsiString("  ineSimilarity                                                                \n")
        + AnsiString("\n")
        + AnsiString("  simfinder --normalize=normalize --itembased --target=BUG,EFFORT --output=outp\n")
        + AnsiString("  ut.txt --learning=learning.csv --similarity=CosineSimilarity                 \n");
}

//---------------------------------------------------------------------------
// R}hCp[XăG[R[hԂ
int __fastcall TCFbESimfinderCommandLineParser::DoParse(void)
{
    if (TCFbECustomCommandLineParser::DoParse() != ecNone) {
        return this->ErrorCode; // ɃG[oĂ

    } else if (this->HelpEnabled) { // wvĂяo
        return ecNone;
    }

    // K{p[^w肳Ă邩ǂ`FbN
    if (this->TargetColumnLabelList->Count == 0) {
        this->ErrorCode = ecNoTargetColumn;
        this->ErrorParameter = "";
    }

    return this->ErrorCode;
}

//---------------------------------------------------------------------------

