/*
    TCFbEGeneralCommandLineParser.h     July 21, 2005.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEGeneralCommandLineParserH
#define TCFbEGeneralCommandLineParserH
//---------------------------------------------------------------------------
#include <system.hpp>
#include <Classes.hpp>

#include "TCFbETypes.h"
//---------------------------------------------------------------------------
class TCFbEGeneralCommandLineParser : public TObject
{
public:
    virtual __fastcall TCFbEGeneralCommandLineParser(int argc=0, char* argv[]=NULL);    // RXgN^
    __fastcall ~TCFbEGeneralCommandLineParser();    // fXgN^
    virtual int __fastcall DoParse(void);  // R}hCp[XăG[R[hԂ

    TCFbEErrorCode  ErrorCode;
    AnsiString      ErrorParameter;
    
protected:
    TStringList*    FOptionList;

    virtual bool __fastcall IsEmpty(void);    // IvVȂ
    virtual bool __fastcall OptionObserved(AnsiString Option, AnsiString Parameter) = 0;    // Option  Parameter ƋɊώ@ꂽƂ񍐂DOption  true C߂łȂ false ԂD
    virtual bool __fastcall OptionNameIs(AnsiString Option, AnsiString ShortForm, AnsiString LongForm);

private:

};
//---------------------------------------------------------------------------
#endif
