/*
    TCFbECustomTableEx.h    December 4, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbECustomTableExH
#define TCFbECustomTableExH
//---------------------------------------------------------------------------
#include "TCFbETypes.h"

// #include "Maprof.h"

#include <SysUtils.hpp>
#include "TCFbECell.h"
#include "TCFbEToolkit.h"
#include "TCFbERowColumnCachedTable.h"
#include "TCFbEColumnCachedTable.h"
#include "TCFbERowCachedTable.h"
#include "TCFbERowRowCachedTable.h"
//---------------------------------------------------------------------------
// v@\tLbVue[u
class TCFbECustomTableEx : public TCFbERowColumnCachedTable
{
public:
    virtual __fastcall TCFbECustomTableEx(void);    // RXgN^iLbV쐬
    virtual __fastcall TCFbECustomTableEx(TStringList* RowLabelList, TStringList* ColumnLabelList);             // w肳ꂽse[u쐬
    virtual __fastcall TCFbECustomTableEx(TStringList* SourceCsvStringList, AnsiString IsQualitativeIndicator); // RXgN^
    __fastcall ~TCFbECustomTableEx();    // fXgN^

    virtual double __fastcall Normalize(double SourceValue, double MaxValue, double MinValue);  // Normalize 
    virtual void __fastcall PartialNormalize(TCFbECustomTableEx* DestTable, int ColumnIndex);   // Table ̗vf𕔕I Normalize 
    virtual void __fastcall Normalize(TCFbECustomTableEx* DestTable);                           // Table ̗vf Normalize 
    virtual double __fastcall DisNormalize(double NormalizedValue, double MaxValue, double MinValue);   // ColumnIndex ڂ Normalize ꂽl NormalizedValue  DisNormalize ĕԂ

    virtual double __fastcall Standardize(double SourceValue, double AverageValue, double StdevValue);  // Standardize 
    virtual void __fastcall PartialStandardize(TCFbECustomTableEx* DestTable, int ColumnIndex); // Table ̗vf𕔕I Standardize 
    virtual void __fastcall Standardize(TCFbECustomTableEx* DestTable);                         // Table ̗vf Standardize 
    virtual double __fastcall DisStandardize(double StandardizedValue, double AverageValue, double StdevValue); // ColumnIndex ڂ Standardize ꂽl StandardizedValue  DisStandardize ĕԂ

    virtual void __fastcall Ordering(TList* SortedCellList);                                    // Ordering 
    virtual void __fastcall PartialOrdering(TCFbECustomTableEx* DestTable, int ColumnIndex);    // Table ̗vf𕔕I Ordering 
    virtual void __fastcall Ordering(TCFbECustomTableEx* DestTable);                            // Table ̗vf Ordering 
    virtual double __fastcall DisOrdering(double Order, TDoubleDynArray& SortedOrders, TDoubleDynArray& SortedValues);  // ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ

    virtual double  __fastcall GetICFCoefficient(int j);    // j ڂ Inverse Case Frequency Coefficient 𓾂

    virtual double __fastcall GetMaxOfRow(int i);       // s̍őlԂD
    virtual double __fastcall GetMinOfRow(int i);       // s̍ŏlԂD
    virtual double __fastcall GetAverageOfRow(int i);   // s̕ϒlԂD
    virtual double __fastcall GetMedianOfRow(int i);    // s̒ԒlԂD
    virtual double __fastcall GetStdevOfRow(int i);     // s̕W΍ԂD
    virtual double __fastcall GetAveragedMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex);   // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Averaged Multiplier ԂD
    virtual double __fastcall GetMedianOfMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex);   // ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Median of Multiplier ԂD

    virtual double __fastcall GetMaxOfColumn(int j);        // ̍őlԂD
    virtual double __fastcall GetMinOfColumn(int j);        // ̍ŏlԂD
    virtual double __fastcall GetAverageOfColumn(int j);    // ̕ϒlԂD
    virtual double __fastcall GetMedianOfColumn(int j);     // ̒ԒlԂD
    virtual double __fastcall GetStdevOfColumn(int j);      // ̕W΍ԂD
    virtual double __fastcall GetAveragedMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex);  // ComparedColumnIndex Ԗڂ̗ BaseColumnIndex Ԗڂ̗ɑ΂ Averaged Multiplier ԂD
    virtual double __fastcall GetMedianOfMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex);  // ComparedColumnIndex Ԗڂ̗ BaseColumnIndex Ԗڂ̗ɑ΂ Median of Multiplier ԂD

    // ChildCache  ChildCacheName ƂÕLbVƂĒǉDLbVVɒǉ trueCɑ݂Ă邽ߒǉȂ false ԂD
    virtual bool __fastcall AddChildCache(TCFbECachedTable* ChildCache, const char* ChildCacheName, bool IsLinkedToParent);

    // ChildCacheName ƂÕLbV폜DLbV폜 trueCYLbV݂Ȃߍ폜Ȃ false ԂD
    virtual bool __fastcall DeleteChildCache(const char* ChildCacheName);

protected:
    virtual TCFbECachedTable* __fastcall CreateClone(void) = 0;         // g̃N[쐬
    virtual TCFbECachedTable* __fastcall CreateRotatedClone(void) = 0;  // g̍sƗ񂪓ւN[쐬

    TCFbERowCachedTable*    MaxRowCache;
    TCFbERowCachedTable*    MinRowCache;
    TCFbERowCachedTable*    AverageRowCache;
    TCFbERowCachedTable*    MedianRowCache;
    TCFbERowCachedTable*    StdevRowCache;
    TCFbEColumnCachedTable* MaxColumnCache;
    TCFbEColumnCachedTable* MinColumnCache;
    TCFbEColumnCachedTable* AverageColumnCache;
    TCFbEColumnCachedTable* MedianColumnCache;
    TCFbEColumnCachedTable* StdevColumnCache;

private:

};
//---------------------------------------------------------------------------
#endif
