/*
    TCFbECustomCommandLineParser.cpp    January 13, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbECustomCommandLineParser.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^iargc  argv ɂăR}hC^
__fastcall TCFbECustomCommandLineParser::TCFbECustomCommandLineParser(int argc, char* argv[])
    : TCFbEGeneralCommandLineParser(argc, argv)
{
    this->HelpEnabled = false;
    this->LearningDataFileNameList = new TStringList();
    this->SimilarityComputationName = "";
    this->ValueBase = vbValue;
    this->AlgorithmBase = abRow;
    this->TargetColumnLabelList = new TStringList;
    this->DefaultValueEnabled = false;
    this->DefaultValue = 0.0;
    this->InverseCaseFrequencyEnabled = false;
    this->VWSimilarityComputationName = "";
    this->OutputFileName = "";
    this->CombinedSimilarityComputationName = "";
    this->CombinedRatio = 0.5;
#ifdef SPECIAL_MODE
    this->LogBase = 10.0;
#else
    this->LogBase = 0.0;
#endif
    this->QualitativeIndicator = "";
}

//---------------------------------------------------------------------------
__fastcall TCFbECustomCommandLineParser::~TCFbECustomCommandLineParser()
{
    delete this->TargetColumnLabelList;
    delete this->LearningDataFileNameList;
}

//---------------------------------------------------------------------------
// ^āCΉގxvZASỸCX^XԂ
TCFbESimilarityComputationAlgorithm* __fastcall TCFbECustomCommandLineParser::CreateSimilarityComputationAlgorithm(AnsiString AlgorithmName)
{
    if (AlgorithmName == "CosineSimilarity") {
        return new TCFbECosineSimilarity();

    } else if (AlgorithmName == "AdjustedCosineSimilarityWithAverage") {
        return new TCFbEAdjustedCosineSimilarityWithAverage();

    } else if (AlgorithmName == "AdjustedCosineSimilarityWithMedian") {
        return new TCFbEAdjustedCosineSimilarityWithMedian();

    } else if (AlgorithmName == "CorrelationCoefficientWithAverage") {
        return new TCFbECorrelationCoefficientWithAverage();

    } else if (AlgorithmName == "CorrelationCoefficientWithMedian") {
        return new TCFbECorrelationCoefficientWithMedian();

    } else if (AlgorithmName == "RankCorrelation") {
        return new TCFbERankCorrelation();

    } else if (AlgorithmName == "DistanceSimilarityWithAverage") {
        return new TCFbEDistanceSimilarityWithAverage();

    } else if (AlgorithmName == "DistanceSimilarityWithMedian") {
        return new TCFbEDistanceSimilarityWithMedian();
    }

    return NULL;    // sȃASY
}

//---------------------------------------------------------------------------
// ^āCΉ\ASỸCX^XԂ
TCFbEPredictionAlgorithm* __fastcall TCFbECustomCommandLineParser::CreatePredictionAlgorithm(AnsiString AlgorithmName)
{
    if (AlgorithmName == "WeightedSum") {
        return new TCFbEWeightedSum();

    } else if (AlgorithmName == "AdjustedWeightedSumWithAverageOfColumn") {
        return new TCFbEAdjustedWeightedSumWithAverageOfColumn();

    } else if (AlgorithmName == "AdjustedWeightedSumWithMedianOfColumn") {
        return new TCFbEAdjustedWeightedSumWithMedianOfColumn();

    } else if (AlgorithmName == "AdjustedWeightedSumWithAverageOfNeighbors") {
        return new TCFbEAdjustedWeightedSumWithAverageOfNeighbors();

    } else if (AlgorithmName == "AdjustedWeightedSumWithMedianOfNeighbors") {
        return new TCFbEAdjustedWeightedSumWithMedianOfNeighbors();

    } else if (AlgorithmName == "AdjustedWeightedSumWithAverageOfRow") {
        return new TCFbEAdjustedWeightedSumWithAverageOfRow();

    } else if (AlgorithmName == "AdjustedWeightedSumWithMedianOfRow") {
        return new TCFbEAdjustedWeightedSumWithMedianOfRow();

    } else if (AlgorithmName == "AmplifiedWeightedSumWithAveragedMultiplier") {
        return new TCFbEAmplifiedWeightedSumWithAveragedMultiplier();

    } else if (AlgorithmName == "AmplifiedWeightedSumWithMedianOfMultiplier") {
        return new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier();

    } else if (AlgorithmName == "AmplifiedWeightedSumWithVWWeightedMultiplier") {
        return new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier();
    }

    return NULL;    // sȃASY
}

//---------------------------------------------------------------------------
// R}hCp[XăG[R[hԂ
int __fastcall TCFbECustomCommandLineParser::DoParse(void)
{
    if (TCFbEGeneralCommandLineParser::DoParse() != ecNone) {
        return this->ErrorCode; // ɃG[oĂ

    }

    if (this->IsEmpty()) {
        this->HelpEnabled = true;
        return ecNone;
    }

    // K{p[^w肳Ă邩ǂ`FbN
    if (this->LearningDataFileNameList->Count <= 0) {
        this->ErrorCode = ecNoLearningDataFileName;

    } else if (this->SimilarityComputationName.IsEmpty()) {
        this->ErrorCode = ecNoSimilarityComputationAlgorithm;
    }

    return this->ErrorCode;
}

//---------------------------------------------------------------------------
// ȉCprotected \bh
//---------------------------------------------------------------------------
// Option  Parameter ƋɊώ@ꂽƂ񍐂D
bool __fastcall TCFbECustomCommandLineParser::OptionObserved(AnsiString Option, AnsiString Parameter)
{
    // -h, --help p[^̌
    if (this->OptionNameIs(Option, "-h", "--help")) {
        this->HelpEnabled = true;

    // -l, --learning p[^̌
    } else if (this->OptionNameIs(Option, "-l", "--learning")) {
        this->LearningDataFileNameList->DelimitedText = Parameter;
        for (int k = 0; k < this->LearningDataFileNameList->Count; k++) {
            if (!FileExists(this->LearningDataFileNameList->Strings[k])) {
                this->ErrorCode = ecLearningDataNotFound;
                this->ErrorParameter = this->LearningDataFileNameList->Strings[k];
                break;
            }
        }

    // -s, --similarity p[^̌
    } else if (this->OptionNameIs(Option, "-s", "--similarity")) {
        this->SimilarityComputationName = Parameter;
        TCFbESimilarityComputationAlgorithm*    SCA = this->CreateSimilarityComputationAlgorithm(Parameter);
        if (SCA == NULL) {
            this->ErrorCode = ecIllegalSimilarityComputationAlgorithm;
            this->ErrorParameter = Parameter;
        }
        delete SCA;

    // -cs, --combined-similarity p[^̌
    } else if (this->OptionNameIs(Option, "-cs", "--combined-similarity")) {
        this->CombinedSimilarityComputationName = Parameter;
        TCFbESimilarityComputationAlgorithm*    SCA = this->CreateSimilarityComputationAlgorithm(Parameter);
        if (SCA == NULL) {
            this->ErrorCode = ecIllegalCombinedSimilarityAlgorithm;
            this->ErrorParameter = Parameter;
        }
        delete SCA;

    // -cr, --combined-ratio p[^̌
    } else if (this->OptionNameIs(Option, "-cr", "--combined-ratio")) {
        try {
            this->CombinedRatio = Parameter.ToDouble();
        } catch (EConvertError &ece) {
            this->ErrorCode = ecIllegalCombinedRatio;
            this->ErrorParameter = Parameter;
        }

    // -n, --normalize p[^̌
    } else if (this->OptionNameIs(Option, "-n", "--normalize")) {
        if (Parameter.AnsiCompareIC("value") == 0) {
            this->ValueBase = vbValue;
        } else if (Parameter.AnsiCompareIC("standardize") == 0) {
            this->ValueBase = vbStandardizedValue;
        } else if (Parameter.AnsiCompareIC("normalize") == 0) {
            this->ValueBase = vbNormalizedValue;
        } else if (Parameter.AnsiCompareIC("order") == 0) {
            this->ValueBase = vbOrder;
        } else {
            this->ErrorCode = ecIllegalNormalizationMethod;
            this->ErrorParameter = Parameter;
        }

    // -i, --itembased p[^̌
    } else if (this->OptionNameIs(Option, "-i", "--itembased")) {
        this->AlgorithmBase = abColumn;

    // -t, --target p[^̌
    } else if (this->OptionNameIs(Option, "-t", "--target")) {
        this->TargetColumnLabelList->DelimitedText = Parameter;

    // -d,--default p[^̌
    } else if(this->OptionNameIs(Option, "-d", "--default")) {
        try {
            this->DefaultValueEnabled = true;
            this->DefaultValue = Parameter.ToDouble();
        } catch (EConvertError &ece) {
            this->ErrorCode = ecIllegalDefaultValue;
            this->ErrorParameter = Parameter;
        }

    // -if, --inverse-frequency p[^̌
    } else if (this->OptionNameIs(Option, "-if", "--inverse-frequency")) {
        this->InverseCaseFrequencyEnabled = true;

    // -vs, --vw-similarity p[^̌
    } else if (this->OptionNameIs(Option, "-vs", "--vw-similarity")) {
        this->VWSimilarityComputationName = Parameter;
        TCFbESimilarityComputationAlgorithm* VWSA = this->CreateSimilarityComputationAlgorithm(this->VWSimilarityComputationName);
        if (VWSA == NULL) {
            this->ErrorCode = ecIllegalVWSimilarityAlgorithm;
            this->ErrorParameter = this->VWSimilarityComputationName;
        }
        delete VWSA;

    // -o,--output p[^̌
    } else if (this->OptionNameIs(Option, "-o", "--output")) {
        this->OutputFileName = Parameter;

        AnsiString OutputDirectory = ExtractFileDir(this->OutputFileName);
        if (!DirectoryExists(OutputDirectory)) {
            try {
                MkDir(OutputDirectory);    // fBNg쐬
            } catch (...) {
                this->ErrorCode = ecOutputDirectoryCantBeMade;
                this->ErrorParameter = OutputDirectory;
            }
        }

    // -lb,--log-base p[^̌
    } else if (this->OptionNameIs(Option, "-lb", "--log-base")) {
        if (Parameter.LowerCase() == "e") {
            this->LogBase = exp(1);
        } else {
            try {
                this->LogBase = Parameter.ToDouble();
            } catch (EConvertError &ece) {
                this->ErrorCode = ecIllegalLogBase;
                this->ErrorParameter = Parameter;
            }
        }

    // -qi, --qualitative-ident p[^̌
    } else if (this->OptionNameIs(Option, "-qi", "--qualitative-ident")) {
        if (Parameter.IsEmpty()) {
            this->ErrorCode = ecNoQualitativeIndicator;
        }
        this->QualitativeIndicator = Parameter;

    } else {
        return false;   // ߕs\
    }

    return true;
}

//---------------------------------------------------------------------------

