/*
    TCFbECombinedSimilarity.h   July 27, 2005.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbECombinedSimilarityH
#define TCFbECombinedSimilarityH
//---------------------------------------------------------------------------
#include "TCFbECosineSimilarity.h"
//---------------------------------------------------------------------------
class TCFbECombinedSimilarity : public TCFbESimilarityComputationAlgorithm
{
public:
    virtual __fastcall TCFbECombinedSimilarity(TCFbESimilarityComputationAlgorithm* BaseAlgorithm, TCFbESimilarityComputationAlgorithm* CombinedAlgorithm, double CombinedRatio);    // RXgN^
    __fastcall ~TCFbECombinedSimilarity();    // fXgN^

    // vZɕKvȃLbV
    virtual void __fastcall PrepareCache(TCFbECustomTableEx* SimilarityComputationTable) {
        this->BaseAlgorithm->PrepareCache(SimilarityComputationTable);
        this->CombinedAlgorithm->PrepareCache(SimilarityComputationTable);
    }

    // TargetRowIndex  AnotherRowIndex ̗ގxvZ
    virtual double __fastcall ComputeSimilarity(TCFbECustomTableEx* SimilarityComputationTable, int TargetRowIndex, int ComparedRowIndex);

protected:
    TCFbESimilarityComputationAlgorithm* BaseAlgorithm;
    TCFbESimilarityComputationAlgorithm* CombinedAlgorithm;
    double CombinedRatio;

private:

};
//---------------------------------------------------------------------------
#endif
