/*
    TCFbEBoolList.h    September 2, 2005.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbEBoolListH
#define TCFbEBoolListH
//---------------------------------------------------------------------------
#include "TCFbETypes.h"

#include <Classes.hpp>
//---------------------------------------------------------------------------
class TCFbEBoolList : public TList
{
public:
    virtual __fastcall TCFbEBoolList(void) : TList() {}
    virtual __fastcall ~TCFbEBoolList(void) {}

    __property bool BoolValues[int Index] = { read=GetBoolValues, write=SetBoolValues };

    virtual bool GetBoolValues(int Index) { return (int)this->Items[Index] == 1; }
    virtual void SetBoolValues(int Index, bool Value) {
        this->Items[Index] = (void*)(Value ? 1 : 0);
    }

    virtual int __fastcall Add(bool Value) {
        return TList::Add((void*)(Value ? 1 : 0));
    }

    virtual void __fastcall Insert(int Index, bool Value) {
        TList::Insert(Index, (void*)(Value ? 1 : 0));
    }

protected:
private:

};
//---------------------------------------------------------------------------
#endif
