/*
    TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier::TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier(void)
    : TCFbEWeightedSum()
{
}

//---------------------------------------------------------------------------
// fXgN^
__fastcall TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier::~TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier()
{
}

//---------------------------------------------------------------------------
// ȍ~Cprotected \bh
//---------------------------------------------------------------------------
// q̒l𓾂
double __fastcall TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier::GetNumerator(int NeighborIndex, int TargetColumnIndex)
{
    TCFbENeighbor*    Neighbor = (TCFbENeighbor*)this->NeighborList->Items[NeighborIndex];
    int Index = this->PredictionTable->GetRowLabelList()->IndexOf(Neighbor->GetLabel());
    return Neighbor->GetValue() * this->GetVWWeightedMultiplierOfRow(this->TargetRowIndex, Index, TargetColumnIndex) * Neighbor->GetSimilarity();
}

//---------------------------------------------------------------------------

// ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Variable Weighting Weighted Multiplier ԂD
double __fastcall TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier::GetVWWeightedMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex, int TargetColumnIndex)
{
    double Numerator = 0.0;
    double Denominator = 0;

    for (int i = 0; i < this->VWPredictionTable->GetNumberOfRows(); i++) {
#ifdef SPECIAL_MODE
        // Y񂪃JeSϐ̏ꍇ̓Avt@C[̌vZɎgȂ
        if (this->VWPredictionTable->GetRowLabelList()->Strings[i].Pos("@") > 0) {
            continue;
        }
#endif
        if (this->VWPredictionTable->RowIsQualitativeByIndex(i)) {
            continue;
        }

        TCFbECell* BaseCell = this->VWPredictionTable->GetCellByIndex(i, BaseRowIndex);
        TCFbECell* ComparedCell = this->VWPredictionTable->GetCellByIndex(i, ComparedRowIndex);

        if (BaseCell->GetEnabled() && ComparedCell->GetEnabled() && !TCFbEToolkit::GetToolkit()->Equals(BaseCell->GetValue(), 0.0) && !TCFbEToolkit::GetToolkit()->Equals(ComparedCell->GetValue(), 0.0)) {
            double Weight = this->GetVWPredictionOfColumn(TargetColumnIndex, i);
            // IWi̎
//            if (Weight >= 0) {
//                Numerator += fabs(BaseCell->GetValue() / ComparedCell->GetValue()) * Weight;
//            } else {
//                Numerator += fabs(ComparedCell->GetValue() / BaseCell->GetValue() * Weight);
//            }
//            Denominator += fabs(Weight);
            // IWi̎
            if (Weight >= 0) {
                Numerator += fabs(BaseCell->GetValue() / ComparedCell->GetValue()) * Weight;
                Denominator += fabs(Weight);
            }
        }
    }

    if (TCFbEToolkit::GetToolkit()->Equals(Denominator, 0.0)) {
        return 0.0;
    }

    return Numerator / Denominator;
}

//---------------------------------------------------------------------------

// ComparedColumnIndex Ԗڂ̗ BaseColumnIndex Ԗڂ̗ɑ΂ Variable Weighting ԂD
double __fastcall TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier::GetVWPredictionOfColumn(int BaseColumnIndex, int ComparedColumnIndex)
{
    if (!this->VWPredictionCache->GetEnabledByIndex(BaseColumnIndex, ComparedColumnIndex)) {
        this->VWPredictionCache->SetValueByIndex(BaseColumnIndex, ComparedColumnIndex, this->VWPredictionAlgorithm->ComputeSimilarity(this->VWPredictionTable, BaseColumnIndex, ComparedColumnIndex));
    }
    return this->VWPredictionCache->GetValueByIndex(BaseColumnIndex, ComparedColumnIndex);
}

//---------------------------------------------------------------------------

