/*
    TCFbESimfinderOutputCache.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbESimfinderOutputCache.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbESimfinderOutputCache::TCFbESimfinderOutputCache(TCFbESimfinderCommandLineParser* Parser, TCFbESimfinderDataLoader* DataLoader, bool IsVerbose)
{
    this->OutputStringList = new TStringList();

    TCFbEToolkit::GetToolkit()->SetApplicationPriority(tpLower);

    if (IsVerbose) {
        fprintf(stderr, "(2/3) Analysis is started with the following algorithms.\n");
        fprintf(stderr, "  %s\n", Parser->SimilarityComputationName);
        fprintf(stderr, "    ..... completed:  0.00\%");
    }

    try {
        TCFbEDataSetEx* DataSet = DataLoader->LearningData;
        DataSet->PrepareCF(Parser->ValueBase, Parser->AlgorithmBase, Parser->CreateSimilarityComputationAlgorithm(Parser->SimilarityComputationName), NULL, 0, Parser->DefaultValueEnabled, Parser->DefaultValue, Parser->InverseCaseFrequencyEnabled, 1.0, Parser->CreateSimilarityComputationAlgorithm(Parser->VWSimilarityComputationName), NULL);
        int RowCount = DataSet->GetSimilarityComputationTable()->GetRowLabelList()->Count;
        double TotalProgress = RowCount * Parser->TargetColumnLabelList->Count;
        int CurrentProgress = 0;

        AnsiString Header = "";
        for (int i = 0; i < RowCount; i++) {
            Header += "," + DataSet->GetSimilarityComputationTable()->GetRowLabelList()->Strings[i];
        }

        for (int k = 0; k < Parser->TargetColumnLabelList->Count; k++) {
            AnsiString TargetColumnLabel = Parser->TargetColumnLabelList->Strings[k];
            int TargetColumnIndex = DataSet->GetSimilarityComputationTable()->GetColumnLabelList()->IndexOf(TargetColumnLabel);

            OutputStringList->Add("Target," + TargetColumnLabel);
            OutputStringList->Add("");
            OutputStringList->Add(Header);

            for (int i = 0; i < RowCount; i++) {
                AnsiString AddedLine = DataSet->GetSimilarityComputationTable()->GetRowLabelList()->Strings[i];
                for (int j = 0; j < RowCount; j++) {
                    AddedLine += ",";
                    if (i > j) {
                        AddedLine += FloatToStr(DataSet->GetSimilarityByIndex(i, j, TargetColumnIndex));
                    } else if (i < j) {
                        AddedLine += FloatToStr(DataSet->GetSimilarityByIndex(j, i, TargetColumnIndex));
                    } else {
                        AddedLine += "1.0";
                    }
                }
                OutputStringList->Add(AddedLine);

                if (IsVerbose) {
                    fprintf(stderr, "\b\b\b\b\b\b%5.2f\%", (double)++CurrentProgress / TotalProgress * 100.0);
                }
            }

            OutputStringList->Add("");
            OutputStringList->Add("");
        }

        if (IsVerbose) {
            fprintf(stderr, "\b\b\b\b\b\b\b100.00\%\n\n");
        }

        TCFbEToolkit::GetToolkit()->SetApplicationPriority(tpNormal);

    } catch (...) {
        TCFbEToolkit::GetToolkit()->SetApplicationPriority(tpNormal);

        delete this->OutputStringList;
        throw;
    }
}

//---------------------------------------------------------------------------
__fastcall TCFbESimfinderOutputCache::~TCFbESimfinderOutputCache()
{
    delete this->OutputStringList;
}

//---------------------------------------------------------------------------

