/*
    TCFbEDistanceSimilarityWithAverage.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEDistanceSimilarityWithAverage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEDistanceSimilarityWithAverage::TCFbEDistanceSimilarityWithAverage(void)
    : TCFbESimilarityComputationAlgorithm()
{
}

//---------------------------------------------------------------------------
// fXgN^
__fastcall TCFbEDistanceSimilarityWithAverage::~TCFbEDistanceSimilarityWithAverage()
{
}

//---------------------------------------------------------------------------
// TargetRowIndex  AnotherRowIndex ̗ގxvZ
double __fastcall TCFbEDistanceSimilarityWithAverage::ComputeSimilarity(TCFbECustomTableEx* SimilarityComputationTable, int TargetRowIndex, int ComparedRowIndex)
{
    this->SimilarityComputationTable = SimilarityComputationTable;

    double    Sum = 0.0;
    int    Count = 0;

    for (int j = 0; j < SimilarityComputationTable->GetNumberOfColumns(); j++) {
        if (SimilarityComputationTable->GetCellByIndex(TargetRowIndex, j)->GetEnabled() && SimilarityComputationTable->GetCellByIndex(ComparedRowIndex, j)->GetEnabled()) {
            Sum += fabs(SimilarityComputationTable->GetCellByIndex(TargetRowIndex, j)->GetValue() - SimilarityComputationTable->GetCellByIndex(ComparedRowIndex, j)->GetValue());
            Count++;
        }
    }

    if (TCFbEToolkit::GetToolkit()->Equals(Sum, 0.0)) {
//    if (Sum == 0.0) {
        return 0.0;
    }

    return (double)Count/Sum;
}

//---------------------------------------------------------------------------

