/*
    EDocfbeError.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.           

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "EDocfbeError.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^iargc  argv ɂăR}hC^
__fastcall EDocfbeError::EDocfbeError(int ErrorCode, AnsiString Parameter, AnsiString AddedMessage)
    : Exception("")
{
    this->ErrorCode = ErrorCode;

    if (ErrorCode == 1) {
        this->Message = "No learning data file name.";

    } else if (ErrorCode == 2) {
        this->Message = "Learning data file \"" + Parameter + "\" is not found.";

    } else if (ErrorCode == 3) {
        this->Message = "No estimating data file name.";

    } else if (ErrorCode == 4) {
        this->Message = "No similarity computation algorithm.";

    } else if (ErrorCode == 5) {
        this->Message = "No prediction algorithm.";

    } else if (ErrorCode == 6) {
        this->Message = "Too long commandline arguments.\nIt has to be less than 1024 characters.";

    } else if (ErrorCode == -1) {
        this->Message = "Estimating data file \"" + Parameter + "\" is not found.";

    } else if (ErrorCode == -2) {
        this->Message = "Similarity computation algorithm \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == -3) {
        this->Message = "Prediction algorithm \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == -4) {
        this->Message = "Normalization method \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == -5) {
        this->Message = "Neighbors size \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == -6) {
        this->Message = "Output directory \"" + Parameter + "\" cannot be made.";

    } else if (ErrorCode == -7) {
        this->Message = "Learning data file \"" + Parameter + "\" cannot be opened.";

    } else if (ErrorCode == -8) {
        this->Message = "Estimating data file \"" + Parameter + "\" cannot be opened.";

    } else if (ErrorCode == -9) {
        this->Message = "There is inconsistency between \"" + Parameter + "\".";

    } else if (ErrorCode == -10) {
        this->Message = "The learning data has not specified target column \"" + Parameter + "\".";

    } else if (ErrorCode == -11) {
        this->Message = "The learning data has too less rows for estimating the targeted column \"" + Parameter +"\".";

    } else if (ErrorCode == -12) {
        this->Message = "Cannot write to the output file \"" + Parameter + "\".";

    } else if (ErrorCode == -13){
        if (Parameter.IsEmpty()) {
            Parameter = "Unknown";
        }
        this->Message = "Unknown error occurred at " + Parameter + " section.";

    } else if (ErrorCode == -14) {
        this->Message = "Default value \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == -15) {
        this->Message = "For merging, base data \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == -16) {
        this->Message = "Case amplifier \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == -17) {
        this->Message = "Variable weighting algorithm (for similarity computation) \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == -18) {
        this->Message = "Variable weighting algorithm (for prediction) \"" + Parameter + "\" is illegal.";

    } else if (ErrorCode == -19) {
        this->Message = "Prediction algorithm (\"" + Parameter + "\") is not AmplifiedWeightedSumWithVWWeightedMultiplier although variable weighting algorithm is specified.";

    } else if (ErrorCode ==-20) {
        this->Message = "No target column is specified.";
    }

    if (!AddedMessage.IsEmpty()) {
        this->Message += "\nUnknown error occurred!\nCould you e-mail to <naoki-o@is.naist.jp> with the following message?\n[ " + AddedMessage + "]";
    }
}

//---------------------------------------------------------------------------
__fastcall EDocfbeError::~EDocfbeError()
{
}

//---------------------------------------------------------------------------

