/*
 * TestFailure.h
 */

#ifndef cppunit_TestFailure_h
#define cppunit_TestFailure_h

#include "cuconfig.h"

cu_NAMESPACE_BEGIN(cppunit)

class Test;

/**
 * seXg̏B<br>
 * Record of a failed test execution.
 *
 * A TestFailure collects a failed test.
 *
 * @see TestResult
 */
class TestFailure
{
  public:
	/**
	 * RXgN^B
	 * @param test seXgB
	 * @param msg  bZ[WB
	 * @param file 肪t@CB
	 * @param line 肪sԍB
	 */
	TestFailure(Test* test, const cu_String& msg, const char* file, long line);

	/** fXgN^B */
	~TestFailure() {}

	/** seXgԂB */
	Test* failedTest() const { return m_failedTest; }

	/** seXg̏ԂB */
	const char* what() const { return m_message.c_str(); }

	/** 肪t@CԂB */
	const char* file() const { return m_file; }

	/** 肪sԍԂB */
	long line() const { return m_line; }

	/** ɕϊB */
	cu_String toString() const;

  private:
	Test* m_failedTest;
	cu_String   m_message;
	const char* m_file;
	long        m_line;
};

cu_NAMESPACE_END

#endif /* !cppunit_TestFailure_h */
