/*
    TCFbETestCase2.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETestCase2H
#define TCFbETestCase2H
//---------------------------------------------------------------------------
#pragma hdrstop
//---------------------------------------------------------------------------
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>

USING_NAMESPACE_CPPUNIT
//---------------------------------------------------------------------------
#include "TCFbEColumnCachedTable.h"
#include "TCFbERowCachedTable.h"

#include "TCFbEDataSetEx.h"
#include "TCFbEToolkit.h"

#include "TCFbECosineSimilarity.h"
#include "TCFbEAdjustedCosineSimilarityWithAverage.h"
#include "TCFbEAdjustedCosineSimilarityWithMedian.h"
#include "TCFbECorrelationCoefficientWithAverage.h"
#include "TCFbECorrelationCoefficientWithMedian.h"
#include "TCFbERankCorrelation.h"
#include "TCFbEDistanceSimilarityWithAverage.h"
#include "TCFbEDistanceSimilarityWithMedian.h"

#include "TCFbEWeightedSum.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfColumn.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfColumn.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfNeighbors.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfNeighbors.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfRow.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfRow.h"
#include "TCFbEAmplifiedWeightedSumWithAveragedMultiplier.h"
#include "TCFbEAmplifiedWeightedSumWithMedianOfMultiplier.h"
//---------------------------------------------------------------------------
// eXgP[X2
class TCFbETestCase2 : public TestCase
{
    // RXgN^
    TEST_CASE_COMMON(TCFbETestCase2)

public:
    // eXg
    //    FILENAME    BUG                LOC                N_COMM            HALVOL                SCPMN            N_VEXUSE
    //    module_1                    800.0000000000     0.3000000000     3600.0000000000     4.0000000000     0.6000000000
    //    module_2    2.0000000000     250.0000000000                     3200.0000000000     3.5000000000     0.4000000000
    //    module_3    5.0000000000     500.0000000000     0.0000000000                         3.0000000000     0.3000000000
    //    module_4    5.0000000000     700.0000000000     0.2500000000     3500.0000000000                     0.8000000000
    //    module_5                    600.0000000000     0.2000000000     3200.0000000000     2.5000000000
    //    module_6    10.0000000000     900.0000000000     0.3500000000     3800.0000000000     4.1000000000     0.7500000000
    virtual void setUp() {
        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,    BUG,            LOC,            N_COMM,            HALVOL,                SCPMN,            N_VEXUSE");
        TestStringList->Add("module_1,    ,                800.0000000000,    0.3000000000,    3600.0000000000,    4.0000000000,    0.6000000000");
        TestStringList->Add("module_2,    2.0000000000,    250.0000000000,    ,                3200.0000000000,     3.5000000000,    0.4000000000");
        TestStringList->Add("module_3,    5.0000000000,    500.0000000000,    0.0000000000,    ,                    3.0000000000,    0.3000000000");
        TestStringList->Add("module_4,    5.0000000000,     700.0000000000, 0.2500000000,     3500.0000000000,     ,                0.8000000000");
        TestStringList->Add("module_5,    ,                600.0000000000, 0.2000000000,     3200.0000000000,     2.5000000000,                ");
        TestStringList->Add("module_6,    10.0000000000,     900.0000000000, 0.3500000000,     3800.0000000000,     4.1000000000,     0.7500000000");

        this->DataSet = new TCFbEDataSetEx(TestStringList);
        delete TestStringList;
    }

    // eXǧЕt
    virtual void tearDown() {
        delete this->DataSet;
    }

    virtual void Test_TCFbEDataSetEx_GetRowLabelList() {
        TEST_ASSERT_EQUALS(6,    this->DataSet->GetNumberOfRows());

        TEST_ASSERT_EQUALS("module_1",    this->DataSet->GetRowLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_2",    this->DataSet->GetRowLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_3",    this->DataSet->GetRowLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_4",    this->DataSet->GetRowLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_5",    this->DataSet->GetRowLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_6",    this->DataSet->GetRowLabelList()->Strings[5].c_str());
    }

    virtual void Test_TCFbEDataSetEx_GetColumnLabelList() {
        TEST_ASSERT_EQUALS(6,    this->DataSet->GetNumberOfColumns());

        TEST_ASSERT_EQUALS("BUG",    this->DataSet->GetColumnLabelList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",    this->DataSet->GetColumnLabelList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    this->DataSet->GetColumnLabelList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    this->DataSet->GetColumnLabelList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",    this->DataSet->GetColumnLabelList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    this->DataSet->GetColumnLabelList()->Strings[5].c_str());
    }

    //---------------------------------------------------------------------------
    // Value-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG    LOC    N_COMM    HALVOL    SCPMN    N_VEXUSE
    //    module_1    800.0000000000     0.3000000000     3600.0000000000     4.0000000000     0.6000000000
    //    module_2    2.0000000000     250.0000000000         3200.0000000000     3.5000000000     0.4000000000
    //    module_3    5.0000000000     500.0000000000     0.0000000000         3.0000000000     0.3000000000
    //    module_4    5.0000000000     700.0000000000     0.2500000000     3500.0000000000         0.8000000000
    //    module_5            600.0000000000     0.2000000000     3200.0000000000     2.5000000000
    //    module_6    10.0000000000     900.0000000000     0.3500000000     3800.0000000000     4.1000000000     0.7500000000
    virtual void Test_TCFbEDataSetEx_GetValues() {
        TEST_ASSERT_EQUALS_DOUBLE(800.0000000000,   this->DataSet->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,     this->DataSet->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600.0000000000,  this->DataSet->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,     this->DataSet->GetValue("module_1", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,     this->DataSet->GetValue("module_1", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0000000000,     this->DataSet->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0000000000,   this->DataSet->GetValue("module_2", "LOC"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,  this->DataSet->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,     this->DataSet->GetValue("module_2", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,     this->DataSet->GetValue("module_2", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,     this->DataSet->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500.0000000000,   this->DataSet->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,     this->DataSet->GetValue("module_3", "N_COMM"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,     this->DataSet->GetValue("module_3", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->GetValue("module_3", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0000000000,    this->DataSet->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->GetValue("module_4", "HALVOL"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->GetValue("module_4", "N_VEXUSE"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(600.0000000000,    this->DataSet->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetValue("module_5", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5000000000,    this->DataSet->GetValue("module_5", "SCPMN"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0000000000,    this->DataSet->GetValue("module_6", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3500000000,    this->DataSet->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0000000000,    this->DataSet->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1000000000,    this->DataSet->GetValue("module_6", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetValue("module_6", "N_VEXUSE"), 1E-6);
    }

    //    Average of Column        5.5000000000     625.0000000000     0.2200000000     3460.0000000000     3.4200000000     0.5700000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(625.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2200000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3460.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4200000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5700000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        5.0000000000     650.0000000000     0.2500000000     3500.0000000000     3.5000000000     0.6000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(650.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    880.9800000000
    //    691.1800000000
    //    101.6600000000
    //    841.2100000000
    //    950.6750000000
    //    785.8666666667
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(880.9800000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(691.1800000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(101.6600000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(841.2100000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(950.6750000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(785.8666666667,    this->DataSet->GetPredictionTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    4.0000000000
    //    3.5000000000
    //    3.0000000000
    //    5.0000000000
    //    301.2500000000
    //    7.0500000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(301.2500000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0500000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    1.7419642857
    //    1.6444444444
    //    1.0303571429
    //    1.3895833333
    //    0.8938019846
    virtual void Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.7419642857,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6444444444,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0303571429,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3895833333,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8938019846,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    1.3214285714
    //    1.6000000000
    //    1.0857142857
    //    1.4166666667
    //    0.8888888889
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.3214285714,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0857142857,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4166666667,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8888888889,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
    //    BUG        2.0000000000     5.0000000000     5.0000000000         10.0000000000
    //    LOC    800.0000000000     250.0000000000     500.0000000000     700.0000000000     600.0000000000     900.0000000000
    //    N_COMM    0.3000000000         0.0000000000     0.2500000000     0.2000000000     0.3500000000
    //    HALVOL    3600.0000000000     3200.0000000000         3500.0000000000     3200.0000000000     3800.0000000000
    //    SCPMN    4.0000000000     3.5000000000     3.0000000000         2.5000000000     4.1000000000
    //    N_VEXUSE    0.6000000000     0.4000000000     0.3000000000     0.8000000000         0.7500000000
    virtual void Test_TCFbEDataSetEx_GetAppliedValues_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);

        TEST_ASSERT_EQUALS_DOUBLE(2.0000000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_4"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(800.0000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500.0000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600.0000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_1"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3500000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3600.0000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_2"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_3"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.5000000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1000000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_4"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_6"), 1E-6);
    }

    //    Average of Row        880.9800000000     691.1800000000     101.6600000000     841.2100000000     950.6750000000     785.8666666667
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(880.9800000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(691.1800000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(101.6600000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(841.2100000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(950.6750000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(785.8666666667,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Row        4.0000000000     3.5000000000     3.0000000000     5.0000000000     301.2500000000     7.0500000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(301.2500000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0500000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Column
    //    5.5000000000
    //    625.0000000000
    //    0.2200000000
    //    3460.0000000000
    //    3.4200000000
    //    0.5700000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(625.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2200000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3460.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4200000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5700000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Column
    //    5.0000000000
    //    650.0000000000
    //    0.2500000000
    //    3500.0000000000
    //    3.5000000000
    //    0.6000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(650.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    0.0090634921
    //    24.2857142857
    //    0.0015617168
    //    1.5590398761
    //    10.3125000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0090634921,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(24.2857142857,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0015617168,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5590398761,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.3125000000,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.0090000000
    //    24.2857142857
    //    0.0014285714
    //    1.6666666667
    //    9.7916666667
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0090000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(24.2857142857,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0014285714,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6666666667,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9.7916666667,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Standardized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG    LOC    N_COMM    HALVOL    SCPMN    N_VEXUSE
    //    module_1        0.8268741925     0.6620847109     0.6002450480     0.9592347424     0.1547131869
    //    module_2    -1.2185435917     -1.7718732697         -1.1147408034     0.1323082403     -0.8767080593
    //    module_3    -0.1740776560     -0.5906244232     -1.8207329549         -0.6946182617     -1.3924186824
    //    module_4    -0.1740776560     0.3543746539     0.2482817666     0.1714985851         1.1861344332
    //    module_5        -0.1181248846     -0.1655211777     -1.1147408034     -1.5215447638
    //    module_6    1.5666989036     1.2993737311     1.0758876552     1.4577379737     1.1246200428     0.9282791216
    virtual void Test_TCFbEDataSetEx_GetAppliedValues_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);

        TEST_ASSERT_EQUALS_DOUBLE(0.8268741925,    this->DataSet->GetPredictionTable()->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6620847109,    this->DataSet->GetPredictionTable()->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6002450480,    this->DataSet->GetPredictionTable()->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9592347424,    this->DataSet->GetPredictionTable()->GetValue("module_1", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1547131869,    this->DataSet->GetPredictionTable()->GetValue("module_1", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.2185435917,    this->DataSet->GetPredictionTable()->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.7718732697,    this->DataSet->GetPredictionTable()->GetValue("module_2", "LOC"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->GetPredictionTable()->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1323082403,    this->DataSet->GetPredictionTable()->GetValue("module_2", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8767080593,    this->DataSet->GetPredictionTable()->GetValue("module_2", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->GetPredictionTable()->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5906244232,    this->DataSet->GetPredictionTable()->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.8207329549,    this->DataSet->GetPredictionTable()->GetValue("module_3", "N_COMM"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.6946182617,    this->DataSet->GetPredictionTable()->GetValue("module_3", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.3924186824,    this->DataSet->GetPredictionTable()->GetValue("module_3", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->GetPredictionTable()->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3543746539,    this->DataSet->GetPredictionTable()->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->GetPredictionTable()->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1714985851,    this->DataSet->GetPredictionTable()->GetValue("module_4", "HALVOL"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.1861344332,    this->DataSet->GetPredictionTable()->GetValue("module_4", "N_VEXUSE"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(-0.1181248846,    this->DataSet->GetPredictionTable()->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1655211777,    this->DataSet->GetPredictionTable()->GetValue("module_5", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->GetPredictionTable()->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.5215447638,    this->DataSet->GetPredictionTable()->GetValue("module_5", "SCPMN"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.5666989036,    this->DataSet->GetPredictionTable()->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2993737311,    this->DataSet->GetPredictionTable()->GetValue("module_6", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0758876552,    this->DataSet->GetPredictionTable()->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4577379737,    this->DataSet->GetPredictionTable()->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1246200428,    this->DataSet->GetPredictionTable()->GetValue("module_6", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9282791216,    this->DataSet->GetPredictionTable()->GetValue("module_6", "N_VEXUSE"), 1E-6);
    }

    //    Average of Column        0.0000000000     0.0000000000     0.0000000000     0.0000000000     0.0000000000     0.0000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        -0.1740776560     0.1181248846     0.2482817666     0.1714985851     0.1323082403     0.1547131869
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1181248846,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1714985851,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1323082403,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1547131869,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.6406303761
    //    -0.9699114968
    //    -0.9344943957
    //    0.3572423566
    //    -0.7299829074
    //    1.2420995713
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.6406303761,    this->DataSet->GetPredictionTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9699114968,    this->DataSet->GetPredictionTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9344943957,    this->DataSet->GetPredictionTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3572423566,    this->DataSet->GetPredictionTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7299829074,    this->DataSet->GetPredictionTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2420995713,    this->DataSet->GetPredictionTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.6620847109
    //    -1.1147408034
    //    -0.6946182617
    //    0.2482817666
    //    -0.6401309906
    //    1.2119968869
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.6620847109,    this->DataSet->GetPredictionTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->GetPredictionTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6946182617,    this->DataSet->GetPredictionTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->GetPredictionTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6401309906,    this->DataSet->GetPredictionTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2119968869,    this->DataSet->GetPredictionTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    2.1078996983
    //    0.8139249639
    //    2.1576086957
    //    3.0422240803
    //    0.5366241602
    virtual void Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.1078996983,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8139249639,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1576086957,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0422240803,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5366241602,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.5025641026
    //    0.8722943723
    //    2.5000000000
    //    2.3152173913
    //    0.6153846154
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.5025641026,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8722943723,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.3152173913,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6153846154,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    // StandardizedValue-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
    //    BUG        -1.2185435917     -0.1740776560     -0.1740776560         1.5666989036
    //    LOC    0.8268741925     -1.7718732697     -0.5906244232     0.3543746539     -0.1181248846     1.2993737311
    //    N_COMM    0.6620847109         -1.8207329549     0.2482817666     -0.1655211777     1.0758876552
    //    HALVOL    0.6002450480     -1.1147408034         0.1714985851     -1.1147408034     1.4577379737
    //    SCPMN    0.9592347424     0.1323082403     -0.6946182617         -1.5215447638     1.1246200428
    //    N_VEXUSE    0.1547131869     -0.8767080593     -1.3924186824     1.1861344332         0.9282791216
    virtual void Test_TCFbEDataSetEx_GetAppliedValues_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);

        TEST_ASSERT_EQUALS_DOUBLE(-1.2185435917,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_4"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.5666989036,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8268741925,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.7718732697,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5906244232,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3543746539,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1181248846,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2993737311,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6620847109,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_1"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.8207329549,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1655211777,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0758876552,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6002450480,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_2"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1714985851,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4577379737,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.9592347424,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1323082403,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6946182617,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_3"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-1.5215447638,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1246200428,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1547131869,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8767080593,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.3924186824,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1861344332,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_4"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.9282791216,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_6"), 1E-6);
    }

    //    Average of Column        0.6406303761     -0.9699114968     -0.9344943957     0.3572423566     -0.7299829074     1.2420995713
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.6406303761,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9699114968,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9344943957,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3572423566,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7299829074,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2420995713,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.6620847109     -1.1147408034     -0.6946182617     0.2482817666     -0.6401309906     1.2119968869
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.6620847109,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.1147408034,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6946182617,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6401309906,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2119968869,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    //    0.0000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    -0.1740776560
    //    0.1181248846
    //    0.2482817666
    //    0.1714985851
    //    0.1323082403
    //    0.1547131869
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(-0.1740776560,    this->DataSet->GetPredictionTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1181248846,    this->DataSet->GetPredictionTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2482817666,    this->DataSet->GetPredictionTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1714985851,    this->DataSet->GetPredictionTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1323082403,    this->DataSet->GetPredictionTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1547131869,    this->DataSet->GetPredictionTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    0.6698521441
    //    0.7509766379
    //    1.0609677789
    //    3.6178617319
    //    0.8373580520
    virtual void Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.6698521441,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7509766379,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0609677789,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.6178617319,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8373580520,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.5894698868
    //    0.7011294400
    //    1.0747465812
    //    1.3930917501
    //    0.7683342653
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.5894698868,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7011294400,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0747465812,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3930917501,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7683342653,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Normalized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG    LOC    N_COMM    HALVOL    SCPMN    N_VEXUSE
    //    module_1        0.8461538462     0.8571428571     0.6666666667     0.9375000000     0.6000000000
    //    module_2    0.0000000000     0.0000000000         0.0000000000     0.6250000000     0.2000000000
    //    module_3    0.3750000000     0.3846153846     0.0000000000         0.3125000000     0.0000000000
    //    module_4    0.3750000000     0.6923076923     0.7142857143     0.5000000000         1.0000000000
    //    module_5        0.5384615385     0.5714285714     0.0000000000     0.0000000000
    //    module_6    1.0000000000     1.0000000000     1.0000000000     1.0000000000     1.0000000000     0.9000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedValues_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);

        TEST_ASSERT_EQUALS_DOUBLE(0.8461538462,    this->DataSet->GetPredictionTable()->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8571428571,    this->DataSet->GetPredictionTable()->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6666666667,    this->DataSet->GetPredictionTable()->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9375000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "LOC"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6250000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3846153846,    this->DataSet->GetPredictionTable()->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "N_COMM"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.3125000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6923076923,    this->DataSet->GetPredictionTable()->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7142857143,    this->DataSet->GetPredictionTable()->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "HALVOL"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "N_VEXUSE"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.5384615385,    this->DataSet->GetPredictionTable()->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5714285714,    this->DataSet->GetPredictionTable()->GetValue("module_5", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "SCPMN"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "N_VEXUSE"), 1E-6);
    }

    //    Average of Column        0.4375000000     0.5769230769     0.6285714286     0.4333333333     0.5750000000     0.5400000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.4375000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5769230769,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6285714286,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4333333333,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5750000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5400000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.3750000000     0.6153846154     0.7142857143     0.5000000000     0.6250000000     0.6000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6153846154,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7142857143,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6250000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.7814926740
    //    0.1650000000
    //    0.2144230769
    //    0.6563186813
    //    0.2774725275
    //    0.9833333333
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.7814926740,    this->DataSet->GetPredictionTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1650000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2144230769,    this->DataSet->GetPredictionTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6563186813,    this->DataSet->GetPredictionTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2774725275,    this->DataSet->GetPredictionTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9833333333,    this->DataSet->GetPredictionTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.8461538462
    //    0.0000000000
    //    0.3125000000
    //    0.6923076923
    //    0.2692307692
    //    1.0000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.8461538462,    this->DataSet->GetPredictionTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3125000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6923076923,    this->DataSet->GetPredictionTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2692307692,    this->DataSet->GetPredictionTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    2.2500000000
    //    2.6000000000
    //    1.0888888889
    //    1.5357142857
    //    0.7948260073
    virtual void Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.2500000000,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6000000000,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0888888889,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5357142857,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7948260073,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    2.2500000000
    //    2.6000000000
    //    1.2111111111
    //    1.5357142857
    //    0.8461538462
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.2500000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2111111111,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5357142857,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8461538462,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    // NormalizedValue-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
    //    BUG        0.0000000000     0.3750000000     0.3750000000         1.0000000000
    //    LOC    0.8461538462     0.0000000000     0.3846153846     0.6923076923     0.5384615385     1.0000000000
    //    N_COMM    0.8571428571         0.0000000000     0.7142857143     0.5714285714     1.0000000000
    //    HALVOL    0.6666666667     0.0000000000         0.5000000000     0.0000000000     1.0000000000
    //    SCPMN    0.9375000000     0.6250000000     0.3125000000         0.0000000000     1.0000000000
    //    N_VEXUSE    0.6000000000     0.2000000000     0.0000000000     1.0000000000         0.9000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedValues_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_4"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8461538462,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3846153846,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6923076923,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5384615385,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8571428571,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_1"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7142857143,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5714285714,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6666666667,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_2"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.9375000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6250000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3125000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_3"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_4"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.9000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_6"), 1E-6);
    }

    //    Average of Column        0.7814926740     0.1650000000     0.2144230769     0.6563186813     0.2774725275     0.9833333333
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.7814926740,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1650000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2144230769,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6563186813,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2774725275,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9833333333,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.8461538462     0.0000000000     0.3125000000     0.6923076923     0.2692307692     1.0000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.8461538462,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3125000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6923076923,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2692307692,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.4375000000
    //    0.5769230769
    //    0.6285714286
    //    0.4333333333
    //    0.5750000000
    //    0.5400000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.4375000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5769230769,    this->DataSet->GetPredictionTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6285714286,    this->DataSet->GetPredictionTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4333333333,    this->DataSet->GetPredictionTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5750000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5400000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.3750000000
    //    0.6153846154
    //    0.7142857143
    //    0.5000000000
    //    0.6250000000
    //    0.6000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6153846154,    this->DataSet->GetPredictionTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7142857143,    this->DataSet->GetPredictionTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6250000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    0.8388888889
    //    0.7625000000
    //    0.8750000000
    //    0.7333333333
    //    0.4953703704
    virtual void Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8388888889,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7625000000,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8750000000,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7333333333,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4953703704,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    0.9750000000
    //    0.7625000000
    //    0.8750000000
    //    1.0000000000
    //    0.3750000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9750000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7625000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8750000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3750000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Order-based & Row-based
    //---------------------------------------------------------------------------
    //    FILENAME    BUG    LOC    N_COMM    HALVOL    SCPMN    N_VEXUSE
    //    module_1        0.8000000000     0.7500000000     0.7500000000     0.7500000000     0.5000000000
    //    module_2    0.0000000000     0.0000000000         0.1250000000     0.5000000000     0.2500000000
    //    module_3    0.5000000000     0.2000000000     0.0000000000         0.2500000000     0.0000000000
    //    module_4    0.5000000000     0.6000000000     0.5000000000     0.5000000000         1.0000000000
    //    module_5        0.4000000000     0.2500000000     0.1250000000     0.0000000000
    //    module_6    1.0000000000     1.0000000000     1.0000000000     1.0000000000     1.0000000000     0.7500000000
    virtual void Test_TCFbEDataSetEx_GetAppliedValues_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);

        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "LOC"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "N_COMM"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "HALVOL"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "N_VEXUSE"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "SCPMN"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "N_VEXUSE"), 1E-6);
    }

    //    Average of Column        0.5000000000     0.5000000000     0.5000000000     0.5000000000     0.5000000000     0.5000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.5000000000     0.5000000000     0.5000000000     0.5000000000     0.5000000000     0.5000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.7100000000
    //    0.1750000000
    //    0.1900000000
    //    0.6200000000
    //    0.1937500000
    //    0.9583333333
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.7100000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1750000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1900000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6200000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1937500000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9583333333,    this->DataSet->GetPredictionTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.7500000000
    //    0.1250000000
    //    0.2000000000
    //    0.5000000000
    //    0.1875000000
    //    1.0000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1875000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    3.1666666667
    //    3.5000000000
    //    1.2083333333
    //    3.6666666667
    //    0.7433333333
    virtual void Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.1666666667,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2083333333,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.6666666667,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7433333333,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    2.0000000000
    //    3.5000000000
    //    1.4166666667
    //    3.0000000000
    //    0.7500000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4166666667,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Order-based & Column-based
    //---------------------------------------------------------------------------
    //    FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
    //    BUG        0.0000000000     0.5000000000     0.5000000000         1.0000000000
    //    LOC    0.8000000000     0.0000000000     0.2000000000     0.6000000000     0.4000000000     1.0000000000
    //    N_COMM    0.7500000000         0.0000000000     0.5000000000     0.2500000000     1.0000000000
    //    HALVOL    0.7500000000     0.1250000000         0.5000000000     0.1250000000     1.0000000000
    //    SCPMN    0.7500000000     0.5000000000     0.2500000000         0.0000000000     1.0000000000
    //    N_VEXUSE    0.5000000000     0.2500000000     0.0000000000     1.0000000000         0.7500000000
    virtual void Test_TCFbEDataSetEx_GetAppliedValues_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_4"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("BUG", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("LOC", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_1"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("N_COMM", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_2"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("HALVOL", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_3"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("SCPMN", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_4"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetValue("N_VEXUSE", "module_6"), 1E-6);
    }

    //    Average of Column        0.7100000000     0.1750000000     0.1900000000     0.6200000000     0.1937500000     0.9583333333
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.7100000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1750000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1900000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6200000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1937500000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9583333333,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.7500000000     0.1250000000     0.2000000000     0.5000000000     0.1875000000     1.0000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1250000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1875000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    //    0.5000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    1.4444444444
    //    1.0000000000
    //    0.6666666667
    //    1.0000000000
    //    0.6111111111
    virtual void Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.4444444444,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6666666667,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6111111111,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    0.5000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, NULL, NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    // ȉCASỸeXg

    //---------------------------------------------------------------------------
    // Value-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.9901177604
    //    0.9999994185
    //    0.9997737281
    //    0.9994448571
    //    0.9999035624
    virtual void Test_TCFbECosineSimilarity_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9901177604,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999994185,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997737281,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994448571,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999035624,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.9976507295
    //    -0.9999971731
    //    0.9829727877
    //    -0.6965683667
    //    0.9767712349
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9976507295,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999971731,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9829727877,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6965683667,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9767712349,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.9984564331
    //    -0.9999971112
    //    0.8320436060
    //    -0.6839439306
    //    0.9587974866
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9984564331,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999971112,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8320436060,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6839439306,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9587974866,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9891840230
    //    0.3514209594
    //    0.9997313139
    //    0.9884671240
    //    0.9943703173
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9891840230,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3514209594,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997313139,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9884671240,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9943703173,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.9900926718
    //    0.9999983627
    //    0.9997677324
    //    0.9831233986
    //    0.9999098538
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9900926718,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999983627,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997677324,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9831233986,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999098538,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    virtual void Test_TCFbERankCorrelation_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.0042074261
    //    0.0132625995
    //    0.0199750312
    //    0.0066489362
    //    0.0166500167
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0042074261,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0132625995,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0199750312,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0066489362,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0166500167,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.0049937578
    //    1.5384615385
    //    0.0199600798
    //    0.0099255583
    //    6.6666666667
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0049937578,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5384615385,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0199600798,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0099255583,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.6666666667,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    5.5085887372
    //    1.9425139355
    //    1.7816757791
    //    5.6010422355
    //    5.5086187813
    //    5.5000000000
    //    6.3056236075
    //    9.0483620803
    virtual void Test_TCFbEWeightedSum_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5085887372,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.9425139355,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.7816757791,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6010422355,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5086187813,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3056236075,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.0483620803,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    5.5085887372
    //    7.4951929079
    //    7.5830164225
    //    5.6010422355
    //    5.5086187813
    //    5.5000000000
    //    6.3056236075
    //    9.0483620803
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5085887372,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4951929079,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.5830164225,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6010422355,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5086187813,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3056236075,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.0483620803,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    5.5085887372
    //    6.9904039104
    //    7.0556218185
    //    5.6010422355
    //    5.5086187813
    //    5.5000000000
    //    6.3056236075
    //    9.0483620803
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5085887372,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9904039104,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0556218185,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6010422355,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5086187813,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3056236075,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.0483620803,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    5.5085887372
    //    7.4951929079
    //    7.5830164225
    //    5.6010422355
    //    5.5086187813
    //    5.5000000000
    //    6.3056236075
    //    9.0483620803
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5085887372,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4951929079,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.5830164225,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6010422355,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5086187813,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3056236075,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.0483620803,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    5.5085887372
    //    6.9904039104
    //    7.0556218185
    //    5.6010422355
    //    5.5086187813
    //    5.5000000000
    //    6.3056236075
    //    9.0483620803
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5085887372,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9904039104,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0556218185,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6010422355,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5086187813,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3056236075,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.0483620803,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    281.7406273018
    //    679.9396998522
    //    708.1546245261
    //    184.3135253771
    //    281.7411374673
    //    281.5008333333
    //    256.0959133680
    //    231.9847013676
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(281.7406273018,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(679.9396998522,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(708.1546245261,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(184.3135253771,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(281.7411374673,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(281.5008333333,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(256.0959133680,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(231.9847013676,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    4.8683499193
    //    4.6008899133
    //    4.6138722997
    //    4.6454715722
    //    4.8683691000
    //    4.8625000000
    //    5.2816621642
    //    6.7625604446
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8683499193,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.6008899133,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.6138722997,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.6454715722,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8683691000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8625000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.2816621642,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7625604446,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.4563463327
    //    0.5297739087
    //    0.3049411761
    //    6.1096261815
    //    6.4563704304
    //    6.4489890886
    //    6.9402192833
    //    8.7917227555
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4563463327,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.5297739087,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.3049411761,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.1096261815,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4563704304,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4489890886,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9402192833,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7917227555,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.2489709923
    //    0.8545838497
    //    0.6335474270
    //    5.9050471690
    //    6.2489986007
    //    6.2400793651
    //    6.9074026500
    //    8.7105454966
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2489709923,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8545838497,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.6335474270,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9050471690,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2489986007,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2400793651,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9074026500,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7105454966,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Column-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃ACeƂق̃ACe̊Ԃ̗ގxvZƂ
    //    0.9836066949
    //    0.9017000960
    //    0.8968217659
    //    0.8991068415
    //    0.9227002865
    virtual void Test_TCFbECosineSimilarity_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9836066949,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9017000960,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8968217659,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8991068415,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9227002865,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.3553050841
    //    0.9999880635
    //    -0.9962689032
    //    0.9999871077
    //    0.9999878833
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.3553050841,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999880635,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9962689032,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999871077,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999878833,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.6686639593
    //    -0.8267794991
    //    0.3184271644
    //    -0.7628956006
    //    -0.5803600916
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.6686639593,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8267794991,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3184271644,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7628956006,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5803600916,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9197895190
    //    0.5801908394
    //    0.9836910734
    //    0.6504566481
    //    0.5734835971
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9197895190,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5801908394,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9836910734,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6504566481,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5734835971,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.8445765603
    //    0.3713906764
    //    0.9701425001
    //    0.6587443126
    //    0.5276900959
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8445765603,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3713906764,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9701425001,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6587443126,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5276900959,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    0.9486832981
    //    0.8660254038
    //    1.0000000000
    //    0.5000000000
    //    0.3162277660
    virtual void Test_TCFbERankCorrelation_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8660254038,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.0017182131
    //    0.1546391753
    //    0.0002861776
    //    0.3191489362
    //    0.2025316456
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0017182131,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1546391753,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0002861776,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3191489362,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2025316456,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.0016806723
    //    0.2000000000
    //    0.0002861230
    //    0.5000000000
    //    0.2247191011
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0016806723,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0002861230,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2247191011,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    873.1364957916
    //    -757.7607670362
    //    531.3759918434
    //    1154.4465349790
    //    1236.8221371001
    //    1201.1766720065
    //    5.6747447069
    //    4.9309180294
    virtual void Test_TCFbEWeightedSum_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(873.1364957916,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-757.7607670362,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(531.3759918434,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1154.4465349790,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1236.8221371001,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1201.1766720065,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6747447069,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.9309180294,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    873.1364957916
    //    -354.3663020927
    //    1742.4505020519
    //    1154.4465349790
    //    1236.8221371001
    //    1201.1766720065
    //    5.6747447069
    //    4.9309180294
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(873.1364957916,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-354.3663020927,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1742.4505020519,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1154.4465349790,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1236.8221371001,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1201.1766720065,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6747447069,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.9309180294,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    873.1364957916
    //    -755.9291955365
    //    536.8747523610
    //    1154.4465349790
    //    1236.8221371001
    //    1201.1766720065
    //    5.6747447069
    //    4.9309180294
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(873.1364957916,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-755.9291955365,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(536.8747523610,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1154.4465349790,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1236.8221371001,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1201.1766720065,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6747447069,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.9309180294,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    873.1364957916
    //    -354.3663020927
    //    1742.4505020519
    //    1154.4465349790
    //    1236.8221371001
    //    1201.1766720065
    //    5.6747447069
    //    4.9309180294
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(873.1364957916,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-354.3663020927,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1742.4505020519,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1154.4465349790,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1236.8221371001,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1201.1766720065,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6747447069,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.9309180294,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    873.1364957916
    //    -755.9291955365
    //    536.8747523610
    //    1154.4465349790
    //    1236.8221371001
    //    1201.1766720065
    //    5.6747447069
    //    4.9309180294
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(873.1364957916,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-755.9291955365,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(536.8747523610,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1154.4465349790,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1236.8221371001,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1201.1766720065,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6747447069,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.9309180294,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    70.2940236880
    //    -12.1051047669
    //    56.5179027437
    //    86.1774891195
    //    89.7237935206
    //    89.8827339687
    //    6.3024270113
    //    6.1980967847
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(70.2940236880,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-12.1051047669,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(56.5179027437,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(86.1774891195,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(89.7237935206,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(89.8827339687,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3024270113,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.1980967847,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    56.6336099214
    //    -5.5206813825
    //    46.7213346640
    //    68.8394183841
    //    71.4331335925
    //    71.8135612192
    //    5.6687896181
    //    5.5834912841
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(56.6336099214,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-5.5206813825,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(46.7213346640,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(68.8394183841,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(71.4331335925,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(71.8135612192,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6687896181,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5834912841,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.5291385470
    //    3.8340870341
    //    -2.4495683047
    //    6.4816870463
    //    6.4216001505
    //    6.5782588617
    //    6.4632114933
    //    6.4525282124
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5291385470,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.8340870341,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-2.4495683047,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4816870463,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4216001505,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5782588617,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4632114933,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4525282124,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.4463614446
    //    3.9667971678
    //    -2.5552539516
    //    6.3691043537
    //    6.3061917131
    //    6.4650434431
    //    6.5721274414
    //    6.6087908140
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abColumn() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4463614446,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.9667971678,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-2.5552539516,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3691043537,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3061917131,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4650434431,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5721274414,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.6087908140,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Standardized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    -0.6685321921
    //    -0.7263668776
    //    0.4756642569
    //    -0.7943749408
    //    0.9359682466
    virtual void Test_TCFbECosineSimilarity_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6685321921,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7263668776,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4756642569,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7943749408,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9359682466,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.6685321921
    //    -0.7263668776
    //    0.4756642569
    //    -0.7943749408
    //    0.9359682466
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6685321921,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7263668776,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4756642569,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7943749408,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9359682466,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.6441729975
    //    -0.6252352350
    //    0.1708979822
    //    -0.8464172857
    //    0.8913308489
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6441729975,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6252352350,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1708979822,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8464172857,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8913308489,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.1932599017
    //    0.5206404284
    //    -0.8899375377
    //    -0.2454869582
    //    0.4257212724
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.1932599017,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5206404284,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8899375377,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2454869582,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4257212724,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.1612725498
    //    0.4574269066
    //    -0.8919718972
    //    -0.3464579202
    //    0.4568398976
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.1612725498,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4574269066,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8919718972,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3464579202,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4568398976,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    0.2000000000
    //    0.6000000000
    //    -0.2000000000
    //    -0.2000000000
    //    0.3000000000
    virtual void Test_TCFbERankCorrelation_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.6480796282
    //    0.5632770548
    //    1.7046881796
    //    0.6701997000
    //    1.8637615340
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.6480796282,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5632770548,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7046881796,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6701997000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8637615340,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.7282241594
    //    0.6248077011
    //    2.2191499289
    //    0.7518839594
    //    2.1164041832
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.7282241594,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6248077011,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.2191499289,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7518839594,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.1164041832,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    7.8791184665
    //    7.8791184665
    //    8.2846370429
    //    6.2016226314
    //    6.3684057634
    //    5.8461538462
    //    6.5428593071
    //    6.4761750070
    virtual void Test_TCFbEWeightedSum_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2846370429,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2016226314,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3684057634,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8461538462,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5428593071,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4761750070,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    7.8791184665
    //    7.8791184665
    //    8.2846370429
    //    6.2016226314
    //    6.3684057634
    //    5.8461538462
    //    6.5428593071
    //    6.4761750070
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2846370429,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2016226314,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3684057634,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8461538462,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5428593071,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4761750070,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    7.3820996255
    //    7.3820996255
    //    7.7402091590
    //    5.7631345282
    //    5.9150554221
    //    5.6923076923
    //    6.5428593071
    //    6.4761750070
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3820996255,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3820996255,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7402091590,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7631345282,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9150554221,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6923076923,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5428593071,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4761750070,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    7.8791184665
    //    7.8791184665
    //    8.2846370429
    //    6.2016226314
    //    6.3684057634
    //    5.8461538462
    //    6.5428593071
    //    6.4761750070
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8791184665,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2846370429,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2016226314,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3684057634,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8461538462,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5428593071,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4761750070,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    7.3820996255
    //    7.3820996255
    //    7.7402091590
    //    5.7631345282
    //    5.9150554221
    //    5.6923076923
    //    6.5428593071
    //    6.4761750070
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3820996255,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3820996255,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7402091590,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7631345282,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9150554221,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6923076923,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5428593071,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4761750070,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    6.9971833436
    //    6.9971833436
    //    7.1962453031
    //    8.6971059189
    //    8.6976628954
    //    8.6882033604
    //    7.3198994084
    //    7.2400757620
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9971833436,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9971833436,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1962453031,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.6971059189,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.6976628954,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.6882033604,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3198994084,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2400757620,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    7.2199129827
    //    7.2199129827
    //    7.3836873837
    //    8.5024992234
    //    8.5113929208
    //    8.4676331522
    //    7.5020621945
    //    7.4335338255
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2199129827,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2199129827,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3836873837,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.5024992234,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.5113929208,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.4676331522,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.5020621945,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4335338255,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    7.9852154064
    //    7.9852154064
    //    8.4914422136
    //    5.6726577406
    //    5.8504306686
    //    4.9003816983
    //    5.0085713034
    //    4.9884189461
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.9852154064,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.9852154064,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.4914422136,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6726577406,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8504306686,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.9003816983,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0085713034,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.9884189461,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.7435511624
    //    6.7435511624
    //    7.0699084414
    //    6.3496068260
    //    6.4641013403
    //    5.8594508056
    //    5.8440931022
    //    5.7695640772
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbStandardizedValue_abRow() {
        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7435511624,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7435511624,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0699084414,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3496068260,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4641013403,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8594508056,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8440931022,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7695640772,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Standardized Value-based & Column-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃ACeƂق̃ACe̊Ԃ̗ގxvZƂ
    //    0.9197895190
    //    0.5801908394
    //    0.9836910734
    //    0.6504566481
    //    0.5734835971
    virtual void Test_TCFbECosineSimilarity_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9197895190,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5801908394,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9836910734,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6504566481,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5734835971,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.5425783563
    //    -0.7505577749
    //    0.9560931789
    //    -0.1325356570
    //    -0.8994903813
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.5425783563,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7505577749,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9560931789,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1325356570,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8994903813,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.2086983819
    //    -0.7375326010
    //    0.8276918233
    //    -0.2010362691
    //    -0.9425209184
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.2086983819,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7375326010,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8276918233,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2010362691,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9425209184,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9197895190
    //    0.5801908394
    //    0.9836910734
    //    0.6504566481
    //    0.5734835971
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9197895190,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5801908394,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9836910734,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6504566481,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5734835971,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.8445765603
    //    0.3713906764
    //    0.9701425001
    //    0.6587443126
    //    0.5276900959
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8445765603,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3713906764,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9701425001,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6587443126,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5276900959,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    0.9486832981
    //    0.8660254038
    //    1.0000000000
    //    0.5000000000
    //    0.3162277660
    virtual void Test_TCFbERankCorrelation_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8660254038,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    2.2654496090
    //    1.1719546701
    //    5.3730705644
    //    1.2967526339
    //    1.1239717110
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.2654496090,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1719546701,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.3730705644,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2967526339,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1239717110,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    2.1164041832
    //    2.0374431173
    //    9.1776015587
    //    1.9210797177
    //    1.0771446655
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.1164041832,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0374431173,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9.1776015587,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.9210797177,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0771446655,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    7.3963128657
    //    5.7269858610
    //    5.3448561446
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEWeightedSum_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7269858610,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3448561446,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    7.3963128657
    //    7.7262695701
    //    7.7176834782
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7262695701,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7176834782,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    7.3963128657
    //    7.7932244064
    //    7.7971480708
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7932244064,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7971480708,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    7.3963128657
    //    7.7262695701
    //    7.7176834782
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7262695701,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7176834782,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    7.3963128657
    //    7.7932244064
    //    7.7971480708
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7932244064,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7971480708,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.3963128657
    //    5.7269858610
    //    5.3448561446
    //    7.3963128657
    //    7.4078212982
    //    7.4670534651
    //    7.3648955089
    //    7.3674924426
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7269858610,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3448561446,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3963128657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4078212982,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4670534651,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3648955089,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3674924426,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    6.4344463441
    //    5.3276416043
    //    5.0308637184
    //    6.4344463441
    //    6.4588646709
    //    6.4816138179
    //    6.3980348673
    //    6.3836750588
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4344463441,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3276416043,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0308637184,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4344463441,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4588646709,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4816138179,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3980348673,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3836750588,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    8.4097779902
    //    5.4647588967
    //    4.9646422830
    //    8.4097779902
    //    8.5870654272
    //    8.1651171039
    //    8.0331497042
    //    8.1096186429
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.4097779902,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.4647588967,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.9646422830,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.4097779902,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.5870654272,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1651171039,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.0331497042,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1096186429,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    7.2737634965
    //    5.7177923703
    //    5.4139783909
    //    7.2737634965
    //    7.3335706061
    //    7.2524091609
    //    7.2853143663
    //    7.3632608217
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbStandardizedValue_abColumn() {
        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2737634965,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7177923703,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.4139783909,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2737634965,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3335706061,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2524091609,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2853143663,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbStandardizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3632608217,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Normalized Value-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.6944994562
    //    0.7609133497
    //    0.9484206852
    //    0.7229564935
    //    0.9909483325
    virtual void Test_TCFbECosineSimilarity_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.6944994562,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7609133497,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9484206852,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7229564935,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9909483325,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.6325046601
    //    -0.7118987884
    //    0.4510233762
    //    -0.8260362038
    //    0.9282829241
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6325046601,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7118987884,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4510233762,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8260362038,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9282829241,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.6002671236
    //    -0.6047799861
    //    0.1368306741
    //    -0.8693886832
    //    0.8778496852
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6002671236,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6047799861,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1368306741,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8693886832,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8778496852,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.5217016230
    //    0.5232452951
    //    -0.4152703551
    //    0.2288910488
    //    0.7133008256
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.5217016230,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5232452951,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4152703551,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2288910488,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7133008256,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.0376633264
    //    0.6245229727
    //    -0.3698247162
    //    0.2413616015
    //    0.7735019523
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0376633264,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6245229727,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3698247162,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2413616015,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7735019523,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    0.3162277660
    //    0.2108185107
    //    -0.2000000000
    //    0.1054092553
    //    0.7071067812
    virtual void Test_TCFbERankCorrelation_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2108185107,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1054092553,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7071067812,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    1.7974938787
    //    1.5725240307
    //    4.6330080611
    //    1.8201896031
    //    5.0375974535
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.7974938787,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5725240307,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.6330080611,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8201896031,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0375974535,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    1.8750000000
    //    1.6326530612
    //    6.2400000000
    //    2.0526315789
    //    6.5000000000
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.8750000000,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6326530612,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.2400000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0526315789,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.5000000000,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    5.8457813913
    //    4.4391869066
    //    4.5313691091
    //    4.7744565036
    //    5.8504904216
    //    5.9670171536
    //    6.5179876750
    //    6.6540850484
    virtual void Test_TCFbEWeightedSum_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8457813913,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.4391869066,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.5313691091,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.7744565036,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8504904216,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9670171536,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5179876750,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.6540850484,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    5.8457813913
    //    7.8943363194
    //    8.3315337175
    //    6.1118700210
    //    7.2843062179
    //    6.9432030581
    //    6.5179876750
    //    6.6540850484
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8457813913,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8943363194,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3315337175,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.1118700210,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2843062179,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9432030581,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5179876750,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.6540850484,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    5.8457813913
    //    7.4007435461
    //    7.7886530592
    //    5.9208109471
    //    7.0794753899
    //    6.8037479289
    //    6.5179876750
    //    6.6540850484
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8457813913,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4007435461,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7886530592,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9208109471,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0794753899,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8037479289,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5179876750,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.6540850484,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    5.8457813913
    //    7.8943363194
    //    8.3315337175
    //    6.1118700210
    //    7.2843062179
    //    6.9432030581
    //    6.5179876750
    //    6.6540850484
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8457813913,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8943363194,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3315337175,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.1118700210,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2843062179,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9432030581,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5179876750,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.6540850484,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    5.8457813913
    //    7.4007435461
    //    7.7886530592
    //    5.9208109471
    //    7.0794753899
    //    6.8037479289
    //    6.5179876750
    //    6.6540850484
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8457813913,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4007435461,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7886530592,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9208109471,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0794753899,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8037479289,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5179876750,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.6540850484,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.6800049332
    //    7.8954829478
    //    8.1728980646
    //    8.7181054697
    //    9.1868549947
    //    8.5293112606
    //    7.4768452087
    //    7.4177020951
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6800049332,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8954829478,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1728980646,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7181054697,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.1868549947,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.5293112606,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4768452087,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4177020951,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    8.1721164738
    //    8.2181974265
    //    8.4765239368
    //    9.3745951657
    //    9.4621348507
    //    9.1967315577
    //    7.9276720187
    //    7.8445634703
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1721164738,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2181974265,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.4765239368,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.3745951657,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.4621348507,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.1967315577,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.9276720187,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8445634703,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.5170356198
    //    2.6693517040
    //    2.5908826247
    //    5.3403742334
    //    6.7529876635
    //    5.8261368945
    //    6.5574729267
    //    6.5821784831
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5170356198,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.6693517040,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.5908826247,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3403742334,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7529876635,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.8261368945,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5574729267,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5821784831,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.7393356617
    //    2.8700152617
    //    2.7758766252
    //    5.4050765801
    //    6.8537983891
    //    5.9774601920
    //    6.8463641416
    //    6.8872716311
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow() {
        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7393356617,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.8700152617,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.7758766252,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.4050765801,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8537983891,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9774601920,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8463641416,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8872716311,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Normalized Value-based & Column-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃ACeƂق̃ACe̊Ԃ̗ގxvZƂ
    //    0.9722536510
    //    0.9114556946
    //    0.9945054529
    //    0.8574565448
    //    0.8281469016
    virtual void Test_TCFbECosineSimilarity_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9722536510,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9114556946,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9945054529,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8574565448,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8281469016,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.5111669542
    //    -0.6984463542
    //    0.9604245007
    //    -0.5511071481
    //    -0.9155257605
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.5111669542,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6984463542,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9604245007,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5511071481,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9155257605,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.1932564780
    //    -0.2616141047
    //    1.0000000000
    //    0.0000000000
    //    -0.7359449862
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.1932564780,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2616141047,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7359449862,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9197895190
    //    0.5801908394
    //    0.9836910734
    //    0.6504566481
    //    0.5734835971
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9197895190,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5801908394,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9836910734,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6504566481,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5734835971,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.8445765603
    //    0.3713906764
    //    0.9701425001
    //    0.6587443126
    //    0.5276900959
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8445765603,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3713906764,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9701425001,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6587443126,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5276900959,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    0.9486832981
    //    0.8660254038
    //    1.0000000000
    //    0.5000000000
    //    0.3162277660
    virtual void Test_TCFbERankCorrelation_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8660254038,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    12.2352941176
    //    4.2000000000
    //    24.0000000000
    //    4.3636363636
    //    3.0769230769
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(12.2352941176,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.2000000000,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(24.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.3636363636,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0769230769,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    208.0000000000
    //    2.9473684211
    //    0.0000000000
    //    16.0000000000
    //    3.4782608696
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(208.0000000000,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9473684211,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(16.0000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4782608696,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    8.2538532430
    //    0.6980667268
    //    2.6002649545
    //    8.2256297348
    //    8.2004824253
    //    8.3238624241
    //    7.9971783596
    //    8.7913720505
    virtual void Test_TCFbEWeightedSum_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2538532430,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.6980667268,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.6002649545,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2256297348,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2004824253,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3238624241,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.9971783596,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7913720505,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    8.2538532430
    //    8.1422098513
    //    8.2937437299
    //    8.2256297348
    //    8.2004824253
    //    8.3238624241
    //    7.9971783596
    //    8.7913720505
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2538532430,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1422098513,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2937437299,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2256297348,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2004824253,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3238624241,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.9971783596,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7913720505,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    8.2538532430
    //    8.7581427144
    //    8.7648255756
    //    8.2256297348
    //    8.2004824253
    //    8.3238624241
    //    7.9971783596
    //    8.7913720505
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2538532430,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7581427144,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7648255756,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2256297348,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2004824253,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3238624241,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.9971783596,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7913720505,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    8.2538532430
    //    8.1422098513
    //    8.2937437299
    //    8.2256297348
    //    8.2004824253
    //    8.3238624241
    //    7.9971783596
    //    8.7913720505
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2538532430,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1422098513,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2937437299,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2256297348,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2004824253,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3238624241,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.9971783596,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7913720505,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    8.2538532430
    //    8.7581427144
    //    8.7648255756
    //    8.2256297348
    //    8.2004824253
    //    8.3238624241
    //    7.9971783596
    //    8.7913720505
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2538532430,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7581427144,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7648255756,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2256297348,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2004824253,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3238624241,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.9971783596,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.7913720505,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.3627585157
    //    5.3842197177
    //    6.1624371940
    //    7.3987493476
    //    7.4192587247
    //    7.4541413736
    //    7.4417807266
    //    7.6762294431
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3627585157,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3842197177,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.1624371940,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3987493476,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4192587247,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4541413736,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4417807266,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6762294431,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    6.3817908081
    //    5.0132721844
    //    5.6349813262
    //    6.4291890259
    //    6.4600398558
    //    6.4664238878
    //    6.4683252826
    //    6.8546913482
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3817908081,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0132721844,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6349813262,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4291890259,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4600398558,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4664238878,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4683252826,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8546913482,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.7356986948
    //    1.5943618168
    //    3.2079143266
    //    6.7978062138
    //    6.7866053164
    //    6.9805017665
    //    6.9034316974
    //    7.6106459045
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7356986948,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.5943618168,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.2079143266,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7978062138,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7866053164,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9805017665,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9034316974,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6106459045,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    7.2029020397
    //    1.5662396041
    //    3.4832788572
    //    7.2878875829
    //    7.3175891521
    //    7.4463255610
    //    7.2840556698
    //    8.5724954318
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abColumn() {
        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2029020397,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.5662396041,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.4832788572,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2878875829,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3175891521,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4463255610,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2840556698,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbNormalizedValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.5724954318,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Order-based & Row-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃W[Ƃق̃W[̊Ԃ̗ގxvZƂ
    //    0.7302077484
    //    0.7646370735
    //    0.8936184067
    //    0.8076212696
    //    0.9987569171
    virtual void Test_TCFbECosineSimilarity_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.7302077484,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7646370735,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8936184067,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8076212696,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9987569171,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.7809376882
    //    -0.7408896016
    //    0.1268864803
    //    -0.8682179366
    //    0.9668594366
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7809376882,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7408896016,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1268864803,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8682179366,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9668594366,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.7809376882
    //    -0.7408896016
    //    0.1268864803
    //    -0.8682179366
    //    0.9668594366
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7809376882,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7408896016,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1268864803,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8682179366,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9668594366,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    -0.2292202491
    //    0.5490023806
    //    -0.9299617703
    //    0.3061292983
    //    0.9800181487
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2292202491,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5490023806,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9299617703,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3061292983,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9800181487,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    -0.3547874376
    //    0.6827887420
    //    -0.9230769231
    //    0.7158291329
    //    0.9805806757
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3547874376,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6827887420,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9230769231,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7158291329,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9805806757,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    -0.6324555320
    //    0.5000000000
    //    -0.3333333333
    //    0.7745966692
    //    0.7905694150
    virtual void Test_TCFbERankCorrelation_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6324555320,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3333333333,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7745966692,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7905694150,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    2.0779220779
    //    1.7021276596
    //    3.3333333333
    //    1.7582417582
    //    4.1666666667
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.0779220779,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7021276596,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.3333333333,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7582417582,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1666666667,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    2.2857142857
    //    1.8181818182
    //    4.0000000000
    //    1.7777777778
    //    4.0000000000
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.2857142857,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8181818182,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.7777777778,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    5.3964152862
    //    3.5136824485
    //    3.5136824485
    //    3.7622298310
    //    3.7552564332
    //    4.3238403829
    //    5.9258578807
    //    5.7081545064
    virtual void Test_TCFbEWeightedSum_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3964152862,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.5136824485,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.5136824485,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.7622298310,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.7552564332,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.3238403829,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9258578807,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7081545064,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    5.3964152862
    //    8.3411359321
    //    8.3411359321
    //    7.2491578961
    //    7.2700815609
    //    8.1533665540
    //    5.9258578807
    //    5.7081545064
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3964152862,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2491578961,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2700815609,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1533665540,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9258578807,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7081545064,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    5.3964152862
    //    8.3411359321
    //    8.3411359321
    //    7.2491578961
    //    7.2700815609
    //    8.1533665540
    //    5.9258578807
    //    5.7081545064
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3964152862,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2491578961,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2700815609,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1533665540,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9258578807,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7081545064,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    5.3964152862
    //    8.3411359321
    //    8.3411359321
    //    7.2491578961
    //    7.2700815609
    //    8.1533665540
    //    5.9258578807
    //    5.7081545064
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3964152862,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2491578961,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2700815609,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1533665540,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9258578807,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7081545064,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    5.3964152862
    //    8.3411359321
    //    8.3411359321
    //    7.2491578961
    //    7.2700815609
    //    8.1533665540
    //    5.9258578807
    //    5.7081545064
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3964152862,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3411359321,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2491578961,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2700815609,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1533665540,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9258578807,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7081545064,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.2288130020
    //    6.8402013116
    //    6.8402013116
    //    8.4493543622
    //    8.5462606599
    //    8.6007373312
    //    7.0447115221
    //    6.9763233190
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2288130020,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8402013116,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8402013116,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.4493543622,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.5462606599,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.6007373312,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0447115221,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9763233190,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    7.9077536964
    //    7.0234326872
    //    7.0234326872
    //    8.2192659103
    //    8.3472126702
    //    8.5151621021
    //    7.7224263580
    //    7.7145922747
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.9077536964,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0234326872,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0234326872,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.2192659103,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.3472126702,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.5151621021,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7224263580,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7145922747,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    7.7361923003
    //    0.8502771665
    //    0.8502771665
    //    4.5162890072
    //    4.7867617388
    //    5.5898379286
    //    7.1718074863
    //    7.0818669528
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7361923003,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8502771665,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8502771665,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.5162890072,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.7867617388,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5898379286,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1718074863,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0818669528,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    8.0306627683
    //    0.8953833128
    //    0.8953833128
    //    4.3146578538
    //    4.6039473519
    //    5.4593100788
    //    7.5042528290
    //    7.4481402003
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbOrder_abRow() {
        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.0306627683,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8953833128,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8953833128,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.3146578538,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.6039473519,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.4593100788,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.5042528290,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4481402003,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Order-based & Column-based
    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //    ̃ACeƂق̃ACe̊Ԃ̗ގxvZƂ
    //    0.9660917831
    //    0.9128709292
    //    0.9938079900
    //    0.8783100657
    //    0.8006407690
    virtual void Test_TCFbECosineSimilarity_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9660917831,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9128709292,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9938079900,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8783100657,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8006407690,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.5525800754
    //    -0.5585029467
    //    0.8430182553
    //    -0.3060441633
    //    -0.6975057878
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.5525800754,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5585029467,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8430182553,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3060441633,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6975057878,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    0.3003341575
    //    -1.0000000000
    //    0.0000000000
    //    -0.2592442202
    //    -0.3835167802
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.3003341575,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2592442202,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3835167802,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9128709292
    //    0.7071067812
    //    0.9899494937
    //    0.6324555320
    //    0.4472135955
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9128709292,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7071067812,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9899494937,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6324555320,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4472135955,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.9128709292
    //    0.7071067812
    //    0.9899494937
    //    0.6324555320
    //    0.4472135955
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9128709292,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7071067812,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9899494937,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6324555320,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4472135955,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    0.9486832981
    //    0.8660254038
    //    1.0000000000
    //    0.5000000000
    //    0.3162277660
    virtual void Test_TCFbERankCorrelation_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8660254038,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3162277660,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    10.0000000000
    //    6.0000000000
    //    24.0000000000
    //    4.0000000000
    //    2.6666666667
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.0000000000,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(24.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6666666667,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    20.0000000000
    //    0.0000000000
    //    0.0000000000
    //    4.0000000000
    //    2.6666666667
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(20.0000000000,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.6666666667,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    7.1663776510
    //    2.1565387928
    //    -0.7664859097
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEWeightedSum_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.1565387928,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7664859097,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    7.1663776510
    //    7.7604810809
    //    7.3943696760
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7604810809,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3943696760,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    7.1663776510
    //    8.1829928045
    //    8.0707178183
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1829928045,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.0707178183,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    7.1663776510
    //    7.7604810809
    //    7.3943696760
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.7604810809,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3943696760,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    7.1663776510
    //    8.1829928045
    //    8.0707178183
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1829928045,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.0707178183,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    7.1663776510
    //    5.5422945323
    //    4.3061251574
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5422945323,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.3061251574,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    7.1663776510
    //    5.5422945323
    //    4.3061251574
    //    7.3206853908
    //    7.3206853908
    //    7.4129073811
    //    7.4642857143
    //    7.6250000000
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1663776510,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5422945323,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.3061251574,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3206853908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4129073811,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4642857143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6250000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    7.0331690488
    //    2.4027026598
    //    -0.2064777658
    //    7.2939365509
    //    7.2939365509
    //    7.4840209493
    //    6.8293650794
    //    10.0972222222
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0331690488,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.4027026598,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2064777658,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2939365509,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.2939365509,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4840209493,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8293650794,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(10.0972222222,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.7266315228
    //    2.5102852628
    //    -0.4704246654
    //    7.0176620007
    //    7.0176620007
    //    7.1951758339
    //    7.3214285714
    //    7.3750000000
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbOrder_abColumn() {
        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7266315228,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.5102852628,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4704246654,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0176620007,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0176620007,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1951758339,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3214285714,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbOrder, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.3750000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Row-based with Default Value
    //---------------------------------------------------------------------------
    //    FILENAME    BUG                LOC                N_COMM            HALVOL            SCPMN            N_VEXUSE
    //    module_1                    800.0000000000     0.3000000000     3600.0000000000    4.0000000000     0.6000000000
    //    module_2    2.0000000000     250.0000000000     0.0000000000     3200.0000000000 3.5000000000     0.4000000000
    //    module_3    5.0000000000     500.0000000000     0.0000000000     0.0000000000     3.0000000000     0.3000000000
    //    module_4    5.0000000000     700.0000000000     0.2500000000     3500.0000000000 0.0000000000     0.8000000000
    //    module_5    0.0000000000     600.0000000000     0.2000000000     3200.0000000000 2.5000000000     0.0000000000
    //    module_6    10.0000000000     900.0000000000     0.3500000000     3800.0000000000 4.1000000000     0.7500000000
    virtual void Test_TCFbEDataSetEx_GetAppliedValues_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(800.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetValue("module_1", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,    this->DataSet->GetPredictionTable()->GetValue("module_2", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,    this->DataSet->GetPredictionTable()->GetValue("module_3", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->GetPredictionTable()->GetValue("module_4", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5000000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_5", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3500000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1000000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,    this->DataSet->GetPredictionTable()->GetValue("module_6", "N_VEXUSE"), 1E-6);
    }

    //    Average of Column        3.6666666667    625.0000000000     0.1833333333     2883.3333333333     2.8500000000     0.4750000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(3.6666666667,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(625.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1833333333,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2883.3333333333,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.8500000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4750000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        3.5000000000    650.0000000000     0.2250000000     3350.0000000000     3.2500000000     0.5000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(650.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2250000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3350.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.2500000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    //    734.1500000000
    //    575.9833333333
    //    84.7166666667
    //    701.0083333333
    //    633.7833333333
    //    785.8666666667
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(734.1500000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(575.9833333333,    this->DataSet->GetPredictionTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(84.7166666667,    this->DataSet->GetPredictionTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(701.0083333333,    this->DataSet->GetPredictionTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(633.7833333333,    this->DataSet->GetPredictionTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(785.8666666667,    this->DataSet->GetPredictionTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    //    2.3000000000
    //    2.7500000000
    //    1.6500000000
    //    2.9000000000
    //    1.3500000000
    //    7.0500000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(2.3000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.7500000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6500000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3500000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0500000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //
    //    1.3935714286
    //    1.2333333333
    //    0.8242857143
    //    1.3895833333
    //    0.7448349872
    virtual void Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.3935714286,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.2333333333,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8242857143,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3895833333,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7448349872,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //
    //    1.1428571429
    //    1.4666666667
    //    1.0285714286
    //    1.4166666667
    //    0.8730158730
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.1428571429,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4666666667,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0285714286,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4166666667,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8730158730,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //
    //    0.9901175649
    //    0.2169221429
    //    0.9997721591
    //    0.9994448439
    //    0.9999002840
    virtual void Test_TCFbECosineSimilarity_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9901175649,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2169221429,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997721591,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994448439,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999002840,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    0.4455348639
    //    -0.9808083450
    //    0.9929463014
    //    0.9497516455
    //    0.9985833835
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.4455348639,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9808083450,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9929463014,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9497516455,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9985833835,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.7827156626
    //    -0.8795878211
    //    0.9756955866
    //    -0.9756061568
    //    0.9991412486
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.7827156626,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8795878211,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9756955866,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9756061568,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9991412486,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9892752555
    //    0.0183264173
    //    0.9997389845
    //    0.9993756170
    //    0.9998930931
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9892752555,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0183264173,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997389845,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9993756170,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9998930931,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.9900734509
    //    0.2132266756
    //    0.9997686502
    //    0.9994496009
    //    0.9999122075
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9900734509,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2132266756,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997686502,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994496009,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999122075,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    0.8285714286
    //    -0.0869656553
    //    0.4857142857
    //    0.8986451053
    //    0.6571428571
    virtual void Test_TCFbERankCorrelation_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8285714286,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.0869656553,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4857142857,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8986451053,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6571428571,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.0062959077
    //    0.0015358624
    //    0.0286738351
    //    0.0099634673
    //    0.0193361263
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0062959077,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0015358624,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0286738351,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0099634673,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0193361263,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.8000000000
    //    0.3333333333
    //    0.2222222222
    //    0.9523809524
    //    0.1970443350
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3333333333,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2222222222,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9523809524,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1970443350,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    4.2943498073
    //    2.5042430380
    //    1.9308496653
    //    4.2599132797
    //    4.2937641063
    //    3.4569423780
    //    5.4251270834
    //    2.5342393917
    virtual void Test_TCFbEWeightedSum_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2943498073,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.5042430380,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.9308496653,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2599132797,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2937641063,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.4569423780,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.4251270834,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.5342393917,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    4.2943498073
    //    4.1510408488
    //    6.1245921132
    //    4.2599132797
    //    4.2937641063
    //    3.6726135503
    //    5.4251270834
    //    2.5342393917
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2943498073,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.1510408488,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.1245921132,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2599132797,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2937641063,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.6726135503,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.4251270834,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.5342393917,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    4.2943498073
    //    4.0761864029
    //    5.9339674565
    //    4.2599132797
    //    4.2937641063
    //    3.6628103152
    //    5.4251270834
    //    2.5342393917
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2943498073,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.0761864029,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9339674565,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2599132797,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2937641063,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.6628103152,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.4251270834,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.5342393917,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    4.2943498073
    //    4.4804004110
    //    6.9633406028
    //    4.2599132797
    //    4.2937641063
    //    3.7157477848
    //    5.4251270834
    //    2.5342393917
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2943498073,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.4804004110,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9633406028,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2599132797,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2937641063,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.7157477848,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.4251270834,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.5342393917,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    4.2943498073
    //    4.7498764164
    //    7.6495893670
    //    4.2599132797
    //    4.2937641063
    //    3.7510394311
    //    5.4251270834
    //    2.5342393917
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2943498073,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.7498764164,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6495893670,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2599132797,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2937641063,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.7510394311,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.4251270834,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.5342393917,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    94.4511411738
    //    220.0613874370
    //    665.5170988436
    //    66.6812802563
    //    93.9576903820
    //    96.3105648765
    //    50.1562683545
    //    176.4967479497
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(94.4511411738,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(220.0613874370,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(665.5170988436,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(66.6812802563,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(93.9576903820,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(96.3105648765,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(50.1562683545,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(176.4967479497,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    3.1758773965
    //    2.3295319316
    //    3.1571711656
    //    3.0536088968
    //    3.1737211519
    //    2.5815779319
    //    3.8839045511
    //    2.4113381113
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.1758773965,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.3295319316,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.1571711656,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.0536088968,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.1737211519,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.5815779319,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.8839045511,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.4113381113,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    3.7243931598
    //    1.5394196088
    //    0.8362800805
    //    3.6035883340
    //    3.7222613688
    //    2.9318261977
    //    4.3950652560
    //    2.6622151715
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.7243931598,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.5394196088,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8362800805,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.6035883340,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.7222613688,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.9318261977,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.3950652560,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.6622151715,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    4.2140276384
    //    1.7515569909
    //    1.1925974429
    //    4.0598753241
    //    4.2113121422
    //    3.2096461971
    //    5.1960412412
    //    2.8487648348
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_DefaultValue() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2140276384,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.7515569909,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.1925974429,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.0598753241,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.2113121422,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.2096461971,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.1960412412,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, true, 0.0, false, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.8487648348,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Row-based with Case Amplification
    //---------------------------------------------------------------------------
    //    FILENAME    BUG                LOC                N_COMM            HALVOL            SCPMN            N_VEXUSE
    //    module_1                    800.0000000000     0.3000000000     3600.0000000000 4.0000000000     0.6000000000
    //    module_2    2.0000000000     250.0000000000                     3200.0000000000 3.5000000000     0.4000000000
    //    module_3    5.0000000000     500.0000000000     0.0000000000                     3.0000000000     0.3000000000
    //    module_4    5.0000000000     700.0000000000     0.2500000000     3500.0000000000                 0.8000000000
    //    module_5                    600.0000000000     0.2000000000     3200.0000000000 2.5000000000
    //    module_6    10.0000000000     900.0000000000     0.3500000000     3800.0000000000 4.1000000000     0.7500000000
    virtual void Test_TCFbEDataSetEx_GetAppliedValues_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(800.0000000000,    this->DataSet->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,        this->DataSet->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600.0000000000,    this->DataSet->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,        this->DataSet->GetValue("module_1", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,        this->DataSet->GetValue("module_1", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0000000000,        this->DataSet->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0000000000,    this->DataSet->GetValue("module_2", "LOC"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,        this->DataSet->GetValue("module_2", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4000000000,        this->DataSet->GetValue("module_2", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,        this->DataSet->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500.0000000000,    this->DataSet->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,        this->DataSet->GetValue("module_3", "N_COMM"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,        this->DataSet->GetValue("module_3", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3000000000,        this->DataSet->GetValue("module_3", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,        this->DataSet->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0000000000,    this->DataSet->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,        this->DataSet->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->GetValue("module_4", "HALVOL"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8000000000,        this->DataSet->GetValue("module_4", "N_VEXUSE"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(600.0000000000,    this->DataSet->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2000000000,        this->DataSet->GetValue("module_5", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0000000000,    this->DataSet->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5000000000,        this->DataSet->GetValue("module_5", "SCPMN"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(10.0000000000,    this->DataSet->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0000000000,    this->DataSet->GetValue("module_6", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3500000000,        this->DataSet->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0000000000,    this->DataSet->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1000000000,        this->DataSet->GetValue("module_6", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7500000000,        this->DataSet->GetValue("module_6", "N_VEXUSE"), 1E-6);
    }

    //    Average of Column        3.6666666667    625.0000000000     0.1833333333     2883.3333333333     2.8500000000     0.4750000000
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(625.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2200000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3460.0000000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.4200000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5700000000,    this->DataSet->GetPredictionTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        3.5000000000    650.0000000000     0.2250000000     3350.0000000000     3.2500000000     0.5000000000
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetPredictionTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(650.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2500000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6000000000,    this->DataSet->GetPredictionTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row
    virtual void Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(880.9800000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(691.1800000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(101.6600000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(841.2100000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(950.6750000000,    this->DataSet->GetPredictionTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(785.8666666667,    this->DataSet->GetPredictionTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        this->DataSet->GetPredictionTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetPredictionTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(4.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0000000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(301.2500000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0500000000,    this->DataSet->GetPredictionTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    virtual void Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.7419642857,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6444444444,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0303571429,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.3895833333,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8938019846,    this->DataSet->GetPredictionTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    virtual void Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.3214285714,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6000000000,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0857142857,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4166666667,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8888888889,    this->DataSet->GetPredictionTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //
    //    0.9754772089
    //    0.9999985462
    //    0.9994344163
    //    0.9986127205
    //    0.9997589234
    virtual void Test_TCFbECosineSimilarity_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9754772089,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999985462,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994344163,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9986127205,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997589234,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.9941371678
    //    -0.9999929327
    //    0.9579740344
    //    -0.4049574283
    //    0.9429358631
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9941371678,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999929327,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9579740344,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4049574283,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9429358631,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.9961455490
    //    -0.9999927779
    //    0.6314881696
    //    -0.3868577039
    //    0.9001548324
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9961455490,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999927779,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6314881696,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.3868577039,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9001548324,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9731790090
    //    0.0732097882
    //    0.9993284200
    //    0.9714167186
    //    0.9859851625
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9731790090,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0732097882,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9993284200,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9714167186,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9859851625,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.9754154161
    //    0.9999959067
    //    0.9994194322
    //    0.9583410280
    //    0.9997746496
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9754154161,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999959067,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9994194322,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9583410280,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9997746496,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    virtual void Test_TCFbERankCorrelation_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.0000011483
    //    0.0000202568
    //    0.0000563922
    //    0.0000036048
    //    0.0000357715
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000011483,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000202568,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000563922,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000036048,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000357715,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    0.0000017623
    //    2.9357333631
    //    0.0000562867
    //    0.0000098149
    //    114.7550621098
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000017623,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.9357333631,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000562867,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000098149,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(114.7550621098,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    5.5213925841
    //    1.8564609881
    //    1.4645845937
    //    5.6631220793
    //    5.5214673631
    //    5.5000000000
    //    6.5445496714
    //    9.8752752495
    virtual void Test_TCFbEWeightedSum_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5213925841,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.8564609881,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.4645845937,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6631220793,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5214673631,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5445496714,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.8752752495,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    5.5213925841
    //    7.4880927858
    //    7.6887576784
    //    5.6631220793
    //    5.5214673631
    //    5.5000000000
    //    6.5445496714
    //    9.8752752495
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5213925841,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4880927858,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6887576784,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6631220793,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5214673631,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5445496714,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.8752752495,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    5.5213925841
    //    6.9761262587
    //    7.1229237616
    //    5.6631220793
    //    5.5214673631
    //    5.5000000000
    //    6.5445496714
    //    9.8752752495
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5213925841,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9761262587,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1229237616,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6631220793,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5214673631,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5445496714,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.8752752495,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    5.5213925841
    //    7.4880927858
    //    7.6887576784
    //    5.6631220793
    //    5.5214673631
    //    5.5000000000
    //    6.5445496714
    //    9.8752752495
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5213925841,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.4880927858,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.6887576784,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6631220793,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5214673631,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5445496714,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.8752752495,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    5.5213925841
    //    6.9761262587
    //    7.1229237616
    //    5.6631220793
    //    5.5214673631
    //    5.5000000000
    //    6.5445496714
    //    9.8752752495
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5213925841,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9761262587,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.1229237616,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6631220793,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5214673631,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5000000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5445496714,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.8752752495,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    282.0984674341
    //    688.2063179686
    //    755.3276653221
    //    129.4506208869
    //    282.0997322253
    //    281.5008333333
    //    197.1741412501
    //    122.0557410763
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(282.0984674341,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(688.2063179686,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(755.3276653221,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(129.4506208869,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(282.0997322253,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(281.5008333333,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(197.1741412501,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(122.0557410763,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    4.8770717813
    //    4.5835320519
    //    4.6093601963
    //    4.5262084112
    //    4.8771195001
    //    4.8625000000
    //    5.2707469092
    //    6.9263012970
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8770717813,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.5835320519,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.6093601963,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.5262084112,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8771195001,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8625000000,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.2707469092,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9263012970,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.4673157995
    //    0.4306988908
    //    -0.1116195296
    //    5.9219250052
    //    6.4673757518
    //    6.4489890886
    //    6.8751593146
    //    8.9201627774
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4673157995,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.4306988908,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1116195296,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9219250052,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4673757518,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4489890886,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8751593146,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.9201627774,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.2622275686
    //    0.7585998125
    //    0.2258763358
    //    5.7218313319
    //    6.2622962203
    //    6.2400793651
    //    6.9489803997
    //    8.8667142979
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_CaseAmplification() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2622275686,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.7585998125,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.2258763358,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.7218313319,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2622962203,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2400793651,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9489803997,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, false, 2.5, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.8667142979,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Row-based with Inverse Case Frequency
    //---------------------------------------------------------------------------
    //    ICF Coefficient        0.4054651081     0.0000000000     0.1823215568     0.1823215568     0.1823215568     0.1823215568
    virtual void Test_TCFbEDataSetEx_GetICFCoefficient_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.4054651081,    this->DataSet->GetICFCoefficient(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetICFCoefficient(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(5), 1E-6);
    }

    //    FILENAME    BUG                LOC                N_COMM            HALVOL            SCPMN            N_VEXUSE
    //    module_1                    0.0000000000     0.0546964670     656.3576044582     0.7292862272     0.1093929341
    //    module_2    0.8109302162     0.0000000000                     583.4289817407     0.6381254488     0.0729286227
    //    module_3    2.0273255405     0.0000000000     0.0000000000                     0.5469646704     0.0546964670
    //    module_4    2.0273255405     0.0000000000     0.0455803892     638.1254487788                     0.1458572454
    //    module_5                    0.0000000000     0.0364643114     583.4289817407     0.4558038920
    //    module_6    4.0546510811     0.0000000000     0.0638125449     692.8219158170     0.7475183829     0.1367411676
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableValues_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_1", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0546964670,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_1", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(656.3576044582,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_1", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7292862272,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_1", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1093929341,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_1", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8109302162,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_2", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_2", "LOC"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(583.4289817407,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_2", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6381254488,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_2", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0729286227,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_2", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0273255405,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_3", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_3", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_3", "N_COMM"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.5469646704,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_3", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0546964670,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_3", "N_VEXUSE"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0273255405,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_4", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_4", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0455803892,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_4", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(638.1254487788,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_4", "HALVOL"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1458572454,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_4", "N_VEXUSE"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_5", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0364643114,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_5", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(583.4289817407,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_5", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4558038920,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_5", "SCPMN"), 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(4.0546510811,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_6", "BUG"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_6", "LOC"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0638125449,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_6", "N_COMM"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(692.8219158170,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_6", "HALVOL"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7475183829,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_6", "SCPMN"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1367411676,    this->DataSet->GetSimilarityComputationTable()->GetValue("module_6", "N_VEXUSE"), 1E-6);
    }

    //    Average of Column        2.2300580946     0.0000000000     0.0401107425     630.8325865071     0.6235397242     0.1039232874 
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableAverageOfColumn_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        this->DataSet->GetSimilarityComputationTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetSimilarityComputationTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(2.2300580946,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0401107425,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(630.8325865071,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6235397242,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1039232874,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        2.0273255405     0.0000000000     0.0455803892     638.1254487788     0.6381254488     0.1093929341 
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfColumn_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        this->DataSet->GetSimilarityComputationTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetSimilarityComputationTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(2.0273255405,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0455803892,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(638.1254487788,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6381254488,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1093929341,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row            131.4501960173        116.9901932057        0.5257973356        128.0688423908        145.9803124860        116.3041064989        
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableAverageOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        this->DataSet->GetSimilarityComputationTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetSimilarityComputationTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(131.4501960173,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(116.9901932057,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5257973356,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(128.0688423908,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(145.9803124860,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(116.3041064989,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row            0.1093929341        0.6381254488        0.0546964670        0.1458572454        0.2461341017        0.4421297752        
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        this->DataSet->GetSimilarityComputationTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetSimilarityComputationTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.1093929341,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6381254488,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0546964670,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1458572454,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2461341017,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4421297752,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(5), 1E-6);
    }

    //    Averaged Multiplier
    //    1.2559523810
    //    1.6666666667
    //    0.9928571429
    //    1.4083333333
    //    0.8950302586
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableAveragedMultiplierOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.2559523810,    this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6666666667,    this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9928571429,    this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.4083333333,    this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8950302586,    this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //    Median of Multiplier
    //    1.1428571429
    //    1.6666666667
    //    1.0285714286
    //    1.5000000000
    //    0.9022556391
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfMultiplierOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.1428571429,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6666666667,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0285714286,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.5000000000,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9022556391,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //
    //    0.9999999990
    //    0.9960528800
    //    0.9999999980
    //    0.9999999454
    //    0.9999999990
    virtual void Test_TCFbECosineSimilarity_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999999990,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9960528800,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999999980,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999999454,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999999990,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //    -0.9999899998
    //    -0.8418935262
    //    0.9999846624
    //    -0.9999996951
    //    0.9999976366
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999899998,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8418935262,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999846624,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999996951,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999976366,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //    -0.9999872780
    //    -0.8234091224
    //    0.0000000000
    //    -0.9999985556
    //    0.9999953612
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999872780,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.8234091224,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9999985556,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999953612,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //    0.9999998165
    //    0.8538086960
    //    0.9999995614
    //    0.9933871162
    //    0.9967326199
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999998165,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8538086960,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999995614,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9933871162,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9967326199,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //    0.9999986528
    //    0.9977000728
    //    0.9999999954
    //    0.9999997581
    //    0.9999995574
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999986528,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9977000728,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999999954,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999997581,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999995574,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //    1.0000000000
    //    0.9486832981
    //    1.0000000000
    //    1.0000000000
    //    1.0000000000
    virtual void Test_TCFbERankCorrelation_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //    0.0547523329
    //    13.7120373694
    //    0.2188454842
    //    0.0546296310
    //    0.1369150012
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0547523329,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(13.7120373694,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2188454842,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0546296310,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1369150012,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //    15.6708998507
    //    18.2827164925
    //    43.8785195820
    //    6.8560186847
    //    54.8481494775
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(15.6708998507,    this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(18.2827164925,    this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(43.8785195820,    this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.8560186847,    this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(54.8481494775,    this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //    5.5004938773
    //    2.2880684666
    //    1.3752726409
    //    5.5151649619
    //    5.5002883383
    //    5.5064979511
    //    5.0368430631
    //    6.7125984252
    virtual void Test_TCFbEWeightedSum_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5004938773,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.2880684666,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.3752726409,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5151649619,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5002883383,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5064979511,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0368430631,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7125984252,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //    5.5004938773
    //    7.5617348853
    //    8.4792674449
    //    5.5151649619
    //    5.5002883383
    //    5.5064979511
    //    5.0368430631
    //    6.7125984252
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5004938773,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.5617348853,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.4792674449,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5151649619,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5002883383,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5064979511,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0368430631,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7125984252,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //    5.5004938773
    //    7.0823106654
    //    7.8334497355
    //    5.5151649619
    //    5.5002883383
    //    5.5064979511
    //    5.0368430631
    //    6.7125984252
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5004938773,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0823106654,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8334497355,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5151649619,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5002883383,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5064979511,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0368430631,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7125984252,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //    5.5004938773
    //    7.5617348853
    //    8.4792674449
    //    5.5151649619
    //    5.5002883383
    //    5.5064979511
    //    5.0368430631
    //    6.7125984252
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5004938773,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.5617348853,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.4792674449,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5151649619,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5002883383,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5064979511,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0368430631,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7125984252,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //    5.5004938773
    //    7.0823106654
    //    7.8334497355
    //    5.5151649619
    //    5.5002883383
    //    5.5064979511
    //    5.0368430631
    //    6.7125984252
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5004938773,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.0823106654,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.8334497355,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5151649619,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5002883383,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5064979511,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0368430631,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.7125984252,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //    281.0041715277
    //    661.9428161121
    //    878.4649010807
    //    262.5602870122
    //    281.2116050340
    //    274.9662446204
    //    763.9778799236
    //    188.9873228346
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(281.0041715277,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(661.9428161121,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(878.4649010807,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(262.5602870122,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(281.2116050340,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(274.9662446204,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(763.9778799236,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(188.9873228346,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //    4.8613764295
    //    4.7200123849
    //    4.9928303347
    //    4.8175420405
    //    4.8618461477
    //    4.8477171613
    //    5.9646483903
    //    5.3179133858
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8613764295,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.7200123849,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.9928303347,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8175420405,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8618461477,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8477171613,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.9646483903,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.3179133858,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //    6.4472375700
    //    0.9587987182
    //    -0.4661622472
    //    6.3795539671
    //    6.4479696499
    //    6.4259443242
    //    8.1632116079
    //    6.9430618850
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4472375700,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9587987182,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.4661622472,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3795539671,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4479696499,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4259443242,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(8.1632116079,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.9430618850,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //    6.2383409959
    //    1.2856714287
    //    -0.1208648580
    //    6.1710140661
    //    6.2390677801
    //    6.2172076086
    //    7.9480009370
    //    6.8843269591
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2383409959,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1.2856714287,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-0.1208648580,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.1710140661,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2390677801,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2172076086,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(7.9480009370,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abRow, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.8843269591,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //---------------------------------------------------------------------------
    // Value-based & Column-based with Inverse Case Frequency
    //---------------------------------------------------------------------------
    //    ICF Coefficient        0.1823215568 	0.1823215568 	0.1823215568 	0.1823215568 	0.4054651081 	0.0000000000 
    virtual void Test_TCFbEDataSetEx_GetICFCoefficient_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1823215568,    this->DataSet->GetICFCoefficient(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4054651081,    this->DataSet->GetICFCoefficient(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetICFCoefficient(5), 1E-6);
    }

    //  FILENAME	module_1    	module_2	    module_3	    module_4	    module_5	    module_6
    //  BUG			                0.3646431136 	0.9116077840 	0.9116077840 		            0.0000000000
    //  LOC		    145.8572454352 	45.5803891985 	91.1607783970 	127.6250897558 	243.2790648649 	0.0000000000
    //  N_COMM		0.0546964670 	            	0.0000000000 	0.0455803892 	0.0810930216 	0.0000000000
    //  HALVOL		656.3576044582 	583.4289817407 	        	    638.1254487788 	1297.4883459461 0.0000000000
    //  SCPMN		0.7292862272 	0.6381254488 	0.5469646704 		            1.0136627703 	0.0000000000
    //  N_VEXUSE    0.1093929341 	0.0729286227 	0.0546964670 	0.1458572454 		            0.0000000000
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableValues_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);

        TEST_ASSERT_EQUALS_DOUBLE(0.3646431136,    this->DataSet->GetSimilarityComputationTable()->GetValue("BUG", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9116077840,    this->DataSet->GetSimilarityComputationTable()->GetValue("BUG", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9116077840,    this->DataSet->GetSimilarityComputationTable()->GetValue("BUG", "module_4"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("BUG", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(145.8572454352,    this->DataSet->GetSimilarityComputationTable()->GetValue("LOC", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(45.5803891985,    this->DataSet->GetSimilarityComputationTable()->GetValue("LOC", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(91.1607783970,    this->DataSet->GetSimilarityComputationTable()->GetValue("LOC", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(127.6250897558,    this->DataSet->GetSimilarityComputationTable()->GetValue("LOC", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(243.2790648649,    this->DataSet->GetSimilarityComputationTable()->GetValue("LOC", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("LOC", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0546964670,    this->DataSet->GetSimilarityComputationTable()->GetValue("N_COMM", "module_1"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("N_COMM", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0455803892,    this->DataSet->GetSimilarityComputationTable()->GetValue("N_COMM", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0810930216,    this->DataSet->GetSimilarityComputationTable()->GetValue("N_COMM", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("N_COMM", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(656.3576044582,    this->DataSet->GetSimilarityComputationTable()->GetValue("HALVOL", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(583.4289817407,    this->DataSet->GetSimilarityComputationTable()->GetValue("HALVOL", "module_2"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(638.1254487788,    this->DataSet->GetSimilarityComputationTable()->GetValue("HALVOL", "module_4"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1297.4883459461,    this->DataSet->GetSimilarityComputationTable()->GetValue("HALVOL", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("HALVOL", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.7292862272,    this->DataSet->GetSimilarityComputationTable()->GetValue("SCPMN", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6381254488,    this->DataSet->GetSimilarityComputationTable()->GetValue("SCPMN", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5469646704,    this->DataSet->GetSimilarityComputationTable()->GetValue("SCPMN", "module_3"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0136627703,    this->DataSet->GetSimilarityComputationTable()->GetValue("SCPMN", "module_5"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("SCPMN", "module_6"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.1093929341,    this->DataSet->GetSimilarityComputationTable()->GetValue("N_VEXUSE", "module_1"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0729286227,    this->DataSet->GetSimilarityComputationTable()->GetValue("N_VEXUSE", "module_2"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0546964670,    this->DataSet->GetSimilarityComputationTable()->GetValue("N_VEXUSE", "module_3"), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1458572454,    this->DataSet->GetSimilarityComputationTable()->GetValue("N_VEXUSE", "module_4"), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetValue("N_VEXUSE", "module_6"), 1E-6);
    }

    //    Average of Column        160.6216451043 	126.0170136248 	18.5348094637 	153.3707167906 	385.4655416507 	0.0000000000
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableAverageOfColumn_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        this->DataSet->GetSimilarityComputationTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetSimilarityComputationTable()), "Average.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(160.6216451043,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(126.0170136248,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(18.5348094637,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(153.3707167906,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(385.4655416507,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfColumn(5), 1E-6);
    }

    //    Median of Column        0.7292862272 	0.6381254488 	0.5469646704 	0.9116077840 	122.1463638176 	0.0000000000
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfColumn_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        this->DataSet->GetSimilarityComputationTable()->AddChildCache(new TCFbEColumnCachedTable(this->DataSet->GetSimilarityComputationTable()), "Median.column", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.7292862272,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6381254488,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5469646704,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9116077840,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(122.1463638176,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfColumn(5), 1E-6);
    }

    //    Average of Row            0.5469646704    108.9170946085  0.0362739756    635.0800761848  0.5856078233    0.0765750539
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableAverageOfRow_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        this->DataSet->GetSimilarityComputationTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetSimilarityComputationTable()), "Average.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.5469646704,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(108.9170946085,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0362739756,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(635.0800761848,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5856078233,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0765750539,    this->DataSet->GetSimilarityComputationTable()->GetAverageOfRow(5), 1E-6);
    }

    //    Median of Row            0.6381254488 109.3929340764  0.0455803892    638.1254487788  0.6381254488    0.0729286227
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfRow_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        this->DataSet->GetSimilarityComputationTable()->AddChildCache(new TCFbERowCachedTable(this->DataSet->GetSimilarityComputationTable()), "Median.row", true);

        TEST_ASSERT_EQUALS_DOUBLE(0.6381254488,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(109.3929340764,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0455803892,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(638.1254487788,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6381254488,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0729286227,    this->DataSet->GetSimilarityComputationTable()->GetMedianOfRow(5), 1E-6);
    }

    //  Averaged Multiplier
    //  0.0083809524
    //  20.0000000000
    //  0.0010267857
    //  1.1190476190
    //  9.3055555556
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableAveragedMultiplierOfRow_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0083809524, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(20.0000000000, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0010267857, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1190476190, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(9.3055555556, this->DataSet->GetSimilarityComputationTable()->GetAveragedMultiplierOfRow(0, 5), 1E-6);
    }

    //  Median of Multiplier
    virtual void Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfMultiplierOfRow_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, NULL, NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0080000000, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(20.0000000000, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0010267857, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1190476190, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 4), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(6.2500000000, this->DataSet->GetSimilarityComputationTable()->GetMedianOfMultiplierOfRow(0, 5), 1E-6);
    }

    //---------------------------------------------------------------------------
    //    Cosine Similarity
    //
    //  0.9874018946
    //  0.7071067812
    //  0.9358455385
    //  0.8862254440
    //  0.9087588771
    virtual void Test_TCFbECosineSimilarity_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9874018946, this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7071067812, this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9358455385, this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8862254440, this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9087588771, this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Average
    //
    //  0.5771848745
    //  0.9999863774
    //  -0.9977510741
    //  0.9999950361
    //  0.9999913801
    virtual void Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.5771848745, this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999863774, this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.9977510741, this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999950361, this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.9999913801, this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Adjusted Cosine Similarity with Median
    //
    //  0.2807929773
    //  -0.5339929914
    //  -0.6748924069
    //  0.0000000000
    //  -0.0510458086
    virtual void Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.2807929773, this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.5339929914, this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.6748924069, this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0000000000, this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.0510458086, this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Average
    //
    //  0.7184156575
    //  0.2553299822
    //  0.8233552487
    //  0.7379831559
    //  0.7323611138
    virtual void Test_TCFbECorrelationCoefficientWithAverage_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.7184156575, this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2553299822, this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8233552487, this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7379831559, this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7323611138, this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Correlation Coefficient with Median
    //
    //  0.8495412560
    //  0.3455473702
    //  0.8833620455
    //  0.7947589515
    //  0.7388188340
    virtual void Test_TCFbECorrelationCoefficientWithMedian_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.8495412560, this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3455473702, this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8833620455, this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7947589515, this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.7388188340, this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Rank Correlation
    //
    //  0.9486832981
    //  0.5000000000
    //  1.0000000000
    //  0.5000000000
    //  0.6324555320
    virtual void Test_TCFbERankCorrelation_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.9486832981, this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000, this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0000000000, this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.5000000000, this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6324555320, this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Average
    //
    //  0.0152567871
    //  1.6876353685
    //  0.0024584558
    //  4.7012699552
    //  2.0894533134
    virtual void Test_TCFbEDistanceSimilarityWithAverage_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0152567871, this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.6876353685, this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0024584558, this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.7012699552, this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0894533134, this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Distance Similarity with Median
    //
    //  0.0147639702
    //  1.1546978837
    //  0.0017150766
    //  3.6565432985
    //  1.8913154992
    virtual void Test_TCFbEDistanceSimilarityWithMedian_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), NULL, 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(0.0147639702, this->DataSet->GetSimilarity("module_1", "module_2", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.1546978837, this->DataSet->GetSimilarity("module_1", "module_3", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0017150766, this->DataSet->GetSimilarity("module_1", "module_4", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.6565432985, this->DataSet->GetSimilarity("module_1", "module_5", -1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8913154992, this->DataSet->GetSimilarity("module_1", "module_6", -1), 1E-6);
    }

    //    Simple Weighted Sum
    //  940.7794929880
    //  -683.1296911591
    //  -1431.2549455240
    //  1084.1128766143
    //  1069.6101665491
    //  1217.9019911543
    //  4.8988407620
    //  5.0740649664
    virtual void Test_TCFbEWeightedSum_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(940.7794929880,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-683.1296911591,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-1431.2549455240,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1084.1128766143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1069.6101665491,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1217.9019911543,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8988407620,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEWeightedSum(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0740649664,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Column
    //  940.7794929880
    //  -298.8602813157
    //  9.5924248921
    //  1084.1128766143
    //  1069.6101665491
    //  1217.9019911543
    //  4.8988407620
    //  5.0740649664
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(940.7794929880,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-298.8602813157,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.5924248921,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1084.1128766143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1069.6101665491,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1217.9019911543,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8988407620,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0740649664,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Column
    //  940.7794929880
    //  -681.3849550250
    //  -1424.7129247271
    //  1084.1128766143
    //  1069.6101665491
    //  1217.9019911543
    //  4.8988407620
    //  5.0740649664
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(940.7794929880,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-681.3849550250,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-1424.7129247271,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1084.1128766143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1069.6101665491,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1217.9019911543,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8988407620,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfColumn(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0740649664,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Neighbors
    //  940.7794929880
    //  -298.8602813157
    //  9.5924248921
    //  1084.1128766143
    //  1069.6101665491
    //  1217.9019911543
    //  4.8988407620
    //  5.0740649664
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(940.7794929880,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-298.8602813157,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(9.5924248921,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1084.1128766143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1069.6101665491,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1217.9019911543,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8988407620,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0740649664,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Neighbors
    //  940.7794929880
    //  -681.3849550250
    //  -1424.7129247271
    //  1084.1128766143
    //  1069.6101665491
    //  1217.9019911543
    //  4.8988407620
    //  5.0740649664
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(940.7794929880,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-681.3849550250,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-1424.7129247271,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1084.1128766143,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1069.6101665491,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(1217.9019911543,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.8988407620,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfNeighbors(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.0740649664,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Average of Row
    //  74.2883077385
    //  -2.8035102339
    //  -23.9604428345
    //  79.3996037139
    //  81.0395971925
    //  91.0505930826
    //  6.1989760962
    //  6.2581022235
    virtual void Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(74.2883077385,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-2.8035102339,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-23.9604428345,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(79.3996037139,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(81.0395971925,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(91.0505930826,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.1989760962,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithAverageOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2581022235,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Adjusted Weighted Sum with Median of Row
    //  59.7242440709
    //  2.2354903435
    //  -11.4838028803
    //  63.2961985140
    //  64.8505942982
    //  72.7375288190
    //  5.5849031515
    //  5.6358218520
    virtual void Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(59.7242440709,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(2.2354903435,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-11.4838028803,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(63.2961985140,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(64.8505942982,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(72.7375288190,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.5849031515,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAdjustedWeightedSumWithMedianOfRow(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(5.6358218520,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Averaged Multiplier
    //  6.4904202029
    //  3.9967359173
    //  -3.8714010773
    //  6.3756423829
    //  6.4150972173
    //  6.4714449465
    //  6.4343174593
    //  6.4049062209
    virtual void Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4904202029,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(3.9967359173,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-3.8714010773,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3756423829,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4150972173,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4714449465,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4343174593,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithAveragedMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.4049062209,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

    //    Amplified Weighted Sum with Median of Multiplier
    //  6.3997633930
    //  4.1206587690
    //  -3.6603438490
    //  6.2708815949
    //  6.3167317728
    //  6.3290603049
    //  6.5954534031
    //  6.5509926585
    virtual void Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abColumn_InverseCaseFrequency() {
        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECosineSimilarity(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3997633930,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(4.1206587690,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEAdjustedCosineSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(-3.6603438490,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.2708815949,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbECorrelationCoefficientWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3167317728,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbERankCorrelation(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.3290603049,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithAverage(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5954534031,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);

        this->DataSet->PrepareCF(vbValue, abColumn, new TCFbEDistanceSimilarityWithMedian(), new TCFbEAmplifiedWeightedSumWithMedianOfMultiplier(), 0, false, 0.0, true, 1.0, NULL, NULL);
        TEST_ASSERT_EQUALS_DOUBLE(6.5509926585,    this->DataSet->GetPredictedValue("module_1", "BUG"), 1E-6);
    }

protected:
    TCFbEDataSetEx* DataSet;

};

//---------------------------------------------------------------------------
#endif
