/*
    TCFbEDistanceSimilarityWithMedian.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEDistanceSimilarityWithMedian.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEDistanceSimilarityWithMedian::TCFbEDistanceSimilarityWithMedian(void)
    : TCFbESimilarityComputationAlgorithm()
{
}

//---------------------------------------------------------------------------
// fXgN^
__fastcall TCFbEDistanceSimilarityWithMedian::~TCFbEDistanceSimilarityWithMedian()
{
}

//---------------------------------------------------------------------------
// TargetRowIndex  AnotherRowIndex ̗ގxvZ
double __fastcall TCFbEDistanceSimilarityWithMedian::ComputeSimilarity(TCFbECustomTableEx* SimilarityComputationTable, int TargetRowIndex, int ComparedRowIndex)
{
    this->SimilarityComputationTable = SimilarityComputationTable;

    TDoubleDynArray Distances;

    for (int j = 0; j < SimilarityComputationTable->GetNumberOfColumns(); j++) {
        if (SimilarityComputationTable->GetCellByIndex(TargetRowIndex, j)->GetEnabled() && SimilarityComputationTable->GetCellByIndex(ComparedRowIndex, j)->GetEnabled()) {
            Distances.Length++;
            Distances[Distances.High] = fabs(SimilarityComputationTable->GetCellByIndex(TargetRowIndex, j)->GetValue() - SimilarityComputationTable->GetCellByIndex(ComparedRowIndex, j)->GetValue());
        }
    }

    if (Distances.Length == 0) {
        return 0.0;
    }

    TCFbEToolkit::GetToolkit()->SortDoubleDynArray(Distances, sdDescending);
    double MedianOfDistance = TCFbEToolkit::GetToolkit()->GetMedianOfDynArray(Distances);
    Distances.Length = 0;

    if (TCFbEToolkit::GetToolkit()->Equals(MedianOfDistance, 0.0)) {
//    if (MedianOfDistance == 0.0) {
        return 0.0;
    }

    return 1 / MedianOfDistance;
}

//---------------------------------------------------------------------------

