/*
    TCFbECustomCommandLineParser.h    January 13, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbECustomCommandLineParserH
#define TCFbECustomCommandLineParserH
//---------------------------------------------------------------------------
#include <system.hpp>
#include <Classes.hpp>

#include "TCFbETypes.h"
#include "EDocfbeError.h"

#include "TCFbESimilarityComputationAlgorithm.h"
#include "TCFbEPredictionAlgorithm.h"

#include "TCFbECosineSimilarity.h"
#include "TCFbEAdjustedCosineSimilarityWithAverage.h"
#include "TCFbEAdjustedCosineSimilarityWithMedian.h"
#include "TCFbECorrelationCoefficientWithAverage.h"
#include "TCFbECorrelationCoefficientWithMedian.h"
#include "TCFbERankCorrelation.h"
#include "TCFbEDistanceSimilarityWithAverage.h"
#include "TCFbEDistanceSimilarityWithMedian.h"

#include "TCFbEWeightedSum.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfColumn.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfColumn.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfNeighbors.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfNeighbors.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfRow.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfRow.h"
#include "TCFbEAmplifiedWeightedSumWithAveragedMultiplier.h"
#include "TCFbEAmplifiedWeightedSumWithMedianOfMultiplier.h"
#include "TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier.h"
//---------------------------------------------------------------------------
class TCFbECustomCommandLineParser : public TObject
{
public:
    virtual __fastcall TCFbECustomCommandLineParser(int argc=0, char* argv[]=NULL);    // RXgN^
    __fastcall ~TCFbECustomCommandLineParser();    // fXgN^

    virtual TCFbESimilarityComputationAlgorithm* __fastcall CreateSimilarityComputationAlgorithm(AnsiString AlgorithmName);
    virtual TCFbEPredictionAlgorithm* __fastcall CreatePredictionAlgorithm(AnsiString AlgorithmName);
    virtual AnsiString __fastcall GetHelpString(void) = 0;  // wvԂ

    int             ErrorCode;      // G[R[hiG[Ȃꍇ 0
    AnsiString      ErrorParameter; // G[p[^

    bool            HelpEnabled;    // wv

    TStringList*    LearningDataFileNameList;
    AnsiString      SimilarityComputationName;
    TCFbEValueBase  ValueBase;
    TCFbEAlgorithmBase  AlgorithmBase;
    TStringList*    TargetColumnLabelList;
    bool            DefaultValueEnabled;
    double          DefaultValue;
    bool            InverseCaseFrequencyEnabled;
    AnsiString      VWSimilarityComputationName;
    TFileName       OutputFileName;

protected:
    TStringList*    FOptionList;

    virtual bool __fastcall IsEmpty(void);    // IvVȂ
    virtual bool __fastcall IsEnableOption(AnsiString OptionLabel0, AnsiString OptionLabel1);    // OptionLabel0, OptionLabel1 ̂ǂ炩 OptionList Ɋ܂܂ĂΕԂ
    virtual bool __fastcall IsEnableValue(AnsiString OptionLabel0, AnsiString OptionLabel1);    // OptionLabel0, OptionLabel1 ̂ǂ炩 OptionLabel= Ƃ`Ŋ֘Atꂽ񂪂 true Ԃ
    virtual AnsiString __fastcall GetValueString(AnsiString OptionLabel0, AnsiString OptionLabel1);    // OptionLabel0, OptionLabel1 ̂ǂ炩 OptionLabel= Ƃ`Ŋ֘Atꂽ OptionList ɂΕԂ

private:

};
//---------------------------------------------------------------------------
#endif
