/*     
    docfbe_test.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.
                                  
    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop
#pragma argsused       
//---------------------------------------------------------------------------
// for Leak Check
#include <cppunit/cudebug.h>

#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>

USING_NAMESPACE_CPPUNIT           
//---------------------------------------------------------------------------
#include "TCFbETestCase0.cpp"
#include "TCFbETestCase2.cpp"
#include "TCFbETestCase4.cpp"
#include "TCFbETestCase6.cpp"

#include "TCFbEToolkit.h"
//---------------------------------------------------------------------------
// #define ENABLE_LEAK_CHECKER
#if defined(ENABLE_LEAK_CHECKER) && defined(_MSC_VER)
#  pragma warning(disable:4073)
#  pragma init_seg(lib)
LeakChecker g_leakChecker;
#endif

class TCFbETestSuite : public TestSuite
{
public:
    Test* GetTestCase0() {
        TestSuite* TestCase0 = new TestSuite("TCFbETestCase0");
//        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_DB));
      
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataLoader));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataLoader_AdoptData_tmbLearningData));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataLoader_AdoptData_tmbEstimatingData));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataLoader_AdoptData_tmbBoth));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataLoader_Merge));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEOutputCash_Jacknifing1));

        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbEDataSetEx));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbECommandLineParser));

        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_Assign));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_RotatedAssign));

        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetMaxOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetMinOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetAverageOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetMedianOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetStdevOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetAveragedMultiplierOfRow));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetMedianOfMultiplierOfRow));

        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetMaxOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetMinOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetAverageOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetMedianOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetStdevOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetAveragedMultiplierOfColumn));
        TestCase0->addTest(new TEST_CASE(TCFbETestCase0, Test_TCFbETableEx_GetMedianOfMultiplierOfColumn));
        return TestCase0;
    }

    Test* GetTestCase2() {
        TestSuite* TestCase2 = new TestSuite("TCFbETestCase2");
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetRowLabelList));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetColumnLabelList));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetValues));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedValues_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedValues_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbStandardizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedValues_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbStandardizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedValues_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbNormalizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedValues_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbNormalizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedValues_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbOrder_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedValues_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbOrder_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbStandardizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbStandardizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbStandardizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbStandardizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbNormalizedValue_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbNormalizedValue_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbOrder_abRow));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbOrder_abRow));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbOrder_abColumn));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbOrder_abColumn));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedValues_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_DefaultValue));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_DefaultValue));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedValues_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfColumn_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfColumn_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAverageOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedAveragedMultiplierOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetAppliedMedianOfMultiplierOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_CaseAmplification));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_CaseAmplification));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetICFCoefficient_vbValue_abRow_InverseCaseFrequency));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableValues_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableAverageOfColumn_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfColumn_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableAverageOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableAveragedMultiplierOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfMultiplierOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abRow_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abRow_InverseCaseFrequency));

        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableValues_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableAverageOfColumn_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfColumn_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableAverageOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableAveragedMultiplierOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDataSetEx_GetSimilarityComputationTableMedianOfMultiplierOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECosineSimilarity_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedCosineSimilarityWithMedian_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithAverage_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbECorrelationCoefficientWithMedian_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbERankCorrelation_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithAverage_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEDistanceSimilarityWithMedian_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEWeightedSum_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfColumn_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfColumn_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfNeighbors_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfNeighbors_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithAverageOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAdjustedWeightedSumWithMedianOfRow_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithAveragedMultiplier_vbValue_abColumn_InverseCaseFrequency));
        TestCase2->addTest(new TEST_CASE(TCFbETestCase2, Test_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbValue_abColumn_InverseCaseFrequency));

        return TestCase2;
    }

    Test* GetTestCase4() {
        TestSuite* TestCase4 = new TestSuite("TCFbETestCase4");

        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEDataSetEx_TemporallyUnable_vbNormalizedValue));

        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETableEx_CopyRowFrom));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETableEx_CopyRowAsColumnFrom));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETableEx_CopyColumnFrom));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETableEx_CopyColumnAsRowFrom));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETableEx_PartialNormalize));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETableEx_PartialStandardize));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETableEx_PartialOrdering));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbETableEx_PartialRowNormalizeOnColumn));

        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbECosineSimilarity_vbValue_abRow));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbValue_abRow));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEAdjustedCosineSimilarityWithAverage_vbNormalizedValue_abRow));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEWeightedSum_vbNormalizedValue_abRow));
        TestCase4->addTest(new TEST_CASE(TCFbETestCase4, Test_TCFbEOutputCash_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow));
        return TestCase4;
    }

    Test* GetTestCase6() {
        TestSuite* TestCase6 = new TestSuite("TCFbETestCase6");
        TestCase6->addTest(new TEST_CASE(TCFbETestCase6, Test_TCFbETableEx_Constructor));
        TestCase6->addTest(new TEST_CASE(TCFbETestCase6, Test_TCFbETableEx_GetStatistics));
        TestCase6->addTest(new TEST_CASE(TCFbETestCase6, Test_TCFbETableEx_ValuesUpdate));
        TestCase6->addTest(new TEST_CASE(TCFbETestCase6, Test_TCFbETableEx_GetUpdatedStatistics));
        TestCase6->addTest(new TEST_CASE(TCFbETestCase6, Test_TCFbETableEx_RotatedAssign_Values));
        TestCase6->addTest(new TEST_CASE(TCFbETestCase6, Test_TCFbETableEx_GetRotatedAssign_Statistics));
        TestCase6->addTest(new TEST_CASE(TCFbETestCase6, Test_TCFbETableEx_GetRotatedAssign_UpdatedValues));
        TestCase6->addTest(new TEST_CASE(TCFbETestCase6, Test_TCFbETableEx_GetRotatedAssign_UpdatedStatistics));
        return TestCase6;
    }
};

//---------------------------------------------------------------------------
int main(int argc, char* argv[])
{
#if defined(ENABLE_LEAK_CHECKER) && !defined(_MSC_VER)
    LeakChecker checker;
#endif

    TestRunner    testRunner;
    TCFbETestSuite    testSuite;
    testRunner.addTest("TCFbETestCase0", testSuite.GetTestCase0());
    testRunner.addTest("TCFbETestCase2", testSuite.GetTestCase2());
    testRunner.addTest("TCFbETestCase4", testSuite.GetTestCase4());
    testRunner.addTest("TCFbETestCase6", testSuite.GetTestCase6());
    int ReturnValue = testRunner.run(argc, argv);
    TCFbEToolkit::DeleteToolkit();
    return ReturnValue;
}

// ȉ̋Lq̓fobOpȂ̂ŖĂB
#ifdef USE_DEBUGTOOLS
#  include <debug/debugtools.cpp>
#endif

#if defined(ENABLE_LEAK_CHECKER) && defined(_MSC_VER)
#  pragma warning(disable:4073)
#  pragma init_seg(lib)
LeakChecker g_leakChecker;
#endif

//---------------------------------------------------------------------------
