/*
    TCFbERowCachedTable.h    November 28, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbERowCachedTableH
#define TCFbERowCachedTableH
//---------------------------------------------------------------------------
// #include "Maprof.h"

#include "TCFbECell.h"
#include "TCFbEToolkit.h"
#include "TCFbECachedTable.h"

class TCFbEColumnCachedTable;
#include "TCFbEColumnCachedTable.h"
//---------------------------------------------------------------------------
// sLbVCCfbNX͗
class TCFbERowCachedTable : public TCFbECachedTable
{
public:
    // ANZT\bh
    virtual double __fastcall GetValueByIndex(int TargetRowIndex, int DummyVariable) {
        return TCFbECachedTable::GetValueByIndex(TargetRowIndex, 0);
    }

    virtual bool __fastcall GetEnabledByIndex(int TargetRowIndex, int DummyVariable) {
        return TCFbECachedTable::GetEnabledByIndex(TargetRowIndex, 0);
    }

    virtual void __fastcall SetValueByIndex(int TargetRowIndex, int DummyVariable, double Value) {
        TCFbECachedTable::SetValueByIndex(TargetRowIndex, 0, Value);
    }

    virtual void __fastcall UnableElementByIndex(int TargetRowIndex, int DummyVariable) {
        TCFbECachedTable::UnableElementByIndex(TargetRowIndex, 0);
    }

    virtual __fastcall TCFbERowCachedTable(void);    // RXgN^iLbV쐬
    virtual __fastcall TCFbERowCachedTable(TCFbECachedTable* ParentTable);   // ParentTable ̎qe[u𐶐
    __fastcall ~TCFbERowCachedTable();    // fXgN^

    virtual void __fastcall ParentCellIsUpdated(int RowIndex, int ColumnIndex); // eLbṼZXVꂽ
    virtual int __fastcall  ParentAddRow(const char* RowLabel);          // eLbV̍sǉꂽ
    virtual int __fastcall  ParentAddColumn(const char* ColumnLabel);    // eLbV̗񂪒ǉꂽ
    virtual void __fastcall ParentDeleteRowByIndex(int TargetRowIndex); // eLbV̍s폜ꂽ
    virtual void __fastcall ParentDeleteColumnByIndex(int TargetColumnIndex);   // eLbV̗񂪍폜ꂽ
    
protected:
    virtual TCFbECachedTable* __fastcall CreateClone(void);             // g̃N[쐬
    virtual TCFbECachedTable* __fastcall CreateRotatedClone(void);      // g̍sƗ񂪓ւN[쐬

private:

};
//---------------------------------------------------------------------------
#endif
