/*
    TCFbEDataSetEx.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEDataSetEx.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)            
//---------------------------------------------------------------------------
double __fastcall TCFbEDataSetEx::GetSimilarityByIndex(int TargetRowIndex, int ComparedRowIndex)
{
    if (!this->IsPrepared()) {
        Exception("TCFbEDataSetEx is not preapared (in TCFbEDataSetEx::GetSimilaritiesByIndex).");
    }

    TCFbERowRowCachedTable* SimilarityCache = (TCFbERowRowCachedTable*)this->GetSimilarityCache();

    if (!SimilarityCache->GetEnabledByIndex(TargetRowIndex, ComparedRowIndex)) {
        double CalculatedSimilarity = this->FSimilarityComputationAlgorithm->ComputeSimilarity(this->GetSimilarityComputationTable(), TargetRowIndex, ComparedRowIndex);

        if (this->FCaseAmplifier != 1.0) {
            if (CalculatedSimilarity >= 0.0) {
                CalculatedSimilarity = Power(CalculatedSimilarity, this->FCaseAmplifier);
            } else {
                CalculatedSimilarity = -1.0 * Power(-1.0 * CalculatedSimilarity, this->FCaseAmplifier);
            }
        }

        SimilarityCache->SetValueByIndex(TargetRowIndex, ComparedRowIndex, CalculatedSimilarity);
    }

    return SimilarityCache->GetValueByIndex(TargetRowIndex, ComparedRowIndex);
}

//---------------------------------------------------------------------------
double __fastcall TCFbEDataSetEx::GetPredictedValueByIndex(int TargetRowIndex, int TargetColumnIndex)
{
    if (!this->IsPrepared()) {
        Exception("TCFbEDataSetEx is not preapared (in TCFbEDataSetEx::GetPredictedValueByIndex).");
    }

    TCFbECustomTableEx* PredictedValueCache = this->GetPredictedValueCache();

    if (!PredictedValueCache->GetEnabledByIndex(TargetRowIndex, TargetColumnIndex)) {
        double  PredictedValue;
        TObjectList* NeighborList = new TObjectList();
        if (this->FAlgorithmBase == abRow) {
            this->GetNearestNeighbors(TargetRowIndex, TargetColumnIndex, this->FNeighborhoodSize, NeighborList);
            PredictedValue = this->FPredictionAlgorithm->Predict(this->GetPredictionTable(), TargetRowIndex, TargetColumnIndex, NeighborList);
        } else {    // ACex[XȂ\Ώۂ̍sƗւĎs
            this->GetNearestNeighbors(TargetColumnIndex, TargetRowIndex, this->FNeighborhoodSize, NeighborList);
            PredictedValue = this->FPredictionAlgorithm->Predict(this->GetPredictionTable(), TargetColumnIndex, TargetRowIndex, NeighborList);
        }
        delete NeighborList;

        switch (this->FValueBase) {
            case vbStandardizedValue:
                PredictedValue = this->DisStandardize(TargetColumnIndex, PredictedValue);
                break;
            case vbNormalizedValue:
                PredictedValue = this->DisNormalize(TargetColumnIndex, PredictedValue);
                break;
            case vbOrder:
                PredictedValue = this->DisOrderingEx(TargetColumnIndex, PredictedValue);
                break;
            default:
                ; // Ȃ
        }
        PredictedValueCache->SetValueByIndex(TargetRowIndex, TargetColumnIndex, PredictedValue);
    }

    return PredictedValueCache->GetValueByIndex(TargetRowIndex, TargetColumnIndex);
}

//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEDataSetEx::TCFbEDataSetEx(void)
    : TCFbETableEx()
{
    this->FValueBase = vbUnknown;
    this->FAlgorithmBase = abUnknown;
    this->FSimilarityComputationAlgorithm = NULL;
    this->FPredictionAlgorithm = NULL;
    this->FNeighborhoodSize = -1;
    this->FIsPrepared = false;

    this->TemporallyUnableRowIndex = -1;
    this->TemporallyUnableColumnIndex = -1;
    this->TemporallyUnableValue = 0.0;
}

//---------------------------------------------------------------------------
// RXgN^
// SourceCsvStringList f[^\z
// Row  1 sڂɃR[h̃x
// Column  1 sڂɃACẽx
// ͒lĂƂ݂Ȃ
__fastcall TCFbEDataSetEx::TCFbEDataSetEx(TStringList* SourceCsvStringList)
    : TCFbETableEx(SourceCsvStringList)
{
    this->FValueBase = vbUnknown;
    this->FAlgorithmBase = abUnknown;
    this->FSimilarityComputationAlgorithm = NULL;
    this->FPredictionAlgorithm = NULL;
    this->FNeighborhoodSize = -1;
    this->FIsPrepared = false;

    this->TemporallyUnableRowIndex = -1;
    this->TemporallyUnableColumnIndex = -1;
    this->TemporallyUnableValue = 0.0;
}

//---------------------------------------------------------------------------
__fastcall TCFbEDataSetEx::~TCFbEDataSetEx()    // fXgN^
{
    if (this->IsPrepared()) {
        delete this->FPredictionAlgorithm;
        delete this->FSimilarityComputationAlgorithm;
    }
}

//---------------------------------------------------------------------------
//    CF ̏siPredictionTable 
//    ValueBase:            vZɎgliValue / StandardizedValue / NormalizedValue / Order
//    AlgorithmBase:        Row(User)-based CColumn(Item)-based 
//    SimilarityComputationAlgorithm:   ގxvZASYiTCFbEDataSetEx 
//    PredictionAlgorithm:  \ASYiTCFbEDataSetEx 
//    NeighborhoodSize:     lCo[tbhTCY
//    DefaultValueEnabled:  Default Value ߍ݋@\Lɂ邩ǂ
//    DefaultValue:         Default Value ߍ݋@\LȂƂɖߍޒl
//    InverseCaseFrequencyEnabled:  Inverse Case Frequency @\Lɂ邩ǂ
//    CaseAmplifier:        Case Amplification @\gpƂ amplifierigpȂƂ 1.0 wj
void __fastcall TCFbEDataSetEx::PrepareCF(TCFbEValueBase ValueBase, TCFbEAlgorithmBase AlgorithmBase, TCFbESimilarityComputationAlgorithm* SimilarityComputationAlgorithm, TCFbEPredictionAlgorithm* PredictionAlgorithm, int NeighborhoodSize, bool DefaultValueEnabled, double DefaultValue, bool InverseCaseFrequencyEnabled, double CaseAmplifier)
{
    if (this->IsPrepared()) {
        delete this->FSimilarityComputationAlgorithm;
        delete this->FPredictionAlgorithm;
        this->DeleteChildCache("NormalizedTable");
    }

    this->FSimilarityComputationAlgorithm = SimilarityComputationAlgorithm;
    this->FPredictionAlgorithm = PredictionAlgorithm;
    this->FNeighborhoodSize = NeighborhoodSize;
    this->FAlgorithmBase = AlgorithmBase;
    this->FValueBase = ValueBase;

    TCFbETableEx* NormalizedTable = new TCFbETableEx();

    // Value / StandardizedValue / NormalizedValue / Order ̏
    switch (this->FValueBase) {
        case vbStandardizedValue:
        case vbNormalizedValue:
        case vbOrder :
            NormalizedTable->Assign(this);
            this->AddChildCache(NormalizedTable, "NormalizedTable", false);

            if (this->FValueBase == vbStandardizedValue) {
                NormalizedTable->Standardize();
            } else if (this->FValueBase == vbNormalizedValue) {
                NormalizedTable->Normalize();
            } else if (this->FValueBase == vbOrder) {
                NormalizedTable->Ordering();
            }

            break;

        default:
            NormalizedTable->Assign(this);
            this->AddChildCache(NormalizedTable, "NormalizedTable", false);
    }

    // Default Value ̐ݒ
    this->FDefaultValueEnabled = DefaultValueEnabled;
    this->FDefaultValue = DefaultValue;
    if (this->FDefaultValueEnabled) {
        for (int i = 0; i < NormalizedTable->GetNumberOfRows(); i++) {
            for (int j = 0; j < NormalizedTable->GetNumberOfColumns(); j++) {
                if (!NormalizedTable->GetEnabledByIndex(i, j)) {
                    NormalizedTable->SetValueByIndex(i, j, this->FDefaultValue);
                }
            }
        }
    }

    TCFbECustomTableEx* SimilarityComputationTable;
    TCFbECustomTableEx* PredictionTable;

    // SimilarityComputationTable, PredictionTable ̏
    if (this->FAlgorithmBase == abRow) {    // User-based CF
        SimilarityComputationTable = new TCFbETableEx();
        PredictionTable = new TCFbETableEx();

        SimilarityComputationTable->Assign(NormalizedTable);
        PredictionTable->Assign(NormalizedTable);

        NormalizedTable->AddChildCache(SimilarityComputationTable, "SimilarityComputationTable", false);
        NormalizedTable->AddChildCache(PredictionTable, "PredictionTable", false);
    } else {    // Item-based CF
        SimilarityComputationTable = new TCFbERotatedTableEx();
        PredictionTable = new TCFbERotatedTableEx();

        SimilarityComputationTable->RotatedAssign(NormalizedTable);
        PredictionTable->RotatedAssign(NormalizedTable);

        NormalizedTable->AddChildCache(SimilarityComputationTable, "SimilarityComputationTable", false);
        NormalizedTable->AddChildCache(PredictionTable, "PredictionTable", false);
    }

    // Inverse Case Frequency
    this->FInverseCaseFrequencyEnabled = InverseCaseFrequencyEnabled;
    if (this->FInverseCaseFrequencyEnabled) {
        for (int j = 0; j < SimilarityComputationTable->GetNumberOfColumns(); j++) {
            double    ICFCoefficient = SimilarityComputationTable->GetICFCoefficient(j);
            for (int i = 0; i < SimilarityComputationTable->GetNumberOfRows(); i++) {
                if (SimilarityComputationTable->GetEnabledByIndex(i, j)) {
                    SimilarityComputationTable->SetValueByIndex(i, j, SimilarityComputationTable->GetValueByIndex(i, j) * ICFCoefficient);
                }
            }
        }
    }

    this->FCaseAmplifier = CaseAmplifier;

    // Similarity LbV̏
    TCFbERowRowCachedTable* SimilarityCache = new TCFbERowRowCachedTable(SimilarityComputationTable->GetRowLabelList(), SimilarityComputationTable->GetColumnLabelList());
    SimilarityComputationTable->AddChildCache(SimilarityCache, "SimilarityCache", true);

    // PredictedValue LbV̏
    TCFbECustomTableEx* PredictedValueCache;
    if (this->FAlgorithmBase == abRow) {    // User-based CF
        PredictedValueCache = new TCFbETableEx(this->GetRowLabelList(), this->GetColumnLabelList());
    } else {    // Item-based CF
        PredictedValueCache = new TCFbERotatedTableEx(this->GetRowLabelList(), this->GetColumnLabelList());
    }
    PredictionTable->AddChildCache(PredictedValueCache, "PredictedValueCache", true);

    this->FIsPrepared = true;
}

//---------------------------------------------------------------------------
// TargetRowIndex ɑ΂ NearestNeigobors 𒲂ׂ
// TargetRowIndex: ގx𒲂ׂΏۂ̍s
// TargetColumnIndex: \Ώۂ̗iTargetColumnIndex ̒l Enabled łȂs Neighbors Ɋ܂߂Ȃ 
// NeighborList  Neigobors ގxɓĕԂ
// Ԃꂽ TObjectList  GetNearestNeighbors Ă񂾃NX폜Kv
void __fastcall TCFbEDataSetEx::GetNearestNeighbors(int TargetRowIndex, int TargetColumnIndex, int NeighborhoodSize, TObjectList* NeighborList)
{
    if (NeighborhoodSize == 0) {
        NeighborhoodSize = MaxInt;
    }

    for (int i = 0; i < this->GetSimilarityComputationTable()->GetNumberOfRows(); i++) {
        if (this->GetPredictionTable()->GetEnabledByIndex(i, TargetColumnIndex) && (i != TargetRowIndex)) {
            double Similarity = this->GetSimilarityByIndex(TargetRowIndex, i);

            int k = 0;
            while (k < NeighborList->Count) {
                if ( ((TCFbENeighbor*)NeighborList->Items[k])->GetSimilarity() < Similarity) {
                    break;
                }
                k++;
            }

            if (k < NeighborhoodSize) {
                if (NeighborList->Count >= NeighborhoodSize) {
                    NeighborList->Delete(NeighborList->Count - 1);
                }
                TCFbECell* CurrentSourceCell = (this->FAlgorithmBase == abRow) ? this->GetCellByIndex(i, TargetColumnIndex) : this->GetCellByIndex(TargetColumnIndex, i);
                double Value = CurrentSourceCell->GetEnabled() ? CurrentSourceCell->GetValue() : this->FDefaultValue;
                NeighborList->Insert(k, new TCFbENeighbor(this->GetPredictionTable()->GetRowLabelList()->Strings[i], Similarity, this->GetPredictionTable()->GetValueByIndex(i, TargetColumnIndex), Value));
            }
        }
    }
}

//---------------------------------------------------------------------------
// BaseDataSet ɂāCthis ɂȂVȗƂĒǉ
void __fastcall TCFbEDataSetEx::FillColumns(TCFbEDataSetEx* BaseDataSet)
{
    for (int j = 0; j < BaseDataSet->GetNumberOfColumns(); j++) {
        if (this->GetColumnLabelList()->IndexOf(BaseDataSet->GetColumnLabelList()->Strings[j]) == -1) {
            this->AddColumn(BaseDataSet->GetColumnLabelList()->Strings[j].c_str());
        }
    }
}

//---------------------------------------------------------------------------
// TargetDataSet Ǝѐ邩ǂ𒲂ׂ
bool __fastcall TCFbEDataSetEx::IsConsistentWith(TCFbEDataSetEx* TargetDataSet)
{
    if (this->GetNumberOfColumns() != TargetDataSet->GetNumberOfColumns()) {
        return false;
    }

    for (int j = 0; j < this->GetColumnLabelList()->Count; j++) {
        if (TargetDataSet->GetColumnLabelList()->IndexOf(this->GetColumnLabelList()->Strings[j]) == -1) {
            return false;
        }
    }
    return true;
}

//---------------------------------------------------------------------------
// ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ
double __fastcall TCFbEDataSetEx::DisOrderingEx(int ColumnIndex, double Order)
{
    TList* SortedList = new TList();
    if (this->FAlgorithmBase == abRow) {    // User-based
        this->GetPredictionTable()->GetSortedCellListOfColumn(ColumnIndex, SortedList);
    } else {
        this->GetPredictionTable()->GetSortedCellListOfRow(ColumnIndex, SortedList);
    }

    TDoubleDynArray Array;
    Array.Length = SortedList->Count;
    for (int k = 0; k < SortedList->Count; k++) {
        Array[k] = ((TCFbECell*)SortedList->Items[k])->GetValue();
    }

    double ResultedValue = this->DisOrdering(ColumnIndex, Order, Array);
    delete SortedList;
    Array.Length = 0;
    
    return ResultedValue;
}

//---------------------------------------------------------------------------
// TargetRowIndex, TargetColumnIndex ̃ZꎞI Enabled = false ɂ
void __fastcall TCFbEDataSetEx::TemporallyUnable(int TargetRowIndex, int TargetColumnIndex)
{
    if ((this->TemporallyUnableRowIndex >= 0) && (this->TemporallyUnableColumnIndex >= 0)) {
        this->RecoverEnabled();
    }

    if (this->GetEnabledByIndex(TargetRowIndex, TargetColumnIndex)) {
        this->TemporallyUnableRowIndex = TargetRowIndex;
        this->TemporallyUnableColumnIndex = TargetColumnIndex;
        this->TemporallyUnableValue = this->GetValueByIndex(TargetRowIndex, TargetColumnIndex);
        this->UnableElementByIndex(TargetRowIndex, TargetColumnIndex);
    } else {
        this->TemporallyUnableRowIndex = -1;
        this->TemporallyUnableColumnIndex = -1;
    }
}

//---------------------------------------------------------------------------
// ꎞI Enabled = false ɂĂZɂǂ
void __fastcall TCFbEDataSetEx::RecoverEnabled(void)
{
    if ((this->TemporallyUnableRowIndex < 0) && (this->TemporallyUnableColumnIndex < 0)) {
        return;
    }

    this->SetValueByIndex(this->TemporallyUnableRowIndex, this->TemporallyUnableColumnIndex, this->TemporallyUnableValue);
    this->TemporallyUnableRowIndex = -1;
    this->TemporallyUnableColumnIndex = -1;
}

//---------------------------------------------------------------------------
// ȉCprotected \bh̒`
//---------------------------------------------------------------------------
void __fastcall TCFbEDataSetEx::RePrepareCF(int TargetRowIndex, int TargetColumnIndex)
{
    if (!this->IsPrepared()) {
        return;
//        Exception("TCFbEDataSetEx is not preapared (in TCFbEDataSetEx::RePrepareCF).");
    }

    // ΏۃZ܂܂sE̐K蒼
    TCFbECustomTableEx* SimilarityComputationTable = this->GetSimilarityComputationTable();
    TCFbECustomTableEx* PredictionTable = this->GetPredictionTable();
    TCFbETableEx*       NormalizedTable = this->GetNormalizedTable();

    // Value / StandardizedValue / NormalizedValue / Order ̏
    switch (this->FValueBase) {
        case vbStandardizedValue:
        case vbNormalizedValue:
        case vbOrder:
            NormalizedTable->CopyColumnFrom(this, TargetColumnIndex, true);

            if (this->FValueBase == vbStandardizedValue) {
                NormalizedTable->PartialStandardize(TargetColumnIndex);
            } else if (this->FValueBase == vbNormalizedValue) {
                NormalizedTable->PartialNormalize(TargetColumnIndex);
            } else if (this->FValueBase == vbOrder) {
                NormalizedTable->PartialOrdering(TargetColumnIndex);
            }

            // Default Value ̐ݒ
            if (this->FDefaultValueEnabled) {
                for (int i = 0; i < NormalizedTable->GetNumberOfRows(); i++) {
                    if (!NormalizedTable->GetEnabledByIndex(i, TargetColumnIndex) && (i != TargetRowIndex)) {
                        NormalizedTable->SetValueByIndex(i, TargetColumnIndex, this->FDefaultValue);
                    }
                }
            }

            // SimilarityComputationTable, PredictionTable ̏
            if (this->FAlgorithmBase == abRow) {    // User-based CF
                SimilarityComputationTable->CopyColumnFrom(NormalizedTable, TargetColumnIndex, false);
                PredictionTable->CopyColumnFrom(NormalizedTable, TargetColumnIndex, false);
            } else {    // Item-based CF
                SimilarityComputationTable->CopyColumnAsRowFrom(NormalizedTable, TargetColumnIndex, false);
                PredictionTable->CopyColumnAsRowFrom(NormalizedTable, TargetColumnIndex, false);
            }

            break;

        default:
            if (this->FAlgorithmBase == abRow) {    // User-based CF
                SimilarityComputationTable->CopyCellFrom(this, TargetRowIndex, TargetColumnIndex, TargetRowIndex, TargetColumnIndex);
                PredictionTable->CopyCellFrom(this, TargetRowIndex, TargetColumnIndex, TargetRowIndex, TargetColumnIndex);
            } else {
                SimilarityComputationTable->CopyCellFrom(this, TargetRowIndex, TargetColumnIndex, TargetColumnIndex, TargetRowIndex);
                PredictionTable->CopyCellFrom(this, TargetRowIndex, TargetColumnIndex, TargetColumnIndex, TargetRowIndex);
            }
            break;
    }

    // Inverse Case Frequency
    if (this->FInverseCaseFrequencyEnabled) {
        for (int j = 0; j < SimilarityComputationTable->GetNumberOfColumns(); j++) {
            double ICFCoefficient = SimilarityComputationTable->GetICFCoefficient(j);
            for (int i = 0; i < SimilarityComputationTable->GetNumberOfRows(); i++) {
                if (SimilarityComputationTable->GetEnabledByIndex(i, j)) {
                    SimilarityComputationTable->SetValueByIndex(i, j, SimilarityComputationTable->GetValueByIndex(i, j) * ICFCoefficient);
                }
            }
        }
    }
}

//---------------------------------------------------------------------------

