/*
    TCFbETestCase0.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETestCase0H
#define TCFbETestCase0H
//---------------------------------------------------------------------------
#pragma hdrstop
//---------------------------------------------------------------------------
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>

USING_NAMESPACE_CPPUNIT
//---------------------------------------------------------------------------
#include <System.hpp>

//#include "TCFbEDataAccessor.h"
#include "TCFbETable.h"
#include "TCFbEDataSet.h"
#include "TCFbECommandLineParser.h"
#include "TCFbEOutputCash.h"
#include "TCFbEOutputFormatter.h"
#include "TCFbECsvOutputFormatter.h"
#include "TCFbERecommendationOutputFormatter.h"
#include "TCFbEDataLoader.h"
//---------------------------------------------------------------------------
// eXgP[X1
class TCFbETestCase0 : public TestCase
{
    // RXgN^
    TEST_CASE_COMMON(TCFbETestCase0)

public:
    TCFbETable*    Table;
    TCFbEDataSet*    LearningData;
    TCFbEDataSet*    EstimatingData;

    // eXg
    /*
                column_0    column_1    column_2    column_3    column_4
        row_0    1                        4            100
        row_1    2                        10            1
        row_2    -5            2            3            4            5
        row_3                            3
    */
    virtual void setUp() {
        this->Table = new TCFbETable();
        Table->AddColumn("column_0");
        Table->AddColumn("column_1");
        Table->AddColumn("column_2");
        Table->AddColumn("column_3");
        Table->AddColumn("column_4");
        Table->AddRow("row_0");
        Table->AddRow("row_1");
        Table->AddRow("row_2");
        Table->AddRow("row_3");
        Table->Cells["row_0"]["column_0"]->Value = 1.0;
        Table->Cells["row_0"]["column_2"]->Value = 4.0;
        Table->Cells["row_0"]["column_3"]->Value = 100.0;
        Table->Cells["row_1"]["column_0"]->Value = 2.0;
        Table->Cells["row_1"]["column_2"]->Value = 10.0;
        Table->Cells["row_1"]["column_3"]->Value = 1.0;
        Table->Cells["row_2"]["column_0"]->Value = -5.0;
        Table->Cells["row_2"]["column_1"]->Value = 2.0;
        Table->Cells["row_2"]["column_2"]->Value = 3.0;
        Table->Cells["row_2"]["column_3"]->Value = 4.0;
        Table->Cells["row_2"]["column_4"]->Value = 5.0;
        Table->Cells["row_3"]["column_2"]->Value = 3.0;

        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,    BUG,    LOC,    N_COMM,    HALVOL,    SCPMN,    N_VEXUSE");
        TestStringList->Add("module_2,    0,        250,    0.2,    3200,    3.5,    0.4");
        TestStringList->Add("module_3,    0,        500,    0,        3200,    3,        0.3");
        TestStringList->Add("module_4,    1,        700,    0.25,    3500,    4,        0.8");
        TestStringList->Add("module_5,    0,        600,    0.2,    3200,    2.5,    0.1");
        TestStringList->Add("module_6,    1,        900,    0.35,    3800,    4.1,    0.75");

        this->LearningData = new TCFbEDataSet(TestStringList);

        TestStringList->Clear();
        TestStringList->Add("FILENAME,    BUG,    LOC,    N_COMM,    HALVOL,    SCPMN,    N_VEXUSE");
        TestStringList->Add("module_1,    1,        800,    0.3,    3600,    4,        0.6");

        this->EstimatingData = new TCFbEDataSet(TestStringList);
        delete TestStringList;
    }

    // eXǧЕt
    virtual void tearDown() {
        delete this->EstimatingData;
        delete this->LearningData;
        delete this->Table;
    }

    //---------------------------------------------------------------------------
    // ȉCTCFbEDataLoader ̃eXg
    //---------------------------------------------------------------------------
    //    test\\Test_TCFbEDataLoader000_learn.csv
    //---------------------------------------------------------------------------
    //    FILENAME    BUG    LOC    N_COMM    HALVOL    SCPMN    N_VEXUSE    REV
    //    module_2    0    250    0.2        3200    3.5        0.4
    //    module_3    0        0                3        0.3            5
    //    module_4    1    700    0.25    3500    4        0.8            11
    //    module_5    0        0.2                2.5        0.1            20
    //    module_6    1    900    0.35    3800    4.1        0.75
    //---------------------------------------------------------------------------
    //    test\\Test_TCFbEDataLoader000_apply.csv
    //---------------------------------------------------------------------------
    //    FILENAME    SCPMN    LOC    BUG    N_COMM    HALVOL    N_VEXUSE    REV
    //    module_1    4        800    1    0.3                0.6            12
    //---------------------------------------------------------------------------
    virtual void Test_TCFbEDataLoader() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=5"
            , "-t=BUG"
            , "-dd"
            , "-dn"
            , "-ds"
            , "-dv"
            , "-l=test\\Test_TCFbEDataLoader000_learn.csv"
            , "-e=test\\Test_TCFbEDataLoader000_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(12, argv);
        TCFbEDataLoader*    Loader = new TCFbEDataLoader(Parser);

        TEST_ASSERT_EQUALS(5,    Loader->LearningData->NumberOfRows);
        TEST_ASSERT_EQUALS(7,    Loader->LearningData->NumberOfColumns);

        TEST_ASSERT_EQUALS("BUG",    Loader->LearningData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",    Loader->LearningData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Loader->LearningData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->LearningData->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",    Loader->LearningData->ColumnLabelList->Strings[4].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->LearningData->ColumnLabelList->Strings[5].c_str());
        TEST_ASSERT_EQUALS("REV",    Loader->LearningData->ColumnLabelList->Strings[6].c_str());

        TEST_ASSERT_EQUALS("module_2",    Loader->LearningData->RowLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",    Loader->LearningData->RowLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",    Loader->LearningData->RowLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",    Loader->LearningData->RowLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",    Loader->LearningData->RowLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][4]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][5]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][6]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][3]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][4]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][5]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][6]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][3]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][4]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][5]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][6]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][3]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][4]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][5]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][6]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][3]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][4]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][5]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[4][6]);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[0][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0,    Loader->LearningData->ValuesByIndex[0][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->ValuesByIndex[0][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200.0,    Loader->LearningData->ValuesByIndex[0][3], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5,    Loader->LearningData->ValuesByIndex[0][4], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.4,    Loader->LearningData->ValuesByIndex[0][5], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[1][0], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[1][2], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0,    Loader->LearningData->ValuesByIndex[1][4], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,    Loader->LearningData->ValuesByIndex[1][5], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0,    Loader->LearningData->ValuesByIndex[1][6], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->ValuesByIndex[2][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0,    Loader->LearningData->ValuesByIndex[2][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25,    Loader->LearningData->ValuesByIndex[2][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0,    Loader->LearningData->ValuesByIndex[2][3], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    Loader->LearningData->ValuesByIndex[2][4], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8,    Loader->LearningData->ValuesByIndex[2][5], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(11.0,    Loader->LearningData->ValuesByIndex[2][6], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[3][0], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->ValuesByIndex[3][2], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.5,    Loader->LearningData->ValuesByIndex[3][4], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.1,    Loader->LearningData->ValuesByIndex[3][5], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(20.0,    Loader->LearningData->ValuesByIndex[3][6], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->ValuesByIndex[4][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0,    Loader->LearningData->ValuesByIndex[4][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35,    Loader->LearningData->ValuesByIndex[4][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0,    Loader->LearningData->ValuesByIndex[4][3], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1,    Loader->LearningData->ValuesByIndex[4][4], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.75,    Loader->LearningData->ValuesByIndex[4][5], 1E-6);


        TEST_ASSERT_EQUALS(1,    Loader->EstimatingData->NumberOfRows);
        TEST_ASSERT_EQUALS(7,    Loader->EstimatingData->NumberOfColumns);

        TEST_ASSERT_EQUALS("SCPMN",    Loader->EstimatingData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",    Loader->EstimatingData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("BUG",    Loader->EstimatingData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Loader->EstimatingData->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->EstimatingData->ColumnLabelList->Strings[4].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->EstimatingData->ColumnLabelList->Strings[5].c_str());
        TEST_ASSERT_EQUALS("REV",    Loader->EstimatingData->ColumnLabelList->Strings[6].c_str());

        TEST_ASSERT_EQUALS("module_1",    Loader->EstimatingData->RowLabelList->Strings[0].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[0][4]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][5]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][6]);

        TEST_ASSERT_EQUALS_DOUBLE(4.0,    Loader->EstimatingData->ValuesByIndex[0][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(800.0,    Loader->EstimatingData->ValuesByIndex[0][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->EstimatingData->ValuesByIndex[0][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,    Loader->EstimatingData->ValuesByIndex[0][3], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.6,    Loader->EstimatingData->ValuesByIndex[0][5], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(12.0,    Loader->EstimatingData->ValuesByIndex[0][6], 1E-6);

        delete Loader;
        delete Parser;
    }

    virtual void Test_TCFbEDataLoader_AdoptData_tmbLearningData() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=5"
            , "-t=BUG"
            , "-m=learning"
            , "-l=test\\Test_TCFbEDataLoader001_learn.csv"
            , "-e=test\\Test_TCFbEDataLoader001_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(9, argv);
        TCFbEDataLoader*    Loader = new TCFbEDataLoader(Parser);

        //    FILENAME    BUG        LOC        N_COMM        HALVOL
        //    module_2    0        250        0.2            3200
        //    module_3    0                0
        //    module_4    1        700        0.25        3500
        //    module_5    0                0.2
        //    module_6    1        900        0.35        3800
        TEST_ASSERT_EQUALS(5,    Loader->LearningData->NumberOfRows);
        TEST_ASSERT_EQUALS(4,    Loader->LearningData->NumberOfColumns);

        TEST_ASSERT_EQUALS("BUG",    Loader->LearningData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",    Loader->LearningData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Loader->LearningData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->LearningData->ColumnLabelList->Strings[3].c_str());

        TEST_ASSERT_EQUALS("module_2",    Loader->LearningData->RowLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",    Loader->LearningData->RowLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",    Loader->LearningData->RowLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",    Loader->LearningData->RowLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",    Loader->LearningData->RowLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][3]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][3]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][3]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][3]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][3]);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[0][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0,    Loader->LearningData->ValuesByIndex[0][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->ValuesByIndex[0][2], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[1][0], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[1][2], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->ValuesByIndex[2][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0,    Loader->LearningData->ValuesByIndex[2][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25,    Loader->LearningData->ValuesByIndex[2][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0,    Loader->LearningData->ValuesByIndex[2][3], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[3][0], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->ValuesByIndex[3][2], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->ValuesByIndex[4][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0,    Loader->LearningData->ValuesByIndex[4][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35,    Loader->LearningData->ValuesByIndex[4][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0,    Loader->LearningData->ValuesByIndex[4][3], 1E-6);


        //    FILENAME    BUG        LOC        N_COMM        HALVOL
        //    module_1                    0.3
        TEST_ASSERT_EQUALS(1,    Loader->EstimatingData->NumberOfRows);
        TEST_ASSERT_EQUALS(4,    Loader->EstimatingData->NumberOfColumns);

        TEST_ASSERT_EQUALS("BUG",        Loader->EstimatingData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",        Loader->EstimatingData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Loader->EstimatingData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->EstimatingData->ColumnLabelList->Strings[3].c_str());

        TEST_ASSERT_EQUALS("module_1",    Loader->EstimatingData->RowLabelList->Strings[0].c_str());

        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[0][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[0][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[0][3]);


        TEST_ASSERT_EQUALS_DOUBLE(0.3,    Loader->EstimatingData->ValuesByIndex[0][2], 1E-6);

        delete Loader;
        delete Parser;
    }

    virtual void Test_TCFbEDataLoader_AdoptData_tmbEstimatingData() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=5"
            , "-t=BUG"
            , "-m=estimating"
            , "-l=test\\Test_TCFbEDataLoader001_learn.csv"
            , "-e=test\\Test_TCFbEDataLoader001_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(9, argv);
        TCFbEDataLoader*    Loader = new TCFbEDataLoader(Parser);

        //    FILENAME    N_COMM    HALVOL    SCPMN    N_VEXUSE    REV
        //    module_2    0.2        3200
        //    module_3    0
        //    module_4    0.25    3500
        //    module_5    0.2
        //    module_6    0.35    3800
        TEST_ASSERT_EQUALS(5,    Loader->LearningData->NumberOfRows);
        TEST_ASSERT_EQUALS(5,    Loader->LearningData->NumberOfColumns);

        TEST_ASSERT_EQUALS("N_COMM",    Loader->LearningData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->LearningData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("SCPMN",        Loader->LearningData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->LearningData->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("REV",        Loader->LearningData->ColumnLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS("module_2",    Loader->LearningData->RowLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",    Loader->LearningData->RowLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",    Loader->LearningData->RowLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",    Loader->LearningData->RowLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",    Loader->LearningData->RowLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][1]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][4]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][1]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][4]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][1]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][4]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][1]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][4]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][1]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][4]);

        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->ValuesByIndex[0][0], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[1][0], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.25,    Loader->LearningData->ValuesByIndex[2][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0,    Loader->LearningData->ValuesByIndex[2][1], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->ValuesByIndex[3][0], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.35,    Loader->LearningData->ValuesByIndex[4][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0,    Loader->LearningData->ValuesByIndex[4][1], 1E-6);


        //    FILENAME    N_COMM    HALVOL    SCPMN    N_VEXUSE    REV
        //    module_1    0.3                4        0.6            12
        TEST_ASSERT_EQUALS(1,    Loader->EstimatingData->NumberOfRows);
        TEST_ASSERT_EQUALS(5,    Loader->EstimatingData->NumberOfColumns);

        TEST_ASSERT_EQUALS("N_COMM",    Loader->EstimatingData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->EstimatingData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("SCPMN",        Loader->EstimatingData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->EstimatingData->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("REV",        Loader->EstimatingData->ColumnLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS("module_1",    Loader->EstimatingData->RowLabelList->Strings[0].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[0][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][4]);


        TEST_ASSERT_EQUALS_DOUBLE(0.3,    Loader->EstimatingData->ValuesByIndex[0][0], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(4.0,    Loader->EstimatingData->ValuesByIndex[0][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,    Loader->EstimatingData->ValuesByIndex[0][3], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(12.0,    Loader->EstimatingData->ValuesByIndex[0][4], 1E-6);

        delete Loader;
        delete Parser;
    }

    virtual void Test_TCFbEDataLoader_AdoptData_tmbBoth() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=5"
            , "-t=BUG"
            , "-m=both"
            , "-l=test\\Test_TCFbEDataLoader001_learn.csv"
            , "-e=test\\Test_TCFbEDataLoader001_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(9, argv);
        TCFbEDataLoader*    Loader = new TCFbEDataLoader(Parser);

        //    FILENAME    BUG        LOC        N_COMM        HALVOL    SCPMN    N_VEXUSE    REV
        //    module_2    0        250        0.2            3200
        //    module_3    0                0
        //    module_4    1        700        0.25        3500
        //    module_5    0                0.2
        //    module_6    1        900        0.35        3800
        TEST_ASSERT_EQUALS(5,    Loader->LearningData->NumberOfRows);
        TEST_ASSERT_EQUALS(7,    Loader->LearningData->NumberOfColumns);

        TEST_ASSERT_EQUALS("BUG",        Loader->LearningData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",        Loader->LearningData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Loader->LearningData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->LearningData->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",        Loader->LearningData->ColumnLabelList->Strings[4].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->LearningData->ColumnLabelList->Strings[5].c_str());
        TEST_ASSERT_EQUALS("REV",        Loader->LearningData->ColumnLabelList->Strings[6].c_str());

        TEST_ASSERT_EQUALS("module_2",    Loader->LearningData->RowLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",    Loader->LearningData->RowLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",    Loader->LearningData->RowLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",    Loader->LearningData->RowLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",    Loader->LearningData->RowLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][4]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][5]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][6]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][4]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][5]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][6]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[2][4]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[2][5]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[2][6]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][4]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][5]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][6]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[4][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[4][4]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[4][5]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[4][6]);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[0][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250.0,Loader->LearningData->ValuesByIndex[0][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->ValuesByIndex[0][2], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[1][0], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[1][2], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->ValuesByIndex[2][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700.0,    Loader->LearningData->ValuesByIndex[2][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25,    Loader->LearningData->ValuesByIndex[2][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3500.0,    Loader->LearningData->ValuesByIndex[2][3], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Loader->LearningData->ValuesByIndex[3][0], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.2,    Loader->LearningData->ValuesByIndex[3][2], 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Loader->LearningData->ValuesByIndex[4][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(900.0,    Loader->LearningData->ValuesByIndex[4][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.35,    Loader->LearningData->ValuesByIndex[4][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800.0,    Loader->LearningData->ValuesByIndex[4][3], 1E-6);


        //    FILENAME    N_COMM    HALVOL    SCPMN    N_VEXUSE    REV        BUG        LOC
        //    module_1    0.3                4        0.6            12
        TEST_ASSERT_EQUALS(1,    Loader->EstimatingData->NumberOfRows);
        TEST_ASSERT_EQUALS(7,    Loader->EstimatingData->NumberOfColumns);

        TEST_ASSERT_EQUALS("N_COMM",    Loader->EstimatingData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Loader->EstimatingData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("SCPMN",        Loader->EstimatingData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Loader->EstimatingData->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("REV",        Loader->EstimatingData->ColumnLabelList->Strings[4].c_str());
        TEST_ASSERT_EQUALS("BUG",        Loader->EstimatingData->ColumnLabelList->Strings[5].c_str());
        TEST_ASSERT_EQUALS("LOC",        Loader->EstimatingData->ColumnLabelList->Strings[6].c_str());

        TEST_ASSERT_EQUALS("module_1",    Loader->EstimatingData->RowLabelList->Strings[0].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[0][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][4]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[0][5]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[0][6]);


        TEST_ASSERT_EQUALS_DOUBLE(0.3,    Loader->EstimatingData->ValuesByIndex[0][0], 1E-6);
                
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    Loader->EstimatingData->ValuesByIndex[0][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.6,    Loader->EstimatingData->ValuesByIndex[0][3], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(12.0,    Loader->EstimatingData->ValuesByIndex[0][4], 1E-6);

        delete Loader;
        delete Parser;
    }


    //            column_0    column_1    column_2    column_3    column_4
    //    row_0    1                        4            100
    //    row_1    2                        10            1
    //    row_2    -5            2            3            4            5
    //    row_3                            3
    virtual void Test_TCFbEDataLoader_Merge() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=5"
            , "-t=BUG"
            , "-m=both"
            , "-l=test\\Test_TCFbEDataLoader_merge000.csv,test\\Test_TCFbEDataLoader_merge001.csv"
            , "-e=test\\Test_TCFbEDataLoader_merge001.csv,test\\Test_TCFbEDataLoader_merge000.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(9, argv);
        TCFbEDataLoader*    Loader = new TCFbEDataLoader(Parser);

        TEST_ASSERT_EQUALS(4,    Loader->LearningData->NumberOfRows);
        TEST_ASSERT_EQUALS(5,    Loader->LearningData->NumberOfColumns);

        TEST_ASSERT_EQUALS("column_0",    Loader->LearningData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("column_1",    Loader->LearningData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("column_2",    Loader->LearningData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("column_3",    Loader->LearningData->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("column_4",    Loader->LearningData->ColumnLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS("row_0",    Loader->LearningData->RowLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("row_1",    Loader->LearningData->RowLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("row_2",    Loader->LearningData->RowLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("row_3",    Loader->LearningData->RowLabelList->Strings[3].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[0][4]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[1][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[1][4]);

        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][3]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[2][4]);

        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->LearningData->EnabledByIndex[3][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->LearningData->EnabledByIndex[3][4]);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,        Loader->LearningData->ValuesByIndex[0][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,        Loader->LearningData->ValuesByIndex[0][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0,    Loader->LearningData->ValuesByIndex[0][3], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0,        Loader->LearningData->ValuesByIndex[1][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0,        Loader->LearningData->ValuesByIndex[1][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,        Loader->LearningData->ValuesByIndex[1][3], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-5.0,        Loader->LearningData->ValuesByIndex[2][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0,        Loader->LearningData->ValuesByIndex[2][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0,        Loader->LearningData->ValuesByIndex[2][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,        Loader->LearningData->ValuesByIndex[2][3], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0,        Loader->LearningData->ValuesByIndex[2][4], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0,        Loader->LearningData->ValuesByIndex[3][2], 1E-6);


        TEST_ASSERT_EQUALS(4,    Loader->EstimatingData->NumberOfRows);
        TEST_ASSERT_EQUALS(5,    Loader->EstimatingData->NumberOfColumns);

        TEST_ASSERT_EQUALS("column_0",    Loader->EstimatingData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("column_1",    Loader->EstimatingData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("column_2",    Loader->EstimatingData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("column_3",    Loader->EstimatingData->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("column_4",    Loader->EstimatingData->ColumnLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS("row_0",    Loader->EstimatingData->RowLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("row_1",    Loader->EstimatingData->RowLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("row_2",    Loader->EstimatingData->RowLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("row_3",    Loader->EstimatingData->RowLabelList->Strings[3].c_str());

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[0][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[0][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[0][4]);

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[1][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[1][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[1][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[1][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[1][4]);

        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[2][0]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[2][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[2][2]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[2][3]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[2][4]);

        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[3][0]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[3][1]);
        TEST_ASSERT_EQUALS((int)true,    Loader->EstimatingData->EnabledByIndex[3][2]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[3][3]);
        TEST_ASSERT_EQUALS((int)false,    Loader->EstimatingData->EnabledByIndex[3][4]);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,        Loader->EstimatingData->ValuesByIndex[0][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,        Loader->EstimatingData->ValuesByIndex[0][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0,    Loader->EstimatingData->ValuesByIndex[0][3], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0,        Loader->EstimatingData->ValuesByIndex[1][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0,        Loader->EstimatingData->ValuesByIndex[1][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,        Loader->EstimatingData->ValuesByIndex[1][3], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-5.0,        Loader->EstimatingData->ValuesByIndex[2][0], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0,        Loader->EstimatingData->ValuesByIndex[2][1], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0,        Loader->EstimatingData->ValuesByIndex[2][2], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,        Loader->EstimatingData->ValuesByIndex[2][3], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0,        Loader->EstimatingData->ValuesByIndex[2][4], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0,        Loader->EstimatingData->ValuesByIndex[3][2], 1E-6);

        delete Loader;
        delete Parser;
    }

    //---------------------------------------------------------------------------
    // ȉCmodule1_learn & module1_apply ɑ΂eXg
    //---------------------------------------------------------------------------
    virtual void Test_module1_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleNormalizedValue_abColumn() {
        char* argv[] = { "docfbe_test"
            , "-n=d-normalize"
            , "-ns=4"
            , "-t=BUG"
            , "-dd"
            , "-dn"
            , "-ds"
            , "-dv"
            , "-i"
            , "-if"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithWeightedMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(14, argv);
        TCFbEDataLoader*    DataLoader = new TCFbEDataLoader(Parser);
        TCFbEOutputCash*    Cash = new TCFbEOutputCash(Parser, DataLoader);
        TCFbEOutputFormatter*    Formatter = new TCFbECsvOutputFormatter(Parser, Cash);

        TEST_ASSERT_EQUALS(1,    DataLoader->EstimatingData->NumberOfRows);
        TEST_ASSERT_EQUALS(5,    DataLoader->EstimatingData->NumberOfColumns);

        TEST_ASSERT_EQUALS("module_1",  DataLoader->EstimatingData->RowLabelList->Strings[0].c_str());

        TEST_ASSERT_EQUALS("BUG",   DataLoader->EstimatingData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",   DataLoader->EstimatingData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",   DataLoader->EstimatingData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",   DataLoader->EstimatingData->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",   DataLoader->EstimatingData->ColumnLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)true,   DataLoader->EstimatingData->Enabled["module_1"]["BUG"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->EstimatingData->Enabled["module_1"]["LOC"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->EstimatingData->Enabled["module_1"]["N_COMM"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->EstimatingData->Enabled["module_1"]["HALVOL"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->EstimatingData->Enabled["module_1"]["SCPMN"]);

        TEST_ASSERT_EQUALS_DOUBLE(10,  DataLoader->EstimatingData->Values["module_1"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(800, DataLoader->EstimatingData->Values["module_1"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.3,  DataLoader->EstimatingData->Values["module_1"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3600,  DataLoader->EstimatingData->Values["module_1"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4,  DataLoader->EstimatingData->Values["module_1"]["SCPMN"], 1E-6);

        TEST_ASSERT_EQUALS(5,    DataLoader->LearningData->NumberOfRows);
        TEST_ASSERT_EQUALS(5,    DataLoader->LearningData->NumberOfColumns);

        TEST_ASSERT_EQUALS("module_2",    DataLoader->LearningData->RowLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",    DataLoader->LearningData->RowLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",    DataLoader->LearningData->RowLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",    DataLoader->LearningData->RowLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",    DataLoader->LearningData->RowLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS("BUG",   DataLoader->LearningData->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",   DataLoader->LearningData->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",   DataLoader->LearningData->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",   DataLoader->LearningData->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",   DataLoader->LearningData->ColumnLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_2"]["BUG"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_2"]["LOC"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_2"]["N_COMM"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_2"]["HALVOL"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_2"]["SCPMN"]);

        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_3"]["BUG"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_3"]["LOC"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_3"]["N_COMM"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_3"]["HALVOL"]);
        TEST_ASSERT_EQUALS((int)false,   DataLoader->LearningData->Enabled["module_3"]["SCPMN"]);

        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_4"]["BUG"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_4"]["LOC"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_4"]["N_COMM"]);
        TEST_ASSERT_EQUALS((int)false,   DataLoader->LearningData->Enabled["module_4"]["HALVOL"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_4"]["SCPMN"]);

        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_5"]["BUG"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_5"]["LOC"]);
        TEST_ASSERT_EQUALS((int)false,   DataLoader->LearningData->Enabled["module_5"]["N_COMM"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_5"]["HALVOL"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_5"]["SCPMN"]);

        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_6"]["BUG"]);
        TEST_ASSERT_EQUALS((int)false,   DataLoader->LearningData->Enabled["module_6"]["LOC"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_6"]["N_COMM"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_6"]["HALVOL"]);
        TEST_ASSERT_EQUALS((int)true,   DataLoader->LearningData->Enabled["module_6"]["SCPMN"]);

        TEST_ASSERT_EQUALS_DOUBLE(0,  DataLoader->LearningData->Values["module_2"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(250,  DataLoader->LearningData->Values["module_2"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.2,  DataLoader->LearningData->Values["module_2"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200,  DataLoader->LearningData->Values["module_2"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5,  DataLoader->LearningData->Values["module_2"]["SCPMN"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(8,  DataLoader->LearningData->Values["module_3"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(500,  DataLoader->LearningData->Values["module_3"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,  DataLoader->LearningData->Values["module_3"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3200,  DataLoader->LearningData->Values["module_3"]["HALVOL"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(5,  DataLoader->LearningData->Values["module_4"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(700,  DataLoader->LearningData->Values["module_4"]["LOC"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25,  DataLoader->LearningData->Values["module_4"]["N_COMM"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(4,  DataLoader->LearningData->Values["module_4"]["SCPMN"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(9,  DataLoader->LearningData->Values["module_5"]["BUG"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(600,  DataLoader->LearningData->Values["module_5"]["LOC"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3200,  DataLoader->LearningData->Values["module_5"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.5,  DataLoader->LearningData->Values["module_5"]["SCPMN"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(15,  DataLoader->LearningData->Values["module_6"]["BUG"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.35,  DataLoader->LearningData->Values["module_6"]["N_COMM"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3800,  DataLoader->LearningData->Values["module_6"]["HALVOL"], 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.1,  DataLoader->LearningData->Values["module_6"]["SCPMN"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(4.1,  DataLoader->LearningData->Values["module_6"]["SCPMN"], 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(4.1,  DataLoader->LearningData->Values["module_6"]["SCPMN"], 1E-6);

        //  Prediction Table
        //  FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
        //  BUG         0           0           1           0           0.942857143 0
        //  LOC         1           0           0.852272727 0.802507837 1
        //  N_COMM      0.571428571 0.914285714 0           0.630541872 0
        //  HALVOL      0           0           0           0           0
        //  SCPMN       0.8125      1           1           0           0

        TEST_ASSERT_EQUALS(5,    DataLoader->LearningData->PredictionTable->NumberOfRows);
        TEST_ASSERT_EQUALS(6,    DataLoader->LearningData->PredictionTable->NumberOfColumns);

        TEST_ASSERT_EQUALS("BUG",    DataLoader->LearningData->PredictionTable->RowLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",    DataLoader->LearningData->PredictionTable->RowLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    DataLoader->LearningData->PredictionTable->RowLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    DataLoader->LearningData->PredictionTable->RowLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",    DataLoader->LearningData->PredictionTable->RowLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS("module_2",   DataLoader->LearningData->PredictionTable->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",   DataLoader->LearningData->PredictionTable->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",   DataLoader->LearningData->PredictionTable->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",   DataLoader->LearningData->PredictionTable->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",   DataLoader->LearningData->PredictionTable->ColumnLabelList->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_1",   DataLoader->LearningData->PredictionTable->ColumnLabelList->Strings[5].c_str());

        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_4"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_5"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_6"]->Enabled);

        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_4"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_5"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, (int)DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_6"]->Enabled);

        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_4"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, (int)DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_5"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_6"]->Enabled);

        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, (int)DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_4"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_5"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_6"]->Enabled);

        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, (int)DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_4"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_5"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_6"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.942857143, DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["BUG"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1, DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.852272727, DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.802507837, DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, DataLoader->LearningData->PredictionTable->Cells["LOC"]["module_5"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0.571428571, DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.914285714, DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.630541872, DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["N_COMM"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["HALVOL"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.8125, DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1, DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_2"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1, DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->Cells["SCPMN"]["module_6"]->Value, 1E-6);


        //  Max of Column       1
        //  Min of Column       0
        //  Average of Column   0.382857143
        //  Median of Column    0
        //  Standard of Column  0.469685088
        //  Inversed Distance   2.272802661
        TEST_ASSERT_EQUALS_DOUBLE(1, DataLoader->LearningData->PredictionTable->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.382857143, DataLoader->LearningData->PredictionTable->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.469685088, DataLoader->LearningData->PredictionTable->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.272802661, DataLoader->LearningData->PredictionTable->GetInversedDistanceOfColumn(5, 0), 1E-6);

        //      MaxofRow    MinofRow    AverageofRow    MedianofRow StandardofRow   AveragedMultiplier  MedianofMultiplier  WeightedMultiplier
        //  LOC 1           0           0.730956113     0.852272727 0.373872555     0.529047619         0.471428571         0.42915792
        TEST_ASSERT_EQUALS_DOUBLE(1, DataLoader->LearningData->PredictionTable->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->PredictionTable->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.730956113, DataLoader->LearningData->PredictionTable->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.852272727, DataLoader->LearningData->PredictionTable->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.373872555, DataLoader->LearningData->PredictionTable->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.529047619, DataLoader->LearningData->PredictionTable->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.471428571, DataLoader->LearningData->PredictionTable->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.42915792, DataLoader->LearningData->PredictionTable->GetWeightedMultiplierOfRow(0, 1, 5), 1E-6);
        TEST_ASSERT_EQUALS(5, DataLoader->LearningData->PredictionTable->GetEnabledCountOfRow(1));

        //  Similarity Computation Table
        //  FILENAME    module_1    module_2    module_3    module_4    module_5    module_6
        //  BUG         0           0           0.223143551 0           0.210392491 0
        //  LOC         0           0           0.190179163 0.179074449 0.223143551
        //  N_COMM      0           0           0           0.140701353             0
        //  HALVOL      0           0           0                       0           0
        //  SCPMN       0           0                       0.223143551 0           0

        TEST_ASSERT_EQUALS(5,    DataLoader->LearningData->SimilarityComputationTable->NumberOfRows);
        TEST_ASSERT_EQUALS(6,    DataLoader->LearningData->SimilarityComputationTable->NumberOfColumns);

        TEST_ASSERT_EQUALS("BUG",    DataLoader->LearningData->SimilarityComputationTable->RowLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("LOC",    DataLoader->LearningData->SimilarityComputationTable->RowLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("N_COMM",    DataLoader->LearningData->SimilarityComputationTable->RowLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("HALVOL",    DataLoader->LearningData->SimilarityComputationTable->RowLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("SCPMN",    DataLoader->LearningData->SimilarityComputationTable->RowLabelList->Strings[4].c_str());

        TEST_ASSERT_EQUALS("module_2",   DataLoader->LearningData->SimilarityComputationTable->ColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("module_3",   DataLoader->LearningData->SimilarityComputationTable->ColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS("module_4",   DataLoader->LearningData->SimilarityComputationTable->ColumnLabelList->Strings[2].c_str());
        TEST_ASSERT_EQUALS("module_5",   DataLoader->LearningData->SimilarityComputationTable->ColumnLabelList->Strings[3].c_str());
        TEST_ASSERT_EQUALS("module_6",   DataLoader->LearningData->SimilarityComputationTable->ColumnLabelList->Strings[4].c_str());
        TEST_ASSERT_EQUALS("module_1",   DataLoader->LearningData->SimilarityComputationTable->ColumnLabelList->Strings[5].c_str());

        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_4"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_5"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_6"]->Enabled);

        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_4"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_5"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_6"]->Enabled);

        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_4"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_5"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_6"]->Enabled);

        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_4"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_5"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_6"]->Enabled);

        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_4"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_5"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, (int)DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_6"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.223143551, DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.210392491, DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["BUG"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.190179163, DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.179074449, DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.223143551, DataLoader->LearningData->SimilarityComputationTable->Cells["LOC"]["module_5"]->Value, 1E-6);


        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.140701353, DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["N_COMM"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_2"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["HALVOL"]["module_6"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_2"]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.223143551, DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_4"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_5"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->SimilarityComputationTable->Cells["SCPMN"]["module_6"]->Value, 1E-6);

        delete Formatter;
        delete Cash;
        delete DataLoader;
        delete Parser;

    }


    //---------------------------------------------------------------------------
    // ȉCTCFbEOutputFormatter ̃eXg
    //---------------------------------------------------------------------------
    virtual void Test_TCFbECsvOutputFormatter_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow() {
        char* argv[] = { "docfbe_test"
            , "-n=d-normalize"
            , "-ns=4"
            , "-t=BUG"
            , "-dd"
            , "-dn"
            , "-ds"
            , "-dv"
            , "-i"
            , "-if"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithWeightedMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(14, argv);
        TCFbEDataLoader*    DataLoader = new TCFbEDataLoader(Parser);
        TCFbEOutputCash*    Cash = new TCFbEOutputCash(Parser, DataLoader);
        TCFbEOutputFormatter*    Formatter = new TCFbECsvOutputFormatter(Parser, Cash);

        /*
            BUG     10.35052506

            Neighbors   Smilarity       Value
            LOC         0.519588986     0
            N_COMM      -0.697044424    1
            HALVOL      -0.969504007    0
            SCPMN       -0.994601344    0.571428571
        */

        TStringList*    CorrectedOutput = new TStringList();
        CorrectedOutput->Add("Label,BUG,Distributions of Similarities,,,,,,,,,,,,,,,,,,,,Neighbors' Labels,,,,Neighbors' Similarities,,,,Neighbors' Values,,,");
        CorrectedOutput->Add("module_1,10.5637085885712,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,LOC,N_COMM,SCPMN,HALVOL,0.519588985718292,-0.697044424323482,-0.969504006792627,-0.99460134443402,800,0.3,4,3600");

        TEST_ASSERT_EQUALS(CorrectedOutput->Text.Trim().c_str(),    Formatter->GetOutputString().Trim().c_str());

        delete CorrectedOutput;
        delete Formatter;
        delete Cash;
        delete DataLoader;
        delete Parser;

    }

    virtual void Test_TCFbERecommendationOutputFormatter_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbDoubleNormalizedValue_abColumn() {
        char* argv[] = { "docfbe_test"
            , "-n=d-normalize"
            , "-ns=4"
            , "-t=*"
            , "-dd"
            , "-dn"
            , "-ds"
            , "-dv"
            , "-i"
            , "-if"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithWeightedMultiplier"
            , "-r"
        };

        TCFbECommandLineParser* Parser = new TCFbECommandLineParser(15, argv);
        TCFbEDataLoader*        DataLoader = new TCFbEDataLoader(Parser);
        TCFbEOutputCash*        Cash = new TCFbEOutputCash(Parser, DataLoader);
        TCFbEOutputFormatter*   Formatter = new TCFbERecommendationOutputFormatter(Parser, Cash);

        TStringList*    CorrectedOutput = new TStringList();

        CorrectedOutput->Add("Label");
        CorrectedOutput->Add("");
        CorrectedOutput->Add("Recommended Item's Label,Score");
        CorrectedOutput->Add("");
        CorrectedOutput->Add("Distributions of Similarities");
        CorrectedOutput->Add("");
        CorrectedOutput->Add("Neighbors' Label,Similarity,Value");
        CorrectedOutput->Add("");
        CorrectedOutput->Add("");

        CorrectedOutput->Add("module_1");
        CorrectedOutput->Add("");
        CorrectedOutput->Add("HALVOL,3600");
        CorrectedOutput->Add("LOC,506.50892529071");
        CorrectedOutput->Add("BUG,10.5637085885712");
        CorrectedOutput->Add("SCPMN,3.6250174801305");
        CorrectedOutput->Add("N_COMM,0.236289713074352");
        CorrectedOutput->Add("");
        CorrectedOutput->Add("0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2");
        CorrectedOutput->Add("");
        CorrectedOutput->Add("LOC,0.519588985718292,800");
        CorrectedOutput->Add("N_COMM,-0.697044424323482,0.3");
        CorrectedOutput->Add("SCPMN,-0.969504006792627,4");
        CorrectedOutput->Add("HALVOL,-0.99460134443402,3600");
        CorrectedOutput->Add("");
        CorrectedOutput->Add("");

        TEST_ASSERT_EQUALS(CorrectedOutput->Text.Trim().c_str(),    Formatter->GetOutputString().Trim().c_str());

        delete CorrectedOutput;
        delete Formatter;
        delete Cash;
        delete DataLoader;
        delete Parser;

    }

    //---------------------------------------------------------------------------
    // ȉCTCFbEOutputCash ̃eXg
    //---------------------------------------------------------------------------
///////
    virtual void Test_TCFbEOutputCash_TCFbEAdjustedCosineSimilarityWithAverage_TCFbEAmplifiedWeightedSumWithMedianOfMultiplier_vbNormalizedValue_abRow() {
        char* argv[] = { "docfbe_test"
            , "-n=d-normalize"
            , "-ns=4"
            , "-t=BUG"
            , "-dd"
            , "-dn"
            , "-ds"
            , "-dv"
            , "-i"
            , "-if"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithWeightedMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(14, argv);
        TCFbEDataLoader*    DataLoader = new TCFbEDataLoader(Parser);
        TCFbEOutputCash*    Cash = new TCFbEOutputCash(Parser, DataLoader);

        TEST_ASSERT_EQUALS((int)true,    (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));

        //  LOC     0.519588986     1
        //  N_COMM  -0.697044424    0.571428571
        //  SCPMN   -0.969504007    0.8125
        //  HALVOL  -0.994601344    0
        TEST_ASSERT_EQUALS("LOC",       Cash->GetNeighbor(0, 0)->Label.c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Cash->GetNeighbor(0, 1)->Label.c_str());
        TEST_ASSERT_EQUALS("SCPMN",     Cash->GetNeighbor(0, 2)->Label.c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Cash->GetNeighbor(0, 3)->Label.c_str());

        TEST_ASSERT_EQUALS_DOUBLE(0.519588986,  Cash->GetNeighbor(0, 0)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.697044424, Cash->GetNeighbor(0, 1)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.969504007, Cash->GetNeighbor(0, 2)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.994601344, Cash->GetNeighbor(0, 3)->Similarity, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,            Cash->GetNeighbor(0, 0)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571,  Cash->GetNeighbor(0, 1)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8125,       Cash->GetNeighbor(0, 2)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,            Cash->GetNeighbor(0, 3)->Value, 1E-6);

        TEST_ASSERT_EQUALS(2,    Cash->GetDistribution(0, 0));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 1));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 2));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 3));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 4));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 5));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 6));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 7));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 8));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 9));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 10));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 11));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 12));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 13));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 14));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 15));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 16));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 17));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 18));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 19));

//        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->EstimatingData->GetICFCoefficient(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0, DataLoader->LearningData->GetICFCoefficient(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.223143551, DataLoader->LearningData->GetICFCoefficient(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.223143551, DataLoader->LearningData->GetICFCoefficient(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.223143551, DataLoader->LearningData->GetICFCoefficient(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.223143551, DataLoader->LearningData->GetICFCoefficient(4), 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(10.56370859,  Cash->GetResultValue(0, 0), 1E-6);

        delete Cash;
        delete DataLoader;
        delete Parser;
    }

    virtual void Test_TCFbEOutputCash_TCFbETCFbEDistanceSimilarityWithMedian_TCFbEAmplifiedWeightedSumWithWeightedMultiplier_vbStandardizedValue_abColumn() {
        char* argv[] = { "docfbe_test"
            , "-n=standardize"
            , "-i"
            , "-ns=0"
            , "-l=test\\Test_TCFbEOutputCash_learn.csv"
            , "-e=test\\Test_TCFbEOutputCash_apply.csv"
            , "-s=DistanceSimilarityWithMedian"
            , "-p=AmplifiedWeightedSumWithWeightedMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(8, argv);
        TCFbEDataLoader*    DataLoader = new TCFbEDataLoader(Parser);
        TCFbEOutputCash*    Cash = new TCFbEOutputCash(Parser, DataLoader);

        TEST_ASSERT_EQUALS((int)true,    (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 5));

        TEST_ASSERT_EQUALS("HALVOL",    Cash->GetNeighbor(0, 0)->Label.c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Cash->GetNeighbor(0, 1)->Label.c_str());
        TEST_ASSERT_EQUALS("SCPMN",    Cash->GetNeighbor(0, 2)->Label.c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Cash->GetNeighbor(0, 3)->Label.c_str());
        TEST_ASSERT_EQUALS("LOC",    Cash->GetNeighbor(0, 4)->Label.c_str());

        TEST_ASSERT_EQUALS_DOUBLE(9.114518269,    Cash->GetNeighbor(0, 0)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.337050049,    Cash->GetNeighbor(0, 1)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.44272653,    Cash->GetNeighbor(0, 2)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.502085852,    Cash->GetNeighbor(0, 3)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.431902245,    Cash->GetNeighbor(0, 4)->Similarity, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.78371755,    Cash->GetNeighbor(0, 0)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.435028413,    Cash->GetNeighbor(0, 1)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.815366258,    Cash->GetNeighbor(0, 2)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.753778361,    Cash->GetNeighbor(0, 3)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.826874193,    Cash->GetNeighbor(0, 4)->Value, 1E-6);

        TEST_ASSERT_EQUALS(2,    Cash->GetDistribution(0, 0));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 1));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 2));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 3));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 4));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 5));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 6));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 7));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 8));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 9));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 10));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 11));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 12));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 13));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 14));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 15));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 16));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 17));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 18));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 19));

        TEST_ASSERT_EQUALS_DOUBLE(0.8672195759,    Cash->GetResultValue(0, 0), 1E-6);

        delete Cash;
        delete DataLoader;
        delete Parser;
    }

    virtual void Test_TCFbEOutputCash_Jacknifing1() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-ns=0"
            , "-t=BUG"
            , "-l=test\\Test_TCFbEOutputCash_Jacknifing1.csv"
            , "-e=test\\Test_TCFbEOutputCash_Jacknifing1.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithMedianOfMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(8, argv);
        TCFbEDataLoader*    DataLoader = new TCFbEDataLoader(Parser);
        TCFbEOutputCash*    Cash = new TCFbEOutputCash(Parser, DataLoader);

        TEST_ASSERT_EQUALS((int)true,    (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 5));

        TEST_ASSERT_EQUALS("module_6",    Cash->GetNeighbor(0, 0)->Label.c_str());
        TEST_ASSERT_EQUALS("module_4",    Cash->GetNeighbor(0, 1)->Label.c_str());
        TEST_ASSERT_EQUALS("module_2",    Cash->GetNeighbor(0, 2)->Label.c_str());
        TEST_ASSERT_EQUALS("module_5",    Cash->GetNeighbor(0, 3)->Label.c_str());
        TEST_ASSERT_EQUALS("module_3",    Cash->GetNeighbor(0, 4)->Label.c_str());

        TEST_ASSERT_EQUALS_DOUBLE(0.975075376,    Cash->GetNeighbor(0, 0)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.76918665,    Cash->GetNeighbor(0, 1)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.743978853,    Cash->GetNeighbor(0, 2)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.765844542,    Cash->GetNeighbor(0, 3)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.90521368,    Cash->GetNeighbor(0, 4)->Similarity, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Cash->GetNeighbor(0, 0)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,    Cash->GetNeighbor(0, 1)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Cash->GetNeighbor(0, 2)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Cash->GetNeighbor(0, 3)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0,    Cash->GetNeighbor(0, 4)->Value, 1E-6);

        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 0));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 1));
        TEST_ASSERT_EQUALS(2,    Cash->GetDistribution(0, 2));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 3));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 4));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 5));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 6));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 7));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 8));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 9));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 10));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 11));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 12));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 13));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 14));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 15));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 16));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 17));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 18));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 19));

        TEST_ASSERT_EQUALS_DOUBLE(0.4202842154,    Cash->GetResultValue(0, 0), 1E-6);

        delete Cash;
        delete DataLoader;
        delete Parser;
    }

    virtual void Test_TCFbEOutputCash_Jacknifing2() {
        char* argv[] = { "docfbe_test"
            , "-n=standardize"
            , "-i"
            , "-ns=0"
            , "-l=test\\Test_TCFbEOutputCash_Jacknifing2.csv"
            , "-e=test\\Test_TCFbEOutputCash_Jacknifing2.csv"
            , "-s=DistanceSimilarityWithMedian"
            , "-p=AmplifiedWeightedSumWithWeightedMultiplier"
        };

        this->EstimatingData->EnabledByIndex[0][0] = false;

        for (int i = 0; i < LearningData->NumberOfRows; i++) {
            EstimatingData->CopyRowFrom(LearningData, i, false);
        }

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(8, argv);
        TCFbEDataLoader*    DataLoader = new TCFbEDataLoader(Parser);
        TCFbEOutputCash*    Cash = new TCFbEOutputCash(Parser, DataLoader);

        TEST_ASSERT_EQUALS((int)true,    (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 5));

        TEST_ASSERT_EQUALS("HALVOL",    Cash->GetNeighbor(0, 0)->Label.c_str());
        TEST_ASSERT_EQUALS("N_VEXUSE",    Cash->GetNeighbor(0, 1)->Label.c_str());
        TEST_ASSERT_EQUALS("SCPMN",    Cash->GetNeighbor(0, 2)->Label.c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Cash->GetNeighbor(0, 3)->Label.c_str());
        TEST_ASSERT_EQUALS("LOC",    Cash->GetNeighbor(0, 4)->Label.c_str());

        TEST_ASSERT_EQUALS_DOUBLE(9.114518269,    Cash->GetNeighbor(0, 0)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.337050049,    Cash->GetNeighbor(0, 1)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.44272653,    Cash->GetNeighbor(0, 2)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.502085852,    Cash->GetNeighbor(0, 3)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.431902245,    Cash->GetNeighbor(0, 4)->Similarity, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(0.78371755,    Cash->GetNeighbor(0, 0)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.435028413,    Cash->GetNeighbor(0, 1)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.815366258,    Cash->GetNeighbor(0, 2)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.753778361,    Cash->GetNeighbor(0, 3)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.826874193,    Cash->GetNeighbor(0, 4)->Value, 1E-6);

        TEST_ASSERT_EQUALS(2,    Cash->GetDistribution(0, 0));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 1));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 2));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 3));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 4));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 5));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 6));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 7));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 8));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 9));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 10));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 11));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 12));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 13));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 14));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 15));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 16));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 17));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 18));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 19));

        TEST_ASSERT_EQUALS_DOUBLE(0.8672195759,    Cash->GetResultValue(0, 0), 1E-6);

        delete Cash;
        delete DataLoader;
        delete Parser;
    }

    virtual void Test_TCFbEOutputCash_Reuse() {
        char* argv1[] = { "docfbe_test"
            , "-n=standardize"
            , "-ns=4"
            , "-t=BUG"
            , "-dd"
            , "-dn"
            , "-ds"
            , "-dv"
            , "-i"
            , "-if"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithWeightedMultiplier"
        };

        TCFbECommandLineParser*    Parser = new TCFbECommandLineParser(14, argv1);
        TCFbEDataLoader*    DataLoader = new TCFbEDataLoader(Parser);
        TCFbEOutputCash*    Cash = new TCFbEOutputCash(Parser, DataLoader);

        TEST_ASSERT_EQUALS((int)true,    (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));

        Cash->GetNeighbor(0, 0);
        Cash->GetNeighbor(0, 1);
        Cash->GetNeighbor(0, 2);
        Cash->GetNeighbor(0, 3);

        Cash->GetDistribution(0, 0);
        Cash->GetDistribution(0, 1);
        Cash->GetDistribution(0, 2);
        Cash->GetDistribution(0, 3);
        Cash->GetDistribution(0, 4);
        Cash->GetDistribution(0, 5);
        Cash->GetDistribution(0, 6);
        Cash->GetDistribution(0, 7);
        Cash->GetDistribution(0, 8);
        Cash->GetDistribution(0, 9);
        Cash->GetDistribution(0, 10);
        Cash->GetDistribution(0, 11);
        Cash->GetDistribution(0, 12);
        Cash->GetDistribution(0, 13);
        Cash->GetDistribution(0, 14);
        Cash->GetDistribution(0, 15);
        Cash->GetDistribution(0, 16);
        Cash->GetDistribution(0, 17);
        Cash->GetDistribution(0, 18);
        Cash->GetDistribution(0, 19);

        Cash->GetResultValue(0, 0);

        delete Cash;
        delete DataLoader;
        delete Parser;

        char* argv2[] = { "docfbe_test"
            , "-n=d-normalize"
            , "-ns=4"
            , "-t=BUG"
            , "-dd"
            , "-dn"
            , "-ds"
            , "-dv"
            , "-i"
            , "-if"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=AdjustedCosineSimilarityWithAverage"
            , "-p=AmplifiedWeightedSumWithWeightedMultiplier"
        };

        this->EstimatingData->EnabledByIndex[0][0] = false;
        Parser = new TCFbECommandLineParser(14, argv2);
        DataLoader = new TCFbEDataLoader(Parser);
        Cash = new TCFbEOutputCash(Parser, DataLoader);

///////
        TEST_ASSERT_EQUALS((int)true,    (int)Cash->GetResultEnabled(0, 0));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 1));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 2));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 3));
        TEST_ASSERT_EQUALS((int)false,    (int)Cash->GetResultEnabled(0, 4));

        //  LOC     0.519588986     1
        //  N_COMM  -0.697044424    0.571428571
        //  SCPMN   -0.969504007    0.8125
        //  HALVOL  -0.994601344    0
        TEST_ASSERT_EQUALS("LOC",       Cash->GetNeighbor(0, 0)->Label.c_str());
        TEST_ASSERT_EQUALS("N_COMM",    Cash->GetNeighbor(0, 1)->Label.c_str());
        TEST_ASSERT_EQUALS("SCPMN",     Cash->GetNeighbor(0, 2)->Label.c_str());
        TEST_ASSERT_EQUALS("HALVOL",    Cash->GetNeighbor(0, 3)->Label.c_str());

        TEST_ASSERT_EQUALS_DOUBLE(0.519588986,  Cash->GetNeighbor(0, 0)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.697044424, Cash->GetNeighbor(0, 1)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.969504007, Cash->GetNeighbor(0, 2)->Similarity, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.994601344, Cash->GetNeighbor(0, 3)->Similarity, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(1,  Cash->GetNeighbor(0, 0)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.571428571,  Cash->GetNeighbor(0, 1)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.8125, Cash->GetNeighbor(0, 2)->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0,    Cash->GetNeighbor(0, 3)->Value, 1E-6);

        TEST_ASSERT_EQUALS(2,    Cash->GetDistribution(0, 0));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 1));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 2));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 3));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 4));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 5));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 6));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 7));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 8));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 9));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 10));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 11));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 12));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 13));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 14));
        TEST_ASSERT_EQUALS(1,    Cash->GetDistribution(0, 15));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 16));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 17));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 18));
        TEST_ASSERT_EQUALS(0,    Cash->GetDistribution(0, 19));

        TEST_ASSERT_EQUALS_DOUBLE(10.56370859,  Cash->GetResultValue(0, 0), 1E-6);

        delete Cash;
        delete DataLoader;
        delete Parser;
    }

    //---------------------------------------------------------------------------
    // ȉCTCFbEDataSet ̃eXg
    //---------------------------------------------------------------------------
    virtual void Test_TCFbEDataSet() {
        TStringList*    TestStringList0 = new TStringList();
        TestStringList0->Add("FILENAME,BUG,EFFORT,AGE");
        TestStringList0->Add("FILE1,10,,9");
        TestStringList0->Add("FILE2,,8,43");
        TestStringList0->Add("FILE3,100,,1000");

        TStringList*    TestStringList1 = new TStringList();
        TestStringList1->Add("FILENAME,EFFORT,AGE, BUG");
        TestStringList1->Add("FILE4,,,100");
        TestStringList1->Add("FILE5,,3,10000");
        TestStringList1->Add("FILE6,78,,");

        TStringList*    TestStringList2 = new TStringList();
        TestStringList2->Add("EFFORT,FILENAME,AGE, BUG");
        TestStringList2->Add("4,FILE4,,5");
        TestStringList2->Add("10,FILE5,3,0.2");
        TestStringList2->Add("8,FILE6,,");


        TCFbEDataSet*    DataSet0 = new TCFbEDataSet(TestStringList0);
        TCFbEDataSet*    DataSet1 = new TCFbEDataSet(TestStringList0);
        TCFbEDataSet*    DataSet2 = new TCFbEDataSet(TestStringList1);
        TCFbEDataSet*    DataSet3 = new TCFbEDataSet(TestStringList2);

        TEST_ASSERT_EQUALS((int)true, DataSet0->IsConsistentWith(DataSet0));
        TEST_ASSERT_EQUALS((int)true, DataSet0->IsConsistentWith(DataSet1));
        TEST_ASSERT_EQUALS((int)true, DataSet0->IsConsistentWith(DataSet2));
        TEST_ASSERT_EQUALS((int)true, DataSet0->IsConsistentWith(DataSet2));

        delete DataSet3;
        delete DataSet2;
        delete DataSet1;
        delete DataSet0;
        delete TestStringList2;
        delete TestStringList1;
        delete TestStringList0;
    }

    //---------------------------------------------------------------------------
    // ȉCTCFbECommandLineParser ̃eXg
    //---------------------------------------------------------------------------
    virtual void Test_TCFbECommandLineParser() {
        char* argv0[] = { "docfbe_test"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=CosineSimilarity"
            , "-p=WeightedSum"
        };

        TCFbECommandLineParser* Parser = new TCFbECommandLineParser(5, argv0);
        TEST_ASSERT_EQUALS("test\\module1_learn.csv",    Parser->LearningDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("test\\module1_apply.csv",    Parser->EstimatingDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("TCFbECosineSimilarity",    AnsiString(Parser->SimilarityComputationAlgorithm->ClassName()).c_str());
        TEST_ASSERT_EQUALS("TCFbEWeightedSum",    AnsiString(Parser->PredictionAlgorithm->ClassName()).c_str());
        TEST_ASSERT_EQUALS((int)vbValue,    (int)Parser->ValueBase);
        TEST_ASSERT_EQUALS((int)abRow,    (int)Parser->AlgorithmBase);
        TEST_ASSERT_EQUALS(0,    Parser->NeighborsSize);
        TEST_ASSERT_EQUALS(0,    Parser->TargetColumnLabelList->Count);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplayNeighbors);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplaySimilarities);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplayDistribution);
        TEST_ASSERT_EQUALS("",    Parser->OutputFileName.c_str());
        delete Parser;

        char* argv1[] = { "docfbe_test"
            , "--learning=test\\module1_learn.csv"
            , "--estimating=test\\module1_apply.csv"
            , "--similarity=CosineSimilarity"
            , "--prediction=WeightedSum"
        };

        Parser = new TCFbECommandLineParser(5, argv1);
        TEST_ASSERT_EQUALS("test\\module1_learn.csv",    Parser->LearningDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("test\\module1_apply.csv",    Parser->EstimatingDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("TCFbECosineSimilarity",    AnsiString(Parser->SimilarityComputationAlgorithm->ClassName()).c_str());
        TEST_ASSERT_EQUALS("TCFbEWeightedSum",    AnsiString(Parser->PredictionAlgorithm->ClassName()).c_str());
        TEST_ASSERT_EQUALS((int)vbValue,    (int)Parser->ValueBase);
        TEST_ASSERT_EQUALS((int)abRow,    (int)Parser->AlgorithmBase);
        TEST_ASSERT_EQUALS(0,    Parser->NeighborsSize);
        TEST_ASSERT_EQUALS(0,    Parser->TargetColumnLabelList->Count);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplayNeighbors);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplaySimilarities);
        TEST_ASSERT_EQUALS((int)false,    Parser->DisplayDistribution);
        TEST_ASSERT_EQUALS("",    Parser->OutputFileName.c_str());
        delete Parser;

        char* argv2[] = { "docfbe_test"
            , "-n=Normalize"
            , "-i"
            , "-ns=10"
            , "-t=BUG,EFFORT"
            , "-dn"
            , "-ds"
            , "-dd"
            , "-o=output.txt"
            , "-l=test\\module1_learn.csv"
            , "-e=test\\module1_apply.csv"
            , "-s=CosineSimilarity"
            , "-p=WeightedSum"
        };

        Parser = new TCFbECommandLineParser(13, argv2);
        TEST_ASSERT_EQUALS("test\\module1_learn.csv",    Parser->LearningDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("test\\module1_apply.csv",    Parser->EstimatingDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("TCFbECosineSimilarity",    AnsiString(Parser->SimilarityComputationAlgorithm->ClassName()).c_str());
        TEST_ASSERT_EQUALS("TCFbEWeightedSum",    AnsiString(Parser->PredictionAlgorithm->ClassName()).c_str());
        TEST_ASSERT_EQUALS((int)vbNormalizedValue,    (int)Parser->ValueBase);
        TEST_ASSERT_EQUALS((int)abColumn,    (int)Parser->AlgorithmBase);
        TEST_ASSERT_EQUALS(10,    Parser->NeighborsSize);
        TEST_ASSERT_EQUALS(2,    Parser->TargetColumnLabelList->Count);
        TEST_ASSERT_EQUALS("BUG",    Parser->TargetColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("EFFORT",    Parser->TargetColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplayNeighbors);
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplaySimilarities);
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplayDistribution);
        TEST_ASSERT_EQUALS("output.txt",    Parser->OutputFileName.c_str());
        delete Parser;

        char* argv3[] = { "docfbe_test"
            , "--normalize=normalize"
            , "--itembased"
            , "--neighbors-size=10"
            , "--target=\"B,U,G\",\"EFFORT\""
            , "--disp-neighbors"
            , "--disp-similarities"
            , "--disp-distribution"
            , "--output=output.txt"
            , "--learning=test\\module1_learn.csv"
            , "--estimating=test\\module1_apply.csv"
            , "--similarity=CosineSimilarity"
            , "--prediction=WeightedSum"
        };

        Parser = new TCFbECommandLineParser(13, argv3);
        TEST_ASSERT_EQUALS("test\\module1_learn.csv",    Parser->LearningDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("test\\module1_apply.csv",    Parser->EstimatingDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("TCFbECosineSimilarity",    AnsiString(Parser->SimilarityComputationAlgorithm->ClassName()).c_str());
        TEST_ASSERT_EQUALS("TCFbEWeightedSum",    AnsiString(Parser->PredictionAlgorithm->ClassName()).c_str());
        TEST_ASSERT_EQUALS((int)vbNormalizedValue,    (int)Parser->ValueBase);
        TEST_ASSERT_EQUALS((int)abColumn,    (int)Parser->AlgorithmBase);
        TEST_ASSERT_EQUALS(10,    Parser->NeighborsSize);
        TEST_ASSERT_EQUALS(2,    Parser->TargetColumnLabelList->Count);
        TEST_ASSERT_EQUALS("B,U,G",    Parser->TargetColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("EFFORT",    Parser->TargetColumnLabelList->Strings[1].c_str());
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplayNeighbors);
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplaySimilarities);
        TEST_ASSERT_EQUALS((int)true,    Parser->DisplayDistribution);
        TEST_ASSERT_EQUALS("output.txt",    Parser->OutputFileName.c_str());
        delete Parser;
    }

    //---------------------------------------------------------------------------
    // ȉCTCFbETable ̃eXg
    //---------------------------------------------------------------------------
    /*
                column_0    column_1    column_2    column_3    column_4
        row_0    1                        4            100
        row_1    2                        10            1
        row_2    -5            2            3            4            5
        row_3                            3
    */
    virtual void Test_TCFbETable_Assign() {
        TCFbETable* TestTable = new TCFbETable();
        TestTable->Assign(this->Table);

        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[0][0]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[0][1]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[0][2]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[0][3]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[0][4]->Enabled);

        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[1][0]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[1][1]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[1][2]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[1][3]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[1][4]->Enabled);

        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[2][0]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[2][1]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[2][2]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[2][3]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[2][4]->Enabled);

        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[3][0]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[3][1]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[3][2]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[3][3]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[3][4]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    TestTable->CellsByIndex[0][0]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    TestTable->CellsByIndex[0][2]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0,TestTable->CellsByIndex[0][3]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0,    TestTable->CellsByIndex[1][0]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0,    TestTable->CellsByIndex[1][2]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,    TestTable->CellsByIndex[1][3]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-5.0,    TestTable->CellsByIndex[2][0]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0,    TestTable->CellsByIndex[2][1]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0,    TestTable->CellsByIndex[2][2]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    TestTable->CellsByIndex[2][3]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0,    TestTable->CellsByIndex[2][4]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0,    TestTable->CellsByIndex[3][2]->Value, 1E-6);

        delete TestTable;
    }

    /*
                column_0    column_1    column_2    column_3    column_4
        row_0    1                        4            100
        row_1    2                        10            1
        row_2    -5            2            3            4            5
        row_3                            3
    */
    virtual void Test_TCFbETable_AssignWithTurn() {
        TCFbETable* TestTable = new TCFbETable();
        TestTable->AssignWithTurn(this->Table);

        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[0][0]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[1][0]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[2][0]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[3][0]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[4][0]->Enabled);

        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[0][1]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[1][1]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[2][1]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[3][1]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[4][1]->Enabled);

        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[0][2]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[1][2]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[2][2]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[3][2]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[4][2]->Enabled);

        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[0][3]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[1][3]->Enabled);
        TEST_ASSERT_EQUALS((int)true,    TestTable->CellsByIndex[2][3]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[3][3]->Enabled);
        TEST_ASSERT_EQUALS((int)false,    TestTable->CellsByIndex[4][3]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(1.0,    TestTable->CellsByIndex[0][0]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    TestTable->CellsByIndex[2][0]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0,TestTable->CellsByIndex[3][0]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(2.0,    TestTable->CellsByIndex[0][1]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0,    TestTable->CellsByIndex[2][1]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0,    TestTable->CellsByIndex[3][1]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(-5.0,    TestTable->CellsByIndex[0][2]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0,    TestTable->CellsByIndex[1][2]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0,    TestTable->CellsByIndex[2][2]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0,    TestTable->CellsByIndex[3][2]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0,    TestTable->CellsByIndex[4][2]->Value, 1E-6);

        TEST_ASSERT_EQUALS_DOUBLE(3.0,    TestTable->CellsByIndex[2][3]->Value, 1E-6);

        delete TestTable;
    }

    // 100    10    5    3
    virtual void Test_TCFbETable_GetMaxOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(100.0, Table->GetMaxOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0, Table->GetMaxOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetMaxOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMaxOfRow(3), 1E-6);
    }

    // 1    1    -5    3
    virtual void Test_TCFbETable_GetMinOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMinOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMinOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-5.0, Table->GetMinOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMinOfRow(3), 1E-6);
    }

    // 35    4.333333333    1.8    3
    virtual void Test_TCFbETable_GetAverageOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(35.0, Table->GetAverageOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.333333333, Table->GetAverageOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.8, Table->GetAverageOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetAverageOfRow(3), 1E-6);
    }

    // 4    2    3    3
    virtual void Test_TCFbETable_GetMedianOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetMedianOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetMedianOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMedianOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMedianOfRow(3), 1E-6);
    }

    // 45.97825573    4.027681991    3.544009029    0
    virtual void Test_TCFbETable_GetStdevOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(45.97825573, Table->GetStdevOfRow(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.027681991, Table->GetStdevOfRow(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.544009029, Table->GetStdevOfRow(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetStdevOfRow(3), 1E-6);
    }

    // 0.043668122    0.045128617    0.0
    virtual void Test_TCFbETable_GetInversedDistanceOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(0.043668122, Table->GetInversedDistanceOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.045128617, Table->GetInversedDistanceOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetInversedDistanceOfRow(0, 3), 1E-6);
    }

    // 33.63333333    8.844444444    1.333333333
    virtual void Test_TCFbETable_GetAveragedMultiplierOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(33.63333333, Table->GetAveragedMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(8.844444444, Table->GetAveragedMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.333333333, Table->GetAveragedMultiplierOfRow(0, 3), 1E-6);
    }

    // 0.5    1.333333333    1.333333333
    virtual void Test_TCFbETable_GetMedianOfMultiplierOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(0.5, Table->GetMedianOfMultiplierOfRow(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.333333333, Table->GetMedianOfMultiplierOfRow(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.333333333, Table->GetMedianOfMultiplierOfRow(0, 3), 1E-6);
    }

    // 9.766805106    3.559046729    1.333333333
    virtual void Test_TCFbETable_GetWeightedMultiplierOfRow() {
        TEST_ASSERT_EQUALS_DOUBLE(9.766805106, Table->GetWeightedMultiplierOfRow(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.559046729, Table->GetWeightedMultiplierOfRow(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.333333333, Table->GetWeightedMultiplierOfRow(0, 3, 0), 1E-6);
    }

    // 2    2    10    100    5
    virtual void Test_TCFbETable_GetMaxOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetMaxOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetMaxOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0, Table->GetMaxOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0, Table->GetMaxOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetMaxOfColumn(4), 1E-6);
    }

    // -5    2    3    1    5
    virtual void Test_TCFbETable_GetMinOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(-5.0, Table->GetMinOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetMinOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->GetMinOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMinOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetMinOfColumn(4), 1E-6);
    }

    // -0.666666667    2    5    35    5
    virtual void Test_TCFbETable_GetAverageOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(-0.666666667, Table->GetAverageOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetAverageOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetAverageOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(35.0, Table->GetAverageOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetAverageOfColumn(4), 1E-6);
    }

    // 1    2    3.5    4    5
    virtual void Test_TCFbETable_GetMedianOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMedianOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->GetMedianOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.5, Table->GetMedianOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->GetMedianOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->GetMedianOfColumn(4), 1E-6);
    }

    // 3.091206165    0    2.915475947    45.97825573    0
    virtual void Test_TCFbETable_GetStdevOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(3.091206165, Table->GetStdevOfColumn(0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetStdevOfColumn(1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(2.915475947, Table->GetStdevOfColumn(2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(45.97825573, Table->GetStdevOfColumn(3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetStdevOfColumn(4), 1E-6);
    }

    //     0.0    0.416184971    0.043202765    0.0
    virtual void Test_TCFbETable_GetInversedDistanceOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetInversedDistanceOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.416184971, Table->GetInversedDistanceOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.043202765, Table->GetInversedDistanceOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetInversedDistanceOfColumn(0, 4), 1E-6);
    }

    //     0.0    0.416184971    0.043202765    0.0
    virtual void Test_TCFbETable_GetInversedDistanceOfColumn2() {
        Table->GetInversedDistanceOfColumn(1, 0);
        Table->GetInversedDistanceOfColumn(1, 2);
        Table->GetInversedDistanceOfColumn(1, 3);
        Table->GetInversedDistanceOfColumn(1, 4);

        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetInversedDistanceOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.416184971, Table->GetInversedDistanceOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.043202765, Table->GetInversedDistanceOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetInversedDistanceOfColumn(0, 4), 1E-6);
    }

    //     0.0    0.416184971    0.043202765    0.0
    virtual void Test_TCFbETable_GetInversedDistanceOfColumn3() {
/*
                column_0    column_1    column_2    column_3    column_4
        row_0    1                        4            100
        row_1    2                        10            1
        row_2    -5            2            3            4            5
        row_3                            3
*/
        Table->UpdateValue("row_0", "column_0", 0.0);
        Table->UpdateValue("row_1", "column_0", 0.0);
        Table->UpdateValue("row_2", "column_0", 0.0);
        Table->UpdateValue("row_2", "column_1", 0.0);
        Table->UpdateValue("row_2", "column_2", 0.0);
        Table->UpdateValue("row_2", "column_3", 0.0);
        Table->UpdateValue("row_2", "column_4", 0.0);

        Table->GetInversedDistanceOfColumn(0, 1);
        Table->GetInversedDistanceOfColumn(0, 2);
        Table->GetInversedDistanceOfColumn(0, 3);
        Table->GetInversedDistanceOfColumn(0, 4);

        Table->UpdateValue("row_0", "column_0", 1.0);
        Table->UpdateValue("row_1", "column_0", 2.0);
        Table->UpdateValue("row_2", "column_0", -5.0);
        Table->UpdateValue("row_2", "column_1", 2.0);
        Table->UpdateValue("row_2", "column_2", 3.0);
        Table->UpdateValue("row_2", "column_3", 4.0);
        Table->UpdateValue("row_2", "column_4", 5.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetInversedDistanceOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.416184971, Table->GetInversedDistanceOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.043202765, Table->GetInversedDistanceOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetInversedDistanceOfColumn(0, 4), 1E-6);
    }

    //     0.0    0.416184971    0.043202765    0.0
    virtual void Test_TCFbETable_GetInversedDistanceOfColumn4() {
/*
                column_0    column_1    column_2    column_3    column_4
        row_0    1                        4            100
        row_1    2                        10            1
        row_2    -5            2            3            4            5
        row_3                            3
*/
        Table->UpdateValue("row_2", "column_1", 0.0);
        Table->UpdateValue("row_2", "column_2", 0.0);
        Table->UpdateValue("row_2", "column_3", 0.0);
        Table->UpdateValue("row_2", "column_4", 0.0);

        Table->GetInversedDistanceOfColumn(0, 1);
        Table->GetInversedDistanceOfColumn(0, 2);
        Table->GetInversedDistanceOfColumn(0, 3);
        Table->GetInversedDistanceOfColumn(0, 4);

        Table->UpdateValue("row_2", "column_1", 2.0);
        Table->UpdateValue("row_2", "column_2", 3.0);
        Table->UpdateValue("row_2", "column_3", 4.0);
        Table->UpdateValue("row_2", "column_4", 5.0);

        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetInversedDistanceOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.416184971, Table->GetInversedDistanceOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.043202765, Table->GetInversedDistanceOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.0, Table->GetInversedDistanceOfColumn(0, 4), 1E-6);
    }

    // 2.5    0.705555556    1.086666667    1
    virtual void Test_TCFbETable_GetAveragedMultiplierOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(2.5, Table->GetAveragedMultiplierOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.705555556, Table->GetAveragedMultiplierOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.086666667, Table->GetAveragedMultiplierOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetAveragedMultiplierOfColumn(0, 4), 1E-6);
    }

    // 2.5    0.25    1.25    1
    virtual void Test_TCFbETable_GetMedianOfMultiplierOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(2.5, Table->GetMedianOfMultiplierOfColumn(0, 1), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.25, Table->GetMedianOfMultiplierOfColumn(0, 2), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.25, Table->GetMedianOfMultiplierOfColumn(0, 3), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetMedianOfMultiplierOfColumn(0, 4), 1E-6);
    }

    // 2.5    0.945394915    1.618832146    1
    virtual void Test_TCFbETable_GetWeightedMultiplierOfColumn() {
        TEST_ASSERT_EQUALS_DOUBLE(2.5, Table->GetWeightedMultiplierOfColumn(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.945394915, Table->GetWeightedMultiplierOfColumn(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.618832146, Table->GetWeightedMultiplierOfColumn(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->GetWeightedMultiplierOfColumn(0, 4, 0), 1E-6);
    }

    virtual void Test_TCFbETable() {
        /*
                    column_0    column_1    column_2    column_3
            row_0    1                                    4
            row_1                2            3
            row_2                                        5
        */
        TCFbETable* Table = new TCFbETable();
        TEST_ASSERT_EQUALS(0, Table->AddRow("row_0"));
        TEST_ASSERT_EQUALS(0, Table->AddColumn("column_0"));
        TEST_ASSERT_EQUALS(1, Table->AddColumn("column_1"));
        TEST_ASSERT_EQUALS(1, Table->AddRow("row_1"));
        TEST_ASSERT_EQUALS(2, Table->AddRow("row_2"));
        TEST_ASSERT_EQUALS(2, Table->AddColumn("column_2"));

        Table->Cells["row_0"]["column_0"]->Value = 1.0;

        TStringList* ColumnLabelList = new TStringList();
        TDoubleDynArray Values;
        ColumnLabelList->Add("column_1");
        ColumnLabelList->Add("column_2");
        Values.Length = 2;
        Values[0] = 2.0;
        Values[1] = 3.0;
        Table->AddRowElements("row_1", ColumnLabelList, Values);
        Values.Length = 0;
        delete ColumnLabelList;

        TStringList* RowLabelList = new TStringList();
        RowLabelList->Add("row_2");
        RowLabelList->Add("row_0");
        Values.Length = 2;
        Values[0] = 5.0;
        Values[1] = 4.0;
        Table->AddColumnElements("column_3", RowLabelList, Values);
        Values.Length = 0;
        delete RowLabelList;

        TEST_ASSERT_EQUALS(3, Table->NumberOfRows);
        TEST_ASSERT_EQUALS(4, Table->NumberOfColumns);

        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_0"]["column_0"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_0"]["column_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_0"]["column_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_0"]["column_3"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->Cells["row_0"]["column_0"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->Cells["row_0"]["column_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_1"]["column_0"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_1"]["column_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_1"]["column_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_1"]["column_3"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->Cells["row_1"]["column_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(3.0, Table->Cells["row_1"]["column_2"]->Value, 1E-6);

        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_2"]["column_0"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_2"]["column_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_2"]["column_2"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_2"]["column_3"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->Cells["row_2"]["column_3"]->Value, 1E-6);

        /*
                    column_0    column_1    column_3
            row_0    1                        4
            row_2                            5
        */
        Table->DeleteRow("row_1");
        Table->DeleteColumn("column_2");

        TEST_ASSERT_EQUALS(2, Table->NumberOfRows);
        TEST_ASSERT_EQUALS(3, Table->NumberOfColumns);

        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_0"]["column_0"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_0"]["column_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_0"]["column_3"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->Cells["row_0"]["column_0"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->Cells["row_0"]["column_3"]->Value, 1E-6);

        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_2"]["column_0"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_2"]["column_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_2"]["column_3"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->Cells["row_2"]["column_3"]->Value, 1E-6);

        /*
                    column_0    column_1    column_3    column_4
            row_0    1                        4            100
            row_2    2                        10            1
        */
        ColumnLabelList = new TStringList();
        ColumnLabelList->Add("column_3");
        ColumnLabelList->Add("column_0");
        Values.Length = 2;
        Values[0] = 10.0;
        Values[1] = 2.0;
        Table->UpdateRowElements("row_2", ColumnLabelList, Values);
        Values.Length = 0;
        delete ColumnLabelList;

        RowLabelList = new TStringList();
        RowLabelList->Add("row_0");
        RowLabelList->Add("row_2");
        Values.Length = 2;
        Values[0] = 100.0;
        Values[1] = 1.0;
        Table->AddColumnElements("column_4", RowLabelList, Values);
        Values.Length = 0;
        delete RowLabelList;

        TEST_ASSERT_EQUALS(2, Table->NumberOfRows);
        TEST_ASSERT_EQUALS(4, Table->NumberOfColumns);

        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_0"]["column_0"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_0"]["column_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_0"]["column_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_0"]["column_4"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->Cells["row_0"]["column_0"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->Cells["row_0"]["column_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0, Table->Cells["row_0"]["column_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_2"]["column_0"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_2"]["column_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_2"]["column_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_2"]["column_4"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(2.0, Table->Cells["row_2"]["column_0"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(10.0, Table->Cells["row_2"]["column_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->Cells["row_2"]["column_4"]->Value, 1E-6);


        /*
                    column_0    column_1    column_3    column_4
            row_0    1+4=5                    4            100
            row_2    2+10+2=14    +4=4        10-3=7        1
        */
        ColumnLabelList = new TStringList();
        ColumnLabelList->Add("column_1");
        ColumnLabelList->Add("column_3");
        ColumnLabelList->Add("column_0");
        Values.Length = 3;
        Values[0] = 4.0;
        Values[1] = -3.0;
        Values[2] = 10.0;
        Table->AddRowElements("row_2", ColumnLabelList, Values);
        Values.Length = 0;
        delete ColumnLabelList;

        RowLabelList = new TStringList();
        RowLabelList->Add("row_2");
        RowLabelList->Add("row_0");
        Values.Length = 2;
        Values[0] = 2.0;
        Values[1] = 4.0;
        Table->AddColumnElements("column_0", RowLabelList, Values);
        Values.Length = 0;
        delete RowLabelList;

        TEST_ASSERT_EQUALS(2, Table->NumberOfRows);
        TEST_ASSERT_EQUALS(4, Table->NumberOfColumns);

        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_0"]["column_0"]->Enabled);
        TEST_ASSERT_EQUALS((int)false, Table->Cells["row_0"]["column_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_0"]["column_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_0"]["column_4"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(5.0, Table->Cells["row_0"]["column_0"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->Cells["row_0"]["column_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(100.0, Table->Cells["row_0"]["column_4"]->Value, 1E-6);

        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_2"]["column_0"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_2"]["column_1"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_2"]["column_3"]->Enabled);
        TEST_ASSERT_EQUALS((int)true, Table->Cells["row_2"]["column_4"]->Enabled);

        TEST_ASSERT_EQUALS_DOUBLE(14.0, Table->Cells["row_2"]["column_0"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(4.0, Table->Cells["row_2"]["column_1"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(7.0, Table->Cells["row_2"]["column_3"]->Value, 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1.0, Table->Cells["row_2"]["column_4"]->Value, 1E-6);

        delete Table;
    }

    virtual void Test_DB() {
//        TCFbEDataAccessor* DataAccessor = new TCFbEDataAccessor("TestDB");
//        DataAccessor->CreateTable();
//        DataAccessor->UpdateValue("module1", "LOC", 100.0);
//        delete DataAccessor;
    }

protected:

};

//---------------------------------------------------------------------------
#endif