/*
    TCFbENeighbor.h    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbENeighborH
#define TCFbENeighborH
//---------------------------------------------------------------------------
#include <system.hpp>
#include <Contnrs.hpp>
#include "TCFbEToolkit.h"
//---------------------------------------------------------------------------
class TCFbENeighbor : public TObject
{
public:
    virtual __fastcall TCFbENeighbor(AnsiString Label, double Similarity, double Value, double SourceValue);    // RXgN^
    __fastcall ~TCFbENeighbor();    // fXgN^

    static double __fastcall GetAverageValueOfNeighborList(TObjectList* NeighborList);    // NeighborList Ɋi[ꂽ Neighbors ̒l̕ϒlԂ
    static double __fastcall GetMedianValueOfNeighborList(TObjectList* NeighborList);    // NeighborList Ɋi[ꂽ Neighbors ̒l̒ԒlԂ

    __property AnsiString    Label = { read=FLabel };
    __property double    Similarity = { read=FSimilarity };
    __property double    Value = { read=FValue };
    __property double    SourceValue = { read=FSourceValue };
    
protected:
    AnsiString    FLabel;
    double    FSimilarity;
    double    FValue;
    double    FSourceValue;

private:

};

//---------------------------------------------------------------------------
// Neighbor ̔r֐
//---------------------------------------------------------------------------
// ~\[g
// > 0 ()    Item1  Item2 菬
//   0    Item1  Item2 
// < 0 ()    Item1  Item2 傫
int __fastcall CompareNeighbor(void *Item1, void *Item2)
{
    if (TCFbEToolkit::GetToolkit()->Equals(((TCFbENeighbor*)Item1)->Similarity, ((TCFbENeighbor*)Item2)->Similarity)) {
        return 0;
    } else if ( ((TCFbENeighbor*)Item1)->Similarity < ((TCFbENeighbor*)Item2)->Similarity ) {
        return 1;
    } else {
        return -1;
    }
}

//---------------------------------------------------------------------------
#endif
