/*
    TCFbEAdjustedWeightedSumWithMedianOfRow.cpp    June 6, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEAdjustedWeightedSumWithMedianOfRow.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEAdjustedWeightedSumWithMedianOfRow::TCFbEAdjustedWeightedSumWithMedianOfRow(void)
    : TCFbEWeightedSum()
{
}

//---------------------------------------------------------------------------
// fXgN^
__fastcall TCFbEAdjustedWeightedSumWithMedianOfRow::~TCFbEAdjustedWeightedSumWithMedianOfRow()
{
}

//---------------------------------------------------------------------------
// ȍ~Cprotected \bh
//---------------------------------------------------------------------------
// q̒l𓾂
double __fastcall TCFbEAdjustedWeightedSumWithMedianOfRow::GetNumerator(int NeighborIndex)
{
    TCFbENeighbor*    Neighbor = (TCFbENeighbor*)this->NeighborList->Items[NeighborIndex];
    int Index = this->DataSet->PredictionTable->RowLabelList->IndexOf(Neighbor->Label);
    return (Neighbor->Value - this->DataSet->PredictionTable->GetMedianOfRow(Index)) *  Neighbor->Similarity;
}

//---------------------------------------------------------------------------
// \l𓾂
double __fastcall TCFbEAdjustedWeightedSumWithMedianOfRow::GetPredictedValue(double Numerator, double Denominator)
{
    return this->DataSet->PredictionTable->GetMedianOfRow(this->TargetRowIndex) + Numerator / Denominator;
}

//---------------------------------------------------------------------------

