<?php
/*
 NCE (Neetchan Cloud Environment.)
 name: nc_update_readcnt_db.php
 author: Akira Ohta (akohta001.gmail.com)
 date: 2013-apr-14th
 description:
  */
include_once "account.php";
include_once "preference.php";
include_once "database.php";
include_once "log.php";
include_once "http_util.php";
include_once "error_code.php";

$user_id = $_POST['user'];
$hashed_passwd = $_POST['hashed_passwd'];
$record_type = $_POST['record_type'];

//--- authorization ---
$user = chk_passwd( $user_id, $hashed_passwd);
if(FALSE === $user){
	echo $ERROR_MSG;
	exit;
}

//--- parameter check start ---
if(!chk_param($record_type)){
	echo ERROR303;
	exit;
}
if(!is_numeric($record_type)){
	echo ERROR303;
	exit;
}
if($record_type < 1 || $record_type > 6){
	echo ERROR304;
	exit;
}
//--- parameter check end ---

$table_name = TABLE_PREFIX."tbl{$user->home_dir}";
$query = <<< QUERY1
select  board_name,  dat_name, last_update from $table_name 
    where record_type = '{$record_type}' order by last_update desc limit 0,50
QUERY1;

try{
	$db->open();
	$result = $db->execute($query);
	
	if(!$result){
		echo ERROR503;
		exit;
	}
	$db->close();
}catch(Exception $e){
	$error = __FILE__."(".__LINE__.
		") An error occured during query.";
	nc_logging($error, $e);
	echo ERROR500;
	exit;
}

echo SUCCESS100;
for($i = 0; $i < $result->num_rows; $i++){
	$row = $result->fetch_assoc();
	echo $row['board_name'].",".$row['dat_name'].",".$row['last_update']."\n";
}

?>
