<?php
/*
 NCE (Neetchan Cloud Environment.)
 name: nc_insert_lines_file.php
 author: Akira Ohta (akohta001.gmail.com)
 date: 2013-apr-14th
 description:
 
 */
include_once "account.php";
include_once "preference.php";
include_once "database.php";
include_once "log.php";
include_once "http_util.php";
include_once "error_code.php";

$user_id = $_POST['user'];
$hashed_passwd = $_POST['hashed_passwd'];
$file_name = $_POST['file_name'];
$num = $_POST['num'];

$user = chk_passwd( $user_id, $hashed_passwd);
if(FALSE === $user){
	echo $ERROR_MSG;
	exit;
}

if(!chk_param($file_name) || !$num || FALSE == is_numeric($num)){
	echo ERROR303;
	exit;
}

if($num <= 0 || $num > 50){
	echo ERROR304;
	exit;
}

$home_dir = OUTPUT_DIR."/{$user->home_dir}";

if(!is_dir($home_dir)){
	$rc = mkdir($home_dir, 0755, true);
	if(!$rc){
		nc_logging("Failed to create folders: $home_dir");
		echo ERROR400;
		exit;
	}
}

$file_path = $home_dir.'/'.$file_name;

$org_lines = file($file_path);
if(!$org_lines){
	$org_lines = array();
}

@$fp=fopen($file_path, 'w');
if(!$fp){
	nc_logging("Failed to create files: $file_path");
	echo ERROR400;
	exit;
}
flock($fp, LOCK_EX);
$len = count($org_lines);

for($i = 0; $i < $len; $i++){
	$s1 = trim($org_lines[$i]);
	$j= 1;
	for( ; $j <= $num; $j++){
		$s2 = $_POST['n'.$j];
		$s2 = replace_64symbol2urlencode($s2);
		if($s1 == $s2){
			break;
		}
	}
	if($j > $num){
		fwrite($fp, $s1."\n");
	}
}
for($i = 1; $i <= $num; $i++){
	$s1 = $_POST['n'.$i];
	if(0 == strlen($s1))
		continue;
	$s1 = replace_64symbol2urlencode($s1);
	fwrite($fp, $s1."\n");
}

flock($fp, LOCK_UN);
fclose($fp);

echo SUCCESS100;

?>
