function maskHTML(tag, obj) {
	var target = document.getElementById(obj);
	var pos = getAreaRange(target);

	var val = target.value;
	var range = val.slice(pos.start, pos.end);
    var beforeNode = val.slice(0, pos.start);
    var afterNode  = val.slice(pos.end);
	var insertNode;

    if (range || pos.start != pos.end) {
       	//insertNode = '<' + tag + '>' + range + '</' + tag + '>';
       	insertNode = '[' + tag + ']' + range + '[/' + tag + ']';
       	target.value = beforeNode + insertNode + afterNode;
    }
    
    else if (pos.start == pos.end) {
       	//insertNode = '<' + tag + '>' + '</' + tag + '>';
       	insertNode = '[' + tag + ']' + range + '[/' + tag + ']';
       	target.value = beforeNode + insertNode + afterNode;
    }
}

function getAreaRange(obj) {
	var pos = new Object();
	
	if (isIE) {
		obj.focus();
		var range = document.selection.createRange();
		var clone = range.duplicate();
		
		clone.moveToElementText(obj);
		clone.setEndPoint( 'EndToEnd', range );

		pos.start = clone.text.length - range.text.length;
		pos.end   = clone.text.length - range.text.length + range.text.length;
  	}

	else if(window.getSelection()) {
		pos.start = obj.selectionStart;
		pos.end   = obj.selectionEnd;
	}

	return pos;
//	alert(pos.start + "," + pos.end);
}
var isIE = (navigator.appName.toLowerCase().indexOf('internet explorer')+1?1:0);
