using System;
using System.Collections.Generic;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace IdlenessKiller
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        private DateTime date_start;//WEBubNJn
        private DateTime date_start_interval;//xݎԊJn
        private TimeSpan time_work;//Wēׂ object
        private TimeSpan time_interval;//xݎ object
        private IKDocument document = new IKDocument();
        //st@C̃tH_擾AftHgݒt@C쐬
        private string setting_fileName = Application.StartupPath +"\\"+Path.GetFileNameWithoutExtension(Application.ExecutablePath) + @".xml";
        //%systemroot%\System32\Drivers\Etc\hosts
        private string hosts_filename = System.Environment.GetFolderPath(Environment.SpecialFolder.System) + "\\drivers\\etc\\hosts";
        private void start_web_blocking() 
        {
            //hosts
            //t@CJēǂݍ
            string[] hosts_contents = File.ReadAllLines(hosts_filename);
            IEnumerator lines = hosts_contents.GetEnumerator();
            using (StreamWriter sw = new StreamWriter(hosts_filename))
            {
                bool site_block_line_flag = false;
                //ubŇ`Ղ΍폜
                while (lines.MoveNext())
                {
                    if (lines.Current.Equals(document.marker_start))
                    {
                        site_block_line_flag = true;
                    }
                    else if (lines.Current.Equals(document.marker_end))
                    {
                        site_block_line_flag = false;
                    }
                    else
                    {
                        if (site_block_line_flag == false)
                        {
                            sw.WriteLine(lines.Current);
                        }
                    }
                }
                //Ƀf[^ǉ
                sw.WriteLine(document.marker_start);
                lines = checkedListBox1.CheckedItems.GetEnumerator();
                while (lines.MoveNext()) 
                {
                    sw.Write("127.0.0.1   ");
                    sw.WriteLine(lines.Current.ToString());
                }
                sw.WriteLine(document.marker_end);
            }

            timer2.Stop();
            //ԌvJnƕ\L̕ύX
            date_start = DateTime.Now;
            timer1.Start();
            button1.Text = document.text_block_end;
        }
        private void stop_web_blocking()
        {
            //hosts߂
            //t@CJēǂݍ
            string[] hosts_contents = File.ReadAllLines(hosts_filename);
            IEnumerator lines = hosts_contents.GetEnumerator();
            using (StreamWriter sw = new StreamWriter(hosts_filename))
            {
                bool site_block_line_flag = false;
                //ubŇ`Ղ΍폜
                while (lines.MoveNext())
                {
                    if (lines.Current.Equals(document.marker_start))
                    {
                        site_block_line_flag = true;
                    }
                    else if (lines.Current.Equals(document.marker_end))
                    {
                        site_block_line_flag = false;
                    }
                    else
                    {
                        if (site_block_line_flag == false)
                        {
                            sw.WriteLine(lines.Current);
                        }
                    }
                }
                //Ƀf[^ǉȂ
            }

            //Ԍv~ƕ\L̕ύX
            timer1.Stop();
            progressBar1.Value = progressBar1.Maximum;
            button1.Text = document.text_block_start;
            textBox1.Text = time_work.ToString();

            //ĎՒfҋ@
            date_start_interval = DateTime.Now;
        }
        private void button1_Click(object sender, EventArgs e)
        {
            if (timer1.Enabled == true) 
            {
                stop_web_blocking();
            }
            else
            {
                start_web_blocking();
            }
            timer2.Stop();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            TimeSpan s = DateTime.Now - date_start;
            double ratio = s.TotalSeconds / time_work.TotalSeconds;
            if (ratio >= 1.0)
            {
                stop_web_blocking();//@hosts߂
                if (document.block_retry_flag) timer2.Start(); //timerɂĖɂȂ̂݁AĎՒf^C}[Jn
            }
            else if(ratio >= 0.0)
            {
                progressBar1.Value = (int)(progressBar1.Maximum * ratio);
                TimeSpan left = time_work - s;
                textBox1.Text = left.Hours.ToString() + ":"+left.Minutes.ToString() +":" + ((int)(left.Seconds)).ToString();
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            //2dNh~Ȃ炱

            //Document֘Ãf[^擾Jn
            System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(IKDocument));
            try
            {
                using(System.IO.FileStream fs = new System.IO.FileStream(setting_fileName, System.IO.FileMode.Open)){
                //Jݒt@Cǂݍ
                    try
                    {
                        document = (IKDocument)serializer.Deserialize(fs);
                    }
                    catch (System.IO.InvalidDataException)
                    {
                        throw new System.IO.FileNotFoundException();
                    }
                }
            }
            //݂ĂȂAftHg̃t@C(bNĊJȂǂ悤EXEIȁj
            catch (System.IO.FileNotFoundException)
            {
                document.set_default_site_list();
                using (System.IO.FileStream fs = new System.IO.FileStream(setting_fileName, System.IO.FileMode.Create))
                {
                    serializer.Serialize(fs, document);
                }
            }
            catch (Exception) {
                Application.Exit();
            }
            //Document֘Ãf[^擾

            //[Jϐ̏
            time_work = TimeSpan.FromMinutes(document.working_minutes);
            time_interval = TimeSpan.FromMinutes(document.interval_minutes);
            progressBar1.Maximum = (int)(document.working_minutes * 60);
            progressBar1.Minimum = 0;
            progressBar1.Style = ProgressBarStyle.Continuous;
            timer1.Interval = document.timer_interval;
            timer2.Interval = document.timer_interval;
            date_start = DateTime.Now;
            date_start_interval = DateTime.Now;
            stop_web_blocking();
            //[Jϐ

            //GUIփf[^Jn
            textBox3.Text = document.working_minutes.ToString();
            textBox4.Text = document.interval_minutes.ToString();
            checkBox1.Checked = document.block_retry_flag;
            checkedListBox1.Items.Clear();
            foreach (IKBlockSite site in document.block_site_list)
            {
                checkedListBox1.Items.Add(site.url, site.block);
            }
            //GUIփf[^
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            stop_web_blocking();
            
            //GUIf[^Jn
            document.block_site_list.Clear();
            foreach (object obj in checkedListBox1.Items)
            {
                bool b = false;
                if (checkedListBox1.GetItemCheckState(checkedListBox1.Items.IndexOf(obj)) == CheckState.Checked) b = true;
                document.block_site_list.Add(new IKBlockSite(obj.ToString(), b));
            }
            //GUIf[^

            System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(IKDocument));
            using (System.IO.FileStream fs = new System.IO.FileStream(setting_fileName, System.IO.FileMode.Create))
            {
                serializer.Serialize(fs, document);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //webTCg̒ǉ
            if (false == checkedListBox1.Items.Contains(textBox2.Text))
            {
                checkedListBox1.Items.Add(textBox2.Text, true);
                textBox2.Text = "";
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (timer1.Enabled == false)
            {
                //Ւf̕ύX
                document.working_minutes = double.Parse(textBox3.Text);
                document.interval_minutes = double.Parse(textBox4.Text);
                document.block_retry_flag = checkBox1.Checked;
                time_work = TimeSpan.FromMinutes(document.working_minutes);
                time_interval = TimeSpan.FromMinutes(document.interval_minutes);
                textBox1.Text = time_work.ToString();
            }
        }

        private void timer2_Tick(object sender, EventArgs e)
        {
            if (timer1.Enabled == true)
            {
                timer2.Stop();
            }
            else
            {
                TimeSpan s = DateTime.Now - date_start_interval;
                double ratio = s.TotalSeconds / time_interval.TotalSeconds;
                if (ratio >= 1.0)
                {
                    start_web_blocking();//ăubNJn
                }
                else if (ratio >= 0.0)
                {
                    TimeSpan left = time_interval - s;
                    textBox1.Text = left.Hours.ToString() + ":" + left.Minutes.ToString() + ":" + ((int)(left.Seconds)).ToString();
                }
            }
        }
    }
    public class IKBlockSite
    {
        public String url;
        public bool block;
        public IKBlockSite()
        {
            url = "";
            block = false;
        }
        public IKBlockSite(String s, bool b)
        {
            url = s;
            block = b;
        }
    }
    public class IKDocument
    {


        public double working_minutes;
        public double interval_minutes;
        public String text_block_start;
        public String text_block_end;
        public String marker_start;
        public String marker_end;
        public int timer_interval;
        public bool block_retry_flag;
        [System.Xml.Serialization.XmlArrayItem(typeof(IKBlockSite))]
        public ArrayList block_site_list = new ArrayList();
        public IKDocument()
        {
            working_minutes = 50.0;//{^獡Wēׂ@50炢
            interval_minutes = 10.0;//̕ƃubNJ玩IɃubN𕜋A(dAtOON̎..)
            text_block_start = " UfU؂ ";
            text_block_end = " Ufɕ ";
            timer_interval = 1000;//mSecPʂ̍XVC^[o bԊuŏ[

            marker_end = "#ENDIF_NamakeGorosi"; //hosts}[J
            marker_start = "#IF_NamakeGorosi"; //hosts}[J
            block_retry_flag = false;//ĎՒfstO
        }
        public void set_default_site_list()
        {
            block_site_list.Clear();
            block_site_list.Add(new IKBlockSite("slashdot.jp", true));
            block_site_list.Add(new IKBlockSite("impress.co.jp", true));
            block_site_list.Add(new IKBlockSite("itmedia.co.jp", true));
            block_site_list.Add(new IKBlockSite("newsing.jp", true));
            block_site_list.Add(new IKBlockSite("b.hatena.ne.jp", true));
            block_site_list.Add(new IKBlockSite("anod.hatelabo.jp", true));
            block_site_list.Add(new IKBlockSite("2ch.net", false));
            block_site_list.Add(new IKBlockSite("mixi.jp", true));
            block_site_list.Add(new IKBlockSite("nicovideo.jp", true));
        }
    }
}