/*
 * Decompiled with CFR 0.152.
 */
package org.yanroncha.n3.resource.xml;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.yanroncha.n3.resource.xml.node.Node;
import org.yanroncha.n3.resource.xml.node.Paragraph;
import org.yanroncha.n3.resource.xml.node.Source;

public class N3XmlConverter
extends DefaultHandler2
implements Runnable {
    private static final String APP_NAME = "N3 XML Converter version 2.10 (2014 - ) MASHIDA, Akinori";
    public static final String INIT_METHOD = "init";
    private static final String SNN_SOURCE = "source";
    public static final String ATTR_ID = "id";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_BLOCK = "block";
    public static final String ATTR_BLIST = "block_list";
    private static final String INDENT_BASE = "    ";
    public static final char NG_KEY_CHAR = '<';
    private static SAXParserFactory factory;
    private static Locator locator;
    SAXParser parser;
    String src;
    StringBuilder charBuff;
    String textType = null;
    boolean stockText;
    Node targetNode = null;
    ArrayDeque<Node> nodeStack;
    Source source;
    StringBuilder indent;

    public static Node getParagraph(String string, Attributes attributes) throws Exception {
        Paragraph paragraph = new Paragraph(attributes);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        stringBuilder.append(string);
        stringBuilder.append('\"');
        if (string != null && string.length() > 0) {
            paragraph.setValue(ATTR_ACTION, stringBuilder.toString(), null);
        }
        return paragraph;
    }

    public static void initNodeClass(Class<? extends Node> clazz) {
        try {
            Method method = clazz.getMethod(INIT_METHOD, new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.printf(">>>>> WARNING: - %s\n", noSuchMethodException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.printf(">>>>> ERROR: Class [%s] initializing failed. (%s)\n", clazz.getName(), exception.getMessage());
            System.exit(-1);
        }
    }

    public static Locator getLocator() {
        return locator;
    }

    public N3XmlConverter(String string) {
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
        }
        try {
            this.parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.printf(">>>>> ERROR: Parser configuration error! - %s\n", parserConfigurationException.getMessage());
            return;
        }
        catch (SAXException sAXException) {
            System.err.printf(">>>>> ERROR: SAX error! - %s\n", sAXException.getMessage());
            return;
        }
        Node.setConverter(this);
        this.src = string;
        this.charBuff = new StringBuilder();
        this.stockText = false;
        this.nodeStack = new ArrayDeque();
        this.source = new Source(new AttributesImpl());
        this.indent = new StringBuilder();
    }

    @Override
    public void run() {
        File file;
        System.out.printf("Converting... [%s]\n", this.src);
        try {
            file = new File(this.src);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        try {
            this.parser.parse(file, (DefaultHandler)this);
        }
        catch (Exception exception) {
            if (exception instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)exception;
                System.err.printf(">>>>> PARSE ERROR (line: %d / column: %d) - %s\n", sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage());
            } else {
                System.err.printf(">>>>> ERROR: Parser error! [%s]\n", exception.getMessage());
            }
            return;
        }
        System.out.print("Conversion finished.\n");
    }

    public Node getTargetNode() {
        return this.nodeStack.peek();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        N3XmlConverter.locator = locator;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.targetNode != null) {
            Node node = null;
            try {
                node = this.targetNode.setSubNode(string3, attributes);
            }
            catch (Exception exception) {
                System.err.printf(">>>>> ERROR: Parse error - %s (line: %d / column: %d)\n", exception.getMessage(), locator.getLineNumber(), locator.getColumnNumber());
                System.exit(-1);
            }
            if (node != null) {
                if (this.targetNode != node) {
                    this.nodeStack.push(node);
                    this.targetNode = node;
                }
            } else {
                this.stockText = true;
                this.textType = attributes.getValue(ATTR_TYPE);
            }
        } else if (SNN_SOURCE.equals(string3)) {
            this.targetNode = this.source;
            this.nodeStack.push(this.source);
        } else {
            System.err.printf(">>>>> ERROR: Root node must be <Source> (line: %d / column: %d)\n", locator.getLineNumber(), locator.getColumnNumber());
            System.exit(-1);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2).trim();
        if (this.stockText) {
            this.charBuff.append(string);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.stockText) {
            String string4 = this.charBuff.toString();
            if (this.targetNode == null) {
                return;
            }
            try {
                this.targetNode.setValue(string3, string4, this.textType);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                System.exit(-1);
            }
            this.charBuff.delete(0, this.charBuff.length());
            this.stockText = false;
        } else if (this.targetNode != null) {
            try {
                Node node = this.targetNode.quitNode(string3);
                if (node != this.targetNode && this.nodeStack.peek() == this.targetNode) {
                    Node node2 = this.nodeStack.pop();
                    this.targetNode = this.nodeStack.peek();
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                System.exit(-1);
            }
        } else {
            System.err.printf(">>>>> ERROR: No target node in ending element. (line: %d / column: %d)\n", locator.getLineNumber(), locator.getColumnNumber());
            System.exit(-1);
        }
    }

    @Override
    public void endDocument() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (Node.isConvertingValues()) {
                    Thread.yield();
                }
                try {
                    N3XmlConverter.this.source.writeData(null, 0);
                }
                catch (Exception exception) {
                    System.err.printf(">>>>> ERROR: Writing error - %s (line: %d / column: %d)\n", exception.toString(), locator.getLineNumber(), locator.getColumnNumber());
                    System.exit(-1);
                }
            }
        }).start();
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        System.err.printf(">>>>> PARSE ERROR line: (%d) column: (%d) - %s\n", sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage());
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        System.err.printf(">>>>> PARSE WARNING line: (%d) column: (%d) - %s\n", sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage());
    }

    public String pushIndent() {
        return this.indent.append(INDENT_BASE).toString();
    }

    public String popIndent() {
        int n;
        int n2 = this.indent.length();
        if (n2 >= (n = INDENT_BASE.length())) {
            return this.indent.delete(n2 - n, n2).toString();
        }
        return "";
    }

    public String getIndent() {
        return this.indent.toString();
    }

    public int getPageIndex(String string) {
        try {
            return this.source.getPageIndex(string);
        }
        catch (Exception exception) {
            System.err.printf(">>>>> ERROR - %s\n", exception.getMessage());
            System.exit(-1);
            return -1;
        }
    }

    public int getParagraphIndex(String string, String string2) {
        try {
            return this.source.getParagraphIndex(string, string2);
        }
        catch (Exception exception) {
            System.err.printf(">>>>> ERROR - %s\n", exception.getMessage());
            System.exit(-1);
            return -1;
        }
    }

    public String getNaviItemLocation(String string) {
        try {
            return this.source.getNaviItemLocation(string);
        }
        catch (Exception exception) {
            System.err.printf(">>>>> ERROR - %s\n", exception.getMessage());
            System.exit(-1);
            return null;
        }
    }

    public String getContentsLocation(String string) {
        try {
            return this.source.getContentsLocation(string);
        }
        catch (Exception exception) {
            System.err.printf(">>>>> ERROR - %s\n", exception.getMessage());
            System.exit(-1);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        System.out.printf("%s\nConverting %d file(s).\n", APP_NAME, stringArray.length);
        for (String string : stringArray) {
            new Thread(new N3XmlConverter(string)).start();
        }
    }

    static {
        locator = null;
        factory = null;
        Source.init();
    }

    public static class IdDuplicatedException
    extends Exception {
        private String message;

        public IdDuplicatedException(Node node, String string) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("ID: [%s] is duplicated for <%s>. (line: %d / column: %d)\n", string, node.getClass().getName(), locator.getLineNumber(), locator.getColumnNumber());
            this.message = stringWriter.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class IdNotFoundException
    extends Exception {
        private String message;

        public IdNotFoundException(String string, String string2) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            int[] nArray = Node.getTargetValueLocation();
            printWriter.printf("ID: [%s] not found for <%s>. (line: %d / column: %d)\n", string2, string, nArray[0], nArray[1]);
            this.message = stringWriter.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class WrongParameterValueException
    extends Exception {
        private String message;

        public WrongParameterValueException(Node node, String string, String string2) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("[%s] is wrong value of parameter (%s) for <%s>. (line: %d / column: %d)\n", string2, string, node.getClass().getName(), locator.getLineNumber(), locator.getColumnNumber());
            this.message = stringWriter.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class NecessaryParameterLackedException
    extends Exception {
        private String message;

        public NecessaryParameterLackedException(Node node, String string) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("Necessary paremter(s) lacked [%s] for <%s>. (line: %d / column: %d)\n", string, node.getClass().getName(), locator.getLineNumber(), locator.getColumnNumber());
            this.message = stringWriter.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class IndexNotFoundException
    extends Exception {
        private String message;

        public IndexNotFoundException(String string) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            int[] nArray = Node.getTargetValueLocation();
            printWriter.printf("Index not found for name [%s]. (line: %d / column: %d)\n", string, nArray[0], nArray[1]);
            this.message = stringWriter.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class AttrNotFoundClassException
    extends Exception {
        private String message;

        public AttrNotFoundClassException(String string, String string2) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("Attribute[%s] not found for node[%s]. (line: %d / column: %d)\n", string2, string, locator.getLineNumber(), locator.getColumnNumber());
            this.message = stringWriter.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class NodeDuplicatedException
    extends Exception {
        private String message;

        public NodeDuplicatedException(String string) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("Node[%s] is duplicated. (line: %d / column: %d)\n", string, locator.getLineNumber(), locator.getColumnNumber());
            this.message = stringWriter.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class NotSubNodeException
    extends Exception {
        private String message;

        public NotSubNodeException(Node node, String string) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("Node [%s] is not sub node of <%s>. (line: %d / column: %d)\n", string, node.getClass().getName(), locator.getLineNumber(), locator.getColumnNumber());
            this.message = stringWriter.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

