#!/usr/bin/perl
# /xampp/perl/bin/perl
# N2Wiki ver. 0.2.3
# H.OHARA 2008-07-27
use lib '.';
use strict;
use warnings;
use File::Basename;
use CGI::Carp qw(fatalsToBrowser);
use Ho::B;
use N2::WikiPage;
use N2::Data;
use N2::View;

my $server_name = ''; # 'www.hoge.jp'
my $script_name = ''; # '/~foo/bar/wiki'

my $wiki_title = '';
my $css_file_name = 'diki_style';
my $edit_title_prefix = 'Editing :: ';
my $include_terminate_message = '<p>[Termination :: Too deeply nested]</p>';
my $document_max_depth = 32;
my $command_alias_depth = 32;
my $database_name = 'N2Wiki_db';
my $tinyurl = 'http://tinyurl.com/create.php?url=';
my $day_of_week = ['日','月','火','水','木','金','土'];

$ENV{'PATH'} = '/bin:/usr/bin';
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

sub main {
    my $q = Ho::B->new(-wday => $day_of_week);
    my $server = $server_name ne '' ? $server_name : $ENV{SERVER_NAME};
    my $script = $script_name ne '' ? $script_name : $ENV{SCRIPT_NAME};
    my $path_info = $ENV{PATH_INFO};
    $path_info = $q->check_path_info($path_info, $server, $script);
    my $w = N2::WikiPage->new(
        page => ($path_info eq '' ? '/' : $path_info),
        data => N2::Data->new(db => $database_name),
        view => N2::View->new(
            path => 'http://'.$server.$script,
            scriptpath => $script,
            title => $wiki_title,
            maxdepth => $document_max_depth,
            aliasdepth => $command_alias_depth,
            css => $css_file_name,
            editmsg => $edit_title_prefix,
            termmsg => $include_terminate_message,
            tinyurl => $tinyurl,
            query => $q
        )
    );
    if($ENV{REQUEST_METHOD} eq 'POST') {
        if($ENV{CONTENT_TYPE} =~ /^application\/x-www-form-urlencoded/) {
            my $e = $q->param_post('n2e');
            my $plugin = $q->param_post('plugin');
            my $mod = $q->param_post('moddate');
            my $touch = $q->param_post('touch');
            my $preview = $q->param_post('preview');
            if(defined($plugin)) {
                $w->plugin($plugin);
            }
            elsif(defined($preview)) {
                $w->preview($e);
            }
            elsif($e) {
                $w->write($e,$mod,$touch);
            }
            else {
                $w->remove();
            }
        }
        elsif($ENV{CONTENT_TYPE} =~ /^multipart\/form-data/) {
            my $plugin = $q->upload('plugin');
            if(defined($plugin)) {
                $w->plugin($plugin);
            }
            else {
                $w->read();
            }
        }
        elsif($ENV{CONTENT_TYPE} =~ /^application\/octet-stream/) {
            my $proc = sub {
                my ($data) = @_;
                my $hpos = index($data,';');
                my $header = substr($data,0,$hpos);
                substr($data,0,$hpos+1) = '';
                my %atrb = $q->decode_form($q->split_form_data($header));
                $atrb{DATA} = $data;
                return \%atrb;
            };
            my $plugin = $q->stream('plugin',$proc);
            if(defined($plugin)) {
                $w->plugin($plugin);
            }
            else {
                $w->read();
            }
        }
        else {
            $w->read();
        }
    }
    elsif($ENV{QUERY_STRING} eq '') {
        $w->read();
    }
    elsif($ENV{QUERY_STRING} eq 'e') {
        $w->edit();
    }
    else {
        my $plugin = $q->param_get('plugin');
        if(defined($plugin)) {
            $w->plugin($plugin);
        }
        else {
            $w->read();
        }
    }
}

&main;
