# N2::WikiPage
# 2008/4/9 v0.1
# H.OHARA

# Controller class
package N2::WikiPage;
use strict;
use warnings;

# constructor
sub new {
    my $class = shift;
    my $self = {
        data => undef,  # N2::Data
        view => undef,  # N2::View
        page => '/',  # string
        @_
    };
    $self = bless $self, $class;
    $self->{view}->read_prefs($self->{data});
    $self->{data}->{session_expire} = $self->{view}->{session_expire} * 60;
    $self->{data}->{recentdeleted} = $self->{view}->{recent_deleted};
    return $self;
}

# public methods
sub read {
    my $self = shift;
    my $db = $self->{data};
    my $pg = $self->{page};
    my $view = $self->{view};
    if($db->is_spambot($pg,$view)) {
        $view->spambot();
        return;
    }
    if(defined(my $plg = $db->is_resource($pg))) {
        if($plg eq '') {
            my $uri = $db->resuri($view->{_dirpath},$pg);
            $view->redirect($uri);
        }
        else {
            $view->plugin($pg, $db, $plg);
        }
    }
    elsif($db->is_denied($pg)) {
        $view->render($pg, $db, 3);
    }
    elsif($db->is_denyread($pg)) {
        $view->render($pg, $db, 4);
    }
    else {
        $view->render($pg, $db);
    }
}

sub edit {
    my $self = shift;
    my $pg = $self->{page};
    my $db = $self->{data};
    my $view = $self->{view};
    if($db->is_spambot($pg,$view)) {
        $view->spambot();
        return;
    }
    if($db->is_frozen($pg)) {
        $view->render($pg, $db, 2);
    }
    elsif($db->is_denied($pg)) {
        $view->render($pg, $db, 5);
    }
    elsif($db->is_denyread($pg)) {
        $view->render($pg, $db, 6);
    }
    else {
        $view->render($pg, $db, 1);
    }
}

sub preview {
    my $self = shift;
    my ($data) = @_;
    my $pg = $self->{page};
    my $db = $self->{data};
    my $view = $self->{view};
    $view->{_preview_data} = $data;
    if($view->botcheck($pg,$db,$view->{passcode})) {
        $view->spambot();
        return;
    }
    if($db->is_spambot($pg,$view)) {
        $view->change_passcode($db->is_frozen($pg));
        $view->spambot();
        return;
    }
    $view->render($pg, $db, 8, $data);
}

sub write {
    my $self = shift;
    my ($data,$moddate,$touch) = @_;
    my $pg = $self->{page};
    my $db = $self->{data};
    my $view = $self->{view};
    my $err;
    if($view->botcheck($pg,$db,$view->{passcode})) {
        $view->spambot();
        return;
    }
    if($db->is_spambot($pg,$view)) {
        $view->change_passcode($db->is_frozen($pg));
        $view->spambot();
        return;
    }
    $db->autobackup($pg,$view);
    if($err = $db->set($pg,$data,$moddate,$touch)) {
        $view->dberror($err);
    }
    else {
        $view->redirect_to($pg);
    }
}

sub remove {
    my $self = shift;
    my $pg = $self->{page};
    my $db = $self->{data};
    my $view = $self->{view};
    if($view->botcheck($pg,$db,$view->{passcode})) {
        $view->spambot();
        return;
    }
    if($db->is_spambot($pg,$view)) {
        $view->change_passcode($db->is_frozen($pg));
        $view->spambot();
        return;
    }
    $db->backup($pg,$view->{query});
    $db->remove($pg);
    $db->add_recentdeleted($pg,$view->{query});
    $view->redirect_to('/');
}

sub plugin {
    my $self = shift;
    my ($plugin) = @_;
    my $pg = $self->{page};
    my $db = $self->{data};
    my $view = $self->{view};
    if($db->is_spambot($pg,$view)) {
        $view->change_passcode(0);
        $view->spambot();
        return;
    }
    $view->plugin($pg, $db, $plugin);
}

1;