# N2::Deny
# 2008/07/13 v0.1
# H.OHARA

# Deny prefs class
package N2::Deny;
use strict;
use warnings;

# inherites from N2::PathPrefs
use N2::PathPrefs;
use base qw( N2::PathPrefs );
our $VERSION = 0.1;

# constructor
sub new {
    my $class = shift;
    my $self = {
        page => '/_preferences/deny', # string
        db => undef, # N2::Data
        rex => '^([^# ].*)\s*$', #'
        proc => undef,
        _prefs => undef,
        @_
    };
    $self = bless $self, $class;
    $self->init();
    return $self;
}

sub init {
    my $self = shift;
    my @prefs;
    my $i = 0;
    if(!$self->{proc}) {
        $self->{proc} = sub {
            my ($a) = @_;
            if($a =~ /$self->{rex}/) {
                my $dp = $1 eq '/' ? '/' : "$1/" ;
                my $len = length($dp);
                push(@prefs,[$1,$1,$dp,$len,$i]);
            }
            $i++;
        };
    }
    $self->SUPER::init();
    $self->{_prefs} = \@prefs;
}

1;
