# N2::Date
# 2008/06/04 v0.1
# H.OHARA

# Date class
package N2::Date;
use strict;
use warnings;
use POSIX qw(strftime);

# constructor
sub new {
    my $class = shift;
    my $self = {
        year => undef,
        month => undef,
        day => undef,
        wday => undef,
        yday => undef,
        hour => undef,
        min => undef,
        sec => undef,
        isdst => undef,
        unixtime => undef,
        timezone => 9,
        localwday => ['日','月','火','水','木','金','土'],
        @_
    };
    $self = bless $self, $class;
    $self->init();
    return $self;
}
# private methods
sub init {
    my $self = shift;
    if(defined($self->{unixtime})) {
        $self->utime_to_date();
    }
    else {
        $self->date_to_utime();
    }
}

sub utime_to_date {
    my $self = shift;
    my $ut = defined($self->{unixtime}) ? $self->{unixtime} : time ;
    my @date = localtime($ut);
    $self->{year} = $date[5] + 1900;
    $self->{month} = $date[4] + 1;
    $self->{day} = $date[3];
    $self->{hour} = $date[2];
    $self->{min} = $date[1];
    $self->{sec} = $date[0];
    $self->{wday} = $date[6];
    $self->{yday} = $date[7];
    $self->{isdst} = $date[8];
}

sub date_to_utime {
    my $self = shift;
    my @date = localtime(time);
    my $tz = $self->{timezone};
    $self->{year} =
        defined($self->{year}) ? $self->{year} : $date[5] + 1900 ;
    $self->{month} =
        defined($self->{month}) ? $self->{month} : $date[4] + 1 ;
    $self->{day} = defined($self->{day}) ? $self->{day} : $date[3];
    $self->{hour} = defined($self->{hour}) ? $self->{hour}-$tz : -$tz ;
    $self->{min} = defined($self->{min}) ? $self->{min} : 0 ;
    $self->{sec} = defined($self->{sec}) ? $self->{sec} : 0 ;
    my $y = $self->{year};
    my $m = $self->{month};
    my $d = $self->{day};
    my $days = grep { $_ % 4 == 0 && ($_ % 400 == 0 || $_ % 100 != 0) }
        (1970 .. $y - 1);
    $days += ($y - 1970) * 365;
    my $feb = $y % 4 == 0 && ($y % 400 == 0 || $y % 100 != 0) ? 29 : 28 ;
    my @mdays = (31,$feb,31,30,31,30,31,31,30,31,30,31);
    for (my $i = 1; $i < $m ; $i++) {
        $days += $mdays[$i-1];
    }
    $days += $d-1;
    $self->{unixtime} = 
        $days*86400+$self->{hour}*3600+$self->{min}*60+$self->{sec};
    $self->utime_to_date();
}

sub to_str {
    my $self = shift;
    my ($frmt) = @_;
    my $wd = $self->{localwday}->[$self->{wday}];
    $frmt =~ s/%J/$wd/go;
    return strftime($frmt,
        $self->{sec},$self->{min},$self->{hour},
        $self->{day},$self->{month}-1,$self->{year}-1900
    );
}
1;
