$(function() {

	// Round Corner
	$('.round').corner();
	// Bevel Corner
	$('.bevel').corner('bevel');
	// Dog Ear Corner
	$('.dog').corner('dog');
	// Dog2 Corner
	$('.dog2').corner('dog2');
	// Dog3.Corner
	$('.dog3').corner('dog3');

	/**
	 * inputタグのイベントハンドラ
	 */
	$('input:text, input:password, select')
		/**
		 * キーダウンイベントです。
		 * エンターキーでの送信をロックします。
		 */
		.keydown(function(e) {
			if (e.keyCode == 13) {
				return false;
			}
		})
		/**
		 * フォーカス取得イベントです。
		 * 要素を選択状態にします。
		 */
		.focus(function() {
			if (!$(this).attr('readonly')) {
				$(this).addClass('selected');
				$(this).select();
			}
		})
		/**
		 * フォーカス離脱イベントです。
		 * 要素の選択状態を解除します。
		 */
		.blur(function() {
			$(this).removeClass('selected');
		});

	/**
	 * textareaタグのイベントハンドラ
	 */
	$('textarea')
		/**
		 * フォーカス取得イベントです。
		 * 要素を選択状態にします。
		 */
		.focus(function() {
			$(this).addClass('selected');
		})
		/**
		 * フォーカス離脱イベントです。
		 * 要素の選択状態を解除します。
		 */
		.blur(function() {
			$(this).removeClass('selected');
		});

	/**
	 * コード型inputタグのイベントハンドラです。
	 */
	$('input.code')
		/**
		 * キーダウンイベントです。
		 * 数字以外のキーをロックします。
		 */
		.keydown(function(e) {
			return acceptChars(e.keyCode, 1);
		})
		/**
		 * フォーカス離脱イベントです。
		 * maxlengthで頭ゼロ埋めします。
		 */
		.blur(function() {
			var maxlength = $(this).attr('maxlength');
			$(this).val(zeroFill($(this).val(), maxlength));
		});

	/**
	 * 数字型inputタグのイベントハンドラです。
	 */
	$('input.deg')
		/**
		 * キーダウンイベントです。
		 * 数字以外のキーをロックします。
		 */
		.keydown(function(e) {
			return acceptChars(e.keyCode, 1);
		})

	/**
	 * 数値型inputタグのイベントハンドラです。
	 */
	$('input.num')
		/**
		 * キーダウンイベントです。
		 * 数字、ドット以外のキーをロックします。
		 */
		.keydown(function(e) {
			return acceptChars(e.keyCode, 2);
		})
		/**
		 * フォーカス取得イベントです。
		 * カンマ区切りを解除します。
		 */
		.focus(function() {
			$(this).val(removeComma($(this).val()));
			$(this).select();
		})
		/**
		 * フォーカス離脱イベントです。
		 * カンマ区切りの数値とします。
		 */
		.blur(function() {
			$(this).val(addComma($(this).val()));
		});

	/**
	 * 英字型inputタグのイベントハンドラです。
	 */
	$('input.alpha')
		/**
		 * キーダウンイベントです。
		 * 英字以外のキーをロックします。
		 */
		.keydown(function(e) {
			return acceptChars(e.keyCode, 3);
		});

	/**
	 * 英数字型inputタグのイベントハンドラです。
	 */
	$('input.alnum')
		/**
		 * キーダウンイベントです。
		 * 英数以外のキーをロックします。
		 */
		.keydown(function(e) {
			return acceptChars(e.keyCode, 4);
		});

	/**
	 * 英数記号型inputタグのイベントハンドラです。
	 */
	$('input.ans')
		/**
		 * キーダウンイベントです。
		 * 英数記号以外のキーをロックします。
		 */
		.keydown(function(e) {
			return acceptChars(e.keyCode, 5);
		});

	/**
	 * 日付型inputタグのイベントハンドラです。
	 */
	$('input.date')
		/**
		 * キーダウンイベントです。
		 * 数字とスラッシュキー以外のキーをロックします。
		 */
		.keydown(function(e) {
			return (acceptChars(e.keyCode, 6));
		})
		/**
		 * フォーカス取得イベントです。
		 * 日付フォーマットします。
		 */
		.focus(function() {
			$(this).select();
		})
		/**
		 * フォーカス離脱イベントです。
		 * 日付フォーマットします。
		 */
		.blur(function() {
			$(this).val(dateFormat( $(this).val(), $(this).attr('maxlength')));
		});

	/**
	 * 起動時に数字要素にコンマを付けます。
	 */
	var num = $('input.num');
	for (var i = 0; i < num.length; i++) {
		var item = num.eq(i);
		item.val(addComma(item.val()));
	}

	/**
	 * 起動時に最初の要素にフォーカスを当てます。
	 */
	if ($('.first') != null) {
		window.focus();
		$('.first').focus();
		$('.first').select();
	}

	/**
	 * 最後の要素のイベントハンドラです。
	 */
	$('.last')
		/**
		 * フォーカス離脱イベントです。
		 * 最初の要素にフォーカスを当てます。
		 */
		.blur(function() {
			if ($('.first') != null) {
				window.focus();
				$('.first').focus();
				$('.first').select();
			}
		});

	/**
	 * エンターキーによる送信を許可する要素のイベントハンドラです。
	 */
	$('.enter')
		/**
		 * キーダウンイベントです。
		 * フォームを送信します。
		 */
		.keydown(function(e) {
			if (e.keyCode == 13) {
				$('form:first').submit();
			}
		});

	/**
	 * 読取専用クラスを設定します。
	 */
	$('input.read').attr('readonly', true);
	$('textarea.read').attr('readonly', true);

	/**
	 * テーブルの色を変えます。
	 */
	$('table.border tr:even').css('background-color', '#ccffff');
	$('table.border tr:odd').css('background-color', '#ffffff');
});

/**
 * キャレット位置を取得します。
 * @param		{Object} obj			対象オブジェクト
 * @return		{Integer}				キャレット位置
 */
function getPos(obj)
{
	var pos = 0;
	if (obj.createTextRange) {
		var rng = document.selection.createRange();
		rng.moveStart("character", - obj.value.length);
		pos = rng.text.length;
	}
	else if (obj.selectionStart) {
		pos = obj.selectionStart;
	}
	return pos;
}

/**
 * キャレット位置を設定します。
 * @param		{Object} obj			対象オブジェクト
 * @param		{Integer} pos			キャレット位置
 */
function setPos(obj, pos)
{
	if (obj.createTextRange) {
		var rng = obj.createTextRange();
		rng.move('character', obj.value.length);
		rng.select();
	}
	else if (obj.setSelectionRange) {
		obj.setSelectionRange(pos, pos);
	}
}

/**
 *キーコードが使えるものかを判別します。
 * @param		{Integer} code		キーコード
 * @param		{Integer} type		判別タイプ(1:整数, 2:小数, 3:英字, 4:英数字, 5:英数記号, 6:年月日)
 * @return		{Boolean}			結果
 */
function acceptChars(code, type)
{
	// 基本的に使えるキーコード
	if (code == 8 || code == 9 || (16 <= code && code <= 19) || (28 <= code && code <= 29) || (33 <= code && code <= 40) || (45 <= code && code <= 50)) {
		return true;
	}
	// 数字キー
	if (type == 1 || type == 2 || type == 4 || type == 5 || type == 6) {
		if ((48 <= code && code <= 57) || (96 <= code && code <= 105)) {
			return true;
		}
	}
	// アルファベット
	if (type == 3 || type == 4 || type == 5) {
		if ((65 <= code && code <= 90)) {
			return true;
		}
	}
	// ドット・ハイフン
	if (type == 2 || type == 5) {
		if (code == 109 || code == 110|| code == 189 || code == 190) {
			return true;
		}
	}
	// スラッシュ
	if (type == 6) {
		if (code == 111 || code == 191) {
			return true;
		}
	}
	// その他記号
	if (type == 5) {
		if ((106 <= code && code <= 111) || (186 <= code && code <= 192 || code == 226)) {
			return true;
		}
	}
	// ここまでダメならNG
	return false;
}

/**
 * 値をゼロ埋めします。
 * @param		{String} value		対象値
 * @param		{Integer} len		長さ
 * @return		{String}			ゼロ埋め値
 */
function zeroFill(value, len)
{
	if (value.length > 0) {
		for (var i = value.length; i < len; i++) {
			value = '0' + value;
		}
	}
	return value;
}

/**
 * 値を3桁のカンマ区切りにします。
 * また、同時に.00を削除します。
 * @param		{String} value		対象値
 * @return		{String}			カンマ区切り文字列
 */
function addComma(value)
{
	if (value == null || value.length == 0) return '';
	for(var i = 0; i < value.length / 3; i++){
		value = value.replace(/^([+-]?\d+)(\d\d\d)/,"$1,$2");
	}
	return value.replace(/\.0+$/g, '');;
}

/**
 * 値のカンマを削除します。
 * また、同時に.00を削除します。
 * @param		{String} value		対象値
 */
function removeComma(value)
{
	var ret = value.split(',').join('');
	return ret.replace(/\.0+$/g, '');
}

/**
 * 日付型にします。長さが10ならばYYYY/MM/DD, 8ならばYY/MM/DD, 5ならばMM/DDにフォーマットします。
 * @param		{Boolean} input			入力中
 * @param		{String} value			対象値
 * @param		{Integer} len			長さ
 */
function dateFormat(value, len)
{
	var ret = '';
	var year = '';
	var month = '';
	var day = '';
	var fill = '0';
	value = value.replace(/_/g, '');
	var values = value.split('/');

	if (len == 10) {
		if (values.length >= 1) { year = values[0]; }
		year = zeroFill(year, 4);
		if (values.length >= 2) { month = values[1]; }
		month = zeroFill(month, 2);
		if (values.length >= 3) { day = values[2]; }
		day = zeroFill(day, 2);
		if (year.length == 0 || year == '0000' || month.length == 0 || month == '00' || day.length == 0 || day == '00') {
			return '';
		}
		return year + '/' + month + '/' + day;
	}
	else if (len == 8) {
		if (values.length >= 1) { year = values[0]; }
		year = zeroFill(year, 2);
		if (values.length >= 2) { month = values[1]; }
		month = zeroFill(month, 2);
		if (values.length >= 3) { day = values[2]; }
		day = zeroFill(day, 2);
		if (year.length == 0 || year == '00' || month.length == 0 || month == '00' || day.length == 0 || day == '00') {
			return '';
		}
		return year + '/' + month + '/' + day;
	}
	else if (len == 5) {
		if (values.length >= 1) { month = values[0]; }
		month = zeroFill(month, 2);
		if (values.length >= 2) { day = values[1]; }
		day = zeroFill(day, 2);
		if (month.length == 0 || month == '00' || day.length == 0 || day == '00') {
			return '';
		}
		return month + '/' + day;
	}
	else if (len == undefined) {
		return value;
	}
	return '';
}
