<?php
/**
 * 文字列に関する静的クラスです。
 */
class StringCommon
{
	/**
	 * 文字列からカンマを取り除いた値を返します。
	 * @param		(string)$value		対象文字列
	 * @return		(string)			結果文字列
	 */
	public static function removeComma($value)
	{
		return str_replace(',', '', $value);
	}

	/**
	 * 文字列がセットされていない、ヌル文字または空文字かを取得します。
	 * @param		(string)$value		対象文字列
	 * @return		(bool)				true:セットされていない、ヌル文字または空文字, false:それ以外
	 */
	public static function isNullOrEmpty($value)
	{
		if (!isset($value) || $value == null || strlen($value) == 0) {
			return true;
		}
		return false;
	}

	/**
	 * 配列をCSV形式の文字列に変換して取得します。
	 * @param		(array)$array		配列
	 * @param		(string)$escape		エスケープ文字
	 * @param		(string)$separator	セパレータ文字
	 * @return		(string)			CSV形式の文字列
	 */
	public static function getCsvString($array, $escape = '"', $separator = ',')
	{
		$ret = join($escape . $separator . $escape);
		$ret = $escape . $ret . $escape;
		return $ret;
	}

	/**
	 * CSV形式の文字列を配列に変換して取得します。
	 * @param		(array)$str			文字列
	 * @param		(string$escape		エスケープ文字
	 * @param		(string)$separator	セパレータ文字
	 * @return		(string)			配列
	 */
	public static function getCsvArray($str, $escape = '"', $separator = ',')
	{
		$ret = split($escape . $separator . $escape, $str);
		$ret[0] = str_replace($escape, '', $ret[0]);
		$ret[count($ret) - 1] = str_replace($escape, '', $ret[count($ret) - 1]);
		return $ret;
	}
}