<?php
require_once(SMARTY_DIR . 'Smarty.class.php');

/**
 * Smartyのラッパークラスです。
 */
class SmartyWrapper extends Smarty
{
	/** コンフィグ */
	public $_config = null;

	/**
	 * コンストラクタです。
	 * @param		(assoc)$config		コンフィグ連想配列
	 */
	public function __construct($config)
	{
		$this->_config = $config;
		$this->left_delimiter = $config['smarty']['left_delimiter'];
		$this->right_delimiter = $config['smarty']['right_delimiter'];
		$this->compile_dir = BIN_DIR . 'compile' . DS;
		$this->config_dir = BIN_DIR . 'config' . DS;
		$this->cache_dir = BIN_DIR . 'cache' . DS;
		$this->caching = $config['smarty']['use_cache'];
	}

	/**
	 * テンプレート変数を設定します。
	 * @see smarty/Smarty#assign($tpl_var, $value)
	 */
	public function assign($tpl_var, $value)
	{
		$this->preAssign($value);
		parent::assign($tpl_var, $value);
	}

	/**
	 * 再帰的なアサイン前処理を実行します。
	 */
	private function preAssign(&$value)
	{
		// 配列の場合
		if (is_array($value)) {
			// 中身を再帰的に実行
			foreach ($value as $k => $v) {
				$this->preAssign($value[$k]);
			}
		}
		// 配列でない場合
		else {
			// エスケープを使う場合
			if ($this->_config['env']['html_escape']) {
				// エスケープする
				$value = htmlspecialchars($value, ENT_QUOTES);
			}
			// エンコード変換
			$value = mb_convert_encoding($value, $this->_config['env']['tpl_encode'], $this->_config['env']['php_encode']);
		}
	}
}