<?php
/**
 * 認証に関するクラスです。
 */
class AuthManager
{
	/** 認証コンフィグ */
	private $_authConfig = null;
	/** データベース接続 */
	private $_db = null;
	/** セッション */
	private $_session = null;

	/**
	 * コンストラクタです。
	 * @param		(assoc)$authConfig	認証コンフィグ
	 * @param		(object)$db			データベース接続
	 */
	public function __construct($authConfig, $db)
	{
		$this->_authConfig = $authConfig;
		$this->_db = $db;
		$this->_session = new SessionManager();
	}

	/**
	 * 認証を実施します。
	 * @param		(string)$param		認証パラメータ
	 * @return		(bool)				認証可否
	 */
	public function authorization($param = null)
	{
		// パラメータが設定されていない場合
		if ($param === null) {
			// パラメータの作成
			$param = array();
			foreach ($this->_authConfig['session_values'] as $value) {
				$param[$value] = $this->_session->get($value);
			}
		}

		// 認証クエリの実行
		$result = $this->_db->execSelectSql($this->_authConfig['check_query'], $param, true);

		// NGの場合
		if ($result === false) {
			return false;
		}

		// 認証結果の保存
		foreach ($this->_authConfig['session_values'] as $value) {
			$this->_session->set($value, $result[$value]);
		}

		// OKを返す
		return true;
	}
}