/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.swt.builder.custom.unitselector;

import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.Unit;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitCategory;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitSet;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcLoggerUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.widgets.Tree;

public class SWTTreeViewUnitSelectorDragListener
extends DragSourceAdapter {
    private TreeViewer treeViewer;

    public SWTTreeViewUnitSelectorDragListener(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public void dragStart(DragSourceEvent event) {
        if (((Tree)this.treeViewer.getControl()).getSelectionCount() == 1) {
            event.doit = true;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        Object object;
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        event.data = object = selection.getFirstElement();
        if (MixedCalcLoggerUtil.isDebugEnabled(((Object)((Object)this)).getClass())) {
            MixedCalcLoggerUtil.debug(((Object)((Object)this)).getClass(), "selected object: " + object);
        }
    }

    private void removeUnitCategory(UnitCategory unitCategory) {
        UnitSet unitSet = unitCategory.getUnitSet();
        if (unitSet != null) {
            unitSet.removeUnitCategory(unitCategory);
        }
    }

    private void removeUnit(Unit unit) {
        UnitCategory unitCategory = unit.getUnitCategory();
        if (unitCategory != null) {
            unitCategory.removeUnit(unit);
        }
    }

    public void dragFinished(DragSourceEvent event) {
        if (MixedCalcLoggerUtil.isDebugEnabled(((Object)((Object)this)).getClass())) {
            MixedCalcLoggerUtil.debug(((Object)((Object)this)).getClass(), "drag finished.");
            MixedCalcLoggerUtil.debug(((Object)((Object)this)).getClass(), "drag out object: " + event.data);
        }
        if (event.detail == 2) {
            if (event.data instanceof Unit) {
                this.removeUnit((Unit)event.data);
            } else if (event.data instanceof UnitCategory) {
                this.removeUnitCategory((UnitCategory)event.data);
            }
        }
    }
}

