/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.lib.impl;

import java.util.Calendar;
import java.util.List;
import jp.gr.java_conf.dev240k.mixedcalc.lib.AbstractMixedCalcLibraryTestCase;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.DefaultBufferParser;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.IBufferParser;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.ValueElement;
import jp.gr.java_conf.dev240k.util.commons.LoggerUtil;

public class DefaultBufferParserTest
extends AbstractMixedCalcLibraryTestCase {
    IBufferParser parser = new DefaultBufferParser();

    public void testParseBinaryBuffer() {
        StringBuffer buffer = new StringBuffer("-101, 1, 10, -1");
        ValueElement result = this.parser.parseBuffer(buffer, 2);
        List list = result.getValueList();
        AbstractMixedCalcLibraryTestCase.assertEquals((double)-5.0, (double)((Double)list.get(0)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)1.0, (double)((Double)list.get(1)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)2.0, (double)((Double)list.get(2)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)-1.0, (double)((Double)list.get(3)), (double)0.01);
    }

    public void testParseFloatBuffer() {
        StringBuffer buffer = new StringBuffer("-1.5, 0.00, 0.01, -3");
        ValueElement result = this.parser.parseBuffer(buffer, 1);
        List list = result.getValueList();
        AbstractMixedCalcLibraryTestCase.assertEquals((double)-1.5, (double)((Double)list.get(0)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)0.0, (double)((Double)list.get(1)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)0.01, (double)((Double)list.get(2)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)-3.0, (double)((Double)list.get(3)), (double)0.01);
    }

    public void testParseOctalBuffer() {
        StringBuffer buffer = new StringBuffer("-175, 63, 774, -1, ");
        ValueElement result = this.parser.parseBuffer(buffer, 3);
        List list = result.getValueList();
        AbstractMixedCalcLibraryTestCase.assertEquals((int)4, (int)list.size());
        AbstractMixedCalcLibraryTestCase.assertEquals((double)-125.0, (double)((Double)list.get(0)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)51.0, (double)((Double)list.get(1)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)508.0, (double)((Double)list.get(2)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)-1.0, (double)((Double)list.get(3)), (double)0.01);
    }

    public void testParseHexadecimalBuffer() {
        StringBuffer buffer = new StringBuffer("-FF, 3a, 4b, -1, -");
        ValueElement result = this.parser.parseBuffer(buffer, 4);
        List list = result.getValueList();
        AbstractMixedCalcLibraryTestCase.assertEquals((int)4, (int)list.size());
        AbstractMixedCalcLibraryTestCase.assertEquals((double)-255.0, (double)((Double)list.get(0)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)58.0, (double)((Double)list.get(1)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)75.0, (double)((Double)list.get(2)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)-1.0, (double)((Double)list.get(3)), (double)0.01);
    }

    public void testParseTimeBuffer() {
        StringBuffer buffer = new StringBuffer("2:30, 3, -1:11:30.05, 0:00:20");
        ValueElement result = this.parser.parseBuffer(buffer, 5);
        List list = result.getValueList();
        AbstractMixedCalcLibraryTestCase.assertEquals((double)9000.0, (double)((Double)list.get(0)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)10800.0, (double)((Double)list.get(1)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)-4290.05, (double)((Double)list.get(2)), (double)1.0E-4);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)20.0, (double)((Double)list.get(3)), (double)0.01);
    }

    public void testParseDateBuffer() {
        Calendar epoch = Calendar.getInstance();
        epoch.set(1970, 0, 1, 0, 0, 0);
        epoch.set(14, 0);
        double epochDouble = (double)epoch.getTimeInMillis() / 8.64E7;
        StringBuffer buffer = new StringBuffer("1970/01/02, 1971, 1969/12/30, 1970/02");
        ValueElement result = this.parser.parseBuffer(buffer, 6);
        List list = result.getValueList();
        AbstractMixedCalcLibraryTestCase.assertEquals((double)(epochDouble + 1.0), (double)((Double)list.get(0)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)(epochDouble + 365.0), (double)((Double)list.get(1)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)(epochDouble + -2.0), (double)((Double)list.get(2)), (double)0.01);
        AbstractMixedCalcLibraryTestCase.assertEquals((double)(epochDouble + 31.0), (double)((Double)list.get(3)), (double)0.01);
    }

    public void testValidateBinaryBuffer() {
        StringBuffer buffer = new StringBuffer("-1");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 2));
        buffer = new StringBuffer("-12");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 2));
        buffer = new StringBuffer("-1, ");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 2));
        buffer = new StringBuffer("-1, 1");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 2));
        buffer = new StringBuffer("-1, 1:");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 2));
    }

    public void testValidateFloatBuffer() {
        StringBuffer buffer = new StringBuffer("-1");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 1));
        buffer = new StringBuffer("-1A");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 1));
        buffer = new StringBuffer("-1F");
        LoggerUtil.debug(((Object)((Object)this)).getClass(), (String)this.parser.parseBuffer(buffer, 1).toString());
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 1));
        buffer = new StringBuffer("-1.");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 1));
        buffer = new StringBuffer("-1.9");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 1));
        buffer = new StringBuffer("-1.9:");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 1));
        buffer = new StringBuffer("-1.9, ");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 1));
    }

    public void testValidateOctalBuffer() {
        StringBuffer buffer = new StringBuffer("-1");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 3));
        buffer = new StringBuffer("-18");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 3));
        buffer = new StringBuffer("-1F");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 3));
        buffer = new StringBuffer("-1.");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 3));
        buffer = new StringBuffer("-1.7");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 3));
        buffer = new StringBuffer("-7:");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 3));
        buffer = new StringBuffer("-17, ");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 3));
        buffer = new StringBuffer("-17, -");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 3));
        buffer = new StringBuffer("-17, --");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 3));
    }

    public void testValidateHexadecimalBuffer() {
        StringBuffer buffer = new StringBuffer("-1");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 4));
        buffer = new StringBuffer("-18");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 4));
        buffer = new StringBuffer("-1F");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 4));
        buffer = new StringBuffer("-1.");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 4));
        buffer = new StringBuffer("-1.7");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 4));
        buffer = new StringBuffer("-7:");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 4));
        buffer = new StringBuffer("-fa, ");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 4));
    }

    public void testValidateTimeBuffer() {
        StringBuffer buffer = new StringBuffer("-1");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 5));
        buffer = new StringBuffer("-18");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 5));
        buffer = new StringBuffer("-1A");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 5));
        buffer = new StringBuffer("-1.");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 5));
        buffer = new StringBuffer("-1.7:2");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 5));
        buffer = new StringBuffer(":a");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 5));
        buffer = new StringBuffer("-5.0:2.1, ");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 5));
    }

    public void testValidateDateBuffer() {
        StringBuffer buffer = new StringBuffer("-1");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 6));
        buffer = new StringBuffer("1990/A");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 6));
        buffer = new StringBuffer("1999/10/10.1");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 6));
        buffer = new StringBuffer("/10");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)false, (boolean)this.parser.validateBuffer(buffer, 6));
        buffer = new StringBuffer("1999/2/30");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 6));
        buffer = new StringBuffer("2008/02/29");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 6));
        buffer = new StringBuffer("1889/10/12, ");
        AbstractMixedCalcLibraryTestCase.assertEquals((boolean)true, (boolean)this.parser.validateBuffer(buffer, 6));
    }
}

