/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.lib.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IBufferElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IElementModifyListener;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IInitialElementFactory;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IValueElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.MixedCalcLibraryInnerException;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.MixedCalcLibraryUtil;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.action.IAction;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.action.IBufferEditor;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.action.IConstantOperator;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.action.IDyadicOperator;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.action.IGeneralAction;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.action.IMonadicOperator;
import jp.gr.java_conf.dev240k.util.commons.LoggerUtil;

public class Calculator {
    private List elementModifyListenerList = new ArrayList();
    private IInitialElementFactory initialElementFactory;
    private LinkedList elements = new LinkedList();
    private Map properties = new HashMap();

    public Object getProperty(String key) {
        Object obj = this.properties.get(key);
        return obj;
    }

    public void setProperty(String key, Object property) {
        this.properties.put(key, property);
    }

    public IElement getThirdElement() {
        ListIterator it = this.elements.listIterator(this.elements.size());
        if (!it.hasPrevious()) {
            return null;
        }
        it.previous();
        if (!it.hasPrevious()) {
            return null;
        }
        it.previous();
        if (!it.hasPrevious()) {
            return null;
        }
        return (IElement)it.previous();
    }

    public IElement getSecondElement() {
        ListIterator it = this.elements.listIterator(this.elements.size());
        if (!it.hasPrevious()) {
            return null;
        }
        it.previous();
        if (!it.hasPrevious()) {
            return null;
        }
        return (IElement)it.previous();
    }

    public IElement getLastElement() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return (IElement)this.elements.getLast();
    }

    public IDyadicOperator getOperator() {
        ListIterator it = this.elements.listIterator(this.elements.size());
        while (it.hasPrevious()) {
            Object obj = it.previous();
            if (!(obj instanceof IDyadicOperator)) continue;
            return (IDyadicOperator)obj;
        }
        return null;
    }

    public IElement getLastValue() {
        ListIterator it = this.elements.listIterator(this.elements.size());
        while (it.hasPrevious()) {
            Object obj = it.previous();
            if (!(obj instanceof IValueElement) && !(obj instanceof IBufferElement)) continue;
            return (IElement)obj;
        }
        return null;
    }

    public IInitialElementFactory getInitialElementFactory() {
        return this.initialElementFactory;
    }

    public void setInitialElementFactory(IInitialElementFactory initialElementFactory) {
        this.initialElementFactory = initialElementFactory;
    }

    public List getElementModifyListenerList() {
        return this.elementModifyListenerList;
    }

    public void addElementModifyListener(IElementModifyListener elementModifyListener) {
        this.elementModifyListenerList.add(elementModifyListener);
    }

    private void addInitialElement() {
        if (this.initialElementFactory != null) {
            this.elements.addLast(this.initialElementFactory.newInitialElement());
        }
    }

    private void removeAllElements() {
        while (!this.elements.isEmpty()) {
            this.elements.removeFirst();
        }
    }

    public void initializeCalculator() {
        if (LoggerUtil.isDebugEnabled(this.getClass())) {
            LoggerUtil.debug(this.getClass(), (String)"initialize.");
        }
        this.initializeStackElements();
    }

    public void initializeStackElements() {
        this.removeAllElements();
        this.addInitialElement();
    }

    public void initializeLastElement() {
        if (this.getLastElement() instanceof IDyadicOperator) {
            this.elements.removeLast();
        }
        if (!this.elements.isEmpty()) {
            this.elements.removeLast();
        }
        this.addInitialElement();
    }

    public void invokeModifyListener() {
        Iterator it = this.getElementModifyListenerList().iterator();
        while (it.hasNext()) {
            IElementModifyListener listener = (IElementModifyListener)it.next();
            if (listener == null) continue;
            if (LoggerUtil.isDebugEnabled(this.getClass())) {
                LoggerUtil.debug(this.getClass(), (String)("invoke modifyListener: " + listener.getClass().getName()));
            }
            listener.modifyElement(this);
        }
    }

    private void executeGeneralAction(IGeneralAction action) {
        action.execute(this);
    }

    private void executeBufferEditor(IBufferEditor editor) {
        IElement last = this.getLastElement();
        if (last == null || last instanceof IValueElement || last instanceof IDyadicOperator) {
            IBufferElement element = editor.newBuffer();
            if (element == null) {
                return;
            }
            if (last instanceof IValueElement) {
                this.elements.removeLast();
            }
            this.elements.addLast(element);
            return;
        }
        if (last instanceof IBufferElement) {
            editor.editBuffer((IBufferElement)last);
            return;
        }
        throw new MixedCalcLibraryInnerException(MixedCalcLibraryUtil.getMessage("message.error.IllegalInnerElement"));
    }

    private void executeConstantOperator(IConstantOperator operator) {
        IElement last = this.getLastElement();
        if (last instanceof IBufferElement || last instanceof IValueElement) {
            this.elements.removeLast();
        }
        IValueElement result = operator.getConstantElement();
        this.elements.addLast(result);
    }

    private void executeMonadicOperator(IMonadicOperator operator) {
        IValueElement lastValue;
        IElement last = this.getLastElement();
        IDyadicOperator lastOperator = null;
        if (last == null) {
            return;
        }
        if (last instanceof IBufferElement) {
            lastValue = ((IBufferElement)last).toValueElement();
        } else if (last instanceof IDyadicOperator) {
            lastOperator = (IDyadicOperator)this.elements.removeLast();
            last = this.getLastElement();
            if (!(last instanceof IValueElement)) {
                throw new MixedCalcLibraryInnerException(MixedCalcLibraryUtil.getMessage("message.error.IllegalInnerElement"));
            }
            lastValue = (IValueElement)last;
        } else if (last instanceof IValueElement) {
            lastValue = (IValueElement)last;
        } else {
            throw new MixedCalcLibraryInnerException(MixedCalcLibraryUtil.getMessage("message.error.IllegalInnerElement"));
        }
        IValueElement result = operator.operateElement(lastValue);
        this.elements.removeLast();
        this.elements.addLast(result);
        if (lastOperator != null) {
            this.elements.addLast(lastOperator);
        }
    }

    private void executeDyadicOperator(IDyadicOperator operator) {
        IValueElement lastValue;
        IElement last = this.getLastElement();
        if (last == null) {
            return;
        }
        if (last instanceof IDyadicOperator) {
            this.elements.removeLast();
            this.elements.addLast(operator);
            return;
        }
        if (last instanceof IBufferElement) {
            lastValue = ((IBufferElement)last).toValueElement();
            this.elements.removeLast();
            this.elements.addLast(lastValue);
        } else if (last instanceof IValueElement) {
            lastValue = (IValueElement)last;
        } else {
            throw new MixedCalcLibraryInnerException(MixedCalcLibraryUtil.getMessage("message.error.IllegalInnerElement"));
        }
        IElement second = this.getSecondElement();
        if (second == null) {
            this.elements.addLast(operator);
            return;
        }
        if (!(second instanceof IDyadicOperator)) {
            throw new MixedCalcLibraryInnerException(MixedCalcLibraryUtil.getMessage("message.error.IllegalInnerElement"));
        }
        IDyadicOperator secondOperator = (IDyadicOperator)second;
        IElement third = this.getThirdElement();
        if (!(third instanceof IValueElement)) {
            throw new MixedCalcLibraryInnerException(MixedCalcLibraryUtil.getMessage("message.error.IllegalInnerElement"));
        }
        IValueElement thirdValue = (IValueElement)third;
        IValueElement result = secondOperator.operateTwoElements(thirdValue, lastValue);
        this.removeAllElements();
        this.elements.addLast(result);
        this.elements.addLast(operator);
    }

    public void executeAction(IAction action) {
        if (action == null) {
            return;
        }
        if (LoggerUtil.isDebugEnabled(this.getClass())) {
            LoggerUtil.debug(this.getClass(), (String)("executeAction( " + action.getClass().getName() + " )"));
        }
        if (this.getLastElement() == null) {
            this.addInitialElement();
        }
        if (action instanceof IGeneralAction) {
            this.executeGeneralAction((IGeneralAction)action);
        } else if (action instanceof IConstantOperator) {
            this.executeConstantOperator((IConstantOperator)action);
        } else if (this.getLastElement() instanceof IBufferElement) {
            if (action instanceof IBufferEditor) {
                this.executeBufferEditor((IBufferEditor)action);
            } else if (action instanceof IMonadicOperator) {
                this.executeMonadicOperator((IMonadicOperator)action);
            } else if (action instanceof IDyadicOperator) {
                this.executeDyadicOperator((IDyadicOperator)action);
            }
        } else if (action instanceof IMonadicOperator) {
            this.executeMonadicOperator((IMonadicOperator)action);
        } else if (action instanceof IBufferEditor) {
            this.executeBufferEditor((IBufferEditor)action);
        } else if (action instanceof IDyadicOperator) {
            this.executeDyadicOperator((IDyadicOperator)action);
        }
        this.invokeModifyListener();
    }
}

