/**
 *  queryRender
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: queryRender.js,v $ $Revision: 1.1 $ $Date: 2006/11/25 12:32:04 $
 * 
 *  @requires  mController
 *  @requires  mUtils
 *  @member    mController
**/
{
 /**
  *  render target object
  * 
  *  @private
 **/
 this._renderTarget = null;

 /**
  *  render value
  *
  *  @private
 **/
 this._renderValue = null;

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.init = function()
 {
 };

 /**
  *  setRenderTarget
  * 
  *  @param   object  targetObject  // render target object
  * 
  *  @return  void
 **/
 this.setRenderTarget = function(targetObject)
 {
  this._renderTarget = targetObject;
 };

 /**
  *  setRenderValue
  * 
  *  @param   object  val  // value
  *
  *  @return  void
 **/
 this.setRenderValue = function(obj)
 {
  this._renderValue = obj;
 };

 /**
  *  display
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.display = function()
 {
  if(this._renderTarget == undefined)
  {
   mUtils.logger.setMessage('warning','queryRender','display',mUtils.language.getLanguage('mRenderNotSet'));
   return;
  }
  try
  {
   var arr = [];
   for(var i in this._renderValue)
    arr.push(i + '=' + this._renderValue[i]);
   var obj = DomUtils.createObject('queryNavigation','a',
       {'href' : location.pathname + '?' + arr.join('&'),
        'innerHTML' : mUtils.config.getConfig('navigationString')},{});
   this._renderTarget.appendChild(obj);
  }
  catch(e)
  {
   mUtils.logger.setMessage('warning','queryRender','display',mUtils.language.getLanguage('mRenderNotWrite'));
  }
 };
};
