/**
 *  formRender
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: formRender.js,v $ $Revision: 1.1 $ $Date: 2006/11/24 13:36:51 $
 * 
 *  @requires  mController
 *  @requires  mUtils
 *  @member    mController
**/
{
 /**
  *  render target object
  * 
  *  @private
 **/
 this._renderTarget = null;

 /**
  *  render value
  *
  *  @private
 **/
 this._renderValue = null;

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.init = function()
 {
 };

 /**
  *  setRenderTarget
  * 
  *  @param   object  targetObject  // render target object
  * 
  *  @return  void
 **/
 this.setRenderTarget = function(targetObject)
 {
  this._renderTarget = targetObject;
 };

 /**
  *  setRenderValue
  * 
  *  @param   object  obj  // value
  *
  *  @return  void
 **/
 this.setRenderValue = function(obj)
 {
  this._renderValue = obj;
 };

 /**
  *  display
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.display = function()
 {
  var frm = this._renderTarget;
  var val = this._renderValue;
  if(!frm)
  {
   mUtils.logger.setMessage('warning','formRender','display',mUtils.language.getLanguage('mRenderNotSet'));
   return;
  }
  try
  {
   for(var i in frm.elements)
   {
    var obj = frm.elements[i];
    if(val[obj.id] != undefined)
     switch(obj.type)
     {
      case 'textbox':
      case 'textarea':
      case 'select-one':
       obj.value = val[obj.id];
       break;
      case 'radio':
      case 'checkbox':
       obj.checked = val[obj.id] ? true : false;
       break;
      default:
       break;
     }
   }
  }
  catch(e)
  {
   mUtils.logger.setMessage('warning','formRender','display',mUtils.language.getLanguage('mRenderNotWrite'));
  }
 };
};
