/**
 *  domRender
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: domRender.js,v $ $Revision: 1.1 $ $Date: 2006/11/22 09:10:00 $
 * 
 *  @requires  mController
 *  @requires  mUtils
 *  @member    mController
**/
{
 /**
  *  render target object
  * 
  *  @private
 **/
 this._renderTarget = null;

 /**
  *  render value object
  * 
  *  @private
 **/
 this._renderValue = null;

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.init = function()
 {
 };

 /**
  *  setRenderTarget
  * 
  *  @param   object  targetObject  // render target object
  * 
  *  @return  void
 **/
 this.setRenderTarget = function(targetObject)
 {
  this._renderTarget = targetObject;
 };

 /**
  *  setRenderValue
  * 
  *  @param   object  obj  // value
  *
  *  @return  void
 **/
 this.setRenderValue = function(obj)
 {
  this._renderValue = obj;
 };

 /**
  *  display
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.display = function()
 {
  if(this._renderTarget == undefined)
  {
   mUtils.logger.setMessage('warning','domRender','display',mUtils.language.getLanguage('mRenderNotSet'));
   return;
  }
  try
  {
   this._renderTarget.appendChild(this._renderValue);
  }
  catch(e)
  {
   mUtils.logger.setMessage('warning','domRender','display',mUtils.language.getLanguage('mRenderNotWrite'));   
  }
 };
};
