/**
 *  mUtils
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: mUtils.js,v $ $Revision: 1.24 $ $Date: 2006/12/11 09:38:27 $
 * 
 *  @requires DomUtils
 *  @requires HttpRequestUtils
**/
var mUtils = 
{
 /**
  *  config object
  * 
  *  @see  mConfig
 **/
 config :
 {
  /**
   *  default config data object
   * 
   *  @private
  **/
  _defaultData :
  {
   'renderFile'        : 'dummyRender.js',
   'requestFile'       : 'dummyRequest.js',
   'loggerFile'        : 'logger.js',
   'languageFile'      : 'language.js',
   'filterFile'        : 'filter.js',
   'validatorFile'     : 'validator.js',
   'language'          : 'en',
   'onloadAction'      : null,
   'useCustomConfig'   : false,
   'useDebug'          : false,
   'useDirLanguage'    : false,
   'useCustomLanguage' : false
  },

  /**
   *  config data object
   * 
   *  @private
  **/
  _configData : {},

  /**
   *  custom config data object
   * 
   *  @private
  **/
  _customData : {},

  /**
   *  init
   * 
   *  @param   void
   * 
   *  @return  void
  **/
  init : function()
  {
   this._defaultData.rootPath = DomUtils.getObject('mutanrootpath').src.replace(/\/\w+\.js.*/,'/');
   this._loadConfig();
  },

  /**
   *  _loadConfig
   * 
   *  @param   void
   * 
   *  @return  void
   * 
   *  @see     mUtils#_setupConfig
   *  @private
  **/
  _loadConfig : function()
  {
   mUtils.loadFile('./config.js');
   mUtils.waitResponse(this,{'_configData' : './config.js'},this._setupConfig,null);
  },

  /**
   *  _setupConfig
   * 
   *  @param   void
   * 
   *  @return  void
   * 
   *  @see     mUtils#_loadUtils
   *  @private
  **/
  _setupConfig : function()
  {
   mUtils.config._setDefaultPath('render'   ,'render/');
   mUtils.config._setDefaultPath('request'  ,'request/');
   mUtils.config._setDefaultPath('logger'   ,'lib/');
   mUtils.config._setDefaultPath('language' ,'lib/');
   mUtils.config._setDefaultPath('filter'   ,'lib/');
   mUtils.config._setDefaultPath('validator','lib/');
   mUtils.config._setDefaultPath('config'   ,'configs/');
   mUtils.config._setDefaultPath('sysLang'  ,'lang/');
   mUtils.config._setDefaultPath('model'    ,'models/');
   mUtils.config._setDefaultPath('action'   ,'actions/');
   mUtils.config._setDefaultPath('languages','lang/');
   mUtils._loadUtils();
  },

  /**
   *  _setDefaultPath
   * 
   *  @param   string  keyName  // target key name
   *  @param   string  value    // setting value
   * 
   *  @return  void
   * 
   *  @private
  **/
  _setDefaultPath : function(keyName,value)
  {
   this._defaultData[keyName + 'Path'] = this.getConfig('rootPath') + value;
  },

  /**
   *  loadCustomConfig
   * 
   *  @param  string    actionName  // target action name
   *  @param  function  func        // onload function
   *  @param  object    args        // arguments of onload function
   * 
   *  @return  void
  **/
  loadCustomConfig : function(actionName,func,args)
  {
   this.resetConfig();
   if(this.getConfig('useCustomConfig'))
   {
    var file = this.getConfig('configPath') + actionName + 'Config.js';
    mUtils.loadFile(file);
    mUtils.waitResponse(this,{'_customData' : file},func,args);
   }
   else
   {
    func(args);
   }
  },

  /**
   *  setConfig
   * 
   *  @param   string  keyName  // target key name
   *  @param   string  value    // setting value
   * 
   *  @return  void
  **/
  setConfig : function(keyName,value)
  {
   this._customData[keyName] = value;
  },

  /**
   *  resetConfig
   * 
   *  @param   void
   * 
   *  @return  void
  **/
  resetConfig : function()
  {
   this._customData = {};
  },

  /**
   *  getConfig
   * 
   *  @param   string  keyName  // target key name
   * 
   *  @return  string
  **/
  getConfig : function(keyName)
  {
   switch(true)
   {
    case this._customData[keyName] !== undefined:
     return this._customData[keyName];
    case this._configData[keyName] !== undefined:
     return this._configData[keyName];
    case this._defaultData[keyName] !== undefined:
     return this._defaultData[keyName];
    default:
     mUtils.logger.setMessage('notice','mConfig','get config',
            mUtils.language.getLanguage('mConfigUndefined',{'keyName' : keyName}));
     return null;
   }
  }
 },

 /**
  *  logger object
  * 
  *  @see  mLogger
 **/
 logger : {},

 /**
  *  langage object
  * 
  *  @see  mLanguage
 **/
 language : {},

 /**
  *  validator objects
  * 
  *  @see  mValidator
 **/
 validator : {},

 /**
  *  filter objects
  * 
  *  @see  mFilter
 **/
 filter : {},

 /**
  *  context object
 **/
 context : {},

 /**
  *  object cache
  * 
  *  @see  mUtils.loadFile
  * 
  *  @private
 **/
 _objectCache : {},

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 init : function()
 {
  mUtils.config.init();
 },

 /**
  *  _loadUtils
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mUtils#_setupUtils
  *  @private
 **/
 _loadUtils : function()
 {
  var config    = mUtils.config;
  var logger    = config.getConfig('loggerPath') + config.getConfig('loggerFile');
  var language  = config.getConfig('languagePath') + config.getConfig('languageFile')
  var filter    = config.getConfig('filterPath') + config.getConfig('filterFile')
  var validator = config.getConfig('validatorPath') + config.getConfig('validatorFile')
  mUtils.loadFile(logger);
  mUtils.loadFile(language);
  mUtils.loadFile(filter);
  mUtils.loadFile(validator);
  mUtils.waitResponse(mUtils,
        {'logger' : logger,'language' : language,'filter' : filter,'validator' : validator},
        mUtils._setupUtils,null);
 },

 /**
  *  _setupUtils
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mUtils#_loadDirLanguage
  *  @private
 **/
 _setupUtils : function()
 {
  mUtils.logger.init();
  mUtils.language.init();
  mUtils._loadDirLanguage();
 },

 /**
  *  _loadDirLanguage
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mUtils#_setupDirLanguage
  *  @private
 **/
 _loadDirLanguage : function()
 {
  mUtils.language.loadDirLanguage(mUtils._executeOnloadAction,null);
 },

 /**
  *  _executeOnloadAction
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#doAction
  *  @private
 **/
 _executeOnloadAction : function()
 {
  var actionName = mUtils.config.getConfig('onloadAction');
  if(actionName != null)
   mController.doAction(actionName);
 },

 /**
  *  loadFile
  * 
  *  @param   string  file  // target file address
  *  @param   bool    mode  // is string mode
  * 
  *  @return  void
 **/
 loadFile : function(file,mode)
 {
  if(mUtils._objectCache[file] != undefined)
   return;
  var cli = HttpRequestUtils.getClient('get',file);
  cli.callbacks['200'] = function(res)
  {
   if(mode)
   {
    mUtils._objectCache[file] = res.txt;
    return;
   }
   try
   {
    mUtils._objectCache[file] = Function(res.txt);
   }
   catch(e)
   {
    mUtils.logger.setMessage('warning','mUtils','loadFile',
           mUtils.language.getLanguage('mUtilsErrorParse',{'file' : file}));
    mUtils._objectCache[file] = res.txt;
   }
  };
  cli.callbacks['404'] = function(res)
  {
   try
   {
    mUtils.logger.setMessage('warning','mUtils','loadFile',
           mUtils.language.getLanguage('mUtilsError404',{'file' : file}));
    mUtils._objectCache[file] = {};
   }
   catch(e)
   {
    throw new EvalError(file + ' is file not found');
   }
  };
  cli.callbacks['unknown'] = function(res)
  {
   throw new EvalError('file load error');
  }
  cli.send('');
 },

 /**
  *  waitResponse
  * 
  *  @param   object    pObj  // parent object for cache mapping
  *  @param   hash      list  // mapping list
  *  @param   function  fnc   // onload function
  *  @param   object    args  // arguments for onload function
  * 
  *  @return  void
 **/
 waitResponse : function(pObj,list,fnc,args)
 {
  var flag = true;
  for(var i in list)
  {
   if(mUtils._objectCache[list[i]] == undefined)
   {
    flag = false;
    break;
   }
   try
   {
    if(typeof mUtils._objectCache[list[i]] == 'string')
     pObj[i] = mUtils._objectCache[list[i]];
    else
     pObj[i] = new mUtils._objectCache[list[i]];
   }
   catch(e)
   {
    mUtils.logger.setMessage('warning','mUtils','waitResponse',
           mUtils.language.getLanguage('mUtilsCantConst',{'obj' : list[i]}));
    pObj[i] = {};
   }
  }
  if(flag)
   fnc(args);
  else
   setTimeout(function(){mUtils.waitResponse(pObj,list,fnc,args)},100);
 },

 /**
  *  preloadActionFile
  * 
  *  @param   array   actions
  * 
  *  @return  void
 **/
 preloadActionFile : function(actions)
 {
  var conf = this.config;
  for(var i in actions)
  {
   var actionName = actions[i];
   if(conf.getConfig('useCustomConfig'))
    this.loadFile(conf.getConfig('configPath') + actionName + 'Config.js');
   if(conf.getConfig('useCustomLanguage'))
    this.loadFile(conf.getConfig('languagesPath') + conf.getConfig('language') + '/' + actionName + 'Lang.js');
   this.loadFile(conf.getConfig('modelPath') + actionName + 'Model.js');
   this.loadFile(conf.getConfig('actionPath') + actionName + 'Action.js');
  }
 },

 /**
  *  renderLog
  * 
  *  @param   enum  level  // target error level
  *  @param   bool  flag   // multiple level message flag
  * 
  *  @return  void
 **/
 renderLog : function(level,flag)
 {
  var mes = this.logger.getMessageString(level,flag);
  try
  {
   DomUtils.getObject('mutanLogBox').innerHTML = mes;
  }
  catch(e)
  {
   document.body.appendChild(DomUtils.createObject('mutanLogBox','div',{'innerHTML' : mes},{}));
  }
 },

 /**
  *  appendValidator
  * 
  *  @param   hash  validators  // validator hash
  * 
  *  @return  void
 **/
 appendValidator : function(validators)
 {
  for(var i in validators)
   this.validator[i] = validators[i];
 },

 /**
  *  appendFilter
  * 
  *  @param   hash  fils  // filter hash
  * 
  *  @return  void
 **/
 appendFilter : function(filters)
 {
  for(var i in filters)
   this.filter[i] = filters[i];
 },

 /**
  *  doTypeSafe
  * 
  *  @param   enum    type   // data type
  *                     bool,int,float,string,text
  *  @param   string  value  // data value
  * 
  *  @return  string
 **/
 doTypeSafe : function(type,value)
 {
  switch(type)
  {
   case 'bool':
    return value ? true : false;
    break;
   case 'int':
    return parseInt(value,10);
    break;
   case 'float':
    return parseFloat(value);
    break;
   case 'string':
    value = value.replace(/(\xd\x0a)|(\x0a)|(\x0d)/g,'');
   case 'text':
   default:
    return value;
    break;
  }
 },

 /**
  *  doValidate
  * 
  *  @param   string  value      // data value
  *  @param   array   validator  // validator name array
  *  @param   hash    params     // parameter object
  * 
  *  @return  string
 **/
 doValidate : function(value,validator,params)
 {
  var flag     = true;
  for(var v in validator)
   if(!this.validator[v](value,params))
    flag = false;
  return flag ? value : null;
 },

 /**
  *  doFilter
  * 
  *  @param   string  value   // data value
  *  @param   array   filter  // filter name array
  *  @param   hash    params  // parameter object
  * 
  *  @return  string
 **/
 doFilter : function(value,filter,params)
 {
  for(var v in filter)
   value = this.filter[filter[v]](value,params);
  return value;
 }
};


DomUtils.appendEvent(window,'load',mUtils.init,'normal');
