/**
 *  DomUtils
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: domUtils.js,v $ $Revision: 1.7 $ $Date: 2006/12/11 09:38:27 $
**/
var DomUtils =
{
 /**
  *  object cache
  * 
  *  @private
 **/
 _objArr : {},

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 init : function()
 {
 },

 /**
  *  getObject
  * 
  *  @param   string  targetId  // target object id
  * 
  *  @return  object
 **/
 getObject : function(targetId)
 {
  var obj = DomUtils._objArr[targetId];
  if(!obj)
  {
   obj = document.getElementById(targetId);
   DomUtils._objArr[targetId] = obj;
  }
  return obj;
 },

 /**
  *  createObject
  * 
  *  @param   string  targetId  // new object id
  *  @param   string  type      // new object type
  *  @param   hash    params    // new object propety
  *  @param   hash    styles    // new object style
  * 
  *  @return  object
 **/
 createObject : function(targetId,type,params,styles)
 {
  var obj = document.createElement(type);
  obj.id = targetId;
  for(var i in params)
   obj[i] = params[i];
  for(var i in styles)
   obj.style[i] = styles[i];
  DomUtils._objArr[targetId] = obj;
  return obj;
 },

 /**
  *  clearCache
  * 
  *  @param   string  targetId  // target object Id
  * 
  *  @return  void
 **/
 clearCache : function(targetId)
 {
  if(targetId != null)
   DomUtils._objArr[targetId] = null;
  else
   DomUtils._objArr = {};
 },

 /**
  *  appendEvent
  * 
  *  @param   object    obj       // target object
  *  @param   string    eveName   // event name
  *  @param   function  fnc       // function
  *  @param   enum      priority  // event priority
  *                       first,normal,last
  * 
  *  @return  void
 **/
 appendEvent : function(obj,eveName,fnc,priority)
 {
  switch(true)
  {
   case obj.callbacks == undefined:
    obj.callbacks = {};
   case obj.callbacks[eveName] == undefined:
    obj.callbacks[eveName] = {'first'  : [],'normal' : [],'last'   : []};
    obj['on' + eveName] = function()
    {
     DomUtils.raiseEvent(obj,eveName,null);
     return false;
    };
   default:
    break;
  }
  if(priority != 'first' && priority != 'last')
   priority = 'normal';
  obj.callbacks[eveName][priority].push(fnc);
 },

 /**
  *  raiseEvent
  * 
  *  @param   object  obj      // target object
  *  @param   string  eveName  // event name
  *  @param   object  args     // argments
  * 
  *  @return  void
 **/
 raiseEvent : function(obj,eveName,args)
 {
  try
  {
   var tmp = obj.callbacks[eveName];
   var arr = tmp.first.concat(tmp.normal,tmp.last);
   for(var i in arr)
    arr[i](args);
  }
  catch(e)
  {
  }
 }
}

DomUtils.appendEvent(window,'load',DomUtils.init,'first');
