/**
 * # CHAPTER #
 * ============================================================================
 * ʬɽϢΥإåե
 * ============================================================================
 */

#ifndef _CLASSTABLE_H
#define _CLASSTABLE_H

#include <readData.h>

/**
 * # STRUCT #
 * ʬɽ¤
 * +--------+------------------------------------------+
 * |        |  Predicted as                            +
 * |        +---------+---------+---+---------+--------+
 * |        |  cls0   |  cls1   |...|  clsN   | Total  |
 * +---+----+---------+---------+---+---------+--------+
 * |   |    | cnt[0,0]| cnt[0,1]|   | cnt[0,N]|atCnt[0]|
 * | A |cls0|aShr[0,0]|aShr[0,1]|   |aShr[0,N]|atShr[0]|
 * | c |    |pShr[0,0]|pShr[0,1]|   |pShr[0,N]|        |
 * | t |    | cst[0,0]| cst[0,1]|   | cst[0,N]|atCst[0]|
 * | u +----+---------+---------+---+---------+--------+
 * | a |    | cnt[1,0]| cnt[1,1]|   | cnt[1,N]|atCnt[1]|
 * | l |cls1|aShr[1,0]|aShr[1,1]|   |aShr[1,N]|atShr[1]|
 * |   |    |pShr[1,0]|pShr[1,1]|   |pShr[1,N]|        |
 * |   |    | cst[1,0]| cst[1,1]|   | cst[1,N]|atCst[1]|
 * |   +----+---------+---------+---+---------+--------+
 * |   |    |         |         | : |         |        |
 * |   +----+---------+---------+---+---------+--------+
 * |   |    | cnt[N,0]| cnt[N,1]|   | cnt[N,N]|atCnt[N]|
 * |   |clsN|aShr[N,0]|aShr[N,1]|   |aShr[N,N]|atShr[N]|
 * |   |    |pShr[N,0]|pShr[N,1]|   |pShr[N,N]|        |
 * |   |    | cst[N,0]| cst[N,1]|   | cst[N,N]|atCst[N]|
 * |   +----+---------+---------+---+---------+--------+
 * |   |    | ptCnt[0]| ptCnt[1]|   | ptCnt[N]|   tCnt |
 * |   |Ttl | ptShr[0]| ptShr[1]|   | ptShr[N]|        |
 * |   |    | ptCst[0]| ptCst[1]|   | ptCst[N]|   tCst |
 * +---+----+---------+---------+---+---------+--------+
 * aShr[x,y]=cnt[x,y]/atCnt[x]
 * pShr[x,y]=cnt[x,y]/ptCnt[y]
 * atShr[x]=atCnt[x]/tCnt
 * ptShr[x]=ptCnt[x]/tCnt
 */
struct ClsTbl {
  int      cnt[MaxClsLen][MaxClsLen]; /*ƥη*/
  double  aShr[MaxClsLen][MaxClsLen]; /*actualTotalФ륷*/
  double  pShr[MaxClsLen][MaxClsLen]; /*predictedTotalФ륷*/
  double   cst[MaxClsLen][MaxClsLen]; /*ƥΥ*/
  int    atCnt[MaxClsLen];            /*actualTotal*/
  double atShr[MaxClsLen];            /*actualTotaltotalФ륷*/
  double atCst[MaxClsLen];            /*actualTotal*/
  int    ptCnt[MaxClsLen];            /*predictedTotal*/
  double ptShr[MaxClsLen];            /*predictedTotaltotalФ륷*/
  double ptCst[MaxClsLen];            /*predictedTotal*/
  int    tCnt;                       /*total*/
  double tCst;                       /*total*/

  int    accCnt;                     /**/
  int    errCnt;                     /*顼*/
  double accRate;                    /*Ψ accCnt/tCnt*/
  double errRate;                    /*顼Ψ errCnt/tCnt*/
  double geoMean;                    /*ƥ饹Ψδʿ(ºݤ)*/
};

/**
 * # PROTOTYPE #
 */
struct ClsTbl *initClsTbl(void);
void calClsTbl(struct ClsTbl *ct, struct Cost *cost);
void showClsTbl(struct ClsTbl *ct,struct Data *dat,struct mssFPW *fpw);

#endif
