/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤXMLǡϴϢδؿ
 * ============================================================================
 */

#include <mssXml.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <sys/time.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/encoding.h>
#include <iconv.h>
#include <errno.h> 
#include <glob.h>

/*############################################################################*/
/* Хѿ                                                             */
/*############################################################################*/
xmlParserCtxtPtr ctxt;

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * ʸΥ󥳡ǥѴ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * ʸstrencoding롣encodingˡϥХѿicidǷޤ롣
 *  : Ѵʸݥ󥿤֤
 *        strNULLʤNULL֤
 *        encodingˡꤵƤʤstr֤
 * icidˡ
 * include <iconv.h>
 * icid=iconv_open("UTF-8","EUC-JP"); EUC-JPUTF-8ؤѴ
 */
char *mssEncoding(char *str, iconv_t *icid)
{
  size_t  encilen; /*iconv ʸĹ*/
  size_t  encolen; /*iconv ʸĹ*/
  char *encip;     /*iconv ʸ򼨤ݥ */
  char *encop;     /*iconv ʸ򼨤ݥ */
  char *outStr;    /*ʸѥݥ*/
  int  encMax;

  if(str==NULL)return(NULL);
  if(icid==NULL)return(str);
  if(*str=='\0')return(str);

  encMax=strlen(str)*4;

  /*ʸΣܤΰ*/
  outStr=mssCalloc(sizeof(char)*encMax,"encoding");
  encip=str;
  encop=outStr;
  encilen=strlen(encip)+1;
  encolen=encMax;
  if(-1==iconv(icid,&encip,&encilen,&encop,&encolen)){
    mssShowErrMsg("encoding error in iconv");
    exit(mssErrorNoDefault);
  }
  return(outStr);
}

/**
 * # FUNCTION #
 * mssEncodingؿʸС
 */
char *mssNencoding(char *str, int len, iconv_t *icid)
{
  size_t  encilen; /*iconv ʸĹ*/
  size_t  encolen; /*iconv ʸĹ*/
  char *encip;     /*iconv ʸ򼨤ݥ */
  char *encop;     /*iconv ʸ򼨤ݥ */
  char *outStr;    /*ʸѥݥ*/
  int  encMax;

  if(str==NULL)return(NULL);
  if(icid==NULL)return(str);

  encMax=strlen(str)*4;

  /*ʸΣܤΰ*/
  outStr=mssCalloc(sizeof(char)*encMax,"encoding");
  encip=str;
  encop=outStr;
  encilen=len;
  encolen=encMax;
  if(-1==iconv(icid,&encip,&encilen,&encop,&encolen)){
    mssShowErrMsg("encoding error in iconv");
    exit(mssErrorNoDefault);
  }
  return(outStr);
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * XML˴ؤʸ󢫢mssXmlTag¤ΡѴ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * mssXmlTag¤Τν
 * ̾(element)Ͽ(ݤ)
 * icidåȤƤ(NULLǤʤ)󥳡ǥ󥰤Ѵ򤪤ʤ
 * °򥻥åȤmssAddXmlTagAttribute{Str,Int,Dbl}Ѥ롣
 * elementNULLλNULL֤
 * element'\0'ξϥ顼λ
 */
struct mssXmlTag *mssInitXmlTag(char *element, iconv_t *icid)
{
  struct mssXmlTag *xmlTag;

  if(element==NULL){
    xmlTag=NULL;
  }else if(*element=='\0'){
    mssShowErrMsg("name of XML element is NULL");
    exit(mssErrorNoDefault);
  }else{
    xmlTag=mssCalloc(sizeof(struct mssXmlTag),"initXmlTag");
    if(icid==NULL){
      xmlTag->element=mssStrdup(element);
    }else{
      xmlTag->element=mssEncoding(element,icid);
    }
  }
  return(xmlTag);
}

/**
 * # FUNCTION #
 * ѥ᡼Ϳ줿ǡ°ꥹȤ򥻥åȡmssXmlTag¤Τ֤
 * str="element:attNam1=attVal1,attNam2=attVal2"
 * icidåȤƤ(NULLǤʤ)󥳡ǥ󥰤Ѵ򤪤ʤ
 * ̾'\0'ξϥ顼λ
 */
struct mssXmlTag *mssInitXmlTagByOpt(char *str, iconv_t *icid)
{
  struct mssXmlTag *xmlTag;
  char *tmp;
  char *pos;
  int   attCnt;
  char **attNam;
  int   i;

  if(!mssIsValidStr(str)) return(NULL);
  
  /*ʸ¸*/
  tmp=mssStrdup(str);

  /* -°ѥ졼ȯ*/
  if( NULL!=(pos=strchr(tmp,':')) ){
    *pos='\0';
  }

  /*ǤϿ*/
  xmlTag=mssInitXmlTag(tmp,icid);

  /*°Ͽ*/
  if( pos!=NULL ){
    pos++;

    attCnt=0;
    attNam=mssTokByChr(pos,',',&attCnt,0);
    for(i=0; i<attCnt; i++){
      if( NULL!=(pos=strchr(*(attNam+i),'=')) ){
        *pos='\0'; pos++;
        mssAddXmlTagAttributeStr(xmlTag,*(attNam+i), pos, icid);
      }else{
        mssAddXmlTagAttributeStr(xmlTag,*(attNam+i), "", icid);
      }
    }
    mssFree(attNam);
  }
  mssFree(tmp);
  return(xmlTag);
}

/**
 * # FUNCTION #
 * mssXmlTag¤ΰγ
 */
void mssFreeXmlTag(struct mssXmlTag *xmlTag)
{
  int i;

  if(xmlTag!=NULL){
    mssFree(xmlTag->element);
    for(i=0; i<xmlTag->attCnt; i++){
      mssFree(*(xmlTag->attributes+i));
    }
    mssFree(xmlTag->attributes);
    mssFree(xmlTag);
  }
}

/**
 * # FUNCTION #
 * mssXmlTag¤Τ˻°̾(name)뤫ɤĴ١С
 * °̾Ф(ʸ:value)򹹿롣ʤС°̾ͤɲä
 * icidåȤƤ(NULLǤʤ)󥳡ǥ󥰤Ѵ򤪤ʤ
 * xmlTag->attributesζǤ°̾򡢴Ǥͤݻ롣
 * xmlTagNULLξϲ⤻˥꥿󤹤롣
 */
void mssAddXmlTagAttributeStr(struct mssXmlTag *xmlTag, char *name, char *value, iconv_t *icid)
{
  char *buf;
  char *val;
  char *nam;
  int i;

  if(xmlTag==NULL){
    return;
  }

  if(name==NULL || value==NULL){
    mssShowErrMsg("internal error in addXmlAttribute");
    exit(mssErrorNoDefault);
  }

  /*°̾*/
  if(icid==NULL){
    nam=mssStrdup(name);
  }else{
    nam=mssEncoding(name,icid);
  }
  /*°*/
  buf=mssMalloc(sizeof(char)*(strlen(value)+3),"updXmlTag");
  strcpy(buf,"\"");
  strcat(buf,value);
  strcat(buf,"\"");
  if(icid==NULL){
    val=mssStrdup(buf);
  }else{
    val=mssEncoding(buf,icid);
  }
  mssFree(buf);
 
  /*ϿƤ뤫Ĵ٤*/
  for(i=0; i<xmlTag->attCnt; i=i+2){
    /*פ°ä!!*/
    if(strcmp(*(xmlTag->attributes+i),nam)==0){
      mssFree(*(xmlTag->attributes+i+1));
      *(xmlTag->attributes+i+1)=val;
      return;
    }
  }
  
  /*value˰פ°̾ʤäΤɲ*/
  xmlTag->attCnt+=2;
  xmlTag->attributes=mssRealloc(xmlTag->attributes,
                                sizeof(char *)*xmlTag->attCnt,"addXmlAtt");
  *(xmlTag->attributes+xmlTag->attCnt-2)=nam;
  *(xmlTag->attributes+xmlTag->attCnt-1)=val;
}

/**
 * # FUNCTION #
 * mssXmlTag¤Τ˻°̾(name)뤫ɤĴ١С
 * °̾Τ(:value)򹹿롣ʤС°̾ͤɲä
 * icidåȤƤ(NULLǤʤ)󥳡ǥ󥰤Ѵ򤪤ʤ
 * xmlTag->attributesζǤ°̾򡢴Ǥͤݻ롣
 * xmlTagNULLξϲ⤻˥꥿󤹤롣
 */
void mssAddXmlTagAttributeInt(struct mssXmlTag *xmlTag, char *name, int value, iconv_t *icid)
{
  char buf[100];
  char *tmp;
  char *val;
  char *nam;
  int i;

  if(xmlTag==NULL){
    return;
  }

  if(name==NULL){
    mssShowErrMsg("internal error in addXmlAttribute");
    exit(mssErrorNoDefault);
  }

  /*°̾*/
  if(icid==NULL){
    nam=mssStrdup(name);
  }else{
    nam=mssEncoding(name,icid);
  }

  /*°*/
  strcpy(buf,"\"");
  tmp=mssItoA(value);
  strcat(buf,tmp); mssFree(tmp);
  strcat(buf,"\"");
  if(icid==NULL){
    val=mssStrdup(buf);
  }else{
    val=mssEncoding(buf,icid);
  }
 
  /*ϿƤ뤫Ĵ٤*/
  for(i=0; i<xmlTag->attCnt; i=i+2){
    /*פ°ä!!*/
    if(strcmp(*(xmlTag->attributes+i),nam)==0){
      mssFree(*(xmlTag->attributes+i+1));
      *(xmlTag->attributes+i+1)=val;
      return;
    }
  }

  /*value˰פ°̾ʤäΤɲ*/
  xmlTag->attCnt+=2;
  xmlTag->attributes=mssRealloc(xmlTag->attributes,
                                sizeof(char *)*xmlTag->attCnt,"addXmlAtt");
  *(xmlTag->attributes+xmlTag->attCnt-2)=nam;
  *(xmlTag->attributes+xmlTag->attCnt-1)=val;
}

/**
 * # FUNCTION #
 * mssXmlTag¤Τ˻°̾(name)뤫ɤĴ١С
 * °̾Τ(¿:value)򹹿롣ʤС°̾ͤɲä
 * icidåȤƤ(NULLǤʤ)󥳡ǥ󥰤Ѵ򤪤ʤ
 * xmlTag->attributesζǤ°̾򡢴Ǥͤݻ롣
 * xmlTagNULLξϲ⤻˥꥿󤹤롣
 */
void mssAddXmlTagAttributeDbl(struct mssXmlTag *xmlTag, char *name, double value, iconv_t *icid)
{
  char buf[256];
  char *tmp;
  char *val;
  char *nam;
  int i;

  if(xmlTag==NULL){
    return;
  }

  if(name==NULL){
    mssShowErrMsg("internal error in addXmlAttribute");
    exit(mssErrorNoDefault);
  }

  /*°̾*/
  if(icid==NULL){
    nam=mssStrdup(name);
  }else{
    nam=mssEncoding(name,icid);
  }

  /*°*/
  strcpy(buf,"\"");
  tmp=mssFtoA(value);
  strcat(buf,tmp); mssFree(tmp);
  strcat(buf,"\"");
  if(icid==NULL){
    val=mssStrdup(buf);
  }else{
    val=mssEncoding(buf,icid);
  }
 
  /*ϿƤ뤫Ĵ٤*/
  for(i=0; i<xmlTag->attCnt; i=i+2){
    /*פ°ä!!*/
    if(strcmp(*(xmlTag->attributes+i),nam)==0){
      mssFree(*(xmlTag->attributes+i+1));
      *(xmlTag->attributes+i+1)=val;
      return;
    }
  }

  /*value˰פ°̾ʤäΤɲ*/
  xmlTag->attCnt+=2;
  xmlTag->attributes=mssRealloc(xmlTag->attributes,
                                sizeof(char *)*xmlTag->attCnt,"addXmlAtt");
  *(xmlTag->attributes+xmlTag->attCnt-2)=nam;
  *(xmlTag->attributes+xmlTag->attCnt-1)=val;
}

/**
 * # FUNCTION #
 * ץǻꤵ-°λ񼰤mssXmlTag¤Τ˥åȤ
 * Υݥ󥿤֤
 * Ϳ줿ʸ(str)NULLξNULL֤
 * Ϳ줿ʸ(str)ˤϰѹä̾°̾°
 * Ͽΰ˥åȤ롣
 *
 * ex)
 * str="title:date=2002/01/01,time=10:34:58"
 * ->
 * xmlTag->element="title"
 * xmlTag->attributes={"date","2002/01/01","time","10:34:58"}
 * xmlTag->attCnt=4
 */
struct mssXmlTag *mssOpt2XmlTag(char *str, iconv_t *icid)
{
  char *pos;
  int   attCnt;
  char **atts;
  char *tmpStr;
  int   i;
  struct mssXmlTag *xmlTag; 
  
  if(!mssIsValidStr(str)) return(NULL);

  tmpStr=mssStrdup(str);
  pos=strchr(tmpStr,':');

  /*̾ξ*/
  if(pos==NULL){
    xmlTag=mssInitXmlTag(tmpStr,icid);
    return(xmlTag);
  }

  /*°̾°ͤΥå*/
  *pos++='\0';
  xmlTag=mssInitXmlTag(tmpStr,icid);
  atts=mssTokByChr(pos,',',&attCnt,0);
  for(i=0; i<attCnt; i++){
    pos=strchr(*(atts+i),'=');
    if(pos==NULL){
      mssShowErrMsg("invalid attribute specified");
      exit(mssErrorNoDefault);
    }
    *pos++='\0';
    mssAddXmlTagAttributeStr(xmlTag,*(atts+i), pos,icid);
  }

  mssFree(atts);
  mssFree(tmpStr);
  return(xmlTag);
}   

/**
 * # FUNCTION #
 * mssXmlTag¤ΤʸȤƤζΥݥ󥿤֤
 * icidåȤƤ(NULLǤʤ)󥳡ǥ󥰤Ѵ򤪤ʤ
 * °ο(xmlTag->attCnt)Ĥξϡ°κǸǤ̵뤵롣
 *
 * ex.)
 * xmlTag->element="title"
 * xmlTag->attributes="date","2002/01/01","time","10:10:45"
 * xmlTag->attCnt=4
 *   ->
 * <title date="2002/01/01" time="10:10:45"/>
 */
char *mssXmlTag2emptyTag(struct mssXmlTag *xmlTag, iconv_t *icid)
{
  char buf[4096];
  char *str;
  int bc;
  int i;

  buf[0]='<';

  str=xmlTag->element;
  bc=1;
  while(*str!='\0'){
    if(bc>=4093){
      mssShowErrMsg("XML tag is too long");
      exit(mssErrorNoDefault);
    }
    buf[bc++]=*str++;
  }

  for(i=0; i<xmlTag->attCnt/2; i++){
    buf[bc++]=' ';
    str=*(xmlTag->attributes+i);
    while(*str!='\0'){
      if(bc>=4093){
        mssShowErrMsg("XML tag is too long");
        exit(mssErrorNoDefault);
      }
      buf[bc++]=*str++;
    }
    buf[bc++]='=';
    str=*(xmlTag->attributes+i+1);
    while(*str!='\0'){
      if(bc>=4093){
        mssShowErrMsg("XML tag is too long");
        exit(mssErrorNoDefault);
      }
      buf[bc++]=*str++;
    }
  }

  buf[bc++]='/';
  buf[bc++]='>';
  buf[bc++]='\0';

  if(icid!=NULL){
    return(mssEncoding(buf,icid));
  }else{
    return(mssStrdup(buf));
  }
}

/**
 * # FUNCTION #
 * mssXmlTag¤ΤʸȤƤγϥΥݥ󥿤֤
 * icidåȤƤ(NULLǤʤ)󥳡ǥ󥰤Ѵ򤪤ʤ
 * °ο(xmlTag->attCnt)Ĥξϡ°κǸǤ̵뤵롣
 *
 * ex.)
 * xmlTag->element="title"
 * xmlTag->attributes="date","2002/01/01","time","10:10:45"
 * xmlTag->attCnt=4
 *   ->
 * <title date="2002/01/01" time="10:10:45">
 */
char *mssXmlTag2startTag(struct mssXmlTag *xmlTag, iconv_t *icid)
{
  char buf[4096];
  char *str;
  int bc;
  int i;

  buf[0]='<';

  str=xmlTag->element;
  bc=1;
  while(*str!='\0'){
    if(bc>=4093){
      mssShowErrMsg("XML tag is too long");
      exit(mssErrorNoDefault);
    }
    buf[bc++]=*str++;
  }

  for(i=0; i<xmlTag->attCnt/2; i++){
    buf[bc++]=' ';
    str=*(xmlTag->attributes+i*2);
    while(*str!='\0'){
      if(bc>=4093){
        mssShowErrMsg("XML tag is too long");
        exit(mssErrorNoDefault);
      }
      buf[bc++]=*str++;
    }
    buf[bc++]='=';
    str=*(xmlTag->attributes+i*2+1);
    while(*str!='\0'){
      if(bc>=4093){
        mssShowErrMsg("XML tag is too long");
        exit(mssErrorNoDefault);
      }
      buf[bc++]=*str++;
    }
  }

  buf[bc++]='>';
  buf[bc++]='\0';

  if(icid!=NULL){
    return(mssEncoding(buf,icid));
  }else{
    return(mssStrdup(buf));
  }
}

/**
 * # FUNCTION #
 * mssXmlTag¤ΤʸȤƤνλΥݥ󥿤֤
 * icidåȤƤ(NULLǤʤ)󥳡ǥ󥰤Ѵ򤪤ʤ
 *
 * ex.)
 * xmlTag->element="title"
 * xmlTag->attributes="date","2002/01/01","time","10:10:45"
 * xmlTag->attCnt=4
 *   ->
 * </title>
 */
char *mssXmlTag2endTag(struct mssXmlTag *xmlTag, iconv_t *icid)
{
  char buf[4096];
  char *str;
  int bc;

  buf[0]='<';
  buf[1]='/';

  str=xmlTag->element;
  bc=2;
  while(*str!='\0'){
    if(bc>=4093){
      mssShowErrMsg("XML tag is too long");
      exit(mssErrorNoDefault);
    }
    buf[bc++]=*str++;
  }

  buf[bc++]='>';
  buf[bc++]='\0';

  if(icid!=NULL){
    return(mssEncoding(buf,icid));
  }else{
    return(mssStrdup(buf));
  }
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * XMLνϴϢ
 * ----------------------------------------------------------------------------
 */

/**
 * # FUNCTION #
 * XMLνϡ
 * Сȥ󥳡ǥ󥰤ϡ줾ver,encǻꤹ롣
 *
 * )
 * <?XML version="1.0" encoding="EUC-JP"?>
 */
void mssWriteXmlDeclaration( char *ver, char *enc, struct mssFPW *fp )
{
  
  mssWriteStr("<?xml",fp);
  if(ver!=NULL){
    mssWriteStr(" version=\"", fp);
    mssWriteStr(ver, fp);
    mssWriteStr("\"", fp);
  }
  if(enc!=NULL){
    mssWriteStr(" encoding=\"", fp);
    mssWriteStr(enc, fp);
    mssWriteStr("\"",fp);
  }
  mssWriteStr("?>\n",fp);
}

/**
 * # FUNCTION #
 * mssXmlTag¤Τξ򸵤ˡϥϤ롣
 * icidNULLǤʤХ󥳡ǥѴԤäƽϤ롣
 */
void mssWriteXmlStartTag(struct mssXmlTag *xmlTag, iconv_t *icid, struct mssFPW *fpw)
{
  char *str;
  str=mssXmlTag2startTag(xmlTag, icid);
  mssWriteStr(str,fpw);
  mssFree(str);
}

/**
 * # FUNCTION #
 * mssXmlTag¤Τξ򸵤ˡλϤ롣
 * icidNULLǤʤХ󥳡ǥѴԤäƽϤ롣
 */
void mssWriteXmlEndTag(struct mssXmlTag *xmlTag, iconv_t *icid, struct mssFPW *fpw)
{
  char *str;
  str=mssXmlTag2endTag(xmlTag, icid);
  mssWriteStr(str,fpw);
  mssFree(str);
}

/**
 * # FUNCTION #
 * mssXmlTag¤Τξ򸵤ˡϤ롣
 * icidNULLǤʤХ󥳡ǥѴԤäƽϤ롣
 */
void mssWriteXmlEmptyTag(struct mssXmlTag *xmlTag, iconv_t *icid, struct mssFPW *fpw)
{
  char *str;
  str=mssXmlTag2emptyTag(xmlTag, icid);
  mssWriteStr(str,fpw);
  mssFree(str);
}

/**
 * # FUNCTION #
 * ʸ(str)Ϥ롣
 * icidNULLǤʤХ󥳡ǥѴԤäƽϤ롣
 */
void mssWriteXmlContent( char *str, iconv_t *icid, struct mssFPW *fp )
{
  char *encStr;

  if(str==NULL) return;

  if(icid!=NULL){
    encStr=mssEncoding(str,icid);
    mssWriteStr(encStr,fp);
    mssFree(encStr);
  }else{
    mssWriteStr(str,fp);
  }
}

/**
 * # FUNCTION #
 * XMLΥǥȤϤ롣
 * ǥȤñ̤ȾѶʸǡcntĤζϤ롣
 */
void mssWriteXmlIndent(int cnt, struct mssFPW *fpw)
{
  char spc[1025];
  int i;
  if(cnt>512) cnt=512;
  for(i=0; i<cnt; i++){
    spc[i*2]=' ';
    spc[i*2+1]=' ';
  }
  spc[i*2]='\0';
  mssWriteStr(spc, fpw);
}

/**
 * # FUNCTION #
 * ϥʸ󡢽λ򥻥åȤǽϤ롣
 * °ޤ೫ϥϰʤ
 * ޤǥȡԤ̵ͭǤ롣
 * icidNULLǤʤХ󥳡ǥѴԤäƽϤ롣
 * ex)
 * indCnt=2, element="title", content="this is title" ,retFlg=1
 * ->
 *     <title>this is title</title>
 */
void mssWriteXmlTagStr(int indCnt, char *element, char *content, int retFlg, iconv_t *icid, struct mssFPW *fp )
{
  struct mssXmlTag *xmlTag;

  if(content==NULL) return;

  mssWriteXmlIndent(indCnt,fp);

  xmlTag=mssInitXmlTag(element,icid);
  mssWriteXmlStartTag(xmlTag,icid,fp);
  mssWriteXmlContent(content, icid, fp);
  mssWriteXmlEndTag(xmlTag, icid,fp);
  mssFreeXmlTag(xmlTag);

  if(retFlg){
    mssWriteRet(fp);
  }
}

/**
 * # FUNCTION #
 * ϥλ򥻥åȤǽϤ롣
 * °ޤ೫ϥϰʤ
 * ޤǥȡԤ̵ͭǤ롣
 * icidNULLǤʤХ󥳡ǥѴԤäƽϤ롣
 * ex)
 * indCnt=2, element="title", content=10 ,retFlg=1
 * ->
 *     <title>10</title>
 */
void mssWriteXmlTagInt(int indCnt, char *element, int content, int retFlg, iconv_t *icid, struct mssFPW *fp )
{
  char *buf;
  struct mssXmlTag *xmlTag;

  buf=mssItoA(content);
  mssWriteXmlIndent(indCnt,fp);

  xmlTag=mssInitXmlTag(element,icid);
  mssWriteXmlStartTag(xmlTag,icid,fp);
  mssWriteXmlContent(buf, icid, fp);
  mssWriteXmlEndTag(xmlTag, icid,fp);
  mssFreeXmlTag(xmlTag);

  if(retFlg){
    mssWriteRet(fp);
  }
}

/**
 * # FUNCTION #
 * ϥ¿λ򥻥åȤǽϤ롣
 * °ޤ೫ϥϰʤ
 * ޤǥȡԤ̵ͭǤ롣
 * icidNULLǤʤХ󥳡ǥѴԤäƽϤ롣
 * ex)
 * indCnt=2, element="title", content=5.24 ,retFlg=1
 * ->
 *     <title>5.24</title>
 */
void mssWriteXmlTagDbl(int indCnt, char *element, double content, int retFlg, iconv_t *icid, struct mssFPW *fp )
{
  char *buf;
  struct mssXmlTag *xmlTag;

  buf=mssFtoA(content);
  mssWriteXmlIndent(indCnt,fp);

  xmlTag=mssInitXmlTag(element,icid);
  mssWriteXmlStartTag(xmlTag,icid,fp);
  mssWriteXmlContent(buf, icid, fp);
  mssWriteXmlEndTag(xmlTag, icid,fp);
  mssFreeXmlTag(xmlTag);

  if(retFlg){
    mssWriteRet(fp);
  }
}

/**
 * # FUNCTION #
 * flgʤжϤ롣
 * °ޤϰʤ
 * ޤǥȡԤ̵ͭǤ롣
 * icidNULLǤʤХ󥳡ǥѴԤäƽϤ롣
 * ex)
 * indCnt=2, element="title", flg=1 ,retFlg=1
 * ->
 *     <title/>
 */
void mssWriteXmlTagFlg(int indCnt, char *element, int flg, int retFlg, iconv_t *icid, struct mssFPW *fp )
{
  struct mssXmlTag *xmlTag;

  if(flg){

    mssWriteXmlIndent(indCnt,fp);

    xmlTag=mssInitXmlTag(element,icid);
    mssWriteXmlEmptyTag(xmlTag,icid,fp);
    mssFreeXmlTag(xmlTag);

    if(retFlg){
      mssWriteRet(fp);
    }
  }
}
