/**
 * # CHAPTER #
 * ============================================================================
 * xtcalѤ׻˴ؤؿ
 * ============================================================================
 * ڰǡ
 * ŪˤϿͷ(double)ʸ(char *)Τߤ򰷤
 *
 * ڷѴ
 * §ŪˡƱ黻ҤӴؿˤϰͤ˥ǥեȤηƤ롣
 * ͤˤĤƤϡƴؿλꤹǥեȤηѴ롣
 *
 * ˡؿΰηȡΰǴؿꤵƤȤΡͤ
 * ԰פäͤ롣㤨"length(sqrt($a))"ˤȡ
 * lengthؿϡǥեȤǰȤʸ󷿤ȤꡢsqrtؿϿ֤ͤ
 * λsqrtؿη׻̤ʸ󷿤ѴlengthؿϤ
 * ʸ->ѴatofؿѤƤ롣
 * ηѴϡ§Ūcal_calculateؿˤƥޥɼ¹Ի˹Ԥ롣
 * 㳰ȤơؿΰȤ̤귿Ǥ롣
 * 㤨Сifؿͤ롣ifξＰʤʤ
 * 軰֤λ軰ηϡ桼λ˰¸롣
 * 㤨С"if($a>1,sqrt($a),today()"η׻ͤȡsqrt
 * ֤ͤ軰todayؿʸ֤
 * Τ褦ʥǤϡؿΥǥեȤη̤ˤƤ
 * ̤Ȥ¾θꤵ줿Ȥΰ㤤ϡ̤ξcal_calculateؿ
 * ˤƷѴԤʤȤˤ롣
 * äơؿ硢ηS,NˤСδؿˤϡ
 * ɬηͤȤϤ뤳Ȥݾڤ롣
 * 
 * Ϳ
 * ʸǤäƤ֥륯ơ(")ǰϤɬפϤʤ
 * ex. cat(abc,def,ghi,_) sqrt(10)
 * 
 * ڹ̾λˡ
 * "$̾"Τ褦'$'ƬˤĤ롣Ȥζ̤򤹤뤿ᡣ
 * ѰȤؿ(ex. sum,cat)ˤĤƤϡ磻ɥɤѤ뤳Ȥǽ
 * 㤨С"sum($[ab])"Ȼꤹȡ"sum($a,$b)"Ȼꤷ
 * ʤ롣âŪˤϡ"sum($[ab])""sum($a,$b)"
 * mssCal¤ΤǤγǼˡϰۤʤ롣Ԥcal->arg[0]->fldsĤιܤå
 * 졢Ԥϡcal->arg[0]->flds"$a"cal-arg[1]->flds"$b"
 * 줾쥻åȤ롣
 * ޤǽޥå'*'ѤդɬפǤ롣⤷"sum($*)"Ȼꤷ
 * 硢'*'軻黻ҤȤƲ᤹٤磻ɥɤȤƲ᤹٤
 * ȽǤĤʤߤΤȤ軻黻ҤȤƲᤷƤޤ
 * '*'Υ磻ɥɤѤϡsum($(*))Τ褦ˡ
 * ̳̤̾Ѥ롣
 *
 * ڳƴؿǳݤʸΰγ
 * ƥ桼ؿǳݤ줿ʸΰϡsetStrMalAdd(char *)ؿѤơ
 * Υɥ쥹ϿƤΥɥ쥹ϡcal_calculateؿ¹Ԥ뤿
 * ˳롣
 *
 * դˤĤơ
 * դϣʸ(yyyymmdd)Ϳ롣
 * 쥴ꥪν(1582ǯ1015)ͭ
 *
 */

#include <mssCal.h>
#include <mssConfig.h>
#include <mssBase.h>
#include <mssValue.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>
#include <regex.h>
#include <math.h>
#include <float.h>
#include <errno.h>

/* δؿѤǡ*/
#define N 1   /*ͷ*/
#define S 2   /*ʸ*/
#define M 64  /*Ѱ*/
#define X 128 /*̤*/
#define E 256 /*ü*/

/* ¤calΥ*/
#define NODE  0
#define LEAF  1
#define CONST 2
#define FIELD 3

/**
 * # STRUCT #
 * ̤ͥι⤤ؿ黻Ҥ򸫤Ĥ뤿ι¤
 */
struct OpeTbl {
  char *add; /*ɥ쥹*/
  int   num; /*и*/
  int   pri; /*黻ͥ*/
  struct Func *func;
};

struct OpeLst {
  struct OpeTbl *tbl;
  int            cnt;
};

extern struct mssGlobalVariables mssGV;

static int UsedTopResult=0;
static int UsedPrvResult=0;
static int UsedTopField=0;
static int UsedPrvField=0;
static struct mssFldRec    *Fr=NULL;
static struct mssFldRecDbl *Frd=NULL;
static struct mssFldRecKey *Frk=NULL;

static struct PrvRslStruct {
  MssValue val;
  char  buf[MssRecordMaxLen];
} PrvRsl,TopRsl;

static struct PrvFldStruct {
  char *pnt[MssFieldMaxCnt];
  char  buf[MssRecordMaxLen];
} PrvFld,TopFld;


/* ʸ򤪤ʤ黻Ҥؿǳݤ줿ΰfree뤿˵ΰ */
char       *strMalAdd[256]; /*ºݤγƴؿstr򤷤malloc*/
                            /*ɥ쥹*/
int         strMalCnt;      /*η*/

/**
 * # FUNCTION #
 * ʸǳݤ줿ΰ򥯥ꥢ
 */
static void cal_freeStrMalAdd(void)
{
  int i;
  for(i=0; i<strMalCnt; i++){
    mssFree(strMalAdd[i]);
  }
  strMalCnt=0;
}

/**
 * # FUNCTION #
 * ʸǳݤ줿ΰϿ
 */
static void setStrMalAdd(char *str)
{
  if(strMalCnt==100){
    mssShowErrMsg("too many string operation");
    mssEnd(mssErrorNoDefault);
  }
  strMalAdd[strMalCnt++]=str;
}

/**
 * # SECTION #
 * ----------------------------------------------------------------------------
 * 黻ҤӴؿ
 * ----------------------------------------------------------------------------
 * Ʊ黻ҤؿǤΰηΰ˴ؤ롼
 * 1. ؿMssValueǡŪˤ"double"(ͤ)
 *    "char *"(ʸ)Τߤǽ롣
 * 2. η˹ʤMssValueϤ줿ƴؿμ¹Ի˷Ѵ롣
 */

/**
 * # FUNCTION #
 * +(û)黻
 * Ϳ: 1 + 2
 * : 嵭黻
 */
static MssValue cal_addOperator(struct mssCal *cal)
{
  return(mssVadd(cal->arg[0].val[0],cal->arg[1].val[0]));
}

/**
 * # FUNCTION #
 * -()黻
 * Ϳ: 1 - 2
 * : 嵭黻
 */
static MssValue cal_subOperator(struct mssCal *cal)
{
  return(mssVsub(cal->arg[0].val[0],cal->arg[1].val[0]));
}

/**
 * # FUNCTION #
 * *(軻)黻
 * Ϳ: 1 * 2
 * : 嵭黻
 */
static MssValue cal_mulOperator(struct mssCal *cal)
{
  return(mssVmul(cal->arg[0].val[0],cal->arg[1].val[0]));
}

/**
 * # FUNCTION #
 * /()黻
 * Ϳ: 1 / 2
 * : 嵭黻
 */
static MssValue cal_divOperator(struct mssCal *cal)
{
  return(mssVdiv(cal->arg[0].val[0],cal->arg[1].val[0]));
}

/**
 * # FUNCTION #
 * %(;)黻
 * Ϳ: 1 % 2
 * : 嵭黻
 */
static MssValue cal_modOperator(struct mssCal *cal)
{
  return(mssVmod(cal->arg[0].val[0],cal->arg[1].val[0]));
}

/**
 * # FUNCTION #
 * ==(:equal)黻
 * Ϳ: 1 == 2
 * : 0:԰, 1:
 */
static MssValue cal_eqNOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_EQ, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * <>(:not equal)黻
 * Ϳ: 1 <> 2
 * : 0:԰, 1:
 */
static MssValue cal_neNOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_NE, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * >=(:greater or equal)黻
 * Ϳ: 1 >= 2
 * : 0:԰, 1:
 */
static MssValue cal_geNOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_GE, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * <=(:less or equal)黻
 * Ϳ: 1 <= 2
 * : 0:԰, 1:
 */
static MssValue cal_leNOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_LE, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * >(:greater)黻
 * Ϳ: 1 > 2
 * : 0:԰, 1:
 */
static MssValue cal_gtNOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_GT, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * <(:less)黻
 * Ϳ: 1 < 2
 * : 0:԰, 1:
 */
static MssValue cal_ltNOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_LT, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * ==(ʸ:equal)黻
 * Ϳ: ʸ1 -eq ʸ2
 * : 0:԰, 1:
 */
static MssValue cal_eqSOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_EQ, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * !=(ʸ:not equal)黻
 * Ϳ: ʸ1 -ne ʸ2
 * : 0:԰, 1:
 */
static MssValue cal_neSOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_NE, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * >=(ʸ:greater or equal)黻
 * Ϳ: ʸ1 -ge ʸ2
 * : 0:԰, 1:
 */
static MssValue cal_geSOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_GE, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * <=(ʸ:less or equal)黻
 * Ϳ: ʸ1 -le ʸ2
 * : 0:԰, 1:
 */
static MssValue cal_leSOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_LE, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * >(ʸ:greater)黻
 * Ϳ: ʸ1 -gt ʸ2
 * : 0:԰, 1:
 */
static MssValue cal_gtSOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_GT, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * <(ʸ:less)黻
 * Ϳ: ʸ1 -lt ʸ2
 * : 0:԰, 1:
 */
static MssValue cal_ltSOperator(struct mssCal *cal)
{
  int rsl;
  MssValue v;
  mssVinit(&v,DBL);

  rsl=mssVcmp(cal->arg[0].val[0], OPE_LT, cal->arg[1].val[0]);

  if(rsl==-1) MssVnull(v);
  else        v.v.d=(double)rsl;

  return(v);
}

/**
 * # FUNCTION #
 * ||()黻
 * Ϳ: 1 || 2
 * 12Τ줫λ֤ʳξϣ֤
 */
static MssValue cal_orOperator(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul || cal->arg[1].val[0].nul ){
    MssVnull(v);
  }else{
    if(cal->arg[0].val[0].v.d==1 || cal->arg[1].val[0].v.d==1){
      v.v.d=1;
    }else{
      v.v.d=0;
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * &&()黻
 * Ϳ: 1 && 2
 * 12Ȥˣλ֤ʳξϣ֤
 */
static MssValue cal_andOperator(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul || cal->arg[1].val[0].nul ){
    MssVnull(v);
  }else{
    if(cal->arg[0].val[0].v.d==1 && cal->arg[1].val[0].v.d==1){
      v.v.d=1;
    }else{
      v.v.d=0;
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * ifؿ
 * Ϳ: if(,value1,value2)
 * ͤλvalue1򡢤ʳλvalue2֤
 * value1,value2ηѴϹԤ鷺Τޤ֤
 * ͤNULLξ硢STRNULL֤ͤ
 */
static MssValue cal_if(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,STR);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
  }else{
    if(cal->arg[0].val[0].v.d==1)
      v=cal->arg[1].val[0];
    else
      v=cal->arg[2].val[0];
  }
  return(v);
}

/**
 * # FUNCTION #
 * notؿ
 * Ϳ: not()
 * ͤλϣ򡢤ʳλϣ֤
 * ¾ξϡNULL֤ͤ
 */
static MssValue cal_not(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
  }else{
    if(cal->arg[0].val[0].v.d ==0 ){
      v.v.d = 1;
    }else{
      v.v.d = 0;
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * sumؿ
 * Ϳ: sum(1,2,...,n)
 * 1nޤǤפ֤ͤ
 * ˰ĤǤNULLͤȡNULL֤ͤ
 * sumؿǤϡ̾λ˥磻ɥɤѤǤ롣
 */
static MssValue cal_sum(struct mssCal *cal)
{
  MssValue v;
  int i,j;
  mssVinit(&v,DBL);

  for(i=0; i<cal->argCnt; i++){
    for(j=0; j<cal->arg[i].valCnt; j++){
      if(cal->arg[i].val[j].nul){
        MssVnull(v); return(v);
      }else{
        v.v.d += cal->arg[i].val[j].v.d;
      }
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * minؿ
 * Ϳ: min(1,2,...,n)
 * 1nǺǾ֤ͤ
 * ˰ĤǤNULLͤȡNULL֤ͤ
 * minؿǤϡ̾λ˥磻ɥɤѤǤ롣
 */
static MssValue cal_min(struct mssCal *cal)
{
  MssValue v;
  int i,j;
  mssVinit(&v,DBL);

  mssVclearMax(&v);
  for(i=0; i<cal->argCnt; i++){
    for(j=0; j<cal->arg[i].valCnt; j++){
      if(cal->arg[i].val[j].nul){
        MssVnull(v); return(v);
      }else{
        if(v.v.d > cal->arg[i].val[j].v.d){
          v.v.d = cal->arg[i].val[j].v.d;
        }
      }
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * maxؿ
 * Ϳ: max(1,2,...,n)
 * 1nǺǾ֤ͤ
 * ˰ĤǤNULLͤȡNULL֤ͤ
 * maxnؿǤϡ̾λ˥磻ɥɤѤǤ롣
 */
static MssValue cal_max(struct mssCal *cal)
{
  MssValue v;
  int i,j;
  mssVinit(&v,DBL);

  mssVclearMin(&v);
  for(i=0; i<cal->argCnt; i++){
    for(j=0; j<cal->arg[i].valCnt; j++){
      if(cal->arg[i].val[j].nul){
        MssVnull(v); return(v);
      }else{
        if(v.v.d < cal->arg[i].val[j].v.d){
          v.v.d = cal->arg[i].val[j].v.d;
        }
      }
    }
  }
  return(v);
}


/**
 * # FUNCTION #
 * logؿ
 * Ϳ: log(1,2)
 * 2Ȥ1п֤
 * 1⤷Ͽ20ʲξNULL֤ͤ
 */
static MssValue cal_log(struct mssCal *cal)
{
  MssValue v;
  double rsl1=0;
  double rsl2=0;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul || cal->arg[1].val[0].nul ){
    MssVnull(v);
  }else{
    if(cal->arg[0].val[0].v.d <=0 || cal->arg[1].val[0].v.d <=0){
      MssVnull(v);
    }else{
      rsl1=log(cal->arg[0].val[0].v.d);
      rsl2=log(cal->arg[1].val[0].v.d);

      if(rsl2==0){
        MssVnull(v);
      }else{
        v.v.d = rsl1/rsl2;
      }
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * log2ؿ
 * Ϳ: log2()
 * 2Ȥͤп֤
 * ͤ0ʲξNULL֤ͤ
 */
static MssValue cal_log2(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
  }else{
    if(cal->arg[0].val[0].v.d <=0 ){
      MssVnull(v);
    }else{
      v.v.d=log(cal->arg[0].val[0].v.d)/log(2);
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * logؿ
 * Ϳ: log10()
 * 10Ȥͤп֤
 * ͤ0ʲξNULL֤ͤ
 */
static MssValue cal_log10(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
  }else{
    if(cal->arg[0].val[0].v.d <=0 ){
      MssVnull(v);
    }else{
      v.v.d = log10(cal->arg[0].val[0].v.d);
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * lnؿ
 * Ϳ: ln()
 * ͤμп֤
 * ͤ0ʲξNULL֤ͤ
 */
static MssValue cal_ln(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
  }else{
    if(cal->arg[0].val[0].v.d <=0 ){
      MssVnull(v); return(v);
    }else{
      v.v.d = log(cal->arg[0].val[0].v.d);
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * randؿ
 * Ϳ: rand(Ǿ,,μ)
 * ǾͰʾϢ³顢ε֤
 * ʤǾͤ"Ǿ+-1"ε롣
 * μ郎-1λ֤˱μѤ롣
 * ex) rand(2,3,1): 2,3,4 Τ줫֤ͤ
 * 1ʲ⤷RAND_MAXĶƤХ顼λ
 */
static MssValue cal_rand(struct mssCal *cal)
{
  MssValue v;
  static double unit=0;
  mssVinit(&v,DBL);

  if(mssGV.inCnt==1){
    /*ñ*/
    if(cal->arg[1].val[0].v.d<=1 || cal->arg[1].val[0].v.d>(double)RAND_MAX) {
      mssShowErrMsg("the second parameter must be in a range 2-%d.",RAND_MAX);
      mssEnd(mssErrorNoDefault);
    }
    unit=(double)(RAND_MAX) / ((double)(cal->arg[1].val[0].v.d - 1) );
    /*μ*/
    mssInitRand((int)cal->arg[2].val[0].v.d);
  }

  v.v.d = (double)(int)(cal->arg[0].val[0].v.d+(double)rand()/unit+0.5);
  return(v);
}

/**
 * # FUNCTION #
 * nrandؿ
 * Ϳ: nrand(ʿ,ɸк,μ)
 * ʬۤ˴Ť֤
 * ʬۤϡʿ͡ɸкͿ뤳ȤˤäƷޤ롣
 * μ郎-1λ֤˱μѤ롣
 *
 * ڵ
 * ʿ0ɸк1ʬ۴ؿy=1/sqrt(2*pi) * e^(-x^2/2)
 * x=0λy=1/sqrt(2*pi)Ȥʤ롣
 * a=1/sqrt(2*pi)֤
 * y=a*e^(-x^2/2)
 * ޤe^(-x^2/2)=sqrt(1/e)^(x^2)ǡsqrt(1/e)ʤΤesȤ
 * y=a*es^(x^2)Ȥʤ ---- (1)
 * yκͤ1Ǿͤ0Ȥʤ褦˴ಽ
 * y=(1)/a = es^(x^2) Ȥʤ
 *
 * ʬۤ˽ä
 * 1) xͿyͤ
 * 2) Ƥr
 * 3) r<=y ʤСλxͤȤǤʤ1)
 * 4) xѥ᡼ǻꤵ줿μ˼ޤʤ1)
 * 5) xȤƺѤ
 * ʿѤ濴Ȥƥޥʥȥץ饹Τǡؤ롣
 */
static MssValue cal_nrand(struct mssCal *cal)
{
  MssValue v;
  double negpos;
  static double a;
  static double es;
  double x,y; /*ಽ줿ʬۤˤx,y*/
  double r; /*x*/
  mssVinit(&v,DBL);

  if(mssGV.inCnt==1){

    /*ʬη׻*/
    a =1/sqrt(2*M_PI);
    es=sqrt(1/M_E);

    /*μ*/
    mssInitRand((int)cal->arg[2].val[0].v.d);
  }

  if((double)rand()/RAND_MAX>0.5)negpos=1;
  else                           negpos=-1;

  do {
    x=(double)4*(double)rand()/RAND_MAX; /*01*/
    r=(double)rand()/RAND_MAX;
    y=pow(es,x*x);
  }while(r>y);

  v.v.d = negpos*x*cal->arg[1].val[0].v.d+cal->arg[0].val[0].v.d;

  return(v);
}

/**
 * # FUNCTION #
 * cal->arg[i]˰ĤǤNULLͤУ֤ʳϣ֤
 */
static int argHaveNull(struct mssCal *cal)
{
  int i,j;
  for(i=0; i<cal->argCnt; i++){
    for(j=0; j<cal->arg[i].valCnt; j++){
      if(cal->arg[i].val[j].nul){
        return(1);
      }
    }
  }
  return(0);
}

/**
 * # FUNCTION #
 * catؿ
 * Ϳ: cat(ʸ1,ʸ2,...,ʸn,ڤʸ)
 * ʸ1ʸ2ڤʸϤǷ礷η̤֤
 * ˰ĤǤNULLͤȡNULL֤ͤ
 * catؿǤϡ̾λ˥磻ɥɤѤǤ롣
 * ڤʸ˥ڡ"_"Ѵ롣
 */
static MssValue cal_cat(struct mssCal *cal)
{
  int i,j;
  MssValue v;
  char *token;
  int   tokenLen;
  int   len;
  mssVinit(&v,STR);

  if(argHaveNull(cal)) {
    MssVnull(v);
    return(v);
  }

  /*ǥߥ*/
  token=cal->arg[cal->argCnt-1].val[0].v.s;
  tokenLen=strlen(token);
  for(i=0;i<tokenLen; i++){
    if(*(token+i)==' ') *(token+i)='_';
  }

  len=strlen(cal->arg[0].val[0].v.s)+1;
  v.v.s=mssMalloc(len,"cal_cat");
  strcpy(v.v.s, cal->arg[0].val[0].v.s);

  for(j=1; j<cal->arg[0].valCnt; j++){
    len += strlen(cal->arg[0].val[j].v.s)+tokenLen;
    v.v.s=mssReallocLim(v.v.s,len,MssFieldMaxLen,"cal_cat");
    strcat(v.v.s, token);
    strcat(v.v.s, cal->arg[0].val[j].v.s);
  }

  for(i=1; i<cal->argCnt-1; i++){
    for(j=0; j<cal->arg[i].valCnt; j++){
      len += strlen(cal->arg[i].val[j].v.s)+tokenLen;
      v.v.s=mssReallocLim(v.v.s,len,MssFieldMaxLen,"cal_cat");
      strcat(v.v.s, token);
      strcat(v.v.s, cal->arg[i].val[j].v.s);
    }
  }
  setStrMalAdd(v.v.s);
  return(v);
}

/**
 * # FUNCTION #
 * lengthؿ
 * Ϳ: length(ʸ)
 * ʸĹХȿ֤
 */
static MssValue cal_length(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(argHaveNull(cal)) {
    MssVnull(v);
    return(v);
  }

  v.v.d=(double)strlen(cal->arg[0].val[0].v.s);
  return(v);
}

/**
 * # FUNCTION #
 * fixؿ
 * Ϳ fix(ʸ,ʸ,,ͤʸ)
 * ʸפʸפθĹѴʸ֤
 * ʸϥХȿǻꤹ롣
 * Ĺˤ硢ʸĹʸפû硢
 * ѥǥ(ͤ)ʸֵͤʸפǻꤹ롣
 * ѥǥʸ˥ڡϻǤʤ
 * ޤѥǥ󥰤ݤˡʸ򺸱Τɤˤ뤫
 * ְ֡פ"R"()⤷"L"()Ϳ뤳Ȥˤäƻꤹ롣
 * ʸפĹʸפĹ硢ְ֡פLλϡʸפα¦
 * Ķʬ졢RλϺ¦롣
 */
static MssValue cal_fix(struct mssCal *cal)
{
  int i;
  MssValue v;
  char *str;
  char  rl;
  char  pad;
  int   len;
  int   sl;
  int   padLen;
  int   strLen;
  int   pos;

  mssVinit(&v,STR);

  if(argHaveNull(cal)) {
    MssVnull(v);
    return(v);
  }

  str =      cal->arg[0].val[0].v.s;
  len = (int)cal->arg[1].val[0].v.d;
  rl  =     *cal->arg[2].val[0].v.s;
  pad =     *cal->arg[3].val[0].v.s;
  sl=strlen(str);

  if(isspace(pad)) {
    mssShowErrMsg("padding charactor cannot be a space");
    mssEnd(mssErrorNoDefault);
  }

  if(len>=MssFieldMaxLen) {
    mssShowErrMsg("second parameter in [fix] function must be in a rage of 1-%d",MssFieldMaxLen-1);
    mssEnd(mssErrorNoDefault);
  }

  v.v.s=mssMalloc(len+1,"cal_fix");
  if(sl>len){ padLen=0     ; strLen=len; }
  else      { padLen=len-sl; strLen=sl ; }

  switch(rl){
  case 'L':
    pos=0;
    for(i=0; i<strLen; i++) {
      *(v.v.s+pos)=*(str+i);
      pos++;
    }
    for(i=0; i<padLen; i++) {
      *(v.v.s+pos)=pad;
      pos++;
    }
    *(v.v.s+pos)='\0';
    break;
  case 'R':
    pos=len-1;
    for(i=sl-1; i>=sl-strLen; i--) {
      *(v.v.s+pos)=*(str+i);
      pos--;
    }
    for(i=0; i<padLen; i++) {
      *(v.v.s+pos)=pad;
      pos--;
    }
    *(v.v.s+len)='\0';
    break;
  default:
    mssShowErrMsg("specify [R] or [L] in the third parameter in [fix] function.");
    mssEnd(mssErrorNoDefault);
    break;
  }

  setStrMalAdd(v.v.s);
  return(v);
}

/**
 * # FUNCTION #
 * leftؿ
 * Ϳ left(ʸ,ʸ)
 * ʸפκʸפʸڤ֤ͤ
 * ʸϥХȿǻꤹ롣
 * ʸפʸפĹĹСʸפ򤽤Τޤ֤
 */
static MssValue cal_left(struct mssCal *cal)
{
  MssValue v;
  char *str;
  int   len;
  int   sl;
  int   strLen;

  mssVinit(&v,STR);

  if(argHaveNull(cal)) {
    MssVnull(v);
    return(v);
  }

  str =      cal->arg[0].val[0].v.s;
  len = (int)cal->arg[1].val[0].v.d;
  sl=strlen(str);

  if(len>=MssFieldMaxLen) {
    mssShowErrMsg("invalid length specified in [left] function");
    mssEnd(mssErrorNoDefault);
  }

  if(sl>len) strLen=len;
  else       strLen=sl ;
  v.v.s=mssMalloc(strLen+1,"cal_left");
  strncpy(v.v.s,str,strLen);
  *(v.v.s+strLen)='\0';
  setStrMalAdd(v.v.s);
  return(v);
}

/**
 * # FUNCTION #
 * rightؿ
 * Ϳ right(ʸ,ʸ)
 * ʸפαʸפʸڤ֤ͤ
 * ʸϥХȿǻꤹ롣
 * ʸפʸפĹĹСʸפ򤽤Τޤ֤
 */
static MssValue cal_right(struct mssCal *cal)
{
  MssValue v;
  char *str;
  int   len;
  int   sl;
  int   strLen;

  mssVinit(&v,STR);

  if(argHaveNull(cal)) {
    MssVnull(v);
    return(v);
  }

  str =      cal->arg[0].val[0].v.s;
  len = (int)cal->arg[1].val[0].v.d;
  sl=strlen(str);

  if(len>=MssFieldMaxLen || len <=0) {
    mssShowErrMsg("invalid length specified in [right] function");
    mssEnd(mssErrorNoDefault);
  }

  if(sl>len) strLen=len;
  else       strLen=sl ;
  v.v.s=mssMalloc(strLen+1,"cal_left");
  strncpy(v.v.s,str+(sl-strLen),strLen);
  *(v.v.s+strLen)='\0';
  setStrMalAdd(v.v.s);
  return(v);
}

/**
 * # FUNCTION #
 * substrؿ
 * Ϳ substr(ʸ,ϰ,λ)
 * ʸפΡֳϰ֡פֽλ֡פʸڤ֤ͤ
 * ֽλ֡פʸפĶϡλ֤ѹ롣
 * ֳϰ֡סֽλ֡פȤĶϡNULL֤ͤ
 * ֳϰ֡סֽλ֡פʲοξϥ顼λ롣
 */
static MssValue cal_substr(struct mssCal *cal)
{
  MssValue v;
  char *str;
  int   from;
  int   to;
  int   len;
  int   sl;

  mssVinit(&v,STR);

  if(argHaveNull(cal)) {
    MssVnull(v);
    return(v);
  }

  str  =      cal->arg[0].val[0].v.s;
  from = (int)cal->arg[1].val[0].v.d;
  to   = (int)cal->arg[2].val[0].v.d;
  sl=strlen(str);

  if(from>to) mssSwapInt(&from,&to);
  len=to-from+1;

  if(len>=MssFieldMaxLen || len<=0 || from<=0 || to<=0) {
    mssShowErrMsg("invalid length specified in [substr] function");
    mssEnd(mssErrorNoDefault);
  }

  /*Ȱ֤ʸĹĶƤNULL*/
  if(from>sl) {
    MssVnull(v);
    return(v);
  }

  /*ɰ֤ʸĹĶƤ顢ʸκǸѤ*/
  if(to>sl) to=sl;

  len=to-from+1;

  v.v.s=mssMalloc(len+1,"cal_left");
  strncpy(v.v.s,str+from-1,len);
  *(v.v.s+len)='\0';
  setStrMalAdd(v.v.s);
  return(v);
}

/**
 * # FUNCTION #
 * =~ӱ黻
 * Ϳ ʸ=~ɽ
 * ʸɽ˥ޥåУʤУ֤
 * ɽΥѥϡǡΰܤλΤ߹Ԥ롣
 * ɽȤơExtended Regular Expression(ERE)ѤƤ롣
 */
static MssValue cal_regOperator(struct mssCal *cal)
{

  MssValue v;

  int rsl;
  char *str;
  char *reg;
  mssVinit(&v,DBL);

  if(mssGV.inCnt==1){
    reg=cal->arg[1].val[0].v.s;
    if(regcomp(&cal->regex,reg,REG_EXTENDED) ){
      mssShowErrMsg("error in compiling regex");
      mssEnd(mssErrorNoDefault);
    }
  }

  if(cal->arg[0].val[0].nul) {
    MssVnull(v);
    return(v);
  }

  str=cal->arg[0].val[0].v.s;

  rsl=regexec(&cal->regex, str, 0, NULL,0);
  if(rsl!=0){
    v.v.d=0;
  }else{
    v.v.d=1;
  }
  return(v);
}

/**
 * # FUNCTION #
 * regexEndؿ
 * Ϳ regexEnd(ʸ,ɽ)
 * ʸǡɽ˥ޥå뽪ü֤֤
 * ɽΥѥϡǡΰܤλΤ߹Ԥ롣
 * ɽȤơExtended Regular Expression(ERE)ѤƤ롣
 */
static MssValue cal_regexEnd(struct mssCal *cal)
{

  MssValue v;
  regmatch_t matchPnt;

  int rsl;
  char *str;
  char *reg;
  mssVinit(&v,DBL);

  if(mssGV.inCnt==1){
    reg=cal->arg[1].val[0].v.s;

    if(regcomp(&cal->regex,reg,REG_EXTENDED) ){
      mssShowErrMsg("error in compiling regex");
      mssEnd(mssErrorNoDefault);
    }
  }

  if(cal->arg[0].val[0].nul) {
    MssVnull(v);
    return(v);
  }

  str=cal->arg[0].val[0].v.s;

  rsl=regexec(&cal->regex, str, 1, &matchPnt,0);
  if(rsl!=0){
    MssVnull(v);
  }else{
    v.v.d=matchPnt.rm_eo;
  }
  return(v);
}

/**
 * # FUNCTION #
 * regexStartؿ
 * Ϳ regexStart(ʸ,ɽ)
 * ʸǡɽ˥ޥå볫ϰ֤֤
 * ɽΥѥϡǡΰܤλΤ߹Ԥ롣
 * ɽȤơExtended Regular Expression(ERE)ѤƤ롣
 */
static MssValue cal_regexStart(struct mssCal *cal)
{

  MssValue v;
  regmatch_t matchPnt;

  int rsl;
  char *str;
  char *reg;
  mssVinit(&v,DBL);

  if(mssGV.inCnt==1){
    reg=cal->arg[1].val[0].v.s;

    if(regcomp(&cal->regex,reg,REG_EXTENDED) ){
      mssShowErrMsg("error in compiling regex");
      mssEnd(mssErrorNoDefault);
    }
  }

  if(cal->arg[0].val[0].nul) {
    MssVnull(v);
    return(v);
  }

  str=cal->arg[0].val[0].v.s;

  rsl=regexec(&cal->regex, str, 1, &matchPnt,0);
  if(rsl!=0){
    MssVnull(v);
  }else{
    v.v.d=matchPnt.rm_so+1;
  }
  return(v);
}

/**
 * # FUNCTION #
 * regexLenؿ
 * Ϳ regexStart(ʸ,ɽ)
 * ʸǡɽ˥ޥåʬʸĹХȿȤ֤
 * ɽΥѥϡǡΰܤλΤ߹Ԥ롣
 * ɽȤơExtended Regular Expression(ERE)ѤƤ롣
 */
static MssValue cal_regexLen(struct mssCal *cal)
{

  MssValue v;
  regmatch_t matchPnt;

  int rsl;
  char *str;
  char *reg;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul) {
    MssVnull(v);
    return(v);
  }

  str=cal->arg[0].val[0].v.s;
  if(mssGV.inCnt==1){
    reg=cal->arg[1].val[0].v.s;

    if(regcomp(&cal->regex,reg,REG_EXTENDED) ){
      mssShowErrMsg("error in compiling regex");
      mssEnd(mssErrorNoDefault);
    }
  }

  rsl=regexec(&cal->regex, str, 1, &matchPnt,0);
  if(rsl!=0){
    MssVnull(v);
  }else{
    v.v.d=matchPnt.rm_eo-matchPnt.rm_so;
  }
  return(v);
}

/**
 * # FUNCTION #
 * piؿ
 * Ϳ pi()
 * Ф֤ͤ
 */
static MssValue cal_pi(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  v.v.d=M_PI;
  return(v);
}

/**
 * # FUNCTION #
 * sqrtؿ
 * Ϳ sqrt()
 * ͤʿ֤ͤޥʥλNULL֤ͤ
 */
static MssValue cal_Sqrt(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul || cal->arg[0].val[0].v.d<0){
    MssVnull(v);
  }else{
    v.v.d = sqrt(cal->arg[0].val[0].v.d);
  }
  return(v);
}

/**
 * # FUNCTION #
 * expؿ
 * Ϳ exp()
 * e(ͥԥ)Ȥؿֿ͡פ߾(e^x)֤
 * ׻̤礭NULL֤ͤ
 */
static MssValue cal_Exp(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
    return(v);
  }
  v.v.d = exp(cal->arg[0].val[0].v.d);

  if(v.v.d == HUGE_VAL) {
    MssVnull(v);
  }
  return(v);
}

/**
 * # FUNCTION #
 * powerؿ
 * Ϳ power(1,2)
 * ֿ1פΡֿ2׾׻֤ͤ
 * ׻̤礭ꡢNULL֤ͤ
 */
static MssValue cal_power(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul || cal->arg[1].val[0].nul){
    MssVnull(v);
    return(v);
  }
  v.v.d = pow(cal->arg[0].val[0].v.d,cal->arg[1].val[0].v.d);

  if(v.v.d == HUGE_VAL || v.v.d == ERANGE) {
    MssVnull(v);
  } 
  return(v);
}

/**
 * # FUNCTION #
 * absؿ
 * Ϳ abs()
 * ֿ͡פ֤ͤ
 */
static MssValue cal_abs(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
    return(v);
  }
  if(cal->arg[0].val[0].v.d<0){
    v.v.d=cal->arg[0].val[0].v.d * (-1);
  }else{
    v.v.d=cal->arg[0].val[0].v.d;
  }
  return(v);
}

/**
 * # FUNCTION #
 * upؿ
 * Ϳ up(,)
 * ͤͤˤäڤ夲֤ͤ
 * ͤˤϡڤ夲̿ͤñ̤ꤹ롣
 * 㤨С123.456ȤͤФ׻̤ϰʲΤȤꡣ
 *  
 * 1      124   -> ̤ϣܿ
 * 0.1    123.5 -> ̤0.1ܿ
 * 10     130
 * 0.5    123.5
 */
static MssValue cal_up(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul ||
     cal->arg[1].val[0].nul ||
     cal->arg[1].val[0].v.d<=0 ){
    MssVnull(v);
    return(v);
  }

  v.v.d=ceil(cal->arg[0].val[0].v.d/cal->arg[1].val[0].v.d)*cal->arg[1].val[0].v.d;

  return(v);
}

/**
 * # FUNCTION #
 * downؿ
 * Ϳ down(,)
 * ͤͤˤäڤ겼֤ͤ
 * ͤˤϡڤ겼̿ͤñ̤ꤹ롣
 * 㤨С123.456ȤͤФ׻̤ϰʲΤȤꡣ
 *  
 * 1      123   -> ̤ϣܿ
 * 0.1    123.4 -> ̤0.1ܿ
 * 10     120
 * 0.5    123.0
 */
static MssValue cal_down(struct mssCal *cal)
{
  MssValue v;
  double diff;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul ||
     cal->arg[1].val[0].nul ||
     cal->arg[1].val[0].v.d<=0 ){
    MssVnull(v);
    return(v);
  }

  v.v.d=ceil(cal->arg[0].val[0].v.d/cal->arg[1].val[0].v.d)*cal->arg[1].val[0].v.d;
  diff=v.v.d - cal->arg[0].val[0].v.d;
  if(diff > DBL0 || diff < -DBL0 ){
    v.v.d -= cal->arg[1].val[0].v.d;
  }

  return(v);
}

/**
 * # FUNCTION #
 * roundؿ
 * Ϳ round(,)
 * ͤͤˤäƻͼθ֤ͤ
 * ͤˤϡͼθ̿ͤñ̤ꤹ롣
 * ΤˤСͼθǤϤʤͤܤοͽǺǤᤤ
 * ֤
 * 㤨С123.456ȤͤФ׻̤ϰʲΤȤꡣ
 *  
 * 1      123   -> ̤ϣܿ
 * 0.1    123.5 -> ̤0.1ܿ
 * 10     120
 * 0.5    123.5
 */
static MssValue cal_round(struct mssCal *cal)
{
  MssValue v;
  double v0;
  double v1;
  double vint;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul ||
     cal->arg[1].val[0].nul ||
     cal->arg[1].val[0].v.d<=0 ){
    MssVnull(v);
    return(v);
  }

  v0=cal->arg[0].val[0].v.d;
  v1=cal->arg[1].val[0].v.d;
  if(v0<0) modf((v0-(v1/2)-DBL0)/v1,&vint);
  else     modf((v0+(v1/2)+DBL0)/v1,&vint);
  v.v.d=vint*v1;

  return(v);
}

/**
 * # FUNCTION #
 * fixdecؿ
 * Ϳ up(,ʲ)
 * ͤξʲη򡢻ꤷͤǤʸȤ֤
 */
static MssValue cal_fixdec(struct mssCal *cal)
{
  char buf[256];
  char fmt[20];
  MssValue v;
  mssVinit(&v,STR);

  if(cal->arg[0].val[0].nul ||
     cal->arg[1].val[0].nul ||
     cal->arg[1].val[0].v.d<0 ||
     cal->arg[1].val[0].v.d>6 ){
    MssVnull(v);
    return(v);
  }

  fmt[0]='%';
  fmt[1]='.';
  sprintf(&fmt[2],"%df",(int)cal->arg[1].val[0].v.d);

  sprintf(buf,fmt,cal->arg[0].val[0].v.d);

  v.v.s=mssStrdup(buf);

  setStrMalAdd(v.v.s);
  return(v);
}


/**
 * # FUNCTION #
 * ͭդʤ飱򤽤ǤʤУ֤
 */
static int validDate(char *d)
{
  /*Ĺå*/
  if(strlen(d) != 8) return(0);

  /*쥴ꥪ꾮̵*/
  if(strcmp(d,"15821015")<0) return(0);

  return(1);
}

/**
 * # FUNCTION #
 * ͭʻʤ飱򤽤ǤʤУ֤
 */
static int validTime(char *d)
{
  /*Ĺå*/
  if(strlen(d) != 6) return(0);

  return(1);
}

/**
 * # FUNCTION #
 *ǯʬäꥦ롣
 * 쥴ꥪǤ뤳Ȥ
 * ʸȤͿ줿աˤȤꡢ.double֤
 * http://alfin.mine.utsunomiya-u.ac.jp/~niy/algo/u/ut2jd.html 
 */
static double ut2jd(char *date, char *time)
{
  int year,month,day,hour,min,sec;
  char buf[5];
  double d;
  long j;

  strncpy(buf,date  ,4); buf[4]='\0'; year =atoi(buf);
  strncpy(buf,date+4,2); buf[2]='\0'; month=atoi(buf);
  strncpy(buf,date+6,2); buf[2]='\0'; day  =atoi(buf);
  strncpy(buf,time  ,2); buf[2]='\0'; hour =atoi(buf);
  strncpy(buf,time+2,2); buf[2]='\0'; min  =atoi(buf);
  strncpy(buf,time+4,2); buf[2]='\0'; sec  =atoi(buf);
    
  if (month <= 2) {
    year--;
    month += 12;
  }
    
  if (hour < 12) {
      j = 0;
      d = 0.5;
  } else {
      j = 1;
      d = -0.5;
  }
  d += (hour*3600L + min*60 + sec)/86400.0;
   
  j += year/4;
  j+= 2 - year/100 + year/400;
  j += 1720994L + year*365L + (month+1)*30 + (month+1)*3/5 + day;

  d=d+(double)j;
  return(d);
}

/**
 * # FUNCTION #
 * ꥦǯʬä롣
 * 쥴ꥪǤ뤳Ȥ
 * .doubleͿꥦ顢աʸݥ󥿤
 * ֤ǯʬä򥻥åȤ롣
 * ׻̤ꥴꥪǤʤ-1֤
 * http://alfin.mine.utsunomiya-u.ac.jp/~niy/algo/j/jd2ut.html 
 */
static int jd2ut(char *date, char *time, double d)
{
  long c, k, e, s;
  int year,month,day,hour,min,sec;
  long j;

  j=(long)floor(d);
  d=d-(double)j;

  if (d >= 0.5) {
      j++;
      d -= 0.5;
  } else d += 0.5;

  if (j >= 2299161) j = j + 1 + (j-1867216)/36524 - (j-1867216)/146096;
  j += 1524;

  c = (j - 122.1)/365.25;
  k = 365L*c + c/4;
  e = (j - k)/30.6001;

  year = c - 4716;
  month = e - 1;
  if (month > 12) {
     (month) -= 12;
     (year)++;
  }
  day = j - k - (long)(30.6*e);

  s = d * 86400 + 0.5;
  hour = s / 3600;
  min = (s % 3600) / 60;
  sec = s % 60;

  sprintf(date,"%04d%02d%02d",year,month,day);
  sprintf(time,"%02d%02d%02d",hour,min,sec);

  /*쥴ꥪ򤫤ɤȽ*/
  if( (year)*366+(month)*31+(day) < 1582*366+10*31+15 ) {
    return(-1);
  }else{
    return(0);
  }
}

/**
 * # FUNCTION #
 * դֹ(ĥ顼θ)
 * 0:, 1:, 2:, 3:, 4:, 5:, 6:
 * н:ʿӲѡCˤץ༭ŵ裱,ɾ,ʿ4ǯ,p292.
 */
static int dayweek(char *date)
{
  char buf[5];
  int year,month,day;

  strncpy(buf,date  ,4); buf[4]='\0'; year =atoi(buf);
  strncpy(buf,date+4,2); buf[2]='\0'; month=atoi(buf);
  strncpy(buf,date+6,2); buf[2]='\0'; day  =atoi(buf);

  if(month<=2) year--,month+=12;
  return( (year+year/4-year/100+year/400+(13*month+8)/5+day)%7 );
}

/**
 * # FUNCTION #
 * դ顢ǯΣηв롣
 */
static int day365(char *date)
{
  char base[9];
  double fJD;
  double tJD;

  strncpy(base,date,4); base[4]='\0';
  strcat(base,"0101");
  fJD=ut2jd(base,"000000");
  tJD=ut2jd(date,"000000");

  return( (int)tJD-(int)fJD );
}


/**
 * # FUNCTION #
 * ut2jdؿ
 * Ϳ ud2jd(,)
 * աפΡֻפꥦѴ֤ͤ
 * ꥦȤϡBC4712ǯ11ᤫηв
 * ˤޤλ֤ä¿Ǥ롣
 * 쥴ꥪϰǤʤդ̵ȤNULL֤
 * ex. 1991ǯ61500ʬ0 -> 2448422.5
 */
static MssValue cal_dt2jd(struct mssCal *cal)
{
  MssValue v;

  char *v0;
  char *v1;

  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
    return(v);
  }
  v0 =cal->arg[0].val[0].v.s;
  v1 =cal->arg[1].val[0].v.s;

  if(!validDate(v0) || !validTime(v1)){
    MssVnull(v);
    return(v);
  }

  v.v.d=ut2jd(v0,v1);
  return(v);
}

/**
 * # FUNCTION #
 * jd2dateؿ
 * Ϳ jd2date(ꥦ)
 * ֥ꥦפդ׻֤ͤ
 * ex. 2448422.5 -> 19910615
 */
static MssValue cal_jd2date(struct mssCal *cal)
{
  MssValue v;
  char bufD[9];
  char bufT[7];

  mssVinit(&v,STR);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
    return(v);
  }

  if(-1 == jd2ut(bufD,bufT,cal->arg[0].val[0].v.d)){
    MssVnull(v);
    return(v);
  }

  v.v.s=mssStrdup(bufD);
  setStrMalAdd(v.v.s);
  return(v);
}

/**
 * # FUNCTION #
 * jd2timeؿ
 * Ϳ jd2time(ꥦ)
 * ֥ꥦפ׻֤ͤ
 * ex. 2448422.5 -> 19910615
 */
static MssValue cal_jd2time(struct mssCal *cal)
{
  MssValue v;
  char bufD[9];
  char bufT[7];

  mssVinit(&v,STR);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
    return(v);
  }

  if(-1 == jd2ut(bufD,bufT,cal->arg[0].val[0].v.d)){
    MssVnull(v);
    return(v);
  }

  v.v.s=mssStrdup(bufT);
  setStrMalAdd(v.v.s);
  return(v);
}


/**
 * # FUNCTION #
 * leapyearؿ
 * Ϳ leapyear()
 * աפǯǯǤУ򡢤ǤʤУ֤
 */
static MssValue cal_leapyear(struct mssCal *cal)
{
  MssValue v;

  char buf[5];
  char *v0;
  int year;

  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul){
    MssVnull(v);
    return(v);
  }
  v0=cal->arg[0].val[0].v.s;

  if(!validDate(v0)){
    MssVnull(v);
    return(v);
  }

  strncpy(buf,v0,4);
  buf[4]='\0';
  year=atoi(buf);

  v.v.d=(double)( (year%4==0 && year%100!= 0) || year%400==0 );
  return(v);
}

/**
 * # FUNCTION #
 * datefmtؿ
 * Ϳ datefmt(,եޥå)
 * աʸեޥåȤ˽Ѵ֤ͤ
 * դϣʸ(ex.20030520)Ϳ롣
 * եޥåȤˤǤդʸͿ뤳ȤǤ롣
 * եޥåȤζʸ"_"Ѵ롣
 * ʲü쵭ϡդʸѴ롣
 *
 * 	̣					(20030514)	(20030105)
 * %Y	ǯ					2003		2003
 * %M						05		01
 * %m	Ѹ̾				May		Jan
 * %D						20		05
 * %d	ηв			123		4
 * %w	ֹ(111Ȥ)	20		1
 * %s	νγ			20030514	20030101
 * %W	ֹ				2		0
 *      (0:,1:,2:,3:,4:,5:,6:)
 *      λФˤϥĥ顼θѤƤ
 * %e	Ѹ(Sun,Mon,Tsu,Wed,Thu,Fri,Sat)	Tue		Sun
 * %E	ֹ+Ѹ			2Tue		0Sun
 * %j	ܸ(пڶ)				
 * %J	ֹ+ܸ			2		0
 * %%	%					%		%
 *
 * )
 * datefmt("20030514","%Yǯ%M%D") -> 2003ǯ0514
 */
static MssValue cal_datefmt(struct mssCal *cal)
{
  MssValue v;
  struct mssStrings *hs;
  struct tm *lct;
  time_t caltime;
  int   fmtlen;
  char buf[10];
  char date[9];
  char time[7];
  char *v0;
  char *v1;
  int dow;
  int i;
  int tmp;
  char *wday1[]={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
  char *wday2[]={"","","","","","",""};
  char *emon[]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
  mssVinit(&v,STR);

  hs=mssInitStrings();

  if(cal->arg[0].val[0].nul || cal->arg[1].val[0].nul){
    MssVnull(v);
    return(v);
  }
  v0 =cal->arg[0].val[0].v.s;
  v1 =cal->arg[1].val[0].v.s;

  if(!validDate(v0)){
    MssVnull(v);
    return(v);
  }

  fmtlen=strlen(v1);
  if(fmtlen>=MssFieldMaxLen){
    MssVnull(v);
    return(v);
  }
  for(i=0; i<fmtlen; i++){
    if(isspace(*(v1+i))) *(v1+i)='_';
  }

  caltime = mssStrToTime(cal->arg[0].val[0].v.s);
  if(caltime == -1){
    MssVnull(v);
    return(v);
  }else{
    lct = localtime(&caltime);
  v.v.d = lct->tm_wday;
  } 

  i=0;
  while(*v1!='\0' && i<MssFieldMaxLen-4){
    if(*v1=='%'){
      switch(*(v1+1)){
        case 'Y':
          strncpy(buf,v0,4); buf[4]='\0';
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case 'M':
          strncpy(buf,v0+4,2); buf[2]='\0';
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case 'm':
          strncpy(buf,v0+4,2); buf[2]='\0';
          mssCatStrings(hs,emon[atoi(buf)-1]);
          v1=v1+2;
          break;
        case 'D':
          strncpy(buf,v0+6,2); buf[2]='\0';
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case 'd': /*11ηв */
          sprintf(buf,"%d",day365(v0));
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case 'w': /*ֹ*/
          sprintf(buf,"%d",day365(v0)/7);
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case 's': /**/
          tmp=day365(v0)%7;
          jd2ut(date,time,ut2jd(v0,"000000")-(double)tmp);
          mssCatStrings(hs,date);
          v1=v1+2;
          break;
        case 'W': /*ֹ*/
          dow=(int)dayweek(v0);
          sprintf(buf,"%d",dow);
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case 'e': /*Ѹ*/
          dow=(int)dayweek(v0);
          mssCatStrings(hs,wday1[dow]);
          v1=v1+2;
          break;
        case 'E': /*ֹ+Ѹ*/
          dow=(int)dayweek(v0);
          sprintf(buf,"%d%s",dow,wday1[dow]);
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case 'j': /*ܸ*/
          dow=(int)dayweek(v0);
          mssCatStrings(hs,wday2[dow]);
          v1=v1+2;
          break;
        case 'J': /*ֹ+ܸ */
          dow=(int)dayweek(v0);
          sprintf(buf,"%d%s",dow,wday2[dow]);
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case '%': /*%*/
          buf[0]='%'; buf[1]='\0';
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        default:
          mssCatnStrings(hs,v1,1);
          v1++;
          break;
      }
    }else{
      mssCatnStrings(hs,v1,1);
      v1++;
    }
  }
  v.v.s=mssStrdup(hs->str);
  setStrMalAdd(v.v.s);
  mssFreeStrings(hs);
  return(v);
}

/**
 * # FUNCTION #
 * timefmtؿ
 * Ϳ timefmt(,եޥå)
 * ֻʸեޥåȤ˽Ѵ֤ͤ
 * ϣʸ(ex.150257)Ϳ롣
 * եޥåȤˤǤդʸͿ뤳ȤǤ롣
 * եޥåȤζʸ"_"Ѵ롣
 * ʲü쵭ϡʸѴ롣
 *
 * 	̣			(150257)	(101101)
 * %H	(24ɽ)		15		10
 * %h	(12ɽ)		3		10
 * %e	AM or PM		PM		AM
 * %j	 or 				
 * %M	ʬ			02		11
 * %S				57		01
 * %%	%			%		%
 *
 * )
 * timefmt("101101","%H:%M:%S") -> 10:11:01
 * timefmt("150257","%j%h:%M:%S") -> 03:92:57
 */
static MssValue cal_timefmt(struct mssCal *cal)
{
  MssValue v;
  struct mssStrings *hs;
  int   fmtlen;
  char buf[20];
  char hour[3];
  char minute[3];
  char second[3];
  char *v0;
  char *v1;
  int i;
  mssVinit(&v,STR);

  hs=mssInitStrings();

  if(cal->arg[0].val[0].nul || cal->arg[1].val[0].nul){
    MssVnull(v);
    return(v);
  }
  v0 =cal->arg[0].val[0].v.s;
  v1 =cal->arg[1].val[0].v.s;

  if(!validTime(v0)){
    MssVnull(v);
    return(v);
  }

  fmtlen=strlen(v1);
  if(fmtlen>=MssFieldMaxLen){
    MssVnull(v);
    return(v);
  }
  for(i=0; i<fmtlen; i++){
    if(isspace(*(v1+i))) *(v1+i)='_';
  }

  strncpy(hour  ,v0  ,2); hour[2]  ='\0';
  strncpy(minute,v0+2,2); minute[2]='\0';
  strncpy(second,v0+4,2); second[2]='\0';
  i=0;
  while(*v1!='\0' && i<MssFieldMaxLen-2){
    if(*v1=='%'){
      switch(*(v1+1)){
        case 'H':
          mssCatStrings(hs,hour);
          v1=v1+2;
          break;
        case 'h':
          sprintf(buf,"%02d",(atoi(hour)-1)%12+1);
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case 'e':
          if(atoi(hour)<12) sprintf(buf,"AM");
          else              sprintf(buf,"PM");
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case 'j':
          if(atoi(hour)<12) sprintf(buf,"");
          else              sprintf(buf,"");
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        case 'M':
          mssCatStrings(hs,minute);
          v1=v1+2;
          break;
        case 'S':
          mssCatStrings(hs,second);
          v1=v1+2;
          break;
        case '%': /*%*/
          buf[0]='%'; buf[1]='\0';
          mssCatStrings(hs,buf);
          v1=v1+2;
          break;
        default:
          mssCatnStrings(hs,v1,1);
          v1++;
          break;
      }
    }else{
      mssCatnStrings(hs,v1,1);
      v1++;
    }
  }
  v.v.s=mssStrdup(hs->str);
  setStrMalAdd(v.v.s);
  mssFreeStrings(hs);
  return(v);
}

/**
 * # FUNCTION #
 * dayؿ
 * Ϳ day(1,2)
 * 1פ2פޤǤ֤
 * ȤΤǤդ1582ǯ10159999ǯ1231ޤǡ
 */
static MssValue cal_day(struct mssCal *cal)
{
  MssValue v;

  char *v0;
  char *v1;
  double JD0;
  double JD1;

  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul || cal->arg[1].val[0].nul){
    MssVnull(v);
    return(v);
  }
  v0 =cal->arg[0].val[0].v.s;
  v1 =cal->arg[1].val[0].v.s;

  if(!validDate(v0) || !validDate(v1)){
    MssVnull(v);
    return(v);
  }

  JD0=ut2jd(v0,"000000");
  JD1=ut2jd(v1,"000000");

  v.v.d = JD0-JD1;
  return(v);
}

/**
 * # FUNCTION #
 * timeؿ
 * Ϳ time(1,2)
 * ֻ1פֻ2פޤǤÿ֤
 */
static MssValue cal_time(struct mssCal *cal)
{
  MssValue v;

  time_t    fSec;
  time_t    tSec;
  struct tm fTm;
  struct tm tTm;

  char fBuf[20];
  char tBuf[20];
  char *v0;
  char *v1;
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul || cal->arg[1].val[0].nul){
    MssVnull(v);
    return(v);
  }
  v0 =cal->arg[0].val[0].v.s;
  v1 =cal->arg[1].val[0].v.s;

  if(!validTime(v0) || !validTime(v1)){
    MssVnull(v);
    return(v);
  }

  fTm.tm_year =-1900+2001 ; tTm.tm_year =-1900+2001;
  fTm.tm_mon  =-1+1       ; tTm.tm_mon  =-1+1;
  fTm.tm_mday =1          ; tTm.tm_mday =1;
  fTm.tm_isdst=-1         ; tTm.tm_isdst=-1;

  strncpy(fBuf,v0,2); fBuf[2]='\0';
  fTm.tm_hour=atoi(fBuf);

  strncpy(tBuf,v1,2); tBuf[2]='\0';
  tTm.tm_hour=atoi(tBuf);

  strncpy(fBuf,v0+2,2); fBuf[2]='\0';
  fTm.tm_min=atoi(fBuf);

  strncpy(tBuf,v1+2,2); tBuf[2]='\0';
  tTm.tm_min=atoi(tBuf);

  strncpy(fBuf,v0+4,2); fBuf[2]='\0';
  fTm.tm_sec=atoi(fBuf);

  strncpy(tBuf,v1+4,2); tBuf[2]='\0';
  tTm.tm_sec=atoi(tBuf);

  fSec=mktime(&fTm);
  tSec=mktime(&tTm);
  if( fSec==(time_t)-1 || tSec==(time_t)-1 ){
    MssVnull(v);
    return(v);
  }
  v.v.d = (double)difftime(fSec,tSec);
  return(v);
}

/**
 * # FUNCTION #
 * today()
 * ߤդ֤
 */
static MssValue cal_today(struct mssCal *cal)
{
  MssValue v;
  struct tm *tp;
  long Tim;
  mssVinit(&v,STR);

  time(&Tim);
  tp=localtime(&Tim);
  v.v.s=mssMalloc(9,"cal_today");
  sprintf(v.v.s,"%04d%02d%02d",tp->tm_year+1900,tp->tm_mon+1,tp->tm_mday);
  setStrMalAdd(v.v.s);
  return(v);
}

/**
 * # FUNCTION #
 * nowؿ
 * Ϳ now()
 * ߤλ֤
 */
static MssValue cal_now(struct mssCal *cal)
{
  MssValue v;
  struct tm *tp;
  long Tim;
  mssVinit(&v,STR);

  time(&Tim);
  tp=localtime(&Tim);
  v.v.s=mssMalloc(7,"cal_now");
  sprintf(v.v.s,"%02d%02d%02d",tp->tm_hour,tp->tm_min,tp->tm_sec);
  setStrMalAdd(v.v.s);
  return(v);
}

/**
 * # FUNCTION #
 * ageؿ
 * Ϳ age(1,2)
 * ǯ֤ؤС12ޤǤηвǯ֤
 */
static MssValue cal_age(struct mssCal *cal)
{
  MssValue v;
  int age;
  int y1,y2,m1,m2,d1,d2;
  char *v0;
  char *v1;
  char buf[20];
  char buf2[20];
  mssVinit(&v,DBL);

  if(cal->arg[0].val[0].nul || cal->arg[1].val[0].nul){
    MssVnull(v);
    return(v);
  }
  v0 =cal->arg[0].val[0].v.s;
  v1 =cal->arg[1].val[0].v.s;

  if(!validDate(v0) || !validDate(v1)){
    MssVnull(v);
    return(v);
  }

  strncpy(buf,v0,4);
  buf[4]='\0';
  y1 = atoi(buf);

  strncpy(buf2,v1,4);
  buf2[4]='\0';
  y2 = atoi(buf2);

  strncpy(buf,v0+4,2);
  buf[2]='\0';
  m1 = atoi(buf);

  strncpy(buf2,v1+4,2);
  buf2[2]='\0';
  m2 = atoi(buf2);

  strncpy(buf,v0+6,2);
  buf[2]='\0';
  d1 = atoi(buf);

  strncpy(buf2,v1+6,2);
  buf2[2]='\0';
  d2 = atoi(buf2);

  age = y1 - y2;
  if(m1 < m2){
    age--;
  }else{    
    if(m1 == m2){
      if(d1 < d2){
        age--;
      }
    }
  }
  v.v.d = (double)age;
  return(v);
}

/**
 * # FUNCTION #
 * dayaddؿ
 * Ϳ dayadd(,)
 * աפˡפäդ֤
 */
static MssValue cal_dayadd(struct mssCal *cal)
{

  MssValue v;
  char bufD[10];
  char bufT[10];
  char *v0;
  double jd;
  mssVinit(&v,STR);

  if(cal->arg[0].val[0].nul || cal->arg[1].val[0].nul){
    MssVnull(v);
    return(v);
  }

  v0 =cal->arg[0].val[0].v.s;
  if(!validDate(v0)){
    MssVnull(v);
    return(v);
  }

  jd=ut2jd(v0,"000000");
  jd+=cal->arg[1].val[0].v.d;
  jd2ut(bufD,bufT,jd);
  v.v.s=mssStrdup(bufD);
  setStrMalAdd(v.v.s);
  return(v);
}

/**
 * # FUNCTION #
 * timeaddؿ
 * Ϳ timeadd(,ÿ)
 * ֻפÿä֤
 */
static MssValue cal_timeadd(struct mssCal *cal)
{

  MssValue v;
  char buf[3];
  char *vt;
  struct tm time;
  struct tm *timeR;
  time_t t;
  mssVinit(&v,STR);

  if(cal->arg[0].val[0].nul||cal->arg[1].val[0].nul){
    MssVnull(v);
    return(v);
  }
  vt =cal->arg[0].val[0].v.s;

  if(!validTime(vt)){
    MssVnull(v);
    return(v);
  }

  time.tm_year = -1900+2001;
  time.tm_mon  = -1+1;
  time.tm_mday = 1;

  /**/
  strncpy(buf,vt+0,2); buf[2]='\0';
  time.tm_hour = atoi(buf);

  /*ʬ*/
  strncpy(buf,vt+2,2); buf[2]='\0';
  time.tm_min  = atoi(buf);

  /**/
  strncpy(buf,vt+4,2); buf[2]='\0';
  time.tm_sec  = atoi(buf);

  /*Ĵ̵*/
  time.tm_isdst=-1;

  /*ַ׻*/
  t=mktime(&time);

  t += (int)cal->arg[1].val[0].v.d;
  timeR=localtime(&t);

  v.v.s= mssMalloc(sizeof(char)*16,"timeadd");
  sprintf(v.v.s,"%02d%02d%02d", timeR->tm_hour, timeR->tm_min, timeR->tm_sec);
  setStrMalAdd(v.v.s);
  return(v);
}


/**
 * # FUNCTION #
 * lineؿ
 * Ϳ line()
 * ߽ιֹ֤
 */
static MssValue cal_line(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);
  v.v.d = (double)mssGV.inCnt;
  return(v);
}

/**
 * # FUNCTION #
 * keyLineؿ
 * Ϳ keyLine()
 * ߽Υֹ֤
 * ֹȤϡܤͤƱԤǤιֹΤȤǡۤ륭ͤ
 * ϤޤȡƤӣˤɤ롣
 * δؿ"-k"ѥ᡼ǥܤꤷʤФʤʤ
 * ޤƱͤǤ¤ӤθС"-s"ѥ᡼Ѥ롣
 */
static MssValue cal_keyLine(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);
  v.v.d = (double)mssGV.keyLine;
  return(v);
}

/**
 * # FUNCTION #
 * keyCntؿ
 * Ϳ keyCnt()
 * ߽ΥιԿ֤
 * δؿ"-k"ѥ᡼ǥܤꤷʤФʤʤ
 */
static MssValue cal_keyCnt(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);
  v.v.d = (double)mssGV.keyCnt;
  return(v);
}

/**
 * # FUNCTION #
 * keyNoؿ
 * Ϳ keyNo()
 * ߽Υֹ֤
 * ֹϡۤ륭ͤи뤿Ӥ˥󥯥Ȥ롣
 * δؿ"-k"ѥ᡼ǥܤꤷʤФʤʤ
 */
static MssValue cal_keyNo(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);
  v.v.d = (double)mssGV.keyNo;
  return(v);
}

/**
 * # FUNCTION #
 * fldCntؿ
 * Ϳ fldCnt()
 * ߽ι֤ܿ
 * ƤιԤˤơƱ֤ͤȤˤʤ롣
 */
static MssValue cal_fldCnt(struct mssCal *cal)
{
  MssValue v;
  mssVinit(&v,DBL);
  v.v.d = (double)mssGV.inFldCnt;
  return(v);
}

/**
 * # FUNCTION #
 * prvResultؿ
 * Ϳ prvResult()
 * ߽ιԤΰη̤֤(ʸȤƤǤʤMssValueȤ)
 * mssReadFRKɤ߹ߴؿξ: Ʊ쥭ˤƬԤߤξNULL
 * mssReadFldRec,mssReadFRDɤ߹ߴؿξ: ƬԤξNULL
 */
static MssValue cal_prvResult(struct mssCal *cal)
{
  MssValue v;

  v=PrvRsl.val;
  if(v.vType==STR && !v.nul){
    v.v.s=mssStrdup(PrvRsl.val.v.s);
    setStrMalAdd(v.v.s);
  }

  return(v);
}

/**
 * # FUNCTION #
 * topResultؿ
 * Ϳ topResult()
 * ƬԤη̤֤(ʸȤƤǤʤMssValueȤ)
 * mssReadFRKɤ߹ߴؿξ: Ʊ쥭ˤƬԤη
 * mssReadFldRec,mssReadFRDɤ߹ߴؿξ: ǡΰܤη
 */
static MssValue cal_topResult(struct mssCal *cal)
{
  MssValue v;

  v=TopRsl.val;
  if(v.vType==STR && !v.nul){
    v.v.s=mssStrdup(TopRsl.val.v.s);
    setStrMalAdd(v.v.s);
  }
  return(v);
}

/**
 * # FUNCTION #
 * prvFieldؿ
 * Ϳ prvField(̾)
 * ߽ιԤΰλΡֹ̾פ֤ͤ
 * (ʸȤƤǤʤMssValueȤ)
 * mssReadFRKɤ߹ߴؿξ: Ʊ쥭ˤƬԤߤξNULL
 * mssReadFldRec,mssReadFRDɤ߹ߴؿξ: ƬԤξNULL
 */
static MssValue cal_prvField(struct mssCal *cal)
{
  MssValue v;
  char *str;

  mssVinit(&v,STR);
  if(PrvFld.pnt[0]==NULL){
    MssVnull(v);
  }else{
    str=PrvFld.pnt[(*(cal->arg[0].flds->fi))->num];
    if(*str==MssNullChr){
      MssVnull(v);
    }else{
      v.v.s=mssStrdup(str);
      setStrMalAdd(v.v.s);
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * topFieldؿ
 * Ϳ topField(̾)
 * ƬԤλΡֹ̾פ֤ͤ(ʸȤƤǤʤMssValueȤ)
 * mssReadFRKɤ߹ߴؿξ: Ʊ쥭ˤƬԤη
 * mssReadFldRec,mssReadFRDɤ߹ߴؿξ: ǡΰܤη
 */
static MssValue cal_topField(struct mssCal *cal)
{
  MssValue v;
  char *str;

  mssVinit(&v,STR);
  if(TopFld.pnt[0]==NULL){
    MssVnull(v);
  }else{
    str=TopFld.pnt[(*(cal->arg[0].flds->fi))->num];
    if(*str==MssNullChr){
      MssVnull(v);
    }else{
      v.v.s=mssStrdup(str);
      setStrMalAdd(v.v.s);
    }
  }
  return(v);
}

/**
 * # FUNCTION #
 * lineCmpؿ
 * Ϳ lineCmp(̾1,̾2,...,̾n)
 * ꤵ줿nĤιܤˤĤơ߽ιԤȰιԤͤӤ
 * Ʊʤ0֤߹<Ԥʤ-1,߹>Ԥʤ1֤
 * δؿɤ߹ߴؿμ˴طʤƱư򤹤롣
 * ӤܤNULLͤޤޤƤNULL֤ͤ
 * ƬԤϡ߹>ԤȤư(ʤ֤)
 */
static MssValue cal_lineCmp(struct mssCal *cal)
{

  int i,j;
  int cmp;
  int fldNo;
  MssValue v;

  mssVinit(&v,DBL);

  v.v.d=0;

  /*ǽԤλϰۤʤԤȤ֤*/
  if(mssGV.inCnt==1){
    for(i=0; i<cal->argCnt; i++){
      for(j=0; j<cal->arg[i].valCnt; j++){
        if(cal->arg[i].val[j].nul){
          MssVnull(v);
          return(v);
        }
      }
    }
    v.v.d=1;
    return(v);
  }

  for(i=0; i<cal->argCnt; i++){
    for(j=0; j<cal->arg[i].valCnt; j++){
      fldNo=MssFlds2num(cal->arg[i].flds,i);
      if(cal->arg[i].val[j].nul || MssIsNull(PrvFld.pnt[fldNo]) ){
        MssVnull(v);
        return(v);
      }
      cmp=strcmp(cal->arg[i].val[j].v.s,PrvFld.pnt[fldNo]);
      if(cmp<0) {
        v.v.d=-1;
        return(v);
      }
      if(cmp>0) {
        v.v.d=1;
        return(v);
      }
    }
  }
  v.v.d=0;
  return(v);
}

/**
 * Ѳǽؿ
 * κĿMaxCalArg
 * name : ؿ̾⤷ϱ黻
 * type : 0:ؿ 1:黻
 * priority : 黻Ҥα黻ͥ(㤤̤ͥ⤤)
 *            ؿ̤ͥϺǤ⤤Τǡ"1"Ȥ롣
 * argType: η N:,S:ʸ,X:,M:0İʾη֤
 * retType: ֤ͤη N:, S:ʸ, X:
 * procType : Ѳǽʥǡɤ߹ߥ
 *            ߤΤȤreadFldRec,readFRD,readFRKλĤΤбƤ롣
 *            ӥåαreadFldRec,readFRD,readFRKνǡ
 *            бս˥ӥåȤ򤿤Ƥ롣
 *            1 : readFldRec
 *            2 : readFRD
 *            4 : readFRK
 *            ⤷readFRKɤ߹ߴؿѤȤΤѲǽˤ
 *            procType4Ȥ롣Ƥɤ߹ߴؿѲǽǤ7(1+2+4)
 *            Ȥ롣̾ñ̤νΤߤԤΤǤ7Ȥʤ롣
 * functionAddress: ºݤδؿɥ쥹
 * priorityϱ黻ҤΤ߱ƶ롣ؿ̤ͥȤꤢƤ뤬
 *
 * 1) "-"黻Ҥ"-eq"黻ҡ
 *   ޥɤμ¹Ի˻ꤵ줿׻α黻Ҥõݤˤ
 *   ʲΥꥹȤ˽иʸޥå󥰤򤷤Ƥ롣⤷"-"黻
 *   "-eq"黻ҤϿƤСȤ"-eq"ꤷƤƤ
 *   "-"黻ҤȤƥޥå󥰤ƤޤǡʲΥꥹϿˤ
 *   ƱƬʸı黻ҤˤĤƤϡΤʸĹĹ
 *   Ͽ뤳ȡ
 *   ޤؿ˴ؤƤϤΤ褦ʤȤ򵤤Ťɬפʤ
 *
 * 2) ǸdummyϡüθФΤᡣºݤˤtype==-1ȽǤƤ롣
 * 3) 黻Ҥα黻̤ͥ(priority)ϰʲʸ˴Ť
 *      ʿӲANCI C/C++ŵ,Ω,1996,p.708.
 */
struct Func func[]={
/* name         ,type
                  ,priority
                     ,argType[],retType
                                    ,procType
                                       ,functionAddress*/
  {"*"          ,1, 4,{N,N,E}  ,N   ,7 ,cal_mulOperator},
  {"/"          ,1, 4,{N,N,E}  ,N   ,7 ,cal_divOperator},
  {"%"          ,1, 4,{N,N,E}  ,N   ,7 ,cal_modOperator},
  {"<>"         ,1, 7,{N,N,E}  ,N   ,7 ,cal_neNOperator},
  {"<="         ,1, 7,{N,N,E}  ,N   ,7 ,cal_leNOperator},
  {"<"          ,1, 7,{N,N,E}  ,N   ,7 ,cal_ltNOperator},
  {">="         ,1, 7,{N,N,E}  ,N   ,7 ,cal_geNOperator},
  {">"          ,1, 7,{N,N,E}  ,N   ,7 ,cal_gtNOperator},
  {"=="         ,1, 7,{N,N,E}  ,N   ,7 ,cal_eqNOperator},
  {"-le"        ,1, 7,{S,S,E}  ,N   ,7 ,cal_leSOperator},
  {"-lt"        ,1, 7,{S,S,E}  ,N   ,7 ,cal_ltSOperator},
  {"-ge"        ,1, 7,{S,S,E}  ,N   ,7 ,cal_geSOperator},
  {"-gt"        ,1, 7,{S,S,E}  ,N   ,7 ,cal_gtSOperator},
  {"-ne"        ,1, 7,{S,S,E}  ,N   ,7 ,cal_neSOperator},
  {"-eq"        ,1, 7,{S,S,E}  ,N   ,7 ,cal_eqSOperator},
  {"=~"         ,1, 7,{S,S,E}  ,N   ,7 ,cal_regOperator},
  {"+"          ,1, 5,{N,N,E}  ,N   ,7 ,cal_addOperator},
  {"-"          ,1, 5,{N,N,E}  ,N   ,7 ,cal_subOperator},
  {"||"         ,1,13,{N,N,E}  ,N   ,7 ,cal_orOperator},
  {"&&"         ,1,12,{N,N,E}  ,N   ,7 ,cal_andOperator},

  {"age"        ,0, 1,{S,S,E}  ,N   ,7 ,cal_age},
  {"datefmt"    ,0, 1,{S,S,E}  ,S   ,7 ,cal_datefmt},
  {"dayadd"     ,0, 1,{S,N,E}  ,S   ,7 ,cal_dayadd},
  {"day"        ,0, 1,{S,S,E}  ,N   ,7 ,cal_day},
  {"timefmt"    ,0, 1,{S,S,E}  ,S   ,7 ,cal_timefmt},
  {"timeadd"    ,0, 1,{S,N,E}  ,S   ,7 ,cal_timeadd},
  {"time"       ,0, 1,{S,S,E}  ,N   ,7 ,cal_time},
  {"now"        ,0, 1,{E}      ,S   ,7 ,cal_now},
  {"today"      ,0, 1,{E}      ,S   ,7 ,cal_today},
  {"dt2jd"      ,0, 1,{S,S,E}  ,N   ,7 ,cal_dt2jd},
  {"jd2date"    ,0, 1,{N,E}    ,S   ,7 ,cal_jd2date},
  {"jd2time"    ,0, 1,{N,E}    ,S   ,7 ,cal_jd2time},
  {"leapyear"   ,0, 1,{S,E}    ,N   ,7 ,cal_leapyear},

  {"sum"        ,0, 1,{N,M,E}  ,N   ,7 ,cal_sum},
  {"min"        ,0, 1,{N,M,E}  ,N   ,7 ,cal_min},
  {"max"        ,0, 1,{N,M,E}  ,N   ,7 ,cal_max},
  {"sqrt"       ,0, 1,{N,E}    ,N   ,7 ,cal_Sqrt},
  {"power"      ,0, 1,{N,N,E}  ,N   ,7 ,cal_power},
  {"abs"        ,0, 1,{N,E}    ,N   ,7 ,cal_abs},
  {"up"         ,0, 1,{N,N,E}  ,N   ,7 ,cal_up},
  {"down"       ,0, 1,{N,N,E}  ,N   ,7 ,cal_down},
  {"round"      ,0, 1,{N,N,E}  ,N   ,7 ,cal_round},
  {"fixdec"     ,0, 1,{N,N,E}  ,S   ,7 ,cal_fixdec},
  {"pi"         ,0, 1,{E}      ,N   ,7 ,cal_pi},
  {"exp"        ,0, 1,{N,E}    ,N   ,7 ,cal_Exp},
  {"ln"         ,0, 1,{N,E}    ,N   ,7 ,cal_ln},
  {"log10"      ,0, 1,{N,E}    ,N   ,7 ,cal_log10},
  {"log2"       ,0, 1,{N,E}    ,N   ,7 ,cal_log2},
  {"log"        ,0, 1,{N,N,E}  ,N   ,7 ,cal_log},

  {"rand"       ,0, 1,{N,N,N,E},N   ,7 ,cal_rand},
  {"nrand"      ,0, 1,{N,N,N,E},N   ,7 ,cal_nrand},

  {"cat"        ,0, 1,{S,M,S,E},S   ,7 ,cal_cat},
  {"length"     ,0, 1,{S,E}    ,N   ,7 ,cal_length},
  {"fix"        ,0, 1,{S,N,S,S,E},S ,7 ,cal_fix},
  {"right"      ,0, 1,{S,N,E}  ,S   ,7 ,cal_right},
  {"left"       ,0, 1,{S,N,E}  ,S   ,7 ,cal_left},
  {"substr"     ,0, 1,{S,N,N,E},S   ,7 ,cal_substr},
  {"regexStart" ,0, 1,{S,S,E}  ,N   ,7 ,cal_regexStart},
  {"regexEnd"   ,0, 1,{S,S,E}  ,N   ,7 ,cal_regexEnd},
  {"regexLen"   ,0, 1,{S,S,E}  ,N   ,7 ,cal_regexLen},

  {"not"        ,0, 1,{N,E}    ,N   ,7 ,cal_not},
  {"if"         ,0, 1,{N,X,X,E},X   ,7 ,cal_if},
  {"isnull"     ,0, 1,{S,E}    ,N   ,7 ,cal_not},

  {"lineCmp"    ,0, 1,{S,M,E}  ,N   ,7 ,cal_lineCmp},

  {"prvField"   ,0, 1,{N,E}    ,S   ,7 ,cal_prvField},
  {"topField"   ,0, 1,{N,E}    ,S   ,7 ,cal_topField},
  {"prvResult"  ,0, 1,{E}      ,X   ,7 ,cal_prvResult},
  {"topResult"  ,0, 1,{E}      ,X   ,7 ,cal_topResult},
  {"keyLine"    ,0, 1,{E}      ,N   ,4 ,cal_keyLine},
  {"keyCnt"     ,0, 1,{E}      ,N   ,4 ,cal_keyCnt},
  {"keyNo"      ,0, 1,{E}      ,N   ,4 ,cal_keyNo},
  {"line"       ,0, 1,{E}      ,N   ,7 ,cal_line},
  {"fldCnt"     ,0, 1,{E}      ,N   ,7 ,cal_fldCnt},
  {"dummy"      ,-1,-1,{E}     ,E   ,0 ,NULL}
};

/**
 * # FUNCTION #
 * Func¤ΤargType[]åargCnt,argMul,mulBcnt,mulAcntѿ
 * åȤ롣
 * ѰɽMϰĤʤȤǤ롣
 * argCnt : ɬפʰο
 * argMul : Ѱޤफɤ
 * mulBcnt: Ѱ˲İ뤫
 * mulAcnt: Ѱθ˲İ뤫
 *
 * 㤨СargType[]={S,N,S,N,S,M,S,S,S} λ(ѰޤȤ)
 * argCnt =8
 * argMul =1
 * mulBcnt=4
 * mulAcnt=3
 *
 * 㤨СargType[]={S,N,S} λ(ѰޤޤʤȤ)
 * argCnt =3
 * argMul =0
 * mulBcnt=0
 * mulAcnt=0
 */
static void initCalFunc(void)
{
  int i,j;

  /**/
  i=0;
  while(func[i].type!=-1){
    func[i].argCnt =0;
    func[i].argMul =0;
    func[i].mulBcnt=0;
    func[i].mulAcnt=0;
    i++;
  }

  i=0;
  while(func[i].type!=-1){
    j=0;
    while(func[i].argType[j]!=E){
      if(func[i].argType[j]==M){
        func[i].argMul  =1;
        func[i].mulBcnt =j-1;
      }
      j++;
    }

    /*func->argCntϡɬפʰο */
    if(func[i].argMul) func[i].argCnt=j-1;
    else               func[i].argCnt=j;

    if(func[i].argMul==1){
      func[i].mulAcnt=j-func[i].mulBcnt-2;
    }
    i++;
  }
}

/**
 * # FUNCTION #
 * Ϳ줿ʸ(ʸ)黻ҤɤȽǤ롣
 * Ͽ줿黻ҵ˥ޥåп(1)Ǥʤе(0)֤
 */
static int cal_isOpe(char *str)
{
  int i;

  i=0;
  /*黻ҤΥå*/
  while(func[i].type!=-1){ /*funcνüå*/
    if(func[i].type==1){   /*黻Ҥʤ*/
      if( 0==strncmp(func[i].name,str,strlen(func[i].name)) )
        return(1);
    }
    i++;
  }
  return(0);
}

/**
 * # FUNCTION #
 * Ϳ줿ƬʸϿ줿ؿ̾ɤȽǤ롣
 * ̰ʳʸ+"("ǴؿȽǤ(ex. "sum(" )
 * ؿȽǤƤ⡢ϿƤʤؿǤХ顼λ롣
 * ؿǤп(1)Ǥʤе(0)֤
 */
static int cal_isFunc(char *str)
{
  int i;
  int len;
  char *parPos; /*̤ΰ*/
  char *orgStr;
  orgStr=str;

  /*ǽΰʸ̤ȤȤϡϴؿǤʤ*/
  if(*str=='(')return(0);

  /*str'('ФƤؿǤ롣黻ҤФдؿǤʤ*/
  while(1){
    if(*str=='('){
      parPos=str;
      break;
    }
    if(cal_isOpe(str)) return(0);
    if(*str=='\0')     return(0);
    str++;
  }

  /*$(λ˸¤äƴؿǤʤ*/
  if(*(str-1)=='$') return(0);

  /*ؿΥå*/
  str=orgStr;
  i=0;
  while(func[i].type!=-1){ /*funcνüå*/
    if(func[i].type==0){   /*ؿʤ*/
      len=strlen(func[i].name);
      if( 0==strncmp(func[i].name,str,len) ){
        if(*(str+len)=='(') return(1);
      }
    }
    i++;
  }
  *parPos='\0';
  mssShowErrMsg("I don't know such a function : %s",str);
  mssEnd(mssErrorNoDefault);
  return(0);
}

/**
 * # FUNCTION #
 * strͿ줿̾δؿ黻ҤCؿɥ쥹֤
 * ϿʤХ顼λ
 */
static struct Func *cal_setFuncAdd(char *str)
{
  int len;
  int i=0;

  while(1){

    /*ؿꥹȤǸޤɤߤä饨顼*/
    if(func[i].type==-1)break;

    len=strlen(func[i].name);
    if(0==strncmp(str,func[i].name,len)){
      return(&func[i]);
    }
    i++;
  }
  mssShowErrMsg("I don't know the function:%s\n",str);
  mssEnd(mssErrorNoDefault);
  return(0);
}

/**
 * # FUNCTION #
 * ʸȤƤη׻Υåӽ
 * åϡʲΤȤꡣ
 *   1) ̤бط(̤ο)
 *
 * ϡʲΤȤꡣ
 *   1) ɬפʥڡ⤷ϲԤν
 * 
 */
static char *cal_chkCal(char *str)
{
  int i;
  int parCnt; /*̤ФȤ˳̤Υ٥򥫥Ȥѿ*/
  char *buf;  /*åʸ*/
  char *bufTop;

  /*̤οå*/
  parCnt=0;
  for(i=0; i<strlen(str); i++){
    if(*(str+i)=='(') parCnt++;
    if(*(str+i)==')') parCnt--;
  }
  if(parCnt!=0){
    mssShowErrMsg("mismatch of '(' and ')'\n");
    mssEnd(mssErrorNoDefault);
  }

  /* ɬפʥڡν*/
  buf=mssMalloc(sizeof(char)*strlen(str)+1,"chkCal");
  bufTop=buf;
  while(*str!='\0'){
    /* '"'и鼡'"'ޤ̵ǥԡ*/
    if(*str=='"'){
      *buf=*str;
       buf++; str++;
      while(*str!='"' && *str!='\0'){
        if(*str!='\n'){
          *buf=*str;
          buf++; str++;
        }
      }
      if(*str=='\0') {
        mssShowErrMsg("mismatch of \"\"");
        mssEnd(mssErrorNoDefault);
      }
    }

    /* '$('и鼡')'ޤ̵ǥԡ*/
    if(*str=='$' && *(str+1)=='('){
      *buf=*str; buf++; str++;
      *buf=*str; buf++; str++;
      while(*str!=')' && *str!='\0'){
        if(*str!='\n'){
          *buf=*str;
          buf++; str++;
        }
      }
      if(*str=='\0') {
        mssShowErrMsg("mismatch of '(' and ')'");
        mssEnd(mssErrorNoDefault);
      }
    }

    /*ڡ⤷ϲԤϵͤ*/
    if(*str!=' ' && *str!='\n'){
      *buf=*str;
       buf++;
    }
    str++;
  }
  *buf='\0';
/*printf("after removing redundant spaces : %s\n",bufTop);*/
  return(bufTop);
}


/**
 * # FUNCTION #
 * 黻Ҥ⤷ϴؿΥܥ(str)ӤΥɥ쥹opeLstϿ롣
 */
static char *cal_setOpeTok(struct OpeLst *opeLst, char *str)
{

  opeLst->tbl=mssRealloc(opeLst->tbl, sizeof(struct OpeTbl)*(opeLst->cnt+1),"OpeTok");
  (opeLst->tbl+opeLst->cnt)->add=str;
  (opeLst->tbl+opeLst->cnt)->num=opeLst->cnt;
  (opeLst->tbl+opeLst->cnt)->func=cal_setFuncAdd(str);
  str+=strlen((opeLst->tbl+opeLst->cnt)->func->name);
  opeLst->cnt++;
  return(str);
}

/**
 * # FUNCTION #
 * strͿ줿׻Ρ黻Ҥ⤷ϴؿΥɥ쥹ؤΥꥹȤ롣
 * ̤ǰϤޤ줿α黻Ҥ⤷ϴؿϡоݳȤ롣
 * 㤨Сstr="($a+$b)/10"λ"+"оݤȤʤ
 * ޤؿΰ˸黻Ҥؿ⡢оݳȤ롣
 * str="sum($a,$b,sqrt($c),$d+$e)"λ"sqrt($c)","$d+$e"ɾʤ
 * ؿstrʸ˰ڼäʤ
 *  $a+$b/$c
 *    +  +--- (opeLst->opeTbl+1)->add
 *    |       (opeLst->opeTbl+1)->func
 *   (opeLst->opeTbl+0)->add : ɥ쥹
 *   (opeLst->opeTbl+0)->func : ؿؤΥݥ
 * opeLst->cnt = 2 "+""/"2Ĥα黻ҤȤäƤȤ̣
 */
static void cal_sepOpeTok( struct OpeLst *opeLst, char *str)
{
  int opeCnt; /*黻Ҥο*/
  char *orgStr;
  char *tmpStr;
  int i;
  opeLst->cnt=0;
  opeLst->tbl=NULL;

  orgStr=str;
  /*ޤ黻Ҥ򤵤*/
  while(*str!='\0'){

    if(*str=='(') {
      str=mssSkipStrBlock(str,'(',')'); /*̤Ф*/
      continue;
    }

    if(*str=='"') {
      str=mssSkipStrBlock(str,'"','"'); /*"Ф*/
      if(str==NULL) {
        mssShowErrMsg("mismatch of \"\"");
        mssEnd(mssErrorNoDefault);
      }
      continue;
    }
    if(cal_isOpe(str)){
      str=cal_setOpeTok(opeLst,str); /*opeLstϿ&str黻Ĺʬ*/
    }else{
      str++;
    }
  }

  /*˴ؿ򤵤*/
  /*ؿƬ⤷ϱ黻ҤμΤ*/
  str=orgStr;
  opeCnt=opeLst->cnt;

  if(cal_isFunc(str)){
    str=cal_setOpeTok(opeLst,str); /*opeLstϿ&str黻Ĺʬ*/
  }

  for(i=0; i<opeCnt; i++){
    tmpStr=(opeLst->tbl+i)->add+strlen((opeLst->tbl+i)->func->name);
    if( cal_isFunc(tmpStr) ){
      str=cal_setOpeTok(opeLst,tmpStr); /*opeLstϿ&str黻Ĺʬ*/
    }
  }
}

/**
 * # FUNCTION #
 * ¦γ̤򳰤 (a+b) -> a+b , ((a+b)) -> a+b
 * ʸΰݤ뤳Ȥʤ̤򳰤ʸƬɥ쥹
 * ֤
 */
static char *removePar(char *str)
{

  char *orgStr=str;

  if(*str!='(')return(str);
  str=mssSkipStrBlock(str,'(',')');
  if(*str=='\0'){
    *orgStr='\0';
    *(str-1)='\0';
    orgStr=removePar(++orgStr);
  }
  return(orgStr);
}

/**
 * # FUNCTION #
 * ̤ͥκǤ㤤黻Ҥ⤷ϴؿդ롣
 * ̤ͥƱʤиα黻Ҥ⤷ϴؿ
 */
static struct OpeTbl *getLowPriOpe(struct OpeLst *opeLst)
{
  int minPri=-1;
  int minNum=0;
  int i;

  for(i=0; i<opeLst->cnt; i++){
    if(minPri<=(opeLst->tbl+i)->func->priority){  /*̤ͥ㤱*/
      minPri=(opeLst->tbl+i)->func->priority;
      minNum=i;
    }
  }
  return(opeLst->tbl+minNum);
}

/**
 * # FUNCTION #
 * ɾ̤ͥ˽äơcal¤ΤΥĥ꡼ۤ
 * ۤκݤˤϡĤα黻Ҥ⤷ϴؿȤ˺ƵƤӽФˤơ
 * ĥ꡼Υ٥οΡɤ̤ͥι⤤黻⤷ϴؿǤ롣
 * ؿ⤷ϱ黻ҤĤʤNULL֤
 *
 * 1)
 * str="$val+10/$unit"
 * cal->func=addOperator
 *    ->argCnt=2
 *    ->arg[0].str="$val"
 *    ->arg[1].str="10/$unit"
 *    ->arg[1].node->func=divOperator
 *                 ->argCnt=2
 *                 ->arrg[0].str="10"
 *                 ->arrg[1].str="$unit"
 *
 * 2)
 * str="($val+10)/sum($a,$b,$c)"
 * cal->func=divOperator
 *    ->argCnt=2
 *    ->arg[0].str="$val+10"
 *    ->arg[0].node->func=addOperator
 *                 ->argCnt=2
 *                 ->arrg[0].str="$val"
 *                 ->arrg[1].str="10"
 *    ->arg[1].str="sum($a,$b,$c)"
 *    ->arg[1].node->func=divOperator
 *                 ->argCnt=3
 *                 ->arrg[0].str="$a"
 *                 ->arrg[1].str="$b"
 *                 ->arrg[2].str="$c"
 *
 * ޤδؿǤϡ׻δؿΰοΥåޤ黻ҤǤС
 * ͤ뤫ɤΥåԤ
 */
static struct mssCal *cal_sepCal(char *str, struct mssCal *parent)
{

  struct OpeLst opeLst;
  struct mssCal    *cal;
  struct mssCal    *argCal;
  struct OpeTbl *ope;
  char          *tmpPos;
  char          *tmpStr;
  char          *prePos;
  char           buf[1024];
  int            i;

  /*¦γ̤ϳ (a+b) -> a+b*/
  str=removePar(str);

  /*ߤʸ˴ؤơʱ黻ҤõopeLst¤Τ˥å*/
  cal_sepOpeTok(&opeLst,str);

  /*黻Ҥ⤷ϴؿ̵NULLǥ꥿*/
  if(opeLst.cnt==0) return(NULL);

  /*̤ͥκǤ㤤黻Ҥդ*/
  ope=getLowPriOpe(&opeLst);
/*printf("ope=%s %d\n",ope->add,ope->num);*/

  /*+ƥΡɤȤη*/
  cal=mssCalloc(sizeof(struct mssCal),"sepCal");
  cal->parent=parent; /*ƥΡ*/

  /*Ǥ㤤̤ͥα黻Ҥˤäʸ2Ĥʬ*/
  /* (a+b)/c  ->  (a+b)'\0'c*/
  /*              +     +*/
  /*              |     |*/
  /*              str   ope->add*/

  /*&&& ؿξ
    ؿΰ򥻥å
     X='\0'Ȥ
      sum(abc,(a+b),sum(a+b,c))
     --->>>
      sum(abcX(a+b)Xsum(a+b,c)X
      |   |   |     +arg[2]
      |   +   +arg[1]
      +   arg[0]
      ope->add or str
                  cal->argCnt=3 */
  if( ope->func->type == 0 ){
    cal->func=ope->func; /*ؿΥɥ쥹򥻥å*/

    /*ؿ̾(򥹥å*/
    tmpPos = ope->add;
    while( *(tmpPos++)!='(' );

    /* ','ˤȡʬ*/
    prePos=tmpPos; 
    cal->argCnt=0;

    if( *prePos != ')' ){ /* 'abc()'ʤǤʤ*/
      while(1){
        if(*tmpPos=='(') tmpPos=mssSkipStrBlock(tmpPos,'(',')');
        if(*tmpPos=='"'){
          tmpPos=mssSkipStrBlock(tmpPos,'"','"');
          if(tmpPos==NULL) {
            mssShowErrMsg("mismatch of \"\"");
            mssEnd(mssErrorNoDefault);
          }
        }

        if(*tmpPos==',' || *tmpPos==')'){
          cal->arg[cal->argCnt].str=prePos; /*Υå*/
          prePos=tmpPos+1;
          cal->argCnt++;                    /*οΥ󥯥*/
          if(*tmpPos==')'){
            *tmpPos='\0';
            break;
          }else{
            *tmpPos='\0';
          }
        }
        tmpPos++; 
      }
    }

    /*Υå*/
    if(cal->func->argMul == 0){ /*ѰǤʤ*/
      if(cal->func->argCnt != cal->argCnt){
        mssShowErrMsg("the number of arguments is wrong in [%s]\n",cal->func->name);
        mssEnd(mssErrorNoDefault);
      }
    }else{
      if(cal->argCnt>MaxCalArg){
        mssShowErrMsg("the number of arguments must be less than %d in [%s]\n",MaxCalArg,cal->func->name);
        mssEnd(mssErrorNoDefault);
      }
      if(cal->func->argCnt > cal->argCnt){
        mssShowErrMsg("the number of arguments is wrong [%s]\n",cal->func->name);
        mssEnd(mssErrorNoDefault);
      }
    }

  /*
    &&& 黻Ҥξ
     X='\0'Ȥ
     (a+b)/cX
      ->
     (a+b)XcX
     +    |+
     arg[0]|
     |    |arg[1]
     str  +
          ope->add
     cal->argCnt=2*/
  }else{
    /*黻ҤΥɥ쥹򥻥å*/
    cal->func=ope->func;

    /*黻*/
    if(cal->func->argCnt == 1){
      /*¦ΰХ顼*/
      if(ope->add!=str){
        mssShowErrMsg("黻\"%s\"κ˰\n",cal->func->name);
        mssEnd(mssErrorNoDefault);
      }

      /*ΰ*/
      cal->arg[0].str=ope->add+strlen(cal->func->name);/*黻ҤĹʬ餹 */

      /* 뤫ɤå*/
      if(*cal->arg[0].str=='\0'){
        mssShowErrMsg("黻\"%s\"αΰʤ\n",cal->func->name);
        mssEnd(mssErrorNoDefault);
      }
      cal->argCnt=1;
      *ope->add='\0';

    /*黻(ޤǤбƤʤ)*/
    }else{
      /*ΰ*/
      cal->arg[0].str=str;

      /*ΰ*/
      cal->arg[1].str=ope->add+strlen(cal->func->name); /*黻ҤĹʬ餹*/

      /* 뤫ɤå*/
      if(*cal->arg[0].str=='\0'){
        mssShowErrMsg("黻\"%s\"κΰʤ\n",cal->func->name);
        mssEnd(mssErrorNoDefault);
      }
      if(*cal->arg[1].str=='\0'){
        mssShowErrMsg("黻\"%s\"αΰʤ\n",cal->func->name);
        mssEnd(mssErrorNoDefault);
      }
      cal->argCnt=2;
      *ope->add='\0';
    }
  }

  /*ʪŪ˥ԡ(opeLst.tblfree뤿)*/
  for(i=0; i<cal->argCnt; i++){
    tmpStr=cal->arg[i].str;
    cal->arg[i].str=mssStrdup(tmpStr);
  }
  mssFree(opeLst.tbl);

  /*ƵƽФreallocƥɥ쥹ѤǽΤ*/
  /*ɥ쥹ꤹΤǤϤʤߤֹѤ*/
  for(i=0; i<cal->argCnt; i++){
    strcpy(buf,cal->arg[i].str);
    argCal=cal_sepCal(buf,cal); /*ƵCall*/
    if(argCal==NULL){
      cal->arg[i].type=LEAF;
    }else{
      cal->arg[i].type=NODE;
      cal->arg[i].node=argCal;
    }
  }
  return(cal);
}

/**
 * # FUNCTION #
 * ׻ĥ꡼¤ɽ(debug)
 */
void mssCalShowTree(struct mssCal *cal,int level){

  int i,j;

  for(i=0; i<level; i++){
    printf("  ");
  }
  printf("%s ",cal->func->name);
  for(i=0; i<cal->argCnt; i++){
    printf("%s",cal->arg[i].str);
    switch(cal->arg[i].type){
    case FIELD:
      printf("[fld:");
      for(j=0; j<cal->arg[i].flds->cnt; j++){
        printf("%d(%d) ",(*(cal->arg[i].flds->fi+j))->num,cal->arg[i].datType);
      }
      printf("]");
      break;
    case CONST:
      switch(cal->arg[i].datType){
      case N:
        printf("[cstnum:%g]",cal->arg[i].constant.v.d); break;
      case S:
        printf("[cstStr:%s]",cal->arg[i].constant.v.s); break;
      case X:
        printf("[unknown]"); break;
      }
    }
    printf(" ");
  }
  printf("\n");

  level++;
  for(i=0; i<cal->argCnt; i++){
    if(cal->arg[i].type==NODE)
      mssCalShowTree(cal->arg[i].node,level);
  }
}


/**
 * # FUNCTION #
 * °ΰֹ椫顢ΰΥǡ֤
 * (ѰΤˤ䤳)
 */
static int funcArgType(int argNum,struct mssCal *cal){
  if(cal->func->argMul){ /*Ѱޤޤ*/
    /* S,N,S,N,S,M,S,S,S λ    */
    /* ~~~~~~~                   */
    /* argNumξ */
    if(argNum<cal->func->mulBcnt){
      return(cal->func->argType[argNum]);
    }
    /* S,N,S,N,S,M,S,S,S λ    */
    /*             ~~~~~         */
    /* argNumξ */
    if(argNum>=cal->argCnt - cal->func->mulAcnt){
      return(cal->func->argType[argNum-(cal->argCnt-cal->func->argCnt)+1]);
    }
    /* S,N,S,N,S,M,S,S,S λ    */
    /*         ~~~               */
    /* argNumξ        */
    return(cal->func->argType[cal->func->mulBcnt]);
  }else{                 /*ѰޤޤƤʤ*/
    return(cal->func->argType[argNum]);
  }
}

/**
 * # FUNCTION #
 * ȹѿɾ
 * ̾˥磻ɥɤꤵƤСɾ롣
 * ɾ줿ʣι̾cal->arg[i]->flds˥åȤ롣
 * ꡼դȥåפɾ֤ͤηϾ̤ΰη˹碌)
 */
static void cal_evalFldsConst(
  struct mssCal    *cal,
  struct mssHeader *hd) {  /*ܤֹǻꤹ뤫ɤ*/

  int i;
  char *str;
  char *tmpStr;
  char *s;

  /*NODEκƵ*/
  for(i=0; i<cal->argCnt; i++){
    if( cal->arg[i].type ==  NODE){
      cal_evalFldsConst(cal->arg[i].node, hd);
    }
  }

  /*----------------------------------------*/
  /*ν                              */
  /*----------------------------------------*/
  for(i=0; i<cal->argCnt; i++){

    /*ǡפcal->funcäƤ*/
    cal->arg[i].datType=funcArgType(i,cal);
    switch(cal->arg[i].type){

    /*ؿ黻Ҥޤޤʤ*/
    case LEAF:
      /*ܤξ*/
      if( *cal->arg[i].str == '$' ){
        if( *(cal->arg[i].str+1) == '(' ){ /*$(Date*)λ*/
          tmpStr=mssSkipStrBlock(cal->arg[i].str+1,'(',')');
          *(tmpStr-1)='\0'; 
          str=cal->arg[i].str+2;
        }else{
          str=cal->arg[i].str+1;
        }
        cal->arg[i].type = FIELD;
        cal->arg[i].flds = mssInitFields();
        mssAddFieldsByFldInfoList(cal->arg[i].flds,
                                  mssFldGlbNam2Add(hd->flds,str));

      /*ξ*/
      }else{
        /*ºݤηȴؿ׵᤹ηʤ
          ؿη˹碌*/
        cal->arg[i].type = CONST;
        s=cal->arg[i].str;
        if(*s == '"'){ /*ºݤS*/
          tmpStr=mssSkipStrBlock(s,'"','"');
          if(tmpStr==NULL) {
            mssShowErrMsg("\"ο");
            mssEnd(mssErrorNoDefault);
          }
          *(tmpStr-1) = '\0';
          s++;
        }
        switch(cal->arg[i].datType) {
        case N:
          mssVinit(&cal->arg[i].constant,DBL);
          cal->arg[i].constant.v.d = atof(s);
          break;
        case S:
        case X: /*̤ξϡʸȤͤ򥻥åȤ*/
          mssVinit(&cal->arg[i].constant,STR);
          cal->arg[i].constant.v.s = s;
          break;
        }
      }
      break;

    } /* switch*/
  } /*for i<argCnt*/

  /*ͥפ*/
  cal->retType=cal->func->retType;
}

/**
 * # FUNCTION #
 * mssCal¤ΤǼ줿ؿ(黻)ΤѤƤǡɹؿ
 * ǲǽǤʤؿ(黻)ޤޤƤʤå롣
 * ޤޤƤС顼åɽƽλ롣
 */
static void cal_chkProcType(struct mssCal *cal, unsigned char procType)
{
  int i;

  if( (cal->func->procType & procType) == 0 ){
    mssShowErrMsg("cannot use the function [%s] in this command, or try it again with -k option if possible",cal->func->name);
    mssEnd(mssErrorNoDefault);
  }
  for(i=0; i<cal->argCnt; i++){
    if(cal->arg[i].type==NODE)
      cal_chkProcType(cal->arg[i].node,procType);
  }
}

/**
 * # FUNCTION #
 * ԡȥå׹ԡԷ̡ȥå׹Է̤ѤؿޤޤƤ뤫å
 * ޤޤƤСХѿǤ롢
 * UsedPrvResult,UsedTopResult,UsedPrvField,UsedTopFieldե饰򥻥åȤ롣
 */
static void cal_chkUsedPrvFldRsl(struct mssCal *cal)
{
  int i;

  if( 0==strcmp(cal->func->name,"prvResult") ){
    UsedPrvResult=1;
    return;
  }
  if( 0==strcmp(cal->func->name,"topResult") ){
    UsedTopResult=1;
    return;
  }
  if( 0==strcmp(cal->func->name,"prvField") ){
    UsedPrvField=1;
    return;
  }
  if( 0==strcmp(cal->func->name,"lineCmp") ){
    UsedPrvField=1;
    return;
  }
  if( 0==strcmp(cal->func->name,"topField") ){
    UsedTopField=1;
    return;
  }
  for(i=0; i<cal->argCnt; i++){
    if(cal->arg[i].type==NODE){
      cal_chkUsedPrvFldRsl(cal->arg[i].node);
    }
  }
}

/**
 * # FUNCTION #
 * ǡɹؿreadFldRecϿ롣
 */
void mssCalReadFuncIsFldRec(struct mssCal *cal,struct mssFldRec *fr)
{
  Fr=fr;
  cal_chkProcType(cal, 1);
  cal_chkUsedPrvFldRsl(cal);
}

/**
 * # FUNCTION #
 * ǡɹؿreadFRDϿ롣
 */
void mssCalReadFuncIsFRD(struct mssCal *cal,struct mssFldRecDbl *frd)
{
  Frd=frd;
  cal_chkProcType(cal, 2);
  cal_chkUsedPrvFldRsl(cal);
}

/**
 * # FUNCTION #
 * ǡɹؿreadFRKϿ롣
 */
void mssCalReadFuncIsFRK(struct mssCal *cal,struct mssFldRecKey *frk)
{
  Frk=frk;
  cal_chkProcType(cal, 4);
  cal_chkUsedPrvFldRsl(cal);
}

/**
 * # FUNCTION #
 * ȹ(pnt)ˤƷ׻ƵŪ˼¹Ԥη̤֤
 * ׻̤ͤηƤӽФ¦η˰פʤϷѴԤ
 */
static MssValue cal_calculate_sub(struct mssCal *cal, char **pnt)
{

  int i,j;
  int fldNo;
  MssValue val;
  for(i=0; i<cal->argCnt; i++){
    switch(cal->arg[i].type){
    case NODE:
      cal->arg[i].val[0] = cal_calculate_sub(cal->arg[i].node,pnt);
      cal->arg[i].valCnt = 1;
      break;
    case CONST:
      cal->arg[i].val[0] = cal->arg[i].constant;
      cal->arg[i].valCnt = 1;
      break;
    case FIELD:
      for(j=0; j<cal->arg[i].flds->cnt; j++){
        fldNo=MssFlds2num(cal->arg[i].flds,j);

        cal->arg[i].val[j].nul =0;/*nul*/
        if( MssIsNull(*(pnt+fldNo)) ){
          MssVnull(cal->arg[i].val[j]);
          continue;
        }

        switch(cal->arg[i].datType){
        case N:
          mssVinit(&cal->arg[i].val[j],DBL);
          cal->arg[i].val[j].v.d =atof(*(pnt+fldNo));
          break;
        case S:
        case X: /*̤ξϡʸȤͤ򥻥åȤ*/
          mssVinit(&cal->arg[i].val[j],STR);
          cal->arg[i].val[j].v.s =*(pnt+fldNo);
          break;
        default:
          mssShowErrMsg("internal error\n");
          mssEnd(mssErrorNoDefault);
        }
      }
      cal->arg[i].valCnt = j;
      break;
    }
  }

  /*Ѵ*/
  for(i=0; i<cal->argCnt; i++){
    /*ʸ󷿢ͷѴ*/
    if(cal->arg[i].datType==N && cal->arg[i].val[0].vType==STR){
      for(j=0; j<cal->arg[i].valCnt; j++){
        cal->arg[i].val[j]=mssVs2d(cal->arg[i].val[j]);
      }
      continue;
    }

    /*ͷʸѴ*/
    if(cal->arg[i].datType==S && cal->arg[i].val[0].vType==DBL){
      for(j=0; j<cal->arg[i].valCnt; j++){
        cal->arg[i].val[j]=mssVd2s(cal->arg[i].val[j]);
      }
      continue;
    }
  }

  /* ºݤδؿƤӽФ */
  val=(cal->func->pnt)(cal);

  return( val );
}

static void setRslVal(struct PrvRslStruct *prv, MssValue *rsl)
{
  prv->val=*rsl;
  if(rsl->vType==STR && !rsl->nul){
    strcpy(prv->buf,rsl->v.s);
    prv->val.v.s=prv->buf;
  }
}

static void clearRslVal(struct PrvRslStruct *prv)
{
  MssVnull(prv->val); /*ƬԷ̤ѿΥꥢ*/
}

static void setFldVal(struct PrvFldStruct *prv, char **pnt, int fldCnt)
{
  int chrCnt=0;
  char *str;
  int i;

  for(i=0; i<fldCnt; i++){
    prv->pnt[i]=&prv->buf[chrCnt];
    if(pnt==NULL){
      prv->buf[chrCnt++]=MssNullChr;
      prv->buf[chrCnt++]='\0';
    }else{
      str=*(pnt+i);
      while(*str!='\0'){
        prv->buf[chrCnt++]=*str++;
      }
      prv->buf[chrCnt++]='\0';
    }
  }
}

static void clearFldVal(struct PrvFldStruct *prv)
{
  prv->pnt[0]=NULL;  /*ԹܤѿΥꥢ*/
}

static void setTopField(void)
{
  if(Frk!=NULL){
    if(Frk->curRecNo==1) setFldVal(&TopFld,Frk->pnt,Frk->fldCnt);
  }else if(Frd!=NULL){
    if(mssGV.inCnt  ==1) setFldVal(&TopFld,Frd->pnt[Frd->new],Frd->fldCnt);
  }else if(Fr!=NULL){
    if(mssGV.inCnt  ==1) setFldVal(&TopFld,Fr->pnt,Fr->fldCnt);
  }
}

static void setPrvField(void)
{
  if(Frk!=NULL){
    if(Frk->curRecNo==Frk->keyRecCnt){
      clearFldVal(&PrvFld);
    }else{
      setFldVal(&PrvFld,Frk->pnt,Frk->fldCnt);
    }
  }else if(Frd!=NULL){
    setFldVal(&PrvFld,Frd->pnt[Frd->new],Frd->fldCnt);
  }else if(Fr!=NULL){
    setFldVal(&PrvFld,Fr->pnt,Fr->fldCnt);
  }
}

static void setTopResult(MssValue rsl)
{
  if(Frk!=NULL){
    if(Frk->curRecNo==1) setRslVal(&TopRsl,&rsl);
    if(Frk->curRecNo==Frk->keyRecCnt){
      clearRslVal(&PrvRsl);
    }
  }else if(Frd!=NULL){
    if(mssGV.inCnt  ==1) setRslVal(&TopRsl,&rsl);
  }else if(Fr!=NULL){
    if(mssGV.inCnt  ==1) setRslVal(&TopRsl,&rsl);
  }
}

static void setPrvResult(MssValue rsl)
{
  if(Frk!=NULL){
    if(Frk->curRecNo==Frk->keyRecCnt){
      clearRslVal(&PrvRsl);
    }else{
      setRslVal(&PrvRsl,&rsl);
    }
  }else if(Frd!=NULL){
    setRslVal(&PrvRsl,&rsl);
  }else if(Fr!=NULL){
    setRslVal(&PrvRsl,&rsl);
  }
}

/**
 * # FUNCTION #
 * ȹ(pnt)ˤƷ׻¹Ԥη̤֤
 * ߹Ԥ̤¸Ƥɬפ(prvField(),prvResult()ʤ)
 * ¸Ƥ
 */
MssValue mssCalculate(struct mssCal *cal, char **pnt)
{
  MssValue rsl;

  /*ƬԹܤΥå*/
  if(UsedTopField) setTopField();

  /*׻ǳݤ줿strΰ*/
  cal_freeStrMalAdd();

  /*׻ɾ*/
  rsl=cal_calculate_sub(cal,pnt);

  /*ԹܤΥå*/
  if(UsedPrvField !=0) setPrvField();

  /*ƬԷ׻̤Υå*/
  if(UsedTopResult!=0) setTopResult(rsl);

  /*Է׻̤Υå*/
  if(UsedPrvResult!=0) setPrvResult(rsl);

  return(rsl);
}

/**
 * # FUNCTION #
 * ׻(str)ɾCal¤(ĥ꡼¤ˤ뼰ɽ)ꤹ롣
 * ĥ꡼ΥȥåץΡɤؤΥݥ󥿤֤
 * إå(hd)ϡ׻ι̾褹뤿Ѥ롣
 */
struct mssCal *mssCalCompile(char *str, struct mssHeader *hd)
{
  struct mssCal *cal=NULL;

  initCalFunc();             /*func[]̤ѿΥå*/
  str=cal_chkCal(str);       /*å(;ʬڡν)*/
  cal=cal_sepCal(str,cal);   /*ȡʬ䤷ĥ꡼¤ˤ*/

  if(cal==NULL){
    mssShowErrMsg("cannot find any operators or functions");
    mssEnd(mssErrorNoDefault);
  } 
  cal_evalFldsConst(cal, hd); /*ɾ(ѿŸ)*/
  /*mssCalShowTree(cal,0);*/

  mssGV.inFldCnt=hd->flds->cnt; /*ϥǡιܿ򥰥ХѿϿ*/

  MssVnull(PrvRsl.val); /*Է̤ѿΥꥢ*/
  MssVnull(TopRsl.val); /*ƬԷ̤ѿΥꥢ*/
  PrvFld.pnt[0]=NULL;   /*ԹܤѿΥꥢ*/
  TopFld.pnt[0]=NULL;   /*ƬԹܤѿΥꥢ*/

  return(cal);
}

/**
 * # FUNCTION #
 * ɾĥ꡼ΰ賫
 */
void mssCalFree(struct mssCal *cal)
{
  int i;

  cal_freeStrMalAdd();

  for(i=0; i<cal->argCnt; i++){
    if(cal->arg[i].type==NODE){
      mssCalFree(cal->arg[i].node);
      mssFree(cal->arg[i].str);
    }else{
      if(cal->arg[i].type == FIELD){
        mssFreeFields(cal->arg[i].flds);
      }
      mssFree(cal->arg[i].node);
      mssFree(cal->arg[i].str);
    }
  }
  mssFree(cal);
}
