/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 0.1 : ǿ 2003/06/20                                              */
/* 0.2 : -cץɲ 2003/08/09                                          */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>

#include <xtformatHelp.h>
struct mssComHelp comHelp={
  "xtformat",     /* ޥ̾       */
  "0.2",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

extern struct mssGlobalVariables mssGV;
char *RepTarget; /*ִоʸ*/
int RepTargetLen;
char *RepStr;    /*ִʸ*/
int RepStrLen;

struct PrefixNode {
  char chr;                 /*Ρɤˤʸ*/
  int  fldNo;               /*ܤֹ(꡼դλ˥åȤ)*/
  int  cnt;                 /*ΡɤĻҶο*/
  struct PrefixNode **next; /*ΥΡɤؤΥꥹ(cntο)*/
};

enum DocType {
  KEY,
  LINE,
  TXT,
  IF,
  THEN,
  ELIF,
  ELSE
};

char keyStrings[1024]={'\0'}; /*ܤʸȤ¸*/
int keySum=0;

void prnn(char *str,int len){
  char *buf;
  if(str==NULL){
    printf("NULL");
  }else{
    buf=mssCalloc(sizeof(char)*(len+1),"prnn");
    strncpy(buf,str,len);
    printf("%s",buf);
    mssFree(buf);
  }
}

/*prefixTreeν(ǥХå)*/
void prnPrefixTree(struct PrefixNode *pn,int depth){
  int i;

  for(i=0; i<depth; i++) printf(" ");
  printf("%c [%d] %d\n",pn->chr,pn->fldNo,pn->cnt);
  if(pn->cnt==0) return;

  for(i=0; i<pn->cnt; i++){
    prnPrefixTree( *(pn->next+i), depth+1 );
  }
}

/*prefixTreeγ(ȥåץΡɤϳʤ)*/
void freePrefixTree(struct PrefixNode *pn){
  int i;

  if(pn->cnt==0){
    return;
  }

  for(i=0; i<pn->cnt; i++){
    freePrefixTree( *(pn->next+i));
  }
  for(i=0; i<pn->cnt; i++){
    mssFree(*(pn->next+i));
  }
  mssFree(pn->next);
}

/*ʸrepStrprefixĥ꡼Ͽ*/
/*եΡɤˤfldNoϿ*/
void setPrefixTree(struct PrefixNode *pn,char *repStr,int fldNo){
  struct PrefixNode *nextNode=NULL;
  int i;

  /*ִʸνüãƤдĶѿͤ򥻥åȤƥ꥿*/
  if(*repStr=='\0'){
    if(pn->fldNo!=-1) return; /*ϿѤȤȤƱʸȤ*/
    pn->fldNo=fldNo;
    return;
  }

  /*ΥΡɤ򸡺*/
  for(i=0; i<pn->cnt; i++){
    if( (*(pn->next+i))->chr == *repStr ){
      nextNode=*(pn->next+i);
      break;
    }
  }

  if( nextNode==NULL ){
    /*ΥΡɤ*/
    pn->next=mssRealloc(pn->next,sizeof(struct PrefixNode *)*(pn->cnt+1),"setPT");
    nextNode=*(pn->next+pn->cnt)=mssCalloc(sizeof(struct PrefixNode),"newPN");
    pn->cnt++;
    nextNode->fldNo=-1;

    /*Ρɤʸ򥻥å*/
    nextNode->chr=*repStr;
  }

  /*Ƶ*/
  setPrefixTree(nextNode,repStr+1,fldNo);
  return;
}

/*ʸchrˤäƼprefixΡɤ֤(ʤNULL֤)*/
struct PrefixNode *nextNode(struct PrefixNode *pn,char chr){
  int i;
  for(i=0; i<pn->cnt; i++){
    if( (*(pn->next+i))->chr == chr ){
      return(*(pn->next+i));
      break;
    }
  }
  return(NULL);
}

/*----------------------------------------------------------------------------*/
/* DocNode¤Τӽ                                                  */
/*----------------------------------------------------------------------------*/
struct DocNode {
  enum   DocType type;  /*KEY,LINE,TXT,IF,ELIF,ELSE(TOP-1)*/
  struct DocNode *parent; /*ƥΡɤؤΥݥ(TOPNULL)*/
  struct DocNode *next; /*ΥΡɤؤΥݥ(ʤNULL)*/
  int nextCnt;          /*ΥΡɤο*/

  int currentNo;        /*ϻΥȥΡֹ(top,key,line,ifΤͭ)*/
  int no;               /*Ƥ鸫ƲܤΥΡɤ*/

  char *txt;            /*TXTΡɤξ硢ɥȤؤΥݥ*/
  struct mssCal *cal;   /*ifΡɤξ硢ξＰ*/
  int keyNo;            /*keyΡɤξΥܤο*/
};

struct DocNode *currentNode;

void initDocNode(struct DocNode *doc){
  doc->type=-1;
  doc->parent=NULL;
  doc->next=NULL;
  doc->nextCnt=0;
  doc->keyNo=0;
  doc->txt=NULL;
  doc->cal=NULL;
  doc->currentNo=0;
  doc->no=0;
}


/*----------------------------------------------------------------------------*/
/* Block¤Τӽ                                                    */
/*----------------------------------------------------------------------------*/
struct Block {
  char *top;         /*Υ֥åƬ*/
  char *next;        /*Υ֥åƬ*/
  char *tag;         /*type==TXTλNULL, mallocǳ*/
  enum DocType type; /*Υ֥åΥ*/
};

void freeBlock(struct Block *block){
  if(block!=NULL){
    mssFree(block->tag);
    mssFree(block);
  }
}

/*----------------------------------------------------------------------------*/
/* strִ(optREP)˽ִִʸ֤                    */
/*----------------------------------------------------------------------------*/
char *replaceStr(char *str){
  char *pos;
  char *newStr;
  char *c;
  int len;

  /*ʬΰ(ܺĹ*ִʸĹ(10)*/
  newStr=mssMalloc(MssFieldMaxLen*11,"repStr");

  c=newStr;
  while( NULL != (pos=strstr(str,RepTarget)) ){
    strncpy(c,str,pos-str);
    c+=(pos-str);
    strncpy(c,RepStr,RepStrLen);
    c+=RepStrLen;
    str=pos+RepTargetLen;
  }
  len=strlen(str);
  strncpy(c,str,len);
  c+=len;
  *c='\0';
  return(newStr);
}

/*----------------------------------------------------------------------------*/
/* TXTNodeν                                                              */
/*----------------------------------------------------------------------------*/
void outTXT(struct PrefixNode *pt,char **fr,char *str,struct mssFPW *fpw){
  struct PrefixNode *pn;
  char *repStr;
  int mcnt;
  int i;
  pn=pt;
  mcnt=0; /*prefixTree򤿤ɤäƤǽΰפ֤Ū˥*/
  while(1){

    /*üǽλ*/
    if(*str=='\0'){
      break;
    }

    /*ߤʸprefixĥ꡼ƤϤᡢΥΡɤ*/
    pn=nextNode(pn,*str);

    /*nodeNULLȤȤϡפʸ̵äȤ*/
    if(pn==NULL){
      for(i=mcnt; i<=0; i++) mssWriteChr(*(str+i),fpw);
      mcnt=0;
      pn=pt;

    /*ߤprefixĥ꡼nodefldNo¸ߤȤȤ
      ޥåȤȤǡִʸ*/
    }else if(pn->fldNo!=-1){

      /*ִ郎ꤵƤʤ*/
      if(RepTarget==NULL){
        mssWriteStr(*(fr+pn->fldNo),fpw);

      /*ִ郎ꤵƤ*/
      }else{
        repStr=replaceStr(*(fr+pn->fldNo));
        mssWriteStr(repStr,fpw);
        mssFree(repStr);
      }
      pn=pt;
      mcnt=0;

    /*嵭ξʳȤȤϡޤǥޥåǤȤ*/
    }else{
      mcnt--;
    }
    str++;
  }
}

/*----------------------------------------------------------------------------*/
/* ߤΥΡɤΰʲνϲǽʥΡɤϤ                             */
/* until: 0-Ǹޤ, 1-KEY,LINEޤ, 2-LINEޤ                              */
/*----------------------------------------------------------------------------*/
struct DocNode *outNode(
  struct DocNode *doc, char **fr,
  struct PrefixNode *pt,struct mssFPW *fpw){
  MssValue rsl;
  int sel;

//printf("yyyyy %d,%d (%d)\n",doc->currentNo,doc->nextCnt,doc->type);
  /*ƥȥΡɤϽϤƿƤ*/
  if(doc->type == TXT){
    outTXT(pt,fr,doc->txt,fpw);
    doc->parent->currentNo++;
    return(doc->parent);
  } 

  /*ʾҥΡɤʤпƤ*/
  if(doc->currentNo>=doc->nextCnt) {
    doc->currentNo=0;
    doc->parent->currentNo++;
    return(doc->parent);
  }

  if(doc->type==IF){
    /*ϤƤΥΡɤãȤϾɾ*/
    if(doc->currentNo==0){
      rsl=mssCalculate(doc->cal, fr); 
      if(rsl.nul){
        sel=0;
      }else{
        if(rsl.vType==DBL){
          sel=(int)rsl.v.d;
        }else{
          sel=atoi(rsl.v.s);
        }
      }

      /*郎פTHENΡɤ*/
      /*˵äƤϡƤ褦currentNoꤷƤ*/
      if(sel){
        doc->currentNo=doc->nextCnt;
        return(doc->next+0);

      /*郎פʤмΥΡɤ˥󥯥Ȥ*/
      /*IFΡɤΤޤޥ꥿*/
      }else{
        doc->currentNo++;
        return(doc);
      }

    /*ܰʹߤˬλ*/
    }else{
      return(doc->next+doc->currentNo);
    }
  }

  if(doc->type==ELIF){
    rsl=mssCalculate(doc->cal, fr); 
    if(rsl.nul){
      sel=0;
    }else{
      if(rsl.vType==DBL){
        sel=(int)rsl.v.d;
      }else{
        sel=atoi(rsl.v.s);
      }
    }

    /*郎פлҥΡɤ*/
    /*˵äƤϡ(IF)򽪤褦currentNoꤷƤ*/
    if(sel==1){
      doc->parent->currentNo=doc->parent->nextCnt;
      return(doc->next+doc->currentNo);

    /*郎פʤпƥΡɤ򥤥󥯥Ȥ*/
    /*Ƥ˵*/
    }else{
      doc->parent->currentNo++;
      return(doc->parent);
    }
  }

  return(doc->next+doc->currentNo);
}


/*----------------------------------------------------------------------------*/
/* <!--key-->б<!--endkey-->򸫤Ĥ(keyΥͥȤθ)     */
/* <!--endkey-->"<"'\0'ִ                                         */
/* <!--endkey-->μΰ֤֤                                              */
/* бendʤХ顼                                            */
/*----------------------------------------------------------------------------*/
char *getEndKey(char *buf){
  int depth=1;
  char *pnt=buf;

  while(1){
    pnt=strstr(pnt,"<!--");
    if(pnt==NULL) {
      mssShowErrMsg("there is no end tag for '<!--key-->'");
      mssEnd(mssErrorNoDefault);
    }
    if( 0==strncmp(pnt+4,"key ",4) ) {
      depth++;
    }else if( 0==strncmp(pnt+4,"endkey-->", 9) ) {
      depth--;
      if(depth==0) break;
    }
    pnt++;
  }

  *pnt='\0';      /*֥åκǽ'\0'ִ*/
  return(pnt+13); /*Υ֥å֤֤*/
}

/*----------------------------------------------------------------------------*/
/* <!--line-->б<!--endline-->򸫤Ĥ(lineϥͥȤʤ)  */
/* <!--endline-->"<"'\0'ִ                                        */
/* <!--endline-->μΰ֤֤                                             */
/* бendʤХ顼                                            */
/*----------------------------------------------------------------------------*/
char *getEndLine(char *buf){
  char *pnt=buf;

  pnt=strstr(pnt,"<!--endline-->");
  if(pnt==NULL) {
    mssShowErrMsg("there is no end tag for '<!--line-->'");
    mssEnd(mssErrorNoDefault);
  }
  *pnt='\0';      /*֥åκǽ'\0'ִ*/
  return(pnt+14); /*Υ֥å֤֤*/
}

/*----------------------------------------------------------------------------*/
/* Τʤdocν򸫤Ĥ(˽и륿⤷EOF            */
/* <!--***-->"<"'\0'ִ,EOFʤ̵ִ                            */
/* <!--***-->μΰ֤֤,EOFʤNULL֤                               */
/*----------------------------------------------------------------------------*/
char *getEndTxt(char *buf){
  char *pnt=buf;

  while(1){
    pnt=strstr(pnt,"<!--");
    if(pnt!=NULL){
      if( 0==strncmp(pnt+4,"key " , 4) ||
          0==strncmp(pnt+4,"line" , 4) ||
          0==strncmp(pnt+4,"if "  , 3) ||
          0==strncmp(pnt+4,"elif ", 5) ||
          0==strncmp(pnt+4,"else" , 4) ||
          0==strncmp(pnt+4,"endif", 5) ) break;
    }else{
      break;
    }
    pnt++;
  }
  if(pnt!=NULL){
    *pnt++='\0';   /*֥åκǽ'\0'ִ*/
  }
  return(pnt);
}

/*----------------------------------------------------------------------------*/
/* <!--if-->бend򸫤Ĥ(ifΥͥȤθ)                 */
/* endϡendifΤ줫                                                 */
/* <!--end-->"<"'\0'ִ                                        */
/* <!--end-->μΰ֤֤                                             */
/* бendʤХ顼                                            */
/*----------------------------------------------------------------------------*/
char *getEndIf(char *buf){
  int depth=1;
  char *pnt=buf;

  while(1){
    pnt=strstr(pnt,"<!--");
    if(pnt==NULL) {
      mssShowErrMsg("there is no end tag for '<!--if-->'");
      mssEnd(mssErrorNoDefault);
    }
    if( 0==strncmp(pnt+4,"if ",3) ) {
      depth++;
    }else if( 0==strncmp(pnt+4,"endif-->", 8) ) {
      depth--;
    }
    if(depth==0) {
      if( 0==strncmp(pnt+4,"endif", 5) ){
        *pnt++='\0'; /*֥åκǽ'\0'ִ*/
        pnt=strstr(pnt,"-->");
        if(pnt==NULL) {
          mssShowErrMsg("not a complete tag");
          mssEnd(mssErrorNoDefault);
        }
        pnt+=3;
        break;
      }
    }
    pnt++;
  }
  return(pnt);
}


/*----------------------------------------------------------------------------*/
/* then or<!--elif-->бend򸫤Ĥ(ifΥͥȤθ)        */
/* endϡelif,else,endifΤ줫                                       */
/* <!--end-->"<"'\0'ִ                                        */
/* <!--end-->μΰ֤֤                                             */
/* бendʤХ顼                                            */
/*----------------------------------------------------------------------------*/
char *getEndThen(char *buf){
  int depth=1;
  char *pnt=buf;

  while(1){
    pnt=strstr(pnt,"<!--");
    if(pnt==NULL) break;
    if( 0==strncmp(pnt+4,"if ",3) ) {
      depth++;
    }else if( 0==strncmp(pnt+4,"endif-->", 8) ) {
      depth--;
    }
    if(depth==1) {
      if( 0==strncmp(pnt+4,"elif ", 5) || 0==strncmp(pnt+4,"else", 4) ){
        *pnt++='\0'; /*֥åκǽ'\0'ִ*/
        break;
      }
    }
    if(depth==0) {
      if( 0==strncmp(pnt+4,"endif", 5) ){
        *pnt++='\0'; /*֥åκǽ'\0'ִ*/
        pnt=strstr(pnt,"-->");
        if(pnt==NULL) {
          mssShowErrMsg("not a complete tag");
          mssEnd(mssErrorNoDefault);
        }
        pnt+=3;
        break;
      }
    }
    pnt++;
  }
  return(pnt);
}

/*----------------------------------------------------------------------------*/
/* <!--else-->бend򸫤Ĥ(ifΥͥȤθ)               */
/* <!--endif-->"<"'\0'ִ                                          */
/* <!--endif-->μΰ֤֤                                               */
/* бendʤХ顼                                            */
/*----------------------------------------------------------------------------*/
char *getEndElse(char *buf){

  return(NULL);
/*
  int depth=1;
  char *pnt=buf;

  while(1){
    pnt=strstr(pnt,"<!--");
    if(pnt==NULL) {
      mssShowErrMsg("there is no end tag for '<!--if-->'");
      mssEnd(mssErrorNoDefault);
    }
    if( 0==strncmp(pnt+4,"key ",4) ) {
      depth++;
    }else if( 0==strncmp(pnt+4,"endif-->", 8) ) {
      depth--;
      if(depth==0) break;
    }
    pnt++;
  }
*/

  //*pnt='\0';      /*֥åκǽ'\0'ִ*/
  //return(pnt+12); /*Υ֥å֤֤*/
}

/*----------------------------------------------------------------------------*/
/* bufǽΥ֥åȴФ                                            */
/* <!--endif-->"<"'\0'ִ                                          */
/* <!--endif-->μΰ֤֤                                               */
/* бendʤХ顼                                            */
/*----------------------------------------------------------------------------*/
char *getNextBlock(char *buf,enum DocType type){
  char *pnt=NULL;

  switch(type){
    case KEY:
      pnt=getEndKey(buf);
      break;
    case LINE:
      pnt=getEndLine(buf);
      break;
    case TXT:
      pnt=getEndTxt(buf);
      break;
    case IF:
      pnt=getEndIf(buf);
      break;
    case THEN:
    case ELIF:
      pnt=getEndThen(buf);
      break;
    case ELSE:
      pnt=getEndElse(buf);
      break;
  }
  return(pnt);
}

/*----------------------------------------------------------------------------*/
/* bufǽΥ֥åȴФBlock¤Τ֤                         */
/* block->tag  = <!--***-->ʸ                                           */
/* block->type = KEY | LINE | TXT | IF | ELIF | ELSE                          */
/* block->next = Υ֥åκǽΰ"!--***-->"Ƭ                    */
/* block->top  = <!--***-->"μΰ                                        */
/*----------------------------------------------------------------------------*/
struct Block *getBlock(char *buf, struct DocNode *doc){
  struct Block *block;
  char *end;
  char repChr;

  block=mssCalloc(sizeof(struct Block),"getBlock");

  /*֥åΥפ*/
        if(0==strncmp(buf,"!--key " , 7)){
    block->type=KEY;
  }else if(0==strncmp(buf,"!--line" , 7)){
    block->type=LINE;
  }else if(0==strncmp(buf,"!--if "  , 6)){
    block->type=IF;
  }else if(0==strncmp(buf,"!--elif ", 8)){
    block->type=ELIF;
  }else if(0==strncmp(buf,"!--else" , 7)){
    block->type=ELSE;
  }else if(doc->type==IF){
    block->type=THEN;
  }else{
    block->type=TXT;
  }

  /*Υ֥åνλ֤򸡽Ф\0ִΥ֥åƬ*/
  /*֥åǸãƤNULLȤʤ*/
  block->next=getNextBlock(buf,block->type);

  /*tagʸȤƼ(ΰ,ꥸʥѹʤ)*/
  if(block->type != TXT && block->type != THEN){
    end=strstr(buf,"-->");
    if(end==NULL){
      mssShowErrMsg("can not find closure");
      mssEnd(mssErrorNoDefault);
    }
    end+=3;
    /*tagΥԡ*/
    repChr=*end;
    *end='\0';
    block->tag=mssStrdup(buf);
    *end=repChr;
    block->top=end;

    /*֥åƬ(tagμʸ)*/
  }else{
    /*TXT,THENפξtagʤ*/
    block->tag=NULL;
    block->top=buf;
  }
  
  return(block);
}


int getFldNo(struct PrefixNode *pt,char *str){
  struct PrefixNode *pn;
  int fldNo;
  int mcnt;
  pn=pt;
  mcnt=0; /*prefixTree򤿤ɤäƤǽΰפ֤Ū˥*/
  while(1){
  
    /*üǽλ*/
    if(*str=='\0'){
      fldNo=-1;
      break;
    } 
    
    /*ߤʸprefixĥ꡼ƤϤᡢΥΡɤ*/
    pn=nextNode(pn,*str);
    
    /*nodeNULLȤȤϡפʸ̵äȤ*/
    if(pn==NULL){
      fldNo=-1;
      break;      

    /*ߤprefixĥ꡼nodefldNo¸ߤȤȤ
      ޥåȤȤǡִʸ*/
    }else if(pn->fldNo!=-1){
      fldNo=pn->fldNo;
      break;
    }

    /*嵭ξʳȤȤϡޤǥޥåǤȤ*/
    str++;
  }
  return(fldNo);
}

/*----------------------------------------------------------------------------*/
/* key ι̾̾keyStrings(Х)˥åȤ             */
/* doc->keyNoˤϡޤǤKeyܤοѤȤ                          */
/*----------------------------------------------------------------------------*/
void setKeyTag(struct DocNode *doc, char *tag,struct PrefixNode *pt){
  char **keyStr;
  int keyCnt;
  int i;
  char *end;

  /* !--key $fldname1,$fldname2-->  --> tag=="$fldname1,$fldname2" */
  tag+=7;
  end=strstr(tag,"-->");
  if(end==NULL) {
    mssShowErrMsg("can not find closure");
    mssEnd(mssErrorNoDefault);
  }
  *end='\0';


  /* $fildname ιֹĴ٥åȤ */
  keyStr=mssTokByChr(tag,',',&keyCnt,0);
  for(i=0;i<keyCnt;i++){ /*ʣιܤĴ٤(޶ڤ)*/
    /* Key¤ѤʸȤƤι̾*/
    strcat(keyStrings,",");
    strcat(keyStrings,*(keyStr+i));
  }
  keySum+=keyCnt;
  doc->keyNo=keySum;
}

/*----------------------------------------------------------------------------*/
/* if, elif ι̾׻¤Τ򥻥åȤ                          */
/*----------------------------------------------------------------------------*/
void setIfTag(struct DocNode *doc, char *tag,struct mssHeader *hdi){
  char *end;

  /* !--if $fldname1="aaa"-->  --> tag==$fldname1="aaa" */
  if(doc->type==IF) tag+=6;
  else              tag+=8;
  end=strstr(tag,"-->");
  if(end==NULL) {
    mssShowErrMsg("can not find closure");
    mssEnd(mssErrorNoDefault);
  }
  *end='\0';

  /*׻ɾ*/
  doc->cal=mssCalCompile(tag,hdi);

}

/*----------------------------------------------------------------------------*/
/* ȥեι¤ϤDocNode¤Τ˥åȤ                      */
/*----------------------------------------------------------------------------*/
void setDocTree(
  struct DocNode *doc,
  char *buf,
  struct PrefixNode *pt,
  struct mssHeader *hdi){
  struct Block *block;     /*֥åξ*/
  struct DocNode *curNext; /*ݤDocNode(ṳ̂Τ)*/

  doc->nextCnt=0;
  while(1){
   /* bufǽΥ֥åȴФBlock¤ΤΥå */
    block=getBlock(buf,doc);
//printf("==%d=%s\n",block->type,block->top);

    /*嵭֥åѤDocNode¤Τγ*/
    doc->next=
      mssRealloc(doc->next,sizeof(struct DocNode)*(doc->nextCnt+1),"setDoc");
    curNext=doc->next+doc->nextCnt;
    initDocNode(curNext);
    curNext->no=doc->nextCnt; /*Ƥ鸫ƲܤΥΡɤ*/
    doc->nextCnt++;
    curNext->type=block->type;

    switch(block->type){
      case KEY:
        setKeyTag(curNext,block->tag,pt);
        break;
      case LINE:
      break;
      case IF:
        setIfTag(curNext,block->tag,hdi);
        break;
      case ELIF:
        setIfTag(curNext,block->tag,hdi);
        break;
      case THEN:
      case ELSE:
        break;
      case TXT:
        curNext->txt=block->top;
      break;
    }

    /*TXT֥åξʳƵ*/
    if(block->type!=TXT){
      setDocTree(curNext,block->top,pt,hdi);
    }

    /*Υ֥å򥻥åȤ֤*/
    buf=block->next;
    freeBlock(block);

    /*Υ֥åʤнλ*/
    if(buf==NULL) break;
  }
}


/*----------------------------------------------------------------------------*/
/* ƥΡɤ                                                             */
/*----------------------------------------------------------------------------*/
void setParent(struct DocNode *doc,struct DocNode *parent){
  int i;
  doc->parent=parent;
  for(i=0; i<doc->nextCnt; i++){
    setParent(doc->next+i,doc);
  } 
}

/*----------------------------------------------------------------------------*/
/* DocNode¤Τν(ǥХå)                                            */
/*----------------------------------------------------------------------------*/
void prnTxt(char *str){
  while(*str!='\0'){
    if(*str=='\n') printf("\\n");
    else           printf("%c",*str);
    str++;
  }
}

void prnDocTree(struct DocNode *doc, int depth){
  int i;

  for(i=0; i<depth; i++) printf("  ");
  switch(doc->type){
    case KEY:
      printf("KEY (%d) [%d]\n",doc->no,doc->keyNo);
      break;
    case LINE:
      printf("LINE (%d)\n",doc->no);
      break;
    case TXT:
      printf("TXT (%d)[",doc->no);
      prnTxt(doc->txt);
      printf("]\n");
      break;
    case IF:
      printf("IF (%d)\n",doc->no);
      //cal_printTree(doc->cal,0);
      break;
    case ELIF:
      printf("ELIF (%d)\n",doc->no);
      //cal_printTree(doc->cal,0);
      break;
    case THEN:
      printf("THEN (%d)\n",doc->no);
      break;
    case ELSE:
      printf("ELSE (%d)\n",doc->no);
      break;
  }
  if(doc->next==NULL) return;
  for(i=0; i<doc->nextCnt; i++){
    prnDocTree(doc->next+i,depth+1);
  }
}

void setCalReadFunc(struct DocNode *doc, struct mssFldRecDbl *frd)
{
  int i;
  if(doc->type == IF){
    /*calculationѤɹؿϿ*/
    mssCalReadFuncIsFRD(doc->cal,frd);
  }
  if(doc->next==NULL) return;
  for(i=0; i<doc->nextCnt; i++){
    setCalReadFunc(doc->next+i,frd);
  }
}

/*----------------------------------------------------------------------------*/
/* keyΥ֥쥤Ƚ                                                */
/*----------------------------------------------------------------------------*/
int keyTagBreak(struct mssFldRecDbl *frd, MssOptKEY *optKey, struct DocNode *doc){
  int i,fn;

  /*ǽԤλϥ֥졼*/
  if(frd->eof == 1) return(1);

  for(i=0; i<doc->keyNo; i++){
    fn=MssFlds2num(optKey->flds,i);
    if( 0 != strcmp(*(frd->pnt[frd->new]+fn),*(frd->pnt[frd->old]+fn)) )
       return(1);
  }
  /*嵭ξ򥯥ꥢȤȤϥ֥졼Ǥʤ*/
  /*(optKey->flds->cnt0ȤȤϡ-kλ꤬ʤΤǥ֥졼Ǥʤ)*/
  return(0);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* (Ūѡѥ᡼ǤϻǤʤ                          */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* ץ󥿥                                             */
    "k",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    2,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
  };

/*----------------------------------------------------------------------------*/
/* ʸִꥹ                                                           */
/*----------------------------------------------------------------------------*/
  MssOptSLS optREP={
    OSLS,   /* ץ󥿥                                             */
    "c",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL,   /* ǥե(ʸ)                                           */
    1,      /* ޤǶڤǿκ                             */
    1,      /* ǤʸĹκǾ                                     */
    MssFieldMaxLen,/* ǤʸĹκ                              */
    1,      /* 1:Ǥ˥Ǥ,0:Բ  ex) aaaa:xxxxx            */
    REPT,   /* ΥץΥȥ(Helpɽ)                         */
    REPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ִоݥե                                                           */
/*----------------------------------------------------------------------------*/
  MssOptINF optREF={
    OINF,   /* ץ󥿥                                             */
    "I",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    REFT,   /* ΥץΥȥ(Helpɽ)                         */
    REFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optREP,&optINF,&optREF,&optOTF,&optZIP,NULL};

  struct mssHeader *hdi; /*ϥե<head>Ǽ¤*/
  struct mssFPR    *fpr; /*ϥե빽¤*/
  struct mssFPR    *fpf; /*ȥե빽¤*/
  struct mssFPW    *fpw; /*ϥե빽¤*/
  //Key           *key; /*ܹ¤*/

  struct mssFldRecDbl *frd; /*-Хåե¤*/
  struct DocNode *doc;
  struct DocNode *keyNode;
  struct mssRec    *rec; /*ԥХåե¤*/
  struct PrefixNode *pt;
  char *buf;
  int   bufSize;
  char fldName[MssFieldNameMaxLen+10];
  int i;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
  fpr=mssOpenFPR(optINF.str,4);      /* ϥե륪ץ                  */
  hdi=mssReadHeader(fpr);            /* إåɤ߹                      */

  if(optREP.set){
     RepTarget=*optREP.strList;
     RepTargetLen=strlen(*optREP.strList);
  }else{
     RepTarget=NULL;
  }
  if(optREP.set){
     RepStr=*optREP.colList;
     RepStrLen=strlen(*optREP.colList);
  }else{
     RepStr=NULL;
  }

/*----------------------------------------------------------------------------*/
/* ̾ѿ̾ȤprefixTree˥å                                     */
/* ꡼դˤϹֹ򥻥å                                                 */
/*----------------------------------------------------------------------------*/
  pt=mssCalloc(sizeof(struct PrefixNode),"newPN");
  pt->fldNo=-1;
  for(i=0; i<hdi->flds->cnt; i++){

    /*ִоʸ ex. $abc */
    strcpy(fldName,"$");
    strcat(fldName,MssFlds2name(hdi->flds,i));

    /*prefix treeϿ*/
    setPrefixTree(pt,fldName,i);

    /*ִоʸ ex. ${abc} */
    strcpy(fldName,"${");
    strcat(fldName,MssFlds2name(hdi->flds,i));
    strcat(fldName,"}");

    /*prefix treeϿ*/
    setPrefixTree(pt,fldName,i);
  }
//  prnPrefixTree(pt,0);

/*----------------------------------------------------------------------------*/
/* ִեɤ߹                                                     */
/* -KͤǰϤޤ줿֥å                                                   */
/*                                                                            */
/* <html>                                                                     */
/*   <!--key-->                                                               */
/*     <table>aaaaa $date bbb                                                 */
/*     <!--line-->                                                            */
/*        <td>$user</td><td>$time</td>                                        */
/*     <!--line-->                                                            */
/*     aaaaa $date bbb                                                        */
/*     </table>                                                               */
/*   <!--key-->                                                               */
/* </html>                                                                    */
/*                                                                            */
/* repTxtHead ܤ<!--key-->ޤǤΥ֥å                                */
/* repTxtKeyH ܤ<!--key-->ܤ<!--line-->ޤǤΥ֥å         */
/* repTxtLine ܤ<!--line-->ܤ<!--line-->ޤǤΥ֥å        */
/* repTxtKeyT ܤ<!--line-->ܤ<!--key-->ޤǤΥ֥å         */
/* repTxtTail ܤ<!--key-->ʹߤΥ֥å                                */
/*----------------------------------------------------------------------------*/
  /* ȥե(buf)ɤ߹("\n") */
  fpf=mssOpenFPR(optREF.str,4);
  rec=mssInitRec();
  buf=NULL;
  bufSize=1;
  while(EOF != mssReadRec(fpf,rec)){
    bufSize+=rec->chrCnt;
    buf=mssRealloc(buf,sizeof(char)*bufSize,"buf");
    strcat(buf,rec->pnt);
    strcat(buf,"\n");
  }
  mssFreeRec(rec);
  mssCloseFPR(fpf);

  doc=mssMalloc(sizeof(struct DocNode),"iniDoc");
  initDocNode(doc);
  setDocTree(doc,buf,pt,hdi);
  setParent(doc,NULL);
//  prnDocTree(doc,0);

  /*---------------------------------------------*/
  /* ̾Υѥ᡼ȤƤʸ    */
  /* ",$week,$date,$(store)" ->"week,date,store" */
  /*---------------------------------------------*/
  {
    char *to=keyStrings;
    char *fr=keyStrings;
    if(*fr==',')fr++;
    while(*fr!='\0'){
      if( *fr=='$' || *fr=='(' || *fr==')' ) {
        fr++;
        continue;
      }
      *to=*fr;
      fr++;to++;
    }
    *to=*fr;
  }

  /* optKey򤳤Ƕ*/
  if(keyStrings[0]=='\0'){
    optKEY.set=0;
    optKEY.str=NULL;
    optKEY.cnt=0;
    optKEY.nam=NULL;
    optKEY.diffSame=1;
  }else{
    optKEY.set=1;
    optKEY.str=mssStrdup(keyStrings);
    optKEY.cnt=0;
    optKEY.nam=mssTokByChr(keyStrings,',',&optKEY.cnt,1);
    optKEY.diffSame=0;
  }
  mssSetOptKey(&optKEY, hdi); /* -k ܤإåܤ˴ϢŤ     */

  /* ϥե륪ץ */
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  frd=mssInitFRD(hdi->flds->cnt); /*FRD¤Τν*/

  setCalReadFunc(doc, frd);

  currentNode=doc; /*ȥΡɤ(Хѿ)*/
  while( EOF!=mssReadFRD(fpr,frd) ){
//printf("read\n");

    /*ǽΰԤ*/
    if(mssGV.inCnt==0){
      /*lineޤǽ*/
      while(currentNode->type!=LINE){
        currentNode=outNode(currentNode,frd->pnt[frd->new],pt,fpw);
      }
      mssGV.outCnt++;
    }
    /*֥쥤ν*/
    if(mssKeyBreak(frd, &optKEY)){
      while(1){
        if(currentNode->parent->type!=KEY) break;
        if(!keyTagBreak(frd, &optKEY, currentNode->parent)) break;
        currentNode=currentNode->parent;
        keyNode=currentNode;
        keyNode->currentNo++;
        while(1) {
          currentNode=outNode(currentNode,frd->pnt[frd->old],pt,fpw);
          mssGV.outCnt++;
          if(currentNode==keyNode &&
             currentNode->currentNo>=currentNode->nextCnt) break;
        }
        currentNode->currentNo=0;
      }

      if(frd->eof) break;

      /*lineޤǽ*/
      while(currentNode->type!=LINE){
        currentNode=outNode(currentNode,frd->pnt[frd->new],pt,fpw);
      }
      mssGV.outCnt++;
    }

    mssGV.inCnt++;

    /*̾Ԥν*/
    while(1) {
//printf("output\n");
      currentNode=outNode(currentNode,frd->pnt[frd->new],pt,fpw);
      mssGV.outCnt++;
      if(currentNode->type==LINE &&
         currentNode->currentNo>=currentNode->nextCnt) break;
    }
    currentNode->currentNo=0;
  }

  doc->currentNo++;
  currentNode=doc;
    while(1) {
      currentNode=outNode(currentNode,frd->pnt[frd->new],pt,fpw);
      mssGV.outCnt++;
      if(currentNode->type==-1 &&
         currentNode->currentNo>=currentNode->nextCnt) break;
    }
 

  mssFreeFRD(frd);
  freePrefixTree(pt);
  mssFree(pt);

/*----------------------------------------------------------------------------*/
/*λ                                                                    */
/*----------------------------------------------------------------------------*/
  mssCloseFPR(fpr);     /*ϥեΥ*/
  mssCloseFPW(fpw);     /*ϥեΥ*/
  mssFreeOption(opt);   /*ץΰ賫*/
  mssShowEndMsg();      /* λå             */
  return(0);            /* to avoid warning message   */
}

